#	START NEW ARIX SCCS HEADER
#
#	@(#) devi10.mk: version 25.1 created on 12/2/91 at 14:34:10
#
#	Copyright (c) 1990 by Arix Corporation
#	All Rights Reserved
#
#	@(#)devi10.mk	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation
#
#	END NEW ARIX SCCS HEADER
#
#	makefile for canon/imagen Imprint-10 driver, fonts, etc.
#
# DSL 2
#  SCCS @(#)dwb/troff.d/devi10:devi10.mk	25.1

include $(IROOT)/macdefs

INSDIR = $(ROOT)/usr/bin
FONTDIR = $(ROOT)/usr/lib/font/devi10
MAKEDEV = ../makedev
FFILES = [A-Z] [A-Z][0-9A-Z] DESC
OFILES = [A-Z].out [A-Z][0-9A-Z].out DESC.out

all:	di10 i10_fonts

di10:	di10.o ../draw.o
	$(CC) $(LDFLAGS) -o di10 di10.o ../draw.o -lm
	$(INS) di10 $(INSDIR)/di10
	cd $(INSDIR); chmod 775 di10; chgrp bin di10; chown bin di10

di10.o:	../dev.h canon.h glyph.h spectab.h

i10_fonts:	makedir $(MAKEDEV)
	$(MAKEDEV) DESC
	for i in $(FFILES); \
	do	if [ ! -r $$i.out ] || [ -n "`find $$i -newer $$i.out -print`" ]; \
		   then	$(MAKEDEV) $$i; \
		fi; \
	done
	for i in $(OFILES); \
	do	$(INS) $$i $(FONTDIR)/$$i; \
		chmod 644 $(FONTDIR)/$$i; \
		chgrp bin $(FONTDIR)/$$i; \
		chown bin $(FONTDIR)/$$i; \
	done

makedir:
	if [ ! -d $(FONTDIR) ] ; 	\
	then rm -f $(FONTDIR);  	\
		mkdir $(FONTDIR) ;  	\
		chmod 755 $(FONTDIR) ;  	\
		chgrp bin $(FONTDIR) ;  	\
		chown bin $(FONTDIR) ;  	\
	fi

$(MAKEDEV):
	/bin/cc -s -o $(MAKEDEV) $(MAKEDEV).c

makei10:	makei10.c ../dev.h
	$(CC) $(CFLAGS) $(LDFLAGS) -o makei10 makei10.c

makefonts:	makefonts.c ../dev.h
	$(CC) $(CFLAGS) $(LDFLAGS) -o makefonts makefonts.c

install: all
	cd rasti10; $(MAKE) -$(MAKEFLAGS)f rasti10.mk install

clean:
	rm -f *.o

clobber:	clean
	rm -f $(OFILES) di10 makei10 makefonts
	cd rasti10;  $(MAKE) -$(MAKEFLAGS)f rasti10.mk clobber
