#	START NEW ARIX SCCS HEADER
#
#	@(#) macros.mk: version 25.1 created on 12/2/91 at 14:20:03
#
#	Copyright (c) 1990 by Arix Corporation
#	All Rights Reserved
#
#	@(#)macros.mk	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation
#
#	END NEW ARIX SCCS HEADER
#

#ident	"@(#)dwb/macros.d:macros.mk	25.1"

include $(IROOT)/macdefs

# OL = $(ROOT)/
LIST = lp
# INS = :
MINSLIB = $(ROOT)/usr/lib/macros
TINSLIB = $(ROOT)/usr/lib/tmac
TMACFILES = tmac.an tmac.m tmac.osd
# MAKE = make

all:	mmn man osdd ptx vmca mmt

install:	all macdir insmmn insstrings.mm tmac insman insosdd insptx insvmca insmmt

mmn:	mmn.src strings.mm
	sh ./macrunch mmn

insmmn:	mmn
	$(INS) mmn $(MINSLIB)/mmn
	cd $(MINSLIB); chmod 644 mmn; chgrp bin mmn; chown bin mmn

mmt:	mmt.src strings.mm
	sh ./macrunch mmt

insmmt:	mmt
	$(INS) mmt $(MINSLIB)/mmt
	cd $(MINSLIB); chmod 644 mmt; chgrp bin mmt; chown bin mmt

strings.mm.src: strng.mm.src
	cp strng.mm.src strings.mm.src

strings.mm:	strings.mm.src
	sh ./macrunch strings.mm

insstrings.mm:	strings.mm
	$(INS) strings.mm $(MINSLIB)/strings.mm
	cd $(MINSLIB); chmod 644 strings.mm; chgrp bin strings.mm; chown bin strings.mm

man:	an.src
	sh ./macrunch an

insman:	man
	$(INS) an $(MINSLIB)/an
	cd $(MINSLIB); chmod 644 an; chgrp bin an; chown bin an

osdd:	osdd.src
	sh ./macrunch osdd

insosdd:	osdd
	$(INS) osdd $(MINSLIB)/osdd
	cd $(MINSLIB); chmod 644 osdd; chgrp bin osdd; chown bin osdd

ptx:	ptx.src
	sh ./macrunch ptx

insptx:	ptx
	$(INS) ptx $(MINSLIB)/ptx
	cd $(MINSLIB); chmod 644 ptx; chgrp bin ptx; chown bin ptx

vmca:	vmca.src
	sh ./macrunch vmca

insvmca:	vmca
	$(INS) vmca $(MINSLIB)/vmca
	cd $(MINSLIB); chmod 644 vmca; chgrp bin vmca; chown bin vmca

macdir:
	if [ ! -d $(MINSLIB) ]; then rm -f $(MINSLIB); \
		mkdir $(MINSLIB);  chmod 755 $(MINSLIB);  fi

tmac:	$(TMACFILES)
	if [ ! -d $(TINSLIB) ]; then rm -f $(TINSLIB); \
		mkdir $(TINSLIB);  chmod 755 $(TINSLIB);  fi 
	@for i in $(TMACFILES); \
	do \
		$(INS) $$i $(TINSLIB)/$$i; \
	done
	cd $(TINSLIB); chmod 644 $(TMACFILES); chgrp bin $(TMACFILES); chown bin $(TMACFILES)

listing:    listmmn listmmt listvmca listman listptx

listmmn: ;  nl -ba mmn.src | pr -h "mmn.src" | $(LIST)
	    macref -s -t mmn.src | pr -h "macref of mmn.src" | $(LIST)
listman: ;  nl -ba an.src | pr -h "an.src" | $(LIST)
	    macref -s -t an.src | pr -h "macref of an.src" | $(LIST)

clean:
	rm -f strings.mm.src

clobber:	clean
	rm -f mmn an strings.mm mmn ptx mmt vmca osdd
