/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) simple_mem.c: version 25.1 created on 12/2/91 at 14:17:27	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)simple_mem.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

#ident	"@(#)dsetup/c:simple_mem.c	25.1"

/*
 *	simple and dumb memory allocator
 *
 *	Chunks of memory are allocated in a stackwise fashion.
 *	When something is freed, everything past it is also freed.
 *	It is important that the caller be aware and wary.
 */

#ifndef REG
#define REG register
#endif

typedef unsigned int uint;
typedef unsigned char uchar;

#include "simple_mem.h"

#define MEM_ALLOC_SLOTS 10

uchar *memavail, *memend;
struct memuse slotbase[MEM_ALLOC_SLOTS];
struct memuse *slotavail;

meminit(base,size)
REG uchar *base;
uint size;
{
    slotavail = slotbase;
    memend = base + size;
    memavail = base;
}

struct memuse *
memalloc(size,round)
REG int round;
REG int size;
{
    REG struct memuse *slot;
    REG uchar *temp;

    xprintf("memalloc(%d,%d) ",size,round);
    if((slot = slotavail) >= &slotbase[MEM_ALLOC_SLOTS])
	errxit("bug, memalloc: out of mem slots");
    /* take out the following */
    if(round & (round-1)) errxit("bug, memalloc: round not power of 2");
    round -= 1;
    slot->b = temp = memavail;
    temp = (uchar *)(((int)temp + round) & ~round);
    slot->p = temp;
    slot->c = size;
    temp += size;
    if(temp > memend)errxit("bug, memalloc: out of space");
    memavail = temp;
    xprintf("slot=0x%x, b=0x%x, p=0x%x\n",slot, slot->b, slot->p);
    return(slotavail++);
}

memfree(slot)
REG struct memuse *slot;
{
    xprintf("memfree(0x%x)",slot);
    if(slot >= slotavail) {
    xprintf(" NOP\n");
	return; /* already freed */
    }
    slotavail = slot;
    memavail = slot->b;
    xprintf(" freed\n");
}
