/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) rvfio.c: version 25.1 created on 12/2/91 at 14:17:24	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)rvfio.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

#ident	"@(#)dsetup/c:rvfio.c	25.1"

#include <disksect.h>
#include "dk.h"
#include <pdf.h>
#include <sys/ioctl.h>
#define BSIZE 0x400

#define VALCHS(p) (*(long *)(&(p)))

#ifndef REG
#define REG register
#endif

typedef unsigned int uint;
typedef unsigned char uchar; 

struct hdrspare {
    uint count;
    uint used;
};
/*
struct hdrskip {
};
*/
struct hdrdef {
    uint count;
};
struct hdrbad {
    uint label;
    uint count;
};

union hdr {
    struct hdrspare spare;
    /* struct hdrskip skip; */
    struct hdrdef def;
    struct hdrbad bad;
};

struct tail {
    uchar idfield;
    uchar seqnum;
    uint nextsect;
};
#define SZTAIL sizeof(struct tail)

/* the ORDER and POSITION in this array cannot be changed */
/* check pdf.h for the RV_... names */
static
struct pdfiledef {
    short id;
    short first;
    int entrysize;
    int hdrsize;
    int entrypersector;
} pdfiledef[] = {
    { MEDSECID, 6, sizeof(struct medf), sizeof(struct hdrdef),
	(BSIZE-(sizeof(struct hdrdef)+SZTAIL))/sizeof(struct medf) },
    { BADSECID, 16, sizeof(struct sectid), sizeof(struct hdrbad),
	(BSIZE-(sizeof(struct hdrbad)+SZTAIL))/sizeof(struct sectid) },
    { SKIPSECID, 4, sizeof(struct badtrck), 0 /*sizeof(struct hdrskip)*/,
	(BSIZE-(0 /*sizeof(struct hdrskip)*/+SZTAIL))/sizeof(struct badtrck) },
    { SPARSECID, 2, sizeof(struct sprs), sizeof(struct hdrspare),
	(BSIZE-(sizeof(struct hdrspare)+SZTAIL))/sizeof(struct sprs) },
};

static char pdsectbuf[BSIZE];
static union hdr *hdr = (union hdr *)pdsectbuf;
static struct tail *tail =
    (struct tail *) (&pdsectbuf[BSIZE-sizeof(struct tail)]);
static struct pdfiledef *pdfdef;
static int pdsect,pdnextsect;
static int fileblock;
extern int scsi_dtc;
extern int scsi_fd;


static
pdreadsector(fd,sector,buf)
int fd;
unsigned sector;
char *buf;
{
struct reserve  diskio;
int		do_ioctl = 0;

	diskio.buf = (int)buf;
	diskio.blkno = sector;
	diskio.cnt = 1;
	if(ioctl(scsi_fd,READ_RESV,&diskio) == -1) {
	    diskio.blkno = sector+1;
	    if(ioctl(scsi_fd,READ_RESV,&diskio) == -1) {
		printf("pdreadsector : ioctl failed\n");
		return(-1);
	    }
	}
    return(0x400);
}

static
pdwritesector(fd,sector,buf)
char *buf;
{
    if(lseek(fd,sector*BLKSIZE,0)<0)return(-1);
    if(write(fd,buf,BLKSIZE)<0)return(-1);
    if(lseek(fd,(sector+1)*BLKSIZE,0)<0)return(-1);
    if(write(fd,buf,BLKSIZE)<0)return(-1);

#ifdef DEBUG
    xprintf("pdwrite: 0x%x,",sector);
#endif
    return(0x400);
}

static
pdflopen(f) {
    /* MUSTDO if not good fd then error */

    /* allow multiple opens later */
    /*if(pdfdef) errxit("pdflopen: some pd already open");*/

    switch(f) {
    case RV_SPARE_ID: case RV_SKIP_ID: case RV_DEF_ID: case RV_BAD_ID:
	pdfdef = &pdfiledef[f-1];
	break;
    default:
	/* errxit("pdfileio: unknown resepded file"); */
	return(-1);
	/*NOTREACHED*/
    }
    fileblock = -1;
    pdnextsect = pdfdef->first;
    pdsect = -1;
    return(0);
}

/*
 *	in pdreadsector
 *	read/write need to be made smarter.
 *
 *	If a read error then try the alternate
 *	and give warning (run dsck).
 */

static
readsector(fd) {
    if(pdnextsect == 0) return(0);
    if(pdnextsect == -1) return(-1);
    if(pdreadsector(fd,pdnextsect,pdsectbuf)<0) return(-1);
    if(tail->idfield == 0 && tail->seqnum == 0
      && tail->nextsect == 0 && pdsect == -1 ) {
	return(0); /* empty list */
    }
    if(tail->idfield != pdfdef->id) return(-1);
    if(tail->seqnum != fileblock+1) return(-1);
    pdsect = pdnextsect;
    fileblock++;
    pdnextsect = tail->nextsect;
    return(0x400);
}

pdfread(fd,f,buf)
char * buf;
{
    REG int thissize,thiscount;
    REG int rc;
    REG int size = 0;
    int ldr = 0;

    /* TODO: check parameters */

    if(f == 0) { /* special case, read sector 0 */
	return(pdreadsector(fd,0,buf));
    }

    if(pdflopen(f)<0)return(-1);
    while((rc=readsector(fd))>0) {
	switch(f) {
	case RV_SPARE_ID:
	    thiscount = hdr->spare.count;
	    break;
	case RV_DEF_ID:
	    thiscount = hdr->def.count;
	    break;
	case RV_BAD_ID:
	    thiscount = hdr->bad.count;
	    break;
	case RV_SKIP_ID:
	    for (thiscount=0; thiscount<SKTRKSIZ && ldr < LOGDR+1;) {
		if (VALCHS(((struct sktrk_list *)hdr)->badtrack[thiscount++]) == 0)
		ldr++;
	    }
	    break;
	}
	thissize = pdfdef->entrysize * thiscount;
	size += thissize;
	blockcopy(buf,pdsectbuf+pdfdef->hdrsize, thissize);
	buf += thissize;
    }
    if(rc<0)return(-1);
    pdfdef = 0;
    return(size);
}

pdfstat(fd,buf)
struct pdstat *buf;
{
    int sect,size,count,used;
    int thiscount;
    REG int rc;
    REG struct pdf *pdf = (struct pdf *)(&buf->pd_md_count);/* the first one */
    REG struct sector0 *pd;
    int f, ldr;

    /* TODO: check parameters */

    if(pdreadsector(fd,0,pdsectbuf)<0)return(-1);
    pd = (struct sector0 *)pdsectbuf;
    buf->pd_format = pd->FORMAT_LEVEL;
    if(pd->pd_ldnum == 0) { /* not yet setup */
	buf->pd_boot_start = 0;
	buf->pd_boot_sect = 0;
    } else {
	struct boot_list *b = (struct boot_list *)pdsectbuf;
	if(pdreadsector(fd, BOOT_SECTOR, b)<0) return(-1);
	buf->pd_boot_start = b->boot_strt;
	buf->pd_boot_sect = b->boot_size;
    }
    for(f=1;f<5;f++,pdf++) { /* do it for each type of file */
	if(pdflopen(f)<0)return(-1);
	sect = size = count = used = ldr = 0;
	while((rc=readsector(fd))>0) {
	    switch(f) {
	    case RV_SPARE_ID:
		thiscount = hdr->spare.count;
		used += hdr->spare.used;
		break;
	    case RV_DEF_ID:
		thiscount = hdr->def.count;
		break;
	    case RV_BAD_ID:
		thiscount = hdr->bad.count;
		break;
	    case RV_SKIP_ID:
		for (thiscount=0; thiscount<SKTRKSIZ && ldr < LOGDR+1;) {
			if (VALCHS(((struct sktrk_list *)hdr)->badtrack[thiscount++]) == 0)
				ldr++;
		}
		break;
	    }
	    sect++;
	    count += thiscount;
	    size += pdfdef->entrysize * thiscount;
	}
	if(rc<0)return(-1);
	pdf->pdf_sect = sect;
	pdf->pdf_count = count;
	pdf->pdf_size = size;
	if(f == RV_SPARE_ID) buf->pd_sp_used = used;
	pdfdef = 0;
    }
    return(rc);
}

/* BUG?, pdfwrite should handle f==0 (write sector 0) */
pdfwrite(fd,f,ubuf,count)
char *ubuf;
{
    register char *p = ubuf;
    int entrycount,i;
    int extendfile = 0;
    int empty=0;


    if(pdflopen(f)<0)return(-1);
    /* write em out */

    if(!count) empty++;
    while(count || empty) {

	empty = 0;

	if(count > pdfdef->entrypersector)
	    entrycount = pdfdef->entrypersector;
	else
	    entrycount = count;
	if(extendfile || readsector(fd) == 0) {
			    /* readsector==0, only once */
	    extendfile = 1;
	    fileblock++;
	    pdsect = pdnextsect;
	    if(count > entrycount) {
		if(ioctl(fd,NEXTRVSEC,&pdnextsect)<0) return(-1);
	    } else
		pdnextsect = 0;
	} else if(count > entrycount && pdnextsect == 0) {
	    if(ioctl(fd,NEXTRVSEC,&pdnextsect)<0)return(-1);
	    extendfile = 1;
	}

	tail->idfield = pdfdef->id;
	tail->seqnum = fileblock;
	tail->nextsect = pdnextsect;

	clear(pdsectbuf+pdfdef->hdrsize,BSIZE-(pdfdef->hdrsize+SZTAIL));
	blockcopy(pdsectbuf+pdfdef->hdrsize,p,entrycount * pdfdef->entrysize);

	switch(f) { /* set the variable header counts */
	case RV_SPARE_ID:
	    {
	    int tcount;
	    struct sprs *spare = (struct sprs *)p;
	    hdr->spare.count = entrycount;
	    for(i=0,tcount=0;i<entrycount;i++,spare++)
		if(VALCHS(spare->cyl) == 0)
		    tcount++;
	    /* BUG, spare.used is not quit right when rewriteing */
	    hdr->spare.used = tcount;
	    }
	    break;
	case RV_SKIP_ID:
	    break;
	case RV_DEF_ID:
	    hdr->def.count = entrycount;
	    break;
	case RV_BAD_ID:
	    hdr->bad.label = ASCIBAD;
	    hdr->bad.count = entrycount;
	    break;
	}
	/* output the block */
	if(pdwritesector(fd,pdsect,pdsectbuf)<0)return(-1);
	count -= entrycount;
	p += entrycount * pdfdef->entrysize;
    }
    /* zero any remaining fileblocks */
    while(readsector(fd) > 0) {
	clear(pdsectbuf+pdfdef->hdrsize,BSIZE-(pdfdef->hdrsize+SZTAIL));
	switch(f) { /* set the variable header counts */
	case RV_SPARE_ID:
	    hdr->spare.count = 0;
	    hdr->spare.used = 0;
	    break;
	case RV_SKIP_ID:
	    break;
	case RV_DEF_ID:
	    hdr->def.count = 0;
	    break;
	case RV_BAD_ID:
	    hdr->bad.label = ASCIBAD;
	    hdr->bad.count = 0;
	    break;
	}
	if(pdwritesector(fd,pdsect,pdsectbuf)<0)return(-1);
    }
    pdfdef = 0;
    return(p-ubuf);
}

static
clear(p,c)
REG char *p;
REG int c;
{
    REG int i;
    for(i=0;i<c;i++) *p++ = 0;
}

static
blockcopy(d,s,c)
REG char *d,*s;
REG int c;
{
    while(c--) *d++ = *s++;
}

#ifdef UNIXSTANDALONE
static
ioctl(fd,c,p) {
    return(ioctlck(fd,c,p));
}
#endif

#ifdef MakeTestDisk
/* the following is left around ONLY for the mtd TEST PROGRAM */
/* create an pd "file" */
pdcrfile(fd,f,p,count)
char *p;
{
    int entrycount,i;

    if(!count) {
	warn("nothing to write to file %d",f);
	return;
    }

    if(pdflopen(f)<0)return(-1);
    /* write em out */
    tail->idfield = pdfdef->id;
    fileblock = 0;
    pdnextsect = pdfdef->first;
    while(count) {
	pdsect = pdnextsect;
	if(count > pdfdef->entrypersector) {
	    entrycount = pdfdef->entrypersector;
	    if(ioctl(fd,NEXTRVSEC,&pdnextsect)<0)return(-1);
	} else {
	    pdnextsect = 0;
	    entrycount = count;
	}
	tail->seqnum = fileblock;
	tail->nextsect = pdnextsect;
	clear(pdsectbuf+pdfdef->hdrsize,BSIZE-(pdfdef->hdrsize+SZTAIL));
	blockcopy(pdsectbuf+pdfdef->hdrsize,p,entrycount * pdfdef->entrysize);
	switch(f) { /* set the variable header counts */
	case RV_SPARE_ID:
	    {
	    int tcount;
	    struct sprs *spare = (struct sprs *)p;
	    hdr->spare.count = entrycount;
	    for(i=0,tcount=0;i<entrycount;i++,spare++)
		if(VALCHS(spare->cyl) == 0)
		    tcount++;
	    hdr->spare.used = tcount;
	    }
	    break;
	case RV_SKIP_ID:
	    break;
	case RV_DEF_ID:
	    hdr->def.count = entrycount;
	    break;
	case RV_BAD_ID:
	    hdr->bad.label = ASCIBAD;
	    hdr->bad.count = entrycount;
	    break;
	}
	/* output the block */
	pdwritesector(fd,pdsect,pdsectbuf);
	count -= entrycount;
	p += entrycount * pdfdef->entrysize;
	fileblock++;
    }
    pdfdef = 0;
}
#endif
