/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) dk.h: version 25.1 created on 12/2/91 at 14:17:10	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)dk.h	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*   @(#)Arete/5.0   6/30/84   /usr/src/head/sys/dk.h   */

/******************************************************************************
 *
 * Disk drive commands for structure devq (devq.q_cmd)
 *
 ******************************************************************************/

/*	read/write MULTIPLE logical sectors from logical drive for
	file system with sparing and skip track.
	Main memory can be either contiguous and non-contiguous.
	For contiguous physical memory, the address is specified in devq.q_mem 
	and devq.q_mmu = 0; maximum can handle 0x3fc00 bytes in devq.q_count
	(255 logical sectors) in a single request. (HSDT download code
	V2.6 support this feature)  
	For non-contiguous memory, devq.q_mmu is the pointer to a request
	block which contains a list of page number with an offset of 1k
	boundary into the first page number. (see vreg.h for structure 
	definition) and devq.q_mem = 0; maximum can handle 0x14000 bytes
	in devq.q_count (80 logical sectors) in a single request.
	(HSDT download code V2.8 support this feature)
 */

#define LREAD	1
#define LWRITE	2	

/*	read/write multiple physical sectors from physical drive number
	without sector sparing and skip track.
	If a sector with alternate ID, don't r/w the alternate sector.
	This type of command can accept more than 0x400 for dewq.q_count.
	All the sectors that r/w must be resided on the same head.
	This cmd is used by standalone disktest or read/write
	the first 3 track of the disk in the reserved area.

 */
#define PREADPS	3
#define PWRITPS	4

/*	read/write MULTIPLE logical sectors from reserved area of specified
	physical drive.  Allow sparing and skip track in the reserved area
	Main memory can be either contiguous and non-contiguous.
	For contiguous physical memory, the address is specified in devq.q_mem 
	and devq.q_mmu = 0; maximum can handle 0x3fc00 bytes in devq.q_count
	(255 logical sectors) in a single request.  
	(HSDT download code V2.7 support this feature)
	For non-contiguous memory, devq.q_mmu is the pointer to a request
	block which contains a list of page number with an offset of 1k
	boundary into the first page number. (see vreg.h for structure 
	definition) and devq.q_mem = 0; maximum can handle 0x14000 bytes
	in devq.q_count (80 logical sectors) in a single request.
	(HSDT download code V2.8 support this feature).
 */
#define PLREAD		0x5
#define PLWRITE		0x6

#define PDPSSPR		0x7		/* READ: phy drive with phy sector
					c,h,s (with sparing) */
#define PDPSSPW		0x8		/* WRITE: phy drive with phy sector
					c,h,s (with sparing) */

#define INIT		0xe		/* read sector 0 and build structure */
#define CLOSE		0xf		/* erase structure tbl for phy drive */
#define SIZEDK  	0x10

#define BADBLK		0x11		/* bad block within a physical drive */

#define NEXTRVSEC	0x12		/* next available log sector in reserved
					area for storing more information in
					spare list, media defect list,
					bad sector list */		

#define PHSPARE		0x13		/* spare physical sector */

#define BDBLKNUM	0x15		/* total bad blocks number */

#define HWSPARE		0x16		/* program bad sector id field */

#define ALTSECNUM	0x17		/* total number of alternate sectors in 
			   	   	the spare sectors */
#define ALTSEC		0x18		/* get all the alternate sectors
				   	(used/unused) of a physcial drive */

#define SWAPDEV		0x19		/* get the swap device log drive num */


#define PRSKALT		0x1a		/* phy drive, c,h,s, skip track,
					lookup spare */
#define PWSKALT		0x1b		/* phy drive, c,h,s, skip track,
					lookup spare */

#define WRITEID 	0x1c		/* write sector id (format) */

#define DSKCMPL		0x1d		/* wait until all disk io completed */
#define PF_WAIT  	0x1d

#define UNSPARE		0x1e		/* unspare a sector */

#define SETIME 		0x1f		/* set timing parameters */

#define PWRITS0		0x20		/* setup system sectors 0 */
#define PFMDDEV  	0x20

#define SEEKCYL		0x21		/* seek cylinder */

#define	READID		0x22		/* read sector id */

#define	MEDEFTRK 	0x23		/* read initial media defect information
					 of a single track */
#define GETSEC_0 	0x30



#define DISK	1
#define TAPE	2
#define TAPE9   0x82
#define BLKSIZE	0x400
#define TBLKSIZE 0x200
#define SHIFT10	10
#define INTLEV4	(4<<13)

#define RV  1
#define RP  2

/* rtb command to DTIOCP */

#define DISKBOOT	0xb
#define EXECUTE		0xc
#define FORMAT		0xd
#define INTDISK		0xe

#define BOOTL		0x1
#define BOOTM		0x2

/* disk request buffer */
struct rq {
	char	rq_dev;			/* z80 device - DISK */
	char	rq_opr;			/* operaton */
	char	rq_drive;		/* drive #: log/physical */
	char	rq_flag;		/* flag byte */
	char *	rq_bpaddr;		/* bp address */
	unsigned long rq_bcnt;		/* total bytes cnt */
	unsigned long rq_blkno;		/* block number on unit */
	char *	rq_mem;			/* memory address */
	unsigned long rq_memsize;	/* byte cnt */
	unsigned long cksum;
}; 
struct rs {
	char	rs_dev;
	char	rs_opr;
	short	rs_retcode;
	char *	rs_bpaddr;
	unsigned long rs_bcnt;		/* num of bytes performed */
};
