/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) diskconfig.h: version 25.1 created on 12/2/91 at 14:17:03	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)diskconfig.h	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/*
 *	default configurations
 *
 * a default configuration has
 *	- the size of the reserved area
 *	- a normal disk size
 *	- some number of predefined disks
 */

#define SMALL_LIMIT 		100000
#define MEDIUM_LIMIT		200000 /* med size disk is at least this big */

/* the following represent the array index in the conftable */
#define CONF_MED0 		1 /* first for historical reasons */
#define CONF_SMALL0		2
#define CONF_LARGE0		3
#define CONF_MED		4
#define CONF_SMALL		5
#define CONF_LARGE		6

#define NUM_DISKTYPES		8
#define NUM_DISKCONFS		12

#ifdef MAIN_MODULE

/* conf0 is special, the implication is that the normal is always spec'd */
int conf_new[] = {
    SIZE_RV,
    0x400, LD_USERSPARE, /* since the rest are 0, its one big disk */
    0,
};

int conf_small0[] = { /* system primary disk */
    SIZE_RV,
    25000, LD_USERSPARE,  /* make a bunch of these */
    3, /* specify three disks */
    16000, LD_USERSPARE, /* root */
    16000, LD_SWAP,
    21000, LD_USERSPARE, /* user */
};

#ifdef SPERRY
int conf_med0[] = { /* system primary disk */
    SIZE_RV,
    50000, LD_USERSPARE,  /* make a bunch of these */
    6, /* specify six disks */
    16000, LD_USERSPARE, /* root */
    16000, LD_SWAP,
    34000, LD_USERSPARE, /* user */
    16000, LD_USERSPARE, /* user */
    10000, LD_USERSPARE,
    0, 0,  /* null disk */
};

#else
int conf_med0[] = { /* system primary disk */
    SIZE_RV,
    50000, LD_USERSPARE,  /* make a bunch of these */
    6, /* specify six disks */
    16000, LD_USERSPARE, /* root */
    16000, LD_SWAP,
    25000, LD_USERSPARE, /* user */
    25000, LD_USERSPARE, /* user */
    10000, LD_USERSPARE,
    0, 0,  /* null disk */
};

#endif
int conf_large0[] = {
    SIZE_RV,
    50000, LD_USERSPARE,  /* make a bunch of these */
    6, /* specify six disks */
    16000, LD_USERSPARE, /* root */
    16000, LD_SWAP,
    25000, LD_USERSPARE, /* user */
    30000, LD_USERSPARE,
    30000, LD_USERSPARE,
    30000, LD_USERSPARE,
};

int conf_med[] = {
    SIZE_RV,
    40000, LD_USERSPARE,  /* make a bunch of these */
    2, /* specify two disks */
    25000, LD_USERSPARE,
    25000, LD_USERSPARE,
};
int conf_small[] = {
    SIZE_RV,
    25000, LD_USERSPARE,  /* make a bunch of these */
    2, /* specify two disks */
    25000, LD_USERSPARE,
    25000, LD_USERSPARE,
};

int conf_large[] = {
    SIZE_RV,
    50000, LD_USERSPARE,  /* make a bunch of these */
    4, /* specify four disks */
    30000, LD_USERSPARE,
    30000, LD_USERSPARE,
    30000, LD_USERSPARE,
    30000, LD_USERSPARE,
};
int conf3[] = { /* system primary disk */
    SIZE_RV,
    20000, LD_USERSPARE,  /* make a bunch of these */
    3, /* specify three disks */
    16000, LD_USERSPARE, /* root */
    16000, LD_SWAP,
    25000, LD_USERSPARE, /* user */
};

int conf4[] = { /* test if config won't fit */
    SIZE_RV,
    30000, LD_USERSPARE,  /* make a bunch of these */
    2, /* two disks */
    20000, LD_USERSPARE,
    20000, LD_USERSPARE,
};

int conf5[] = {
    SIZE_RV,
    50000, LD_USERSPARE,  /* make a bunch of these */
    6, /* six disks */
    16000, LD_USERSPARE,
    16000, LD_USERSPARE,
    20000, LD_USERSPARE,
    20000, LD_USERSPARE,
    20000, LD_USERSPARE,
    20000, LD_USERSPARE,
};

int conf6[] = {
    SIZE_RV,
    200000, LD_USERSPARE,  /* make a bunch of these */
    4, /* specify four disks */
    16000, LD_USERSPARE, /* root */
    16000, LD_SWAP,
    25000, LD_USERSPARE, /* user */
    30000, LD_USERSPARE,
};

int conf7[] = { /* test if config won't fit */
    SIZE_RV,
    200000, LD_USERSPARE,  /* make a bunch of these */
    1, /* one disk */
    50000, LD_USERSPARE,
};

struct conftable gConf[] = {
    { "new              ", (struct defconf *)conf_new },
    { "medium drive 0   ", (struct defconf *)conf_med0 },
    { "small drive 0    ", (struct defconf *)conf_small0 },
    { "large drive 0    ", (struct defconf *)conf_large0 },
    { "medium drive     ", (struct defconf *)conf_med },
    { "small drive      ", (struct defconf *)conf_small },
    { "large drive      ", (struct defconf *)conf_large },
    { "sample config    ", (struct defconf *)conf3 },
    { "sample config    ", (struct defconf *)conf4 },
    { "sample config    ", (struct defconf *)conf5 },
    { "sample lg. dr 0	", (struct defconf *)conf6 },
    { "sample lg. dr 1  ", (struct defconf *)conf7 },
};

/* cf. logical drive types, LD_... */
char *ascldtype[] = {
    "NULL",
    "",		/* former FSYS */
    "SWAP",
#ifdef S3000
    "",		/* former PWRF */
#else
    "PWRF",	/* Added back for A1000, mr */
#endif
    "",		/* former HOLE */
    "FSPR",
    "FSKP",
    "",		/* former SPLIT */
};
char *brief_ascldtype[] = {
    "NULL",
    "",		/* former FS */
    "SWP",
#ifdef S3000
    "",		/* former PF */
#else
    "PF",	/* Added back for A1000, mr */
#endif
    "",		/* former HOLE */
    "FSP",
    "FSK",
    "",		/* former SPLIT */
};

#else

extern struct conftable gConf[];
extern char *ascldtype[];
extern char *brief_ascldtype[];

#endif
