/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) dsetmisc.c: version 25.1 created on 12/2/91 at 14:16:29	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)dsetmisc.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#ifdef RO_UNIX
#include <sys/ioctl.h>
#include <ctype.h>
#endif

/*----------------------------------------------------------------------------
/ dsetmisc.c - globally used generic functions
/
/
/---------------------------------------------------------------------------*/

#ifndef TRUE
#define TRUE    1
#define FALSE   0
#endif

/*---------------------------------------------------- externs -------------*/
extern int isscsi();                    /* is SCSI controller */
#ifndef RO_UNIX
extern int isspace();                   /* space character */
extern int isdigit();                   /* 0..9 */
extern int isxdigit();                  /* 0..9 and A..F */
#endif
extern int atoi();                      /* convert string to integer */
extern int atox();                      /* convert hex string to integer */
extern int ldb_to_chs();                /* convert block addr to chs */
extern int chs_to_ldb();                /* convert chs to block addr */
extern void error();

extern char cmdbuf[200];                /* i hope there is a limit */
extern char *pcmd;                      /* command pointer */

extern int scsi_dtc;                    /* scsi type controller */
#ifdef RO_UNIX /* hh */
int scsi_fd = -1;		/* jc1 fd for slice 0 in unix version */
#endif

/*---------------------------------------------------- forwards ------------*/
int  check_drive();
int  gstr();
int  gnum();
int  ghex();
int  gdrive();

/*---------------------------------------------------- check_drive() -------*/
check_drive(drive)
int drive;
{
    register unsigned int controller = drive >> 4;
    register unsigned int disk = drive & 0x0f;
    char *scsi_slice0 = "/dev/rdsk/c0d00s0"; /* hh1 (numbers just for size)*/
    int drv_typ;

#ifdef S3000 /* hh (1/25/89) - s90 can have up tp 16 controllers  */
    if (controller > 15) {
        printf("Invalid controller %d - only controllers 0-15 supported\n",
#else
    if (controller > 3) {
        printf("Invalid controller %d - only controllers 0-3 supported\n",
#endif
            controller);
        return(FALSE);
    }

#ifdef RO_UNIX	/* hh1 */
	sprintf(scsi_slice0,"/dev/rdsk/c%dd%ds0",controller,disk);
	if (scsi_fd != -1) 	/* jc1 */
		close(scsi_fd);
	if( (scsi_fd = open( scsi_slice0, 0 ) ) == -1 ) {
		printf("dsetup : unable to open %s\n",scsi_slice0);
		if (getuid()) /* user is not root */
			printf("         check permissions on device\n");
		return(FALSE);
	}

	/* JTOF - fix the way we we figure out drive. */
	/* FIX -  please be consistent with xprint, printf and other 
	*         error messages 
        */

	drv_typ = ioctl( scsi_fd, GET_DEV_TYPE, 0 );
	if ( drv_typ == SMD_TYPE )
		scsi_dtc = 0;
	else if ( drv_typ == SCSI_TYPE )
		scsi_dtc = 1;
	else
		printf( "dsetup: unknown drive type 0x%x\n", drv_typ );
#else
    scsi_dtc = isscsi(controller);
#endif

    if (scsi_dtc) {
        if (disk > 13) {
            printf("Invalid drive %d - only disks 0..13 per SCSI controller\n",
                    disk);
            return(FALSE);
        }
    }
    else {
        if (disk > 3) {
            printf("Invalid drive %d - only disks 0-3 per controller\n", disk);
            return(FALSE);
        }
    }

    return(TRUE);
}

/*---------------------------------------------------- gstr() --------------*/
int gstr(pp)
char *pp;
{
    register int i;
    register char *p = pcmd;

    while (isspace(*p))                 /* skip over white space */
        p++;
    pcmd = p;
    if (!*p)                            /* EOS */
        return(0);
    for (i = 0; i < 10; i++, p++, pp++) {
        *pp = *p;
        if (!*pp || isspace(*pp))       /* copy until either EOS or space */
            break;
    }
    *pp = 0;                            /* null terminate it */
    pcmd = p;
    return(1);
}

/*---------------------------------------------------- gnum() --------------*/
int gnum(pp)
int *pp;
{
    register char *p = pcmd;
    char *q;

    while (isspace(*p))                 /* skip white spaces */
        p++;
    pcmd = p;
    if (!*p)                            /* Oops! EOS */
        return(0);
    q = p;
    while (isdigit(*p))
        p++;
    pcmd = p;
    if (*p && !isspace(*p))             /* abnormal condition */
        return(0);
    *pp = atoi(q);                      /* convert it to an integer */
    pcmd = p;
    return(1);
}

/*---------------------------------------------------- ghex() ----------------
/ convert a hexadecial ascii representation to a number.  ascii string must
/ be terminated by either a null or a space.
/ function returns TRUE for success; FALSE for failure
/---------------------------------------------------------------------------*/
int ghex(pp)
int *pp;                                /* converted number */
{
    register char *p = pcmd;
    register char *q;
    register int val = 0;

    while (isspace(*p))                 /* skip over white spaces */
        p++;
    pcmd = p;

    if (!*p)                            /* EOS */
        return(FALSE);

    q = p;                              /* remember where we are */
    while (*p) {                        /* fix up for conversion */
        if (isdigit(*p))                /* digits are ok */
            *p -= '0';
        else if (*p >= 'a' && *p <= 'f')/* (a..f) to (:..?) */
            *p -= 'a' - 10;
        else if (*p >= 'A' && *p <= 'F')/* (A..F) to (:..?) */
            *p -= 'A' - 10;
        else                            /* something else.. done */
            break;
        p++;                            /* next char */
    }

    if (*p && !isspace(*p))             /* check terminating char */
        return(FALSE);                  /* wasn't a null or a space */

    pcmd = p;                           /* we read thus far - save */
    for ( ; q < p; q++)                 /* convert to a number */
        val = val * 16 + *q;
    *pp = val;
    return(TRUE);                       /* we did good */
}

/*---------------------------------------------------- gdrive() --------------
/ get drive specification.  If it starts with a 'c', assume c#d#[#] format;
/ else #[ ]#[#] format.  This routine doesn't attempt to verify to validity of
/ drive specification as long as it fits the format.
/ It passes back drive index number.  Return TRUE for success; FALSE otherwise
/---------------------------------------------------------------------------*/
int gdrive(pdr)
int *pdr;
{
    register int c;
    register char *p = pcmd;

    while (isspace(*p))                 /* skip white spaces */
        p++;

    if (*p == 'c') {                    /* c#d#[#] format */
        c = atoi(++p);
        while (isdigit(*p))
            p++;                        /* skip over additional numbers */
        if (*p++ != 'd')                /* not in c0d0 format */
            return(FALSE);
    }
    else {                              /* ##[#] format */
        if (!isdigit(*p))               /* no controller # */
            return(FALSE);
        c = *p - '0';                   /* controller number */
        p++;
        while (isspace(*p))
            p++;
    }

    if (!isdigit(*p))                   /* must be hex format */
        *pdr = (c << 4) | atox(p);
    else
        *pdr = (c << 4) | atoi(p);
    while (isxdigit(*p))                /* skip over what we converted */
        p++;
    pcmd = p;                           /* next parsing point */
    return(TRUE);                       /* success */
}

/*-------------------------------- End of dsetmisc.c -----------------------*/
