/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) dsetmain.c: version 25.1 created on 12/2/91 at 14:16:25	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)dsetmain.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*----------------------------------------------------------------------------
/ dsetmain.c - main module for 'dsetup' program
/
/ April 1988    Craig J. Kim
/ Added SCSI-EDT support
/
/ 4/28/86       Peter Logan
/ Fixed the help message so that it only prints one page at a time
/
/ - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
/ NOTE:  dsetup makes use of setjmp(), longjmp() pair to recover from serious
/   error conditions.  setjmp() is executed once at the top of dsetup()
/   function and longjmp() is called from many error handling functions.
/---------------------------------------------------------------------------*/

#include "disksect.h"

#if defined(UNIXSTANDALONE) | defined(RO_UNIX)
#include <stdio.h>
#endif

#define MAIN_MODULE

#include "dsetup.h"
#include "diskconfig.h"

#ifndef TRUE
#define TRUE    1
#define FALSE   0
#endif

/*---------------------------------------------------- externs -------------*/
extern char *strlwr();
extern int  scsi_dsetup();
extern int  smd_dsetup();
extern int  printf();
extern char *gets();
extern int  check_drive();

/*---------------------------------------------------- forwards ------------*/
static void ask_drive();
static void init();
void pversion();

/*---------------------------------------------------- globals -------------*/
jmp_buf errorbuf;                       /* so we can bail us out */
struct setup oldsetup;                  /* as found on disk */
struct setup prevsetup;                 /* undo with this one */
struct setup newsetup;                  /* working copy */
struct setup tempsetup;                 /* newsetup just before any changes */

#ifdef UNIXSTANDALONE
int debugflag = TRUE;                   /* can toggle with z command */
#else
int debugflag = FALSE;                  /* can toggle with z command */
#endif

char cmdbuf[200];                       /* i hope there is a limit */
char *pcmd;                             /* command pointer */

int warn_level_flag;
int scsi_dtc = FALSE;                   /* scsi type controller */
int	nobadlist=FALSE;

/*==================================================== main() ==============*/
main()
{
    int drive;

    init();                             /* get consoledef, signals, .... */
    pversion();                         /* version info */
    ask_drive(&drive);                  /* ask which drive to dsetup */
    do {
        if (scsi_dtc)
            drive = scsi_dsetup(drive);
        else
            drive = smd_dsetup(drive);
    } while (drive >= 0);
    exit(0);
}

/*---------------------------------------------------- ask_drive() ---------*/
static void ask_drive(drive)
int *drive;
{
    do {
#ifdef RO_UNIX
        printf("\nEnter physical drive unit number to examine-> ");
#else
        printf("\nEnter physical drive unit number to configure-> ");
#endif
        gets(cmdbuf);                   /* user responds */
        pcmd = strlwr(cmdbuf);          /* that's what we want to parse */
        if (gdrive(drive)) {            /* parse out drive number */
            if (!check_drive(*drive))
                *drive = -1;
        }
        else {
            printf("\nInvalid drive unit specification.\n");
            printf("Format:  [c]C[d]D  where C is controller number\n");
            printf("                         D is drive number\n");
            *drive = -1;
        }
    } while (*drive < 0);
}

/*---------------------------------------------------- init() --------------*/
static void init()
{
    static char mempool[100000];        /* grab 100Kb for future memory alloc */

#ifdef UNIXSTANDALONE
    setbuf(stdout, 0);                  /* don't buffer output */
#endif
    meminit(mempool, sizeof (mempool));
}

/*---------------------------------------------------- pversion() ----------*/
void pversion()
{
#ifndef RO_UNIX
    printf("\nStandalone ");
#endif
    printf("dsetup (VER 4.10)\n");
}

/*------------------------------ End of dsetmain.c -------------------------*/
