/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) movefile.c: version 25.1 created on 12/2/91 at 14:15:45	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)movefile.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/*
 * movefile.c -- move/rename a file, much like the mv(1) command
 *		Returns 0 on success, else -1.
 *		Will not overwrite an existing file
 */

#include <stdio.h>
#include <errno.h>
#include <fcntl.h>

extern int debugflag;

#define M_COPY 0
#define M_MOVE 1
#define M_OVER 2

movefile(oldname,newname)
char *oldname, *newname;
{
	return( _domovefile(oldname,newname,M_MOVE) );
}

movefile_overwrite(oldname,newname)
char *oldname, *newname;
{
	return( _domovefile(oldname,newname,M_MOVE | M_OVER) );
}

copyfile(oldname,newname)
char *oldname, *newname;
{
	return( _domovefile(oldname,newname,M_COPY ) );
}

copyfile_overwrite(oldname,newname)
char *oldname, *newname;
{
	return( _domovefile(oldname,newname, M_COPY | M_OVER) );
}

_domovefile(oldname, newname, mode)
char	*oldname, *newname;
{
	int	ofd, nfd, ret;
	char	buf[BUFSIZ];

	/* first, try to relink */

	if (link(oldname, newname) < 0) {
		if ( ! (errno==EXDEV || (errno==EEXIST && mode&M_OVER)) ) 
			return (-1);		/* no can do		*/
	}
	else if ( mode&M_MOVE && unlink(oldname) < 0) 
		return (-1);			/* trouble in river city */
	else
		return (0);			/* success!		*/

	/*
	 * If we get here, than the two pathnames are on different file
	 * systems, or the target exists and we're gonna overwrite it.
	 */

	if ((ofd = open(oldname, O_RDONLY)) < 0)
		return (-1);
	if ( mode & M_OVER ) { 	/* overwrite existing file */
		if (errno==EEXIST)	/* unlink file first, in case linked */
			if ( unlink(newname) < 0 )
				return (-1);
		nfd = creat(newname, 0644) ;
	}
	else 
		nfd = open(newname, O_WRONLY | O_CREAT | O_EXCL, 0644) ;
	if (nfd < 0) {
		(void) close(ofd);
		return (-1);
	}

	while ((ret = read(ofd, buf, sizeof(buf))) > 0) 
		if (write(nfd, buf, (unsigned)ret) != ret) {
			(void) close(ofd);
			(void) close(nfd);
			return (-1);		/* danger will robinson! */
		}

	(void) close(ofd);
	(void) close(nfd);

	if ( mode & M_MOVE )
		return unlink(oldname);
	return  0 ;
}
