/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) main.c: version 25.1 created on 12/2/91 at 14:15:41	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)main.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*
 *	drvinstall.c -- install / uninstall a driver
 */

#ident	"@(#)drvinstall:drvinstall.c	1.0"

#include "in_data.h"
#include <sys/types.h>
#include <sys/fs/s5dir.h>
#include <sys/stat.h>
#include <fcntl.h>
#include "dirent.h"


static char VERSION[] = "1.0";			/* Version of drvinstall */

extern void	exit();
extern void	free();
extern int	getopt();
extern long	lseek();
extern char	*malloc();
extern void	perror();
extern char	*strcat();
extern char	*strcpy();
extern int	strlen();
extern char	*strncpy();
extern char	*strrchr();
extern char	*strdup();

void		error();
void		exit_msg();
void		die();
char		*basename();
char		*killext();
char		*path_name();
struct direct	*nextdir();

extern int	errno;
extern char 	*sys_errlist[];
extern int 	sys_nerr;

int removeflag;			/* Indicates an uninstall */

int	ncntrl = 1;		/* number of controllers */
char	*progname;		/* Pointer to arg[0]; ie. command name */
char	*masbuf;		/* Pointer to tmp buffer space */

/*
 * Paths to the appropiate files
 */

char	*mod_name = NULL;	/* Path to module object file */
char	*master_name = NULL;	/* Path for input master file */
char	*obj_name = NULL;	/* Path for object/library installation */
char	*system_name = NULL;	/* Path to system file */
char	*drvname = NULL;	/* name of driver we're working with */
char	*omas = NULL;		
char	*version = NULL;
char	*iolib_name = NULL;	/* Path to iolib file */
char 	*lib_pre[] = "lib/";	/* prepended path for libraries in iolib file */

/*
 *	Default path names
 */

static char master_def[] = 	"/etc/master.d/";
static char sys_def[] = 	"/etc/system";
static char obj_def[] = 	"/usr/sys/lib/"; /* where the .a's & .o's go */
static char iolib_def[] = 	"/usr/sys/iolib";

int	new_master = 0,
	new_system = 0,
	new_iolib  = 0;

/*
 * Path to name 
 */

#define PATHSIZ 100		/* Allow 100 charactors in path names */

char 	tmpsys[30],		/* tmp file to create new system file */
	tmpmast[30],
	tmpiolib[30];


FILE	*masterfile 	= NULL;
FILE	*systemfile 	= NULL;
FILE	*omast 		= NULL;
FILE	*outfp 		= NULL;

char	used_maj[DSIZE],
	dev_maj[DSIZE];

int	debug;		/* user level debugging */
int	debugflag;	/* programmer level debugging */

/*
**	usage() prints usage, then dies.
*/
void
usage()
{
errprt("Usage : %s [-d dfile] [-m mfile] [-o ofile] [-s sfile]\n",progname);
errprt("                   [-i ifile] [-v version] [-c number] [-nbux]\n\n");
errprt("    d : use object file dfile [required, unless m AND n are given]\n");
errprt("    m : use master file mfile [defaults to %s<driver>]\n",master_def);
errprt("    o : install object file as ofile [defaults to %s<object>]\n",
		obj_def);
errprt("    s : use system file sfile [defaults to %s]\n",sys_def);
errprt("    i : use iolib file ifile [defaults to %s]\n", iolib_def);
errprt("    c : number of controllers allowed [defaults to 1]\n");
errprt("    n : no modifications will be made\n");
errprt("    b : object or library will not be installed as ofile\n");
errprt("    u : uninstall existing driver\n");
errprt("    x : debug mode\n\n");
errprt("<object> is an object or library file.\n");
errprt("<driver> is the name of the driver, if not given, it is \n");
errprt("	<object> without the .a or .o extension. \n");
die();
}

main(argc,argv)
int	argc;
char	*argv[];
{
	extern	char	*optarg;
	extern	int	optind;

	int	i, c;
	int sysed = 1, instobj = 1, frcrmv= 0;

	masbuf = (char *)NULL;

	progname = argv[0];
	
	while ((c = (int)getopt(argc, argv, "xXufnbd:m:v:s:i:o:c:")) != EOF)
		switch (c) {

		case 'x':		/* user level debug flag */
			debug = 1;
			break;
		case 'X':		/* programmer debug flag */
			debugflag = 1;
			break;
		case 'n':		/* Don't edit system file */
			sysed = 0;
			break;
		case 'b':		/* Don't copy object file to /usr/sys */
			instobj = 0;	
			break;
		case 'd':		/* Path to object module REQUIRED */
			mod_name = optarg;
			break;
		case 'o':		/* Path of object/library modules */
			obj_name = optarg;
			break;
		case 'm':		/* master file */
			master_name = optarg;
			break;
		case 's':		/* system file */
			system_name = optarg;
			break;
		case 'i':		/* iolib file */
			iolib_name = optarg;
			break;
		case 'c':		/* number of controllers */
			ncntrl = atoi(optarg);
			break;
		case 'v':		/* version number */
			version = optarg;
			break;
		case 'u':		/* uninstall module */
			removeflag = 1;
			break;
		case 'f':		/* Force remove module */
			frcrmv = 1;
			break;
		case '?':
		default:		/* illegal option letter */
			usage();
		}

	/*
	 * require -d OR -m and -n.  if -d given but not -m, create
	 * 	master_name as basename of mod_name without extension.
	 */
	if (mod_name) {
		if ( !master_name )
			master_name = killext(basename(mod_name));
	} else 	if ( !master_name || sysed )
			usage();

	if (debugflag) {
		printf("master_name = %s\n",master_name ? master_name : "NULL");
		printf("mod_name = %s\n",mod_name ? mod_name : "NULL");
		printf("sysed = %d\n",sysed);
	}
	/*
	 * At this point, sysed implies mod_name is not NULL;
	 * 	master_name is definitely not NULL.
	 */

	if(system_name == NULL) 
		system_name = sys_def;
	if(iolib_name == NULL) 
		iolib_name = iolib_def;
	if(obj_name == NULL && sysed ) {
		obj_name = malloc(PATHSIZ);
		strcpy(obj_name, obj_def );
		strcat(obj_name, basename(mod_name) );
	}  

	drvname = strdup(basename(master_name));

	if ( strchr(master_name,'/') == 0 ) {
		master_name = malloc(strlen(master_def) + strlen(drvname) + 1);
		strcpy(master_name, master_def);
		strcat(master_name, drvname);
	}
	if(debug) {
		printf("Using master file %s\n",master_name);
		if (mod_name != NULL)
			printf("Using module from %s\n",mod_name);
		printf("To install driver %s\n",drvname);
		printf("%s\n",sysed ? "Modifications will be made" :
			"No changes will be made" );
		printf("Using %s as system file\n", system_name);
		printf("Using %s as iolib file\n",iolib_name);
	}
	/*
	 *	call parse_master : parse_master will set up the dev_maj array
	 *	such that each non-zero entry corresponds to a major number 
	 *	used by the driver.  If there is a '-' in the major field of
	 *	the master file, or there is a conflict, a new master file will
	 *	be created (using outfp), and parse_master will return non-zero.
	 */
	sprintf(tmpmast,"/tmp/mast%d",getpid());

	if ( (outfp = fopen(tmpmast,"w"))  == NULL )
		exit_msg("error : cannot open temp master file");

	if ( parse_master(dev_maj,master_name) ) {
		if ( !sysed )
			exit_msg("error : major numbers not available");
		new_master++;
	}
	fclose(outfp);

	if(sysed) {
		/*
		 * 	outfp is used by parse_system to write the modified 
		 *	system file.  We create it and replace the old one.
		 */
		sprintf(tmpsys,"/tmp/sys%d",getpid());
		if ( (outfp = fopen(tmpsys,"w"))  == NULL )
			exit_msg("error : cannot open temp system file");

		parse_system(system_name);
		new_system++;

		fclose(outfp);
	}

	if ( sysed && !removeflag && instobj && strcmp(mod_name,obj_name) &&
			copyfile_overwrite(mod_name,obj_name) )
		exit_msg("error : cannot copy %s to %s\n", mod_name,obj_name);

	if ( sysed && removeflag && instobj && unlink(obj_name) )
		errprt ("%s : warning : cannot remove file %s\n", 
			progname,obj_name);

	if ( sysed && instobj ) 
		modify_iolib(basename(obj_name));

	/* 
	 *	print major number(s) used by given driver
	 */
	for ( i=0; i < NEL(dev_maj) ; i++ )
		if(dev_maj[i])
			printf("%d ",i);
	printf("\n");

	movefiles();
	die(0);
}

/*
 *	basename() returns the filename component of a full pathname.
 */
char *
basename(path)
char *path;
{
	char *base;
	
	if ( base = strrchr(path,'/') )
		return(++base);
	return(path);
}

/*
 *	killext() removes the extension from the end of a filename.
 */	
char *
killext(path)
char *path;
{	
	char *ext;
	char *local = strdup(path);

	if ( ext = strrchr(local,'.') )
		*ext = 0;
	return(local);
}
	

/*VARARGS1*/
void
error(string,arg1,arg2,arg3)
char	*string;
{
	char buffer[256];

	sprintf( buffer, string, arg1, arg2, arg3 );
	fprintf(stderr, "%s: %s\n", progname, buffer);
}


/*
 *	exit_msg(string,arg1,arg2,arg3) - print the exit string and die(1)
 */
/*VARARGS1*/
void
exit_msg(string,arg1,arg2,arg3)
char	*string;
{
	error(string,arg1,arg2,arg3);
	die(1);
}


/*
 *	die(n) - closes the source and target files, removes temp files.
 *		before printing non-zero major numbers and exiting with n.
 */
void
die(n)
	int n;
{
	if(masterfile != NULL)
		fclose(masterfile);
	if(masbuf != (char *)NULL)
		free(masbuf);
	if(*tmpmast)
		unlink(tmpmast);
	if(*tmpsys)
		unlink(tmpsys);
	if(*tmpiolib)
		unlink(tmpiolib);
	exit(n);
}

/*
 *	movefiles() replaces modified files with the appropriate tempfiles,
 *		which are subsequently removed.
 */
movefiles()
{
	if (new_master)
		movefile_overwrite(tmpmast,master_name);
	if (new_system)
		movefile_overwrite(tmpsys,system_name);
	if (new_iolib)
		movefile_overwrite(tmpiolib,iolib_name);
}
		
maj_assign()
{
	static int 	first = 1;
	register int	i;
	FILE		*savefp;

	if (first) {
		savefp = outfp;
		outfp = NULL;
		build_inuse(used_maj);
		first = 0;
		outfp = savefp;
	}

	for (i = 0; i < NEL(used_maj); i++)
		if (used_maj[i] == 0) {
			++used_maj[i];
			return i;
		}

	exit_msg("error: no major numbers available for %s\n",drvname);
}


build_inuse(inuse)
	char *inuse;
{
	char		*p,
			*master_dir,
			path[100];
	struct direct 	*dp;
	int		returnval;

	/* scan the master directory and build the inuse table */

	master_dir = path_name( master_name );
	if (debugflag)
		printf("build_inuse : master_dir = %s ; inuse = 0x%#x\n",
				master_dir,inuse);
	p = master_dir ;
	while (dp = nextdir(p)) {
		if (EQ(dp->d_name, drvname))
			continue;			/* skip driver */
		sprintf(path, "%s/%s", master_dir, dp->d_name);
		returnval = parse_master(inuse, path);
		if (debugflag)
			printf("%s = %d\n", path, returnval);
		p = NULL;
	}
}

/*
 *	path_name() returns the path component of a filename
 */
char *
path_name(path)
	char *path;
{
	register char *s, *local;

	local = (char *)strdup(path);
	if (( s = strrchr(local,'/')) != NULL )
		*s = 0;

	return(local);
}

/*
**	nextdir() : return next filename in directory
** 	if dirname is not NULL, opens dirname and returns first filename.
**	if dirname is NULL, it returns next filename in the current directory.
*/

struct direct *
nextdir(dirname)
char	*dirname;
{
	static struct direct	dent = { 0 };
	static int		dummy = 0;
	static int		fd = -1;
	int			rv;

	if (dirname != NULL) {
		if (fd >= 0)
			(void) close(fd);
		if ((fd = open(dirname, O_RDONLY)) < 0) {
			err(NULL, "getdir: cannot open %s (%s)",
			  dirname, sys_errlist[errno]);
			return (NULL);
		}
	}
	else if (fd < 0)
		return (NULL);

	/*
	 * read the directory
	 */
	while ((rv = read(fd, (char *)&dent, sizeof(dent))) == sizeof(dent)) 
		if (dent.d_ino != 0 && *dent.d_name != '.')
			return (&dent);
	if (rv != 0)
		exit_msg(NULL, "getdir: Read error in %s", dirname);

        close(fd);
	fd = -1;
	return (NULL);
}

errprt(a,b,c,d,e,f)
char *a; 
{
	fprintf(stderr,a,b,c,d,e,f);
}
