/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) iolibmod.c: version 25.1 created on 12/2/91 at 14:15:37	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)iolibmod.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include <stdio.h>

extern char 	*iolib_name,
		*progname,
		*system_name;
		*lib_pre,
		tmpiolib[];

extern int	debugflag,
		removeflag,
		new_iolib;
		
FILE *infp, *outfp;

modify_iolib(module)
char *module;
{
	char 	buff[2][80],
		*curr = buff[0],
		*prev = buff[1];

	int buffn = 0, found = 0;

	if (debugflag)
		printf("modify_iolib : module = %s\n",module);
	/*
	** open temp file for new iolib file and current iolib file.
	*/
	sprintf(tmpiolib,"/tmp/iolib%d",getpid());

	if ( (outfp = fopen(tmpiolib,"w"))  == NULL )
		exit_msg("error : cannot open temp iolib file");

	if ( (infp = fopen(iolib_name,"r"))  == NULL )
		exit_msg("error : cannot open iolib file %s\n", iolib_name);

	if (fgets(prev,80,infp) == NULL)
		exit_msg("error in iolib file %s\n", iolib_name);
	while (1) {
		if ( fgets(curr,80,infp) == NULL ){
			if ( ! feof(infp)) 
				exit_msg("error reading %s\n",iolib_name);
			if (!removeflag && !found ){
				new_iolib++;
				out_add_backslash(outfp,prev);
				fprintf(outfp,"\t%s%s\n",lib_pre,module);
				break; 	/* we're finished !! */
			}
			if ( removeflag && !found )
			    fprintf(stderr,
				"%s : warning : module %s not found in %s\n",
					progname,module,iolib_name);
			/* removeflag && found */
			out_no_backslash(outfp,prev);
			break;
		}
		if (*curr == '\n')	/* blank line, throw out */
			continue;
		if ( online(module,curr) ) {
			found++ ;
			if ( removeflag ){	/* ignore this line */
				new_iolib++;
				continue;	
			}	
			/* 
			** if we get here, we are adding, and have found a dup
			*/
			fprintf(stderr,
				"%s : warning : module %s already in %s\n",
				progname,module,iolib_name);
		}
		fprintf(outfp,"%s",prev);
		switch_ptr(&prev,&curr);
	}
	fclose(outfp);
	if( movefile_overwrite(tmpiolib,iolib_name) )
		exit_msg("error : cannot move %s to %s", tmpiolib, iolib_name);
}

out_no_backslash(fp,str)
	FILE *fp; char *str;
{
	char *s;

	for(s = &str[ strlen(str) - 1 ] ; 
			*s=='\\'||*s==' '||*s=='\t'||*s=='\n' ; s--) 
		*s = 0;
	fprintf(fp,"%s\n",str);
}

out_add_backslash(fp,str)
	FILE *fp; char *str;
{
	char *s;

	for(s = &str[ strlen(str) - 1 ] ; *s==' '||*s=='\t'||*s=='\n' ; s--) 
		*s = 0;
	fprintf(fp,"%s\t\\\n",str);
}

online(str,line)
	char *str, *line;
{
	char 	*s, *name, 
		pre_mod[100];	/* module name with lib_pre prefix ("lib/") */

	s = (char *)strdup(line);
	strcpy(pre_mod,lib_pre);
	strcat(pre_mod,str);
	while(*s == '\t' || *s == ' ')
		s++;
	name = s;
	while(*s != '\t' && *s != ' ' && *s != '\n')
		s++;
	*s = 0;
	return( ! strcmp(pre_mod,name) );
}

switch_ptr(p,q)
char **p, **q;
{
	char *s;

	s = *p;
	*p = *q;
	*q = s;
}
