/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) drvparse.c: version 25.1 created on 12/2/91 at 14:15:27	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)drvparse.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/


/*
 *	drvparse.c -- parse master and system files for drvinstall
 */

#include "in_data.h"

#define nodup(inp)	(inp)->in_nodup = 1
#define out_str(str)	{ if (outfp) fputs((str), outfp); }

extern int	debugflag, removeflag, ncntrl;
extern char	*drvname;
extern FILE	*outfp;

extern char	*strcpy(), *strncpy(), *strchr(), *strrchr(), *memset();


/*
 * parse_system -- parses the system file
 */

parse_system(s_file)
char	*s_file;
{
	register in_t	*inp;
	in_t		input;
	register int	found;
	char		word[MAXLEN];
	static char	*system_sections[] = {	/* system file sections	*/
		"%INCLUDE",
		NULL
	};

	if (debugflag)
		printf("parse_system: %s\n", s_file);

	inp = &input;
	openfile(inp, s_file);

	found = 0;
	while (findword(inp, word) != EOF) {
		switch (selectlist(word, system_sections)) {
		case 0:		/* %INCLUDE */
			found += parse_include(inp);
		DEFAULT:
			if (*word == '%') {
				parse_skipsect(inp);
				break;
			}
			err(inp, "Not a system section header: '%s'", word);
		}
	}

	fclose(inp->in_fp);

	return (found);
}

/*
 * parse_include -- sets the mult field of devices in the system file
 *	If the removeflag is true, remove any line starting with drvname,
 *	else, if a line exists, change its number to ncntrl, else if no
 *	line is found, add one.
 *
 *	Format:		device_name	[ num_controllers ]
 */

parse_include(inp)
register in_t	*inp;
{
	int	foundit;
	char	name[MAXLEN];

	if (debugflag)
		printf("parse_include: %s\n", inp->in_filename);

	foundit = 0;
	while (findcmd(inp, name) == 0) {
		if (EQ(name, drvname)) {
			++foundit;
			if (removeflag) {
				nodup(inp);		/* remove it	*/
			}
			else {
				sprintf(name,"%s\t%d\n",drvname,ncntrl);
				out_str(name);
				nodup(inp);
			}
		}
	}

	if (!removeflag && !foundit) {
		sprintf(name, "%s\t%d\n", drvname, ncntrl);
		out_str(name);
	}

	return (foundit);
}


/*
 * parse_master -- opens and parses the named master file in the master dir
 */

parse_master(majorarray, file)
char	*majorarray, *file;
{
	register in_t	*inp;
	in_t		input;
	register int	req, drvfile;
	char		word[MAXLEN];
	static char	*master_sections[] = {	/* master file sections	*/
		"%DRIVER",
		NULL
	};

	if (debugflag)
		printf("parse_master: %s\n", file);
	inp = &input;
	openfile(inp, file);

	req = 0;
	drvfile = EQ(drvname, pathend(file));	/* parsing the driver's file? */

	while (findword(inp, word) != EOF) {
		switch (selectlist(word, master_sections)) {
		case 0:		/* %DRIVER */
			req += parse_driver(inp, majorarray, drvfile);
		DEFAULT:
			if (*word == '%') {
				parse_skipsect(inp);
				break;
			}
			err(inp, "Not a master section header: '%s'", word);
		}
	}

	fclose(inp->in_fp);
	return (req);
}


/*
 * parse_skipsect -- skip a section, paying no attention to its contents
 */

parse_skipsect(inp)
register in_t	*inp;
{
	char	word[MAXLEN];

	if (debugflag)
		printf("parse_skipsect: %s\n", inp->in_filename);

	while (nextline(inp) == 0) {
		if (nextword(inp, word) == 0 && *word == '%') {
			ungetline(inp);			/* unget this line */
			return;				/* next section header*/
		}
	}

	inp->in_ptr = NULL;				/* EOF: zap last line */
}


/*
 * parse_driver -- parse the driver section of a master file
 *	Format:
 *		Major:		[major_number . . .]
 *		(all other fields ignored)
 *
 *	Increments the element of majorarray that cooresponds to the major
 *	number(s) used by the driver.  Majorarray should be at least DSIZE
 *	bytes long.
 *
 *	Will edit the masterfile if drvfile is true. If editing, parse_driver 
 *	assumes that majorarray was initially all zeros.
 *
 *	Returns the number of major numbers assigned ('-'s instead of numbers)
 *	or the number of major numbers unassigned.
 */

parse_driver(inp, majorarray, drvfile)
register in_t	*inp;
register char	*majorarray;
register int	drvfile;
{
	register int		i, req, lreq;
	register char		*a;
	char			word[MAXLEN];
	char			array[DSIZE];
	static char		*driver_fields[] = {
		"Major:",
		NULL
	};

	if (debugflag)
		printf("parse_driver: %s\n", inp->in_filename);

	a = array;
	memset(a, 0, NEL(array));
	req = lreq = 0;

	while (findcmd(inp, word) == 0) {
		switch (selectlist(word, driver_fields)) {
		case 0:		/* Major: */
			while ((i = get_number(inp, 0, DSIZE-1, CNULL,
			  "Invalid major device number")) != EOF) {
				if (i == MAJ_UNKNOWN) {
					++lreq;

					if (drvfile)
						nodup(inp);	/* do new line*/
				}
				else {
					++a[i];

					if (removeflag)
						nodup(inp);	/* do new line*/
				}
			}

			/* need to do a new Major: line? */

			if (!drvfile || (lreq <= 0 && !removeflag))
				break;				/* nope */

			out_str("Major:\t\t");
			if (removeflag) {
				/* print the line */

				for (i = 0; i < lreq; i++)
					out_str("- ");

				for (i = 0; i < DSIZE; i++) {
					if (a[i]) {
						out_str("- ");
						++lreq;		/* unassigned */
					}
				}
			}
			else {
				/* assign new major numbers */

				for (i = 0; i < lreq; i++)
					++a[maj_assign()];

				/* print the line */

				for (i = 0; i < DSIZE; i++) {
					if (a[i]) {
						sprintf(word, "%d ", i);
						out_str(word);
					}
				}
			}
			out_str("\n");
			break;
		}

		/* update totals */

		req += lreq;
		lreq = 0;

		for (i = 0; i < DSIZE; i++)
			if (a[i]) {
				a[i] = 0;
				++majorarray[i];
			}
	}

	return (req);
}


/*
 * nextline -- get the next line of input, returns EOF or 0
 */

nextline(inp)
register in_t	*inp;
{
	if (!inp->in_nodup && outfp != NULL) {
		fputs(inp->in_dup, outfp);
		*inp->in_dup = NULL;
	}

	if (fgets(inp->in_buf, (int)sizeof(inp->in_buf), inp->in_fp) == NULL) {
		inp->in_ptr = NULL;			/* EOF: zap last line */
		return (EOF);
	}
	++inp->in_lineno;
	inp->in_ptr = inp->in_buf;
	strcpy(inp->in_dup, inp->in_buf);		/* copy line */
	inp->in_nodup = 0;
	return (0);
}
