/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) disks.c: version 25.1 created on 12/2/91 at 14:15:12	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)disks.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

#ident	"@(#)cmd/disks:disks.c	1.3"

/*	disks: (taken from Rob Clevenger, dtconf.c, out of MST.)   	*
 *	                                                           	*
 *      Get the disk availability from all dt controllers,	   	*
 *      make sure that the appropriate devices are created.        	*
 *								   	*	
 *	The utility will print out any errors, as well as any nodes	*
 * 	that need to be made.					   	*
*/

#include <stdio.h>
#include <fcntl.h>
#include <sys/vreg.h>
#include <sys/icb.h>
#include <sys/dtreq.h>
#include <sys/mt.h>
#include <sys/errno.h>
#include <sys/types.h>
#include <sys/sysmacros.h>
#include <sys/stat.h>	/* jc0 */

#ifdef S3000	/* hh1 */

#include <sys/vmem.h>	
#include <sys/pm_iomap.h>
#include <sys/sbus.h>
#include <sys/kmem.h>
#define DSKMAJ		getmaj(scsi ? "scsi_dk_e" : "smd_dk_e", \
				scsi ? controller : (controller / 4))
#define RDSKMAJ		DSKMAJ

#define DISKMIN  (scsi ? ((pd << 4)+ld) : \
		 (((controller % 4) << 6) + (pd << 4) + ld) )
#define NUM_SLOTS	NUM_ICB_DEVS_PER_SYS

#else /* !S3000 */
#define NUM_SLOTS	MAXSLOT	

#define	RSRVMAJ	2

#define	RSRVMIN	((controller << 6) + (pd << 4)) 
#define SCSI_0_BDEV	6	/* scsi controller zero block device number */
#define SCSI_0_CDEV	40	/* scsi controller zero char device number */

#define DSKMAJ	(scsi ? SCSI_0_BDEV + scsicont : 0 )
#define RDSKMAJ	(scsi ? SCSI_0_CDEV + scsicont : 2 )

#define DISKMIN  (scsi ? ((pd << 4)+ld) : ((controller << 6) + (pd << 4) + ld))

#endif /* S3000 */
		

#define MAX_SCSI	14	/* max number of devs on a scsi controller */
#define MAX_SMD		4	/* max number of devs on an edt or hsdt */

#define RSRV_MOD 0600
#define DISK_MOD 0400

#define OWNER 0		/* jc0 - owner will be root, group will be sys */
#define GROUP 3

extern int 	errno;
extern char 	*sys_errlist[];	

char 		*buffer,
 		path[32];

int 		controller, 
		pd, 
		max_disks,
		exitcode;

unsigned long 	icb_base();

main(argc,argv)
int argc;
char *argv[];
{
	register i, j;

	int 	fd, 
		kfd, 
		baseaddr, 
		ld,
	 	bsize=0xfff0,
		scsi,
		scsicont = -1,
		maxdevs;

	char 	*kmem = "/dev/kmem",
		icbname[16],
		tpath[32];

	struct bd_desc 	*bdptr;
	struct dev_desc	*devptr;
	struct pd 	*pdptr;
	struct ld 	*ldptr;
	struct tp 	*tpptr;
	struct icb 	icb;

	if(argc != 1){
		fprintf(stderr, "usage: %s\n",argv[0]);
		exit(1);
	}
	if((kfd = open(kmem,O_RDONLY)) < 0) {
		fprintf(stderr,"cannot open %s\n",kmem);
		exit(1);
	}

	for (i = 0; i < NUM_SLOTS; i++)  {
		scsi = 0;
		sprintf(icbname,"/dev/icb%.2d",i);
		if((fd = open(icbname,O_RDONLY)) < 0 )
			continue;
		if(ioctl(fd,ICBGET,&icb) < 0) {
			fprintf(stderr,"ioctl ICBGET failed on %s\n", icbname);
			close(fd);
			continue;
		}
		close(fd);
		switch(icb.type) {
			case SCSIEDT:
				scsi++;
				scsicont++;
				max_disks = MAX_SCSI;
				break;
			case HSDT:
			case EDT:
				max_disks = MAX_SMD;
				break;
			default:
				continue;
		}
		baseaddr = icb_base(icb.slot);
#ifdef S3000 
		if(lseek(kfd,kv_to_kmem(baseaddr),0) < 0) {
#else
		if(lseek(kfd,baseaddr,0) < 0) {
#endif     
			fprintf(stderr,"lseek to %x failed\n",baseaddr);
			exit(1);
		}
		/* 
		 * buffer size is such that the icb registers will not
		 * be touched.
		 */ 
		if((buffer = (char *)malloc((unsigned)bsize)) == NULL) {
			fprintf(stderr,"malloc of %x failed\n",bsize);
					exit(1);
		}
		if((read(kfd,buffer,bsize)) < 0) {
			fprintf(stderr,"read of %x from address %x failed\n",
				bsize,baseaddr);
			exit(1);
		}

		bdptr = (struct bd_desc *) (*(int *)&buffer[BDVECT] + buffer);

		devptr = (struct dev_desc *) ((int)bdptr->bd_dvptr + buffer);

		/* 
		 * loop through device types on this controller 
		 */
		for(j=0; j < bdptr->bd_devs; j++, devptr++) {

			if ( (devptr->dd_type & DTMSK) != DTDISK ) 
				continue;

			pdptr=(struct pd *)((int)devptr->dd_un.dd_pdisk+buffer);

			/* 
			 * loop through all disks on this controller
			 */
			for(pd=0; pd < max_disks; pd++, pdptr++) {
#ifndef S3000
				if (!scsi && pdptr->pd_ldnum) {
					sprintf(path,"/dev/rv%d", 
						controller * 4 + pd);
					checkdevice(path,RSRVMAJ,RSRVMIN,
						S_IFBLK, RSRV_MOD);
				}
#endif   
				ldptr=(struct ld *)((int)pdptr->pd_ptr+buffer);

				/* 
				 *  do all slices on this physical disk
				 */
				for(ld=0; ld < pdptr->pd_ldnum;ld++,ldptr++) {
					sprintf(path,"/dev/rdsk/c%dd%ds%d",
						controller,pd,ld);
					checkdevice(path,RDSKMAJ,DISKMIN,
						S_IFCHR, DISK_MOD);

					sprintf(path,"/dev/dsk/c%dd%ds%d",
						controller,pd,ld);
					checkdevice(path,DSKMAJ,DISKMIN,
						S_IFBLK, DISK_MOD); 
				}
			}
		}
		controller++;
	}
	exit(exitcode);
}

checkdevice(path,maj,min,type,perms)
	char *path;
	int maj, min, type, perms; 
{
	struct stat 	statb;
	int 		dev_ok = 0, 
			make_dev = 0,
			mode; 
	char 		*err;

	mode = type | perms;

	if(access(path,06) != 0) {	
		if(errno == ENOENT) 
			make_dev++;
		else { 
			fprintf(stderr,"cannot access %s : %s\n",						path,sys_errlist[errno]);
			exit(1);
		}
	} 
	else if (stat(path, &statb) != 0) {
		fprintf(stderr,"stat on %s failed.\n", path);
		exit(1);
	}	
	else {
		if (statb.st_mode != mode)
			err="mode";
		else if (statb.st_uid != OWNER) 
			err="owner";
		else if (statb.st_gid != GROUP)
			err="group";
		else if (statb.st_mode & S_IFMT != type)
			err="device type";
		else if (major(statb.st_rdev) != maj) 
			err="major number";
	        else if (minor(statb.st_rdev) != min)
			err="minor number";
		else 
			dev_ok++ ;

		if (! dev_ok) {
			printf("The existing %s has an incorrect %s.\n",
				path,err);
			fprintf("It will be deleted and recreated.\n");
			unlink(path);
			make_dev++;
		}
	}

	if (make_dev) {	
		if(mknod(path, mode, (int)makedev(maj,min)) < 0) {
			fprintf(stderr,"error creating %s\n",path);
			exitcode++;
			return;
		}
		else {	 
			chown(path,OWNER,GROUP);
			printf("Creating device %-20s : ",path);
			printf("major number %d, minor number %d.\n", maj,min);
		}
	}
}


/*
** hh1	this routine comes from gcttymon.c (where it is called get_gcbase)
*/
unsigned 
icb_base(slot)
	short slot;
{
	register unsigned gcbase;
#ifdef S3000
	register unsigned iom_num, icb_adj_slot, temp;

	iom_num = slot / NUM_ICB_DEVS_PER_IOA;
	icb_adj_slot = slot % NUM_ICB_DEVS_PER_IOA;
	gcbase = KIO_START;
	temp = (ICB_MAP_ENTRY + (iom_num * NEXT_ICB_MAP)) << PM_UnmappedBits;
	gcbase += temp;
	temp = icb_adj_slot * ICBDPMEMSZ;
	gcbase += temp;
#else	/* A1000 */
	gcbase = ICB_BASE(slot);
#endif	/* S3000 */
	return(gcbase);
}/*----------------------------------------------------------------------*/

#ifdef S3000
#define NDEVICES	10
#define MAJOR_MAX 	127
getmaj(name,number)
	char *name; 
	int number;
{
	static struct majdat {
			char *name[15];
			short	nmaj;
			short	maj[MAJOR_MAX]
		} majlist[NDEVICES], *majp;

	static int 	nknown = 0;
	char 		cmd[80];
	int 		num, i;
	FILE		*fp;

	for (i=0; i < nknown; i++) 
		if (!strcmp(name,majlist[i].name))
			if ( number < majlist[i].nmaj && number >= 0)
				return(majlist[i].maj[number]) ;
			else {
				fprintf(stderr,
				     "major number #%d not available for %s\n",
					number, name);
				exit(1);
			}

	majp = &majlist[nknown++] ;

	strcpy(majp->name, name);

	sprintf(cmd,"exec /etc/drvinstall -m %s -n",name);

	if ((fp = popen(cmd, "r")) == NULL) {
		perror("popen failed");
		exit(1);
	}
	for (i = 0; fscanf(fp, "%d", &num) == 1 ; i++){
		if (num < 0 || num > MAJOR_MAX) {
			fprintf(stderr,"drvinstall returned bad major # - %d", 
				num );
			exit(1);
		}
		majp->maj[i] = num;
	}
	if ( (majp->nmaj = i) <= number || number < 0 ) {
		fprintf(stderr,"major number %d not available for %s\n",
				number, name );
		exit(1);
	}
	return(majp->maj[number]);
}
#endif
	
