/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) df.c: version 25.1 created on 12/2/91 at 14:14:20	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)df.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*	ATT:#ident	"df:df.c	1.33"			*/

/*	kd0: 1/20/88 		df -f was not working		*/

#ident	"@(#)ps:df.c	25.1"


/*	Distributed Unix, FS Switching Version	*/
#include <stdio.h>
#include <sys/param.h>
#include <sys/fs/s5param.h>
#include <sys/types.h>
#include <sys/sysmacros.h>
#include <sys/ino.h>
#include <mnttab.h>
#include <sys/stat.h>
#include <ustat.h>
#include <sys/statfs.h>
#include <sys/fs/s5filsys.h>
#include <sys/fs/s5fblk.h>
#include <sys/fs/s5dir.h>
#include <setjmp.h>
#include <sys/errno.h>
#include <string.h>

#ifndef SVIDBLK		/* to be SVID compatible, we must report everything */
#define SVIDBLK	512	/* in 512 byte blocks				    */
#endif


#define MAXBSIZE 4096
#define ISIZE	inode_size (dev)
#define MX_NBINODE_OLD (MAXBSIZE/FsINODESIZE)
#define MX_NBINODE_NEW (MAXBSIZE/SEC_INODESIZE)

#define EQ(x,y,z) (strncmp(x,y,z)==0)
#define MNTTAB "/etc/mnttab"
#define MOUNTED fs_name[0]
#define DEVLEN sizeof(Mp.mt_dev)
#define DEVLSZ 200	/* number of unique file systems we can remember */
#define FREMOTE	0x0002	/* file is remote (see <sys/user.h>)  */

extern char *optarg;
extern int optind, opterr;
extern int errno;
char *devnm();

struct	mnttab	Mp;
struct stat	S;

/* kluge block for raw reads */
struct {
	char bootblock[512];
	struct filsys	supblock;
	} kblock;
/*#define sblock kblock.supblock	*/
struct	filsys	*sblock;

#ifdef SUPERBOFF
#undef SUPERBOFF
#endif
#define SUPERBOFF 0

/*struct ustat	*Fs=(struct ustat *)&sblock.s_tfree;	*/
struct ustat	*Fs;
struct statfs	Fs_info;

int	physblks;
long	bsize;
int 	bshift;
int	freflg, totflg, locflg;
int	fd;
daddr_t	blkno	= 1;
daddr_t	alloc();

char nfsmes[] = "          (%-10.32s): \
is not a file system, directory, or mounted resource\n";

char usage[] = "Usage: \
df [-lt] [-f] [{<file system> <directory> <mounted resource>}] ...\n";

#define	NAMSIZ	100
char	dot[] = ".";
char	dotdot[]="..";
extern  char *getcwd();
char	wdir[NAMSIZ], cdir[NAMSIZ];
long	p;

char *
basename(s)
char *s;
{
	int n = 0;

	while(*s++ != '\0') n++;
	while(n-- > 0)
		if(*(--s) == '/') 
			return(++s);
	return(--s);
}

/* pathname(s) - strip final component of pathname from path s (hh) */
char *
pathname(s)
char *s;
{
	char *pos;

	if ( (pos = (char *)strrchr(s,'/')) != 0) {
		if (pos == s)				/* leave "/" for root */
			pos++;
		*pos = 0;
	}
}

main(argc, argv)
char **argv;
{
	register fi, i;
	char	 dev[DEVLEN+1], *res_name, *s;
	int	 c, k, errcnt = 0;

	s = basename(argv[0]);
	if(!strncmp(s,"devnm",5)) {

		while(--argc) {
			if(stat(*++argv, &S) == -1) {
				fprintf(stderr,"devnm: ");
				errcnt++;
				continue;
			}
			res_name = devnm();
			if(res_name[0] != '\0')
				printf("%s %s\n", res_name, *argv);
			else {
				printf("devnm: %s not found\n", *argv);
				errcnt++;
			}
		}
		exit(errcnt);
	}

	while((c = getopt(argc,argv,"tfl")) != EOF) {
		switch(c) {

			case 'l':	/* do local resources only */
				locflg = 1;
				break;

			case 'f':	/* freelist count only */
				freflg++;
				break;

			case 't':	/* include total allocations */
				totflg = 1;
				break;

			default:
				fprintf(stderr,usage);
				exit(1);
		}
	}

	if((fi = open(MNTTAB, 0)) < 0) {
		fprintf(stderr,"df: cannot open %s\n",MNTTAB);
		exit(1);
	}
	while ((i = read(fi, &Mp, sizeof(Mp))) == sizeof(Mp)) {
	  if ((locflg && (Mp.mt_ro_flg & FREMOTE)) || (strlen(Mp.mt_dev)==0))
			continue;
#ifdef DEBUG
fprintf(stderr, "main: dev=%s mt_dev=%s len=%x\n", dev, Mp.mt_dev, strlen(Mp.mt_dev));
#endif
		sprintf(dev,"%.32s",Mp.mt_dev);
		if(argc > optind) {
				/* we are looking for specific file systems
				   in the mount table */
			for(k=optind;k < argc; k++) {
				if(argv[k][0] == '\0')
					continue;

				if (argv[k][0] != '/') { /* hh */

					getcwd(cdir, NAMSIZ);

					if (argv[k][0] == '.') {
						if (argv[k][1] == '.') 
							pathname(cdir);
					} else {
						strcat(cdir,"/");
						strcat(cdir,argv[k]);
					}
					argv[k] = cdir; 
				}			/* hh end */
				if(stat(argv[k], &S) == -1)
					S.st_dev = -1;

					/* does the argument match either
					   the mountpoint or the device? */
				if(EQ(argv[k], Mp.mt_dev, DEVLEN)
				|| EQ(argv[k], Mp.mt_filsys, DEVLEN)) {
					errcnt += printit(dev, Mp.mt_filsys);
					argv[k][0] = '\0';
				} else	
					/* or is it on one of 
						the mounted devices? */
					if( ((S.st_mode & S_IFMT) == S_IFDIR)
					&& (EQ(devnm(), Mp.mt_dev, DEVLEN))) {
						/* must re-do stat cuz
						   devnm() wiped it out */
						if(stat(argv[k], &S) == -1)
							S.st_dev = -1;
						errcnt += printit(dev, argv[k]);
						argv[k][0] = '\0';
					}
			}
		} else {
				/* doing all things in the mount table */
			if(stat(Mp.mt_filsys, &S) == -1)
				S.st_dev = -1;
			errcnt += printit(dev, Mp.mt_filsys);
		}
	}

			/* process arguments that were not in /etc/mnttab */
	for(i = optind; i < argc; ++i) {
		if(argv[i][0])
			errcnt += printit(argv[i], "\0");
	}

	close(fi);
	exit(errcnt);
}


printit(dev, fs_name)
char *dev, *fs_name;
{
	char mark;
	struct	filsys	*fsblock;
	char *fbuf , *cp, *malloc();



	if(MOUNTED && (Mp.mt_ro_flg & FREMOTE))
		if(freflg)
			return(0);

	if(!MOUNTED || freflg) {	/* Unmounted file system queries
					   and freelist querries work only
					   on UNIX file systems */
		if((fd = open(dev, 0)) < 0) {
			fprintf(stderr,"df: cannot open %s\n",dev);
			close(fd);
			return(1);
		}
		if(((S.st_mode & S_IFMT) == S_IFREG) 
		|| ((S.st_mode & S_IFMT) == S_IFIFO)) {
			printf(nfsmes, dev);
			close(fd);
			return(1);
		}

		sync();
		fbuf=malloc(BSIZE);

		if(lseek(fd, (long)SUPERBOFF, 0) < 0 ){
			close(fd);
			return(1);
		}	
		if ( read(fd, fbuf, BSIZE) != BSIZE) {
			close(fd);
			return(1);
		}	
/* FIX, RS works better if removed */
#if 0
		close(fd);
#endif
		cp= fbuf+512;
		fsblock=(struct filsys *)cp;
		sblock = (struct filsys *) cp;
		Fs = (struct ustat *)&sblock->s_tfree;	

		if(fsblock->s_magic == FsMAGIC) {
			if(fsblock->s_type == Fs1b) {
				physblks = 1;
				bsize = BSIZE;
				bshift = BSHIFT;
			} else if(fsblock->s_type == Fs2b || fsblock->s_type ==FsSEC1)  {		/* shen 11/19/89 corrected hh's mods */
				physblks = 2;
				bsize = BSIZE;
				bshift = BSHIFT;
			} else if(fsblock->s_type == Fs4b ) {
				physblks = 4;
				bsize = 0x800; /* 2k block */
				bshift = 11;
			} else if(fsblock->s_type == Fs8b || fsblock->s_type == FsSEC4) {
				physblks = 8;
				bsize = 0x1000; /* 4k block */
				bshift = 12;
			} else {
				printf("          (%-12s): bad block type\n", 
					dev );
				return(1);
			}
		} else {
			physblks = 1;
			bsize = BSIZE;
			bshift = BSHIFT;
		}
			/* file system sanity test */
		/******* ORIGINAL
		if(sblock.s_fsize <= sblock.s_isize
		|| sblock.s_fsize < Fs->f_tfree
		|| sblock.s_isize < Fs->f_tinode*sizeof(struct dinode)/bsize
	|| ((long)sblock.s_isize*bsize/sizeof(struct dinode)-2) > 0xffffL) {
			printf(nfsmes, dev);
			return(1);
		}
		******** END ORIGINAL */
		if(fsblock->s_fsize <= fsblock->s_isize
		|| fsblock->s_fsize < Fs->f_tfree	/*shen 11/19/89 */
		|| fsblock->s_isize < Fs->f_tinode*ISIZE/bsize /*shen11/19*/
	|| ((long)fsblock->s_isize*bsize/ISIZE-2) > 0xffffL) {
			printf(nfsmes, dev);
			return(1);
		}
		
	} else {	/* mounted file system */

		fbuf=malloc(BSIZE);
		cp= fbuf+512;
		sblock = (struct filsys *) cp;

/*		Fs=(struct ustat *)&kblock.supblock.s_tfree;	 */
		Fs=(struct ustat *)&sblock->s_tfree; /*shen 11/19/89 */	
		if(statfs(fs_name, &Fs_info, sizeof(struct statfs), 0) < 0) {
			fprintf(stderr, "df: cannot statfs %s errno=%x\t", 
				dev, errno);
			perror(" statfs");
			return(1);
		}
			/* copy statfs info into superblock structure */
		Fs->f_tfree = Fs_info.f_bfree;
		Fs->f_tinode = Fs_info.f_ffree;
		strncpy(Fs->f_fname,Fs_info.f_fname,sizeof(Fs_info.f_fname));
		strncpy(Fs->f_fpack,Fs_info.f_fpack,sizeof(Fs_info.f_fpack));

		bsize = (long) Fs_info.f_bsize;
/*		physblks = (int) ( bsize / SVIDBLK ) ;	*/
		physblks = 2;	/* shen spr# 3421 3/20/90 */
		/* set bshift according to bsize - only handle 1K, 2K, 4K. */
		bshift = bsize == 1024 ? 10 : ( bsize == 2048 ? 11 : 12 ) ;
	}

	if(!freflg) {
		if(!MOUNTED) 
			printf("  %-6.6s ", fsblock->s_fname);
		else
			printf("%-9s", fs_name);
		printf(" (%-16.32s):", dev);

			/* mark 2nd and subsequent reports on the same
							remote resource.  */
		mark = (firstpik()) ? ' ' : '*';
		if (MOUNTED)
		{
			printf(" %8ld blocks%c %7u i-nodes\n",
			Fs->f_tfree*physblks, mark, Fs->f_tinode); 
		}
		else
		{
			printf(" %8ld blocks%c %7u i-nodes\n",
			sblock->s_tfree*physblks, mark, sblock->s_tinode); 
		}
	} else {
		daddr_t	i;

		i = 0;
		while(alloc())
		{
			i++;
/*			printf("i=%d\n", i); */
		}
		printf("%-10s(%-12s): %8ld blocks\n",fs_name, dev,
			i*physblks);
		close(fd);
	}
	if(totflg) {
		printf("                   total: ");
		if(MOUNTED && !freflg)
			printf("%8ld blocks %7u i-nodes\n",
				Fs_info.f_blocks*physblks,
				Fs_info.f_files);
		else
			/******** ORIGINAL
			printf("%8ld blocks %7u i-nodes\n",
				sblock.s_fsize*physblks, 
				(unsigned)((sblock.s_isize - 2)
					*bsize/sizeof(struct dinode)));
			************* END ORIGINAL */
			printf("%8ld blocks %7u i-nodes\n",
				fsblock->s_fsize*physblks, 
				(unsigned)((fsblock->s_isize - 2)
					*bsize/ISIZE));
	}
	return(0);
}

firstpik()
{
	static dev_t devlst[DEVLSZ];
	static int i, ndev;

	if(S.st_dev == -1)
		return(1);

	if(ndev)
		for(i=0;i<ndev;i++)
			if(S.st_dev == devlst[i])
				return(0);

	if(ndev < DEVLSZ)
		devlst[ndev++] = S.st_dev;
	return(1);
}
daddr_t
alloc()
{
	int i;
	daddr_t	b;
/*	struct fblk buf; */
	struct fblk *buf;
	char *cp, *fbuf;
	
	i = --sblock->s_nfree;
	if(i<0 || i>=NICFREE) {
		printf("bad free count, b=%ld\n", blkno);
		return(0);
	}
	b = sblock->s_free[i];
	if(b == 0)
		return(0);
	if(b<sblock->s_isize || b>=sblock->s_fsize) {
		printf("bad free block (%ld)\n", b);
		return(0);
	}


	if(sblock->s_nfree <= 0) {
/*		bread(b, &buf, sizeof(buf)); */
		fbuf=malloc(BSIZE);
		bread(b, fbuf, BSIZE); 
		cp=fbuf;
		buf = (struct fblk *) cp;

		blkno = b;
		sblock->s_nfree = buf->df_nfree;
		for(i=0; i<NICFREE; i++)
			sblock->s_free[i] = buf->df_free[i];
		free(fbuf);
	}
	return(b);
}

bread(bno, buf, cnt)
daddr_t bno;
char *buf;
{
	int n;
	int temp;


	if((lseek(fd, bno<<bshift, 0)) < 0) {
		perror("bread: seek error");
		exit(1);
	}

/*	temp=cnt/1024 ;
	if ((cnt % 1024) >0) temp++;
	temp=temp*1024;
	if((n=read(fd, buf, temp)) != temp) {	 
*/

	if((n=read(fd, buf, cnt)) != cnt) {	 
		perror("bread: read error");
		printf("read error %x, count = %d\n", bno, n);
		exit(1);
	}
}

struct direct dbuf;

char *
devnm()
{
	int i;
	static short fno;
	static struct devs {
		char *devdir;
		short dfd;
	} devd[] = {		/* in order of desired search */
		"/dev/dsk",0,
		"/dev/rdsk",0,
		"/dev",0,
		"/dev/mirror", 0,
		"/dev/rmirror", 0,
		"/dev/stripe", 0,
		"/dev/rstripe", 0,
		0, 0
	};
	static char devnam[DEVLEN];

	devnam[0] = '\0';
	if(!devd[1].dfd) {	/* if /dev isn't open, nothing happens */
		for(i = 0; devd[i].devdir ; i++) {
			devd[i].dfd = open(devd[i].devdir, 0);
		}
	}
	fno = S.st_dev;

	for(i = 0; devd[i].devdir; i++) {
		if((devd[i].dfd >= 0)
		   && (chdir(devd[i].devdir) == 0) 
		   && (dsearch(devd[i].dfd,fno))) {
			strcpy(devnam, devd[i].devdir);
			strcat(devnam,"/");
			strncat(devnam,dbuf.d_name,DIRSIZ);
			return(devnam);
		}
	}
	return(devnam);

}

dsearch(ddir,fno)
short ddir, fno;
{
	lseek(ddir, (long)0, 0);
	while(read(ddir, &dbuf, sizeof dbuf) == sizeof dbuf) {
		if(!dbuf.d_ino) continue;
		if(stat(dbuf.d_name, &S) == -1) {
			fprintf(stderr, "devnm: cannot stat %s\n",dbuf.d_name);
			return(0);
		}
		if((fno != S.st_rdev) 
		|| ((S.st_mode & S_IFMT) != S_IFBLK)
		|| (strcmp(dbuf.d_name,"swap") == 0)
		|| (strcmp(dbuf.d_name,"pipe") == 0)
			) continue;
		return(1);
	}
	return(0);
}
