/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) devinfo.c: version 25.1 created on 12/2/91 at 14:14:08	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)devinfo.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

#ident	"@(#)cmd/devinfo:devinfo.c	25.1"

/*	devinfo:                                                   *
 *	                                                           *
*/

#include <stdio.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/errno.h>
#include <sys/sysmacros.h>
#include <sys/ioctl.h>

#ifdef S3000	/* hh1 */
#include <sys/vmem.h>	
#include <sys/pm_iomap.h>
#include <sys/sbus.h>
#include <sys/kmem.h>
#endif

#include <string.h>	/* jc1 */
#include <ctype.h>	/* jc1 */
#include <sys/stat.h>
#include <sys/iopm/dsdb/sdk_disk.h>
				/* jc1 */
				/* Note:  the numbers controllers and devices */
				/* are numbered from 0 up, so the largest */
				/* controller number of 4 controllers is "3" */
#define	MAX_SMD_CONT	3	/* maximum number of smd controllers allowed */
#define	MAX_SMD_DEV	3	/* maximum number of smd devices allowed */
#define	MAX_SCSI_CONT	3	/* maximum number of scsi controllers allowed */
#define	MAX_SCSI_DEV	13	/* maximum number of scsi devices allowed */

#define MAX_DEVICES (scsi ? MAX_SMD_DEV : MAX_SCSI_DEV)
#define MAX_CONTROLLERS (scsi ? MAX_SMD_CONT : MAX_SCSI_CONT)
#define MAX_SLICES	15

char *buffer, *device;
char devname[16];
char path[32];
int controller, pd, ld;
struct sdk_block_0 slice;

main(argc,argv)
int argc;
char *argv[];
{
	register i, j, f;
	char c;
	int fd, baseaddr, board = 0, diskflag = 0, boardflag=0; 
	int vflg = 0, iflg = 0, pflg = 0, errflg = 0;	/* jc0 */
	char *filename = "/dev/kmem";
	char tpath[32];
	register struct bd_desc *bdptr;
	register struct dev_desc *devptr;
	register struct pd *pdptr;
	struct ld *ldptr;
	struct tp *tpptr;
	int bsize=0xfff0;
	extern char *optarg;	/* jc0 */
	int scsi = 0;		/* jc1 */
	int index, length, major_num, minor_num; 	/* jc1 */
	struct stat statb;	/* jc1 */
	int p,r,ldcount;

	setbuf(stdout,0);

	if (argv[1][0] != '-') {
		fprintf(stderr, "Usage: devinfo [-v] -p device | -i device \n");
		exit(2);
	}
	else {
		while ((c = getopt(argc, argv, "vi:p:")) != EOF) {
			switch (c) {
			case 'v':
				vflg++;
				break;
			case 'i':
				if (pflg)	/* jc0 */
					errflg++;
				else
				{
					iflg++;
					device = optarg;
				}
				break;
			case 'p':
				if (iflg)	/* jc0 */
					errflg++;
				else
				{
					pflg++;
					device = optarg;
				}
				break;
			case '?':
				errflg++;
				break;
			}
			if (errflg) {
				fprintf(stderr, "Usage: devinfo -p device | -i device \n");	/* jc0 */
				exit(2);
			}
		}
	}

	/* check validity of beginning of device name */
	if(strncmp(device,"/dev/rdsk/",10) != 0)
	{
		fprintf(stderr,"%s is an invalid device.\n",device);
		exit(2); 
	}

	/* is this a scsi device? - jc1 */
	/* Use an ioctl GET_DISK_SIZE on the device - an error indicates smd, */
	/* a not-error (-1) return value indicates SCSI */

	if((fd = open(device,O_RDONLY)) < 0) {
		fprintf(stderr,"cannot open %s\n",device);
		exit(1);
	}

	/* JTOF - S90 and A1000 3.0 now support scsi/smd  GET_DEV_TYPE 
		  it's now the proper way to do things 5/6/89  */

	if (ioctl(fd,GET_DEV_TYPE,0) == SMD_TYPE) 
		scsi=0;
	else
		scsi=1;
	
	close(fd);
		
	/* determine controller number, physical device, logical device */
	/* in form of: /dev/rdsk/cXXdYYsZZ - jc1 */

	index=11;	/* start after the "c" in /dev/rdsk/cXXdYYsZZ */
	length=strlen(device)-1;	/* correct for 0 = start of string */

	controller=0;

	while ( (index <= length) && (isdigit(device[index++]))) 
		controller=(controller * 10) + (device[index-1] - '0');

	pd=0;
	while ( (index <= length) && (isdigit(device[index++]))) 
		pd=(pd * 10) + (device[index-1] - '0');

	ld=0;
	while ( (index <= length) && isdigit(device[index++]) ) 
		ld=(ld * 10) + (device[index-1] - '0');

	/* check for legal controller, pd and ld device numbers - jc1 */

	if ((controller > MAX_CONTROLLERS) || (pd > MAX_DEVICES) || 
	    (ld > MAX_SLICES)) {
		fprintf(stderr,"%s is an invalid device.\n",device);
		exit(2); 
	}

	/* get the major and minor device numbers for the device - jc1 */

	if (stat(device, &statb) < 0) {
		fprintf(stderr,"Stat on %s failed.\n", device);
		exit(2);
	} else {
       		if (((statb.st_mode & S_IFMT) == (S_IFBLK)) || 
		   ((statb.st_mode & S_IFMT) == (S_IFCHR))) {
			major_num=major(statb.st_rdev);
			minor_num=minor(statb.st_rdev);
		} else {
			fprintf(stderr,"%s is not a character or block special device\n", device);
			exit(2);
		}
	}

/* See if it's an IOPM world ... */

	if ((fd = open(device,O_RDONLY)) < 0)  {
		fprintf(stderr,"Cannot open device %s\n",device);
		exit(2); 
	}

	if (ioctl(fd, SDK_READ_VTOC, &slice) < 0) {
/*		fprintf(stderr,"ioctl READ_VTOC failed on %s\n", device); */
		close(fd);
		}
	else
	{
		p= slice.misc.disk_info.vol_id; 
		if (r=(strncmp(p, "IOPMSCSI",8)) != 0)
		{
		fprintf(stderr,"%s is an invalid device.\n",device);
		exit(2); 
		};
		if (slice.misc.disk_info.date != 0x19890828)
		{
		fprintf(stderr,"%s is an invalid device.\n",device);
		exit(2); 
		};

		if(iflg) 
		{
		if(vflg)
		  {
		printf("  Device Name     Blocks/Cyl.     Bytes/Block       # of partitions with size\n");
		printf("                                                    greater than zero\n");
		  }
		/* -i option */
		for (j=0; j< MAX_IOPM_SLICES; j++)
		  if (slice.slice_table[j].ldrv.ld_size > 0) ++ldcount;
		printf("%s       %d            %d              %d\n",device,
		slice.slice_table[ld].ldrv.ld_spt * slice.misc.disk_info.heads,
		slice.misc.disk_info.bps, ldcount);
		}
		else
		{
		if(vflg)
		printf("  Device Name     Major #   Minor #     Start Block    Total Blocks      Type\n"); 
		/* -p option */
		
		if (ld >  MAX_IOPM_SLICES)
		{
		fprintf(stderr,"logical disk %d does not exist in system\n",ld);
		exit(2);
		}
	printf("%s     %d        %d            %d           %d            %d\n",
		device,major_num,minor_num,
		slice.slice_table[ld].ldrv.ld_strt,
		slice.slice_table[ld].ldrv.ld_size,
		slice.slice_table[ld].ldrv.ld_type);
	}	
	exit(0);
	}
}
