/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) css.c: version 25.1 created on 12/2/91 at 14:09:12	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)css.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/*
 * css.c - display contents of CSS bus slots.
 */

#include <sys/types.h>
#include <stdio.h>
#include <sys/sbus.h>
#include <sys/spm_mem.h>
#include <sys/sysarix.h>
#include <sys/sbus_iopm.h>
#include <sys/sbus_iom.h>

#ifndef SBUS_IOPM
#define	SBUS_IOPM	SBUS_GIO
#endif

#define ONEMB	1048576

struct spm_mem	spm_mem;

#define ID	spm_mem.sbus_slot_id

char		*prog_name;

static int	iom_cnt, vam_cnt;	/* Board counts */


/*ARGSUSED2*/
int
die(n, fmt, a, b, c)
int	n;
char	*fmt;
int	a, b, c;
{
	int		errnum;
	extern int	errno, sys_nerr;
	extern char	*sys_errlist[];
	extern void	exit();

	errno = errnum;
	fprintf(stderr,"%s : ", prog_name);
	fprintf(stderr, fmt, a, b, c);

	if (errnum == 0)
		fprintf(stderr, "\n");
	else if (errnum > 0 && errnum < sys_nerr)
		fprintf(stderr, " (%s)\n", sys_errlist[errnum]);
	else
		fprintf(stderr, " (error = %d)\n", errnum);

	exit(n);
}

static char *
iopm_name(dev_board_id, nump)
uchar	dev_board_id;
int	*nump;
{
	static int	iopm_acdb_cnt, iopm_dsdb_cnt, iopm_lanwan_cnt;
	static char	str[12];

	switch (dev_board_id) {
	case IOPM_DB_ID_DSDB:
	case IOPM_DB_ID_DSDB_FIX:
		*nump = iopm_dsdb_cnt++;
		return ("IOPM.DSDB");
	case IOPM_DB_ID_ACDB:
		*nump = iopm_acdb_cnt++;
		return ("IOPM.ACDB");
	case IOPM_DB_ID_LAN_WAN:
		*nump = iopm_lanwan_cnt++;
		return ("IOPM.LANWAN");
	case IOPM_DB_ID_IOPM_TEST1:
	case IOPM_DB_ID_IOPM_TEST2:
		*nump = 0;
		return ("IOPM.TEST");
	case IOPM_DB_ID_ACDB_38K:
		*nump = iopm_acdb_cnt++;
		return ("IOPM.ACDB-38");
	case IOPM_NO_DB:
		*nump = 0;
		return ("IOPM.NOBOARD");
	default:
		*nump = 0;
		sprintf(str, "IOPM.0x%02x", dev_board_id);
		return (str);
	}
}

char *
pathend(path)
char	*path;
{
	char	*p, *strrchr();

	if (p = strrchr(path, '/'))
		return (p + 1);
	return (path);
}


main(argc, argv)
int	argc;
char	*argv[];
{
	register char	*type;
	register int	cnt, mem, ver;
	register int	i;
	register int	mm_cnt = 0, pm_cnt = 0;
	int		num;

	prog_name = pathend(argv[0]);

	if (sysarix(ARIXGETSPM_MEM, &spm_mem) < 0)
		die(4, "sysarix ARIXGETSPM_MEM system call failed.");

	printf("  Slot     Type        Board      Memory(MB)   Version\n");

	for (i = 0; i < SBUS_NUM_SLOT; i++) {

		switch (ID[i]) {
		case SBUS_SPM:
			type = "SPM";
			cnt = 0;
			mem = 0;
			ver = spm_mem.spm_version;
			break;
		case SBUS_MM:
			type = "MM";
			cnt = mm_cnt++;
			mem = spm_mem.slot_size[i] / ONEMB;
			ver = 0;
			break;
		case SBUS_MM2:
			type = "MM2";
			cnt = mm_cnt++;
			mem = spm_mem.slot_size[i] / ONEMB;
			ver = 0;
			break;
		case SBUS_PM20:
			type = "PM20";
			cnt = pm_cnt++;
			mem = 0;
			ver = 0;
			break;
		case SBUS_DPM40_SGL:
			type = "DPM40_SGL";
			cnt = pm_cnt++;
			mem = 0;
			ver = 0;
			break;
		case SBUS_DPM40_DBL:
			type = "DPM40_DBL";
			cnt = pm_cnt++;
			mem = 0;
			ver = 0;
			break;
		case SBUS_IOM:
		case SBUS_NIOM:
			type = "IOM";
			cnt = iom_cnt++;
			mem = 0;
			ver = 0;
			break;
		case SBUS_IOPM:
		case (SBUS_IOPM - 1):	/* FIX: del when all proto-IOPMs gone */
			type = iopm_name(spm_mem.dev_board_id[i], &num);
			cnt = num;
			mem = 0;
			ver = 0;
			break;
		case SBUS_NO_BOARD:
			continue;
		case SBUS_VAM:
			type = "VAM";
			cnt = vam_cnt++;
			mem = 0;
			ver = 0;
			break;
		default:
			printf("%4d Unrecognized board: ID = 0x%02x\n",
			  i, ID[i]);
			continue;
		}
		printf("  %2d     %-12s   %2d      %8d  %12#x\n",
		  i, type, cnt, mem, ver);

		if (ID[i] == SBUS_IOM || ID[i] == SBUS_NIOM)
			display_iom(i);
	}
	return (0);
}


int
display_iom(iom_slot)
uint	iom_slot;
{
	register int	iom_count, slot;
	register char	*type;
	register int	cnt;
	register int	bad = 0;
	int		num;
	iom_config_t	*iomptr;
	css_bd_dat_t	*cssptr;

	iomptr = spm_mem.iom_config;
	slot = iom_slot;
	for (iom_count = NUM_IOM_PER_SYS; --iom_count >= 0; iomptr++) {
		if (iomptr->iom_slot == slot)
			break;
	}
	if (iom_count < 0)
		die(-1, "display_iom: can't find iom_slot %d!", slot);

	switch (iomptr->card_cage_type) {
	case IOM_TYPE_IOA:
		printf(" [%2d] ICB Bus (unsupported)\n", slot);
		return;
	case IOM_TYPE_IOSBA:
		break;			/* OK */
	case IOM_TYPE_NO_BOARD:
		printf(" [%2d] No Expansion Bus\n", slot);
		return;
	default:
		printf(" [%2d] Unknown Card Cage Type = 0x%02x\n",
		  slot, iomptr->card_cage_type);
		return;
	}

	cssptr = iomptr->ex_card_cage.css_bd_dat;
	for (slot = 0; slot < SBUS_NUM_SLOT; slot++, cssptr++) {
		switch (cssptr->css_slot_id) {
		case SBUS_IOPM:
		case (SBUS_IOPM - 1):	/* FIX: del when all proto-IOPMs gone */
			type = iopm_name(cssptr->dev_board_id, &num);
			cnt = num;
			break;

		case SBUS_VAM:
			type = "VAM";
			cnt = vam_cnt++;
			break;

		case SBUS_NO_BOARD:
			continue;

		case SBUS_SPM:
			type = "SPM";
			bad = 1;
			break;
		case SBUS_MM:
			type = "MM";
			bad = 1;
			break;
		case SBUS_MM2:
			type = "MM2";
			bad = 1;
			break;
		case SBUS_PM20:
			type = "PM20";
			bad = 1;
			break;
		case SBUS_DPM40_SGL:
			type = "DPM40_SGL";
			bad = 1;
			break;
		case SBUS_DPM40_DBL:
			type = "DPM40_DBL";
			bad = 1;
			break;
		case SBUS_NIOM:
		case SBUS_IOM:
			type = "IOM";
			bad = 1;
			break;
		default:
			printf("  %2d.%-2d   Unrecognized Board! ID = 0x%02x\n",
			  iomptr->iom_slot, slot, cssptr->css_slot_id);
			continue;
		}
		if (bad) {
			printf("  %2d.%-2d  %-12s <--- Illegal in Expansion!\n",
			  iomptr->iom_slot, slot, type);
			bad = 0;
			continue;
		}
		printf("  %2d.%-2d  %-12s   %2d      %8d    %10#x\n",
		  iomptr->iom_slot, slot, type, cnt, 0, 0);
	}
}
