/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) sigport.c: version 25.1 created on 12/2/91 at 14:09:00	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)sigport.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/* jc26 */
#include "sys/signal.h"
#include <sys/param.h> 
#include "errno.h"

#ifndef NOJOBS
#ifdef	_POSIX_SOURCE
#ifdef	SIGTSTP
extern	int	csh_has_job_control;	/* defined in sh.c - mu0	*/
#endif	/* SIGTSTP */
#endif	/* _POSIX_SOURCE */
#endif /* NOJOBS */

/* add signal routines sigblock and sigsetmask (and printmask for debugging)
 * - port */

/* There are 3 signal routines used in Berkeley which are not available
 * for AT&T UNIX: sigmask, sigblock, sigsetmask.  */
 
/*static int	globalmask; */	/* create a global mask, to be used by */
int	globalmask;	/* create a global mask, to be used by */
			/* sigblock and sigsetmask. The bits set to */
			/* true in globalmask represent signals to  */
			/* block */

/* To replace "sigblock" and "sigsetmask", we need two items per signal:  
 * blocked or not (a boolean), and the prior state of the signal.  Set up
 * a structure to hold these values for each signal.  Note that the 
 * structure array starts at "0", but the first signal vaule is "1".  array[0]
 * will mean signal #1. */

#define	MASKLENGTH NSIG		/* mask length is same as the number of  */
				/* signals - should also not exceed length of */
				/* an integer (currently=32)*/ 

typedef	char	bool;	/* swiped from sh.h */


/* NOTE:  It is not possible to "block" SIGKILL; Berkeley also cannot block
 * SIGSTOP, or SIGCONT (two signals which we don't have). - port */

/* The usages of sigblock in the code would only have 1 bit set to block,
 * so this code is not, in practice, too expensive to execute */
/* Sigblock has the side effect of adding to globalmask */
/* The initial value of globalmask=0 */

int
sigblock(mask)	/* sigblock returns old mask */
	int	mask;
{
	int	oldmask;
	int	place;
	
	oldmask=globalmask;	/* set up to return prior mask */

			/* sigblock will NOT UNblock signals... */

	if (mask!=0)		/* save time if mask = 0 */
	{		
		globalmask=(mask | globalmask);	  /* add new mask values to  */
						  /* global mask */

		/* look at each bit in the new mask, and block any new items */

		for (place=0; ((place<MASKLENGTH) && (mask!=0)); ++place)
		{
			if (mask & 1)	 /* block the signal if set */
				(void) sighold(place+1);
			
			mask=mask>>1;	/* go on to the next bit */ 
		}	/* stop when done or mask = 0 (no more to do) */
	}
	return (oldmask);
}

/* block signals which should be blocked, unblock those which are not blocked */ 
/* returns nothing, but affects globalmask */

#ifdef sigsetmask
#undef sigsetmask
#endif

/* SIGSETMASK will block or unblock signals as needed, depending on their */
/* bit values in the mask given to sigsetmask. */

sigsetmask(mask)
	int	mask;
{
	int	place;

	globalmask=mask;	 /* reset global mask */

		/* faster to duplicate sigblock's function */
		/* block any new items as needed */

	for (place=0; place<MASKLENGTH; ++place) /* block items as needed */
	{
		if (mask & 1)  /* block the signal if set in mask */
			(void) sighold(place+1); 
		/* UNblock items as needed */
		else if (!(mask & 1)) /* release (unblock) the signal */
			(void) sigrelse(place+1); 
		
		mask=mask>>1;	/* go on to the next bit */
	}
}

/* printmask, used in debugging, will print the binary value of the mask */

void
printmask(mask, masklength)
	int	mask;
	int 	masklength;
{
	int	place;
	
	/* will print for 0 to 22 (for NSIG=23 signals) */

	for (place=0; place<masklength; place++)
	{
		printf("%d", place % 8);
	}
	printf("\n");

	for (place=0; place<masklength; place++)
	{
		printf("%d",(mask&(1<<(masklength-1)))==(1<<(masklength-1))); /* force 1 or 0 */
		mask=mask<<1;
	} 
	printf("\n");
}

sigact(sig,func)
int sig;
void (* func)();
{
	struct sigaction action,oact,*act;

	if (csh_has_job_control) {	/* mu0	*/
		act = &action;

		act->sa_handler = func;
		act->sa_mask = 0;
		act->sa_flags = 0;

		if(sigaction(sig,act,&oact))
			printf("csh: sigaction failed (error 0x%x)\n",errno);

		return((int)oact.sa_handler);
	} else {			/* mu0	*/
		return (signal(sig,func));
	}				/* mu0	*/
}

/* sigpause for the Berkeley system takes mask, not signal.  Sigpause assigns
 * mask to the set of masked signals and then waits for a signal to arrive.
 * As used in the csh code:
 *
 * sh.proc.c:		sigpause(sigblock(0) &~ sigmask(SIGCHLD));
 * sh.proc.c:			sigpause(0);
 *
 * On return the set of masked signals is restored.  Sigmask is usually 0
 * to indicate that no signals are now to be blocked.  sigpause always 
 * terminates by being interrupted.
 */
