/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) signal.h: version 25.1 created on 12/2/91 at 14:08:56	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)signal.h	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#ifndef SYS_SIGNAL_H
#define SYS_SIGNAL_H

/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*	ATT: #ident	"kern-port:sys/signal.h	10.9"		*/

#ident	"@(#)uts/head/sys:signal.h	25.1"

#define	SIGHUP	1	/* hangup */
#define	SIGINT	2	/* interrupt (rubout) */
#define	SIGQUIT	3	/* quit (ASCII FS) */
#define	SIGILL	4	/* illegal instruction (not reset when caught)*/
#define	SIGTRAP	5	/* trace trap (not reset when caught) */
#define	SIGIOT	6	/* TRAPV instruction */
#define SIGABRT 6	/* used by abort, replace SIGIOT in the  future */
#define	SIGEMT	7	/* EMT instruction */
#define	SIGCHK	7	/* CHK instruction */
#define	SIGFPE	8	/* floating point exception */
#define	SIGKILL	9	/* kill (cannot be caught or ignored) */
#define	SIGBUS	10	/* bus error */
#define	SIGSEGV	11	/* segmentation violation */
#define	SIGSYS	12	/* bad argument to system call */
#define	SIGPIPE	13	/* write on a pipe with no one to read it */
#define	SIGALRM	14	/* alarm clock */
#define	SIGTERM	15	/* software termination signal from kill */
#define	SIGUSR1	16	/* user defined signal 1 */
#define	SIGUSR2	17	/* user defined signal 2 */
#define	SIGCLD	18	/* death of a child */
#define	SIGPWR	19	/* power-fail restart */
#define	SIGWINCH 20	/* user defined signal 3 */
#define	SIGUSR4	21	/* user defined signal 4 */
#define SIGPOLL 22	/* pollable event occured */
/* POSIX SIGNALS!!! */
#define SIGSTOP 23	/*stop sig. can't be caught or ignored */
#define SIGCONT 24	/*continue if stopped    */
#define SIGTSTP 25	/*interactive stop sig from terminal */
#define SIGTTIN 26	/*read from control tty-from background process*/
#define SIGTTOU 27	/*write to control tty-from background process*/
#define SIGCHLD SIGCLD  /*redefined for posix; both are child-death signals */
#define	NSIG	28	/* The valid signal number is from 1 to NSIG-1 */
#define MAXSIG	32	/* size of u_signal[], NSIG-1 <= MAXSIG*/
			/* MAXSIG is larger than we need now. */
			/* In the future, we can add more signal */
			/* number without changing user.h */

#if lint
#define SIG_ERR (void(*)())0
#else
#define SIG_ERR	(void(*)())-1
#endif
#define	SIG_DFL	(void(*)())0
#if lint
#define	SIG_IGN	(void (*)())0
#else
#define	SIG_IGN	(void (*)())1
#endif
#if lint
#define SIG_HOLD (void(*)())0
#else
#define SIG_HOLD (void(*)())2
#endif
#if lint
#define SIG_CATCH (void(*)())0
#else
#define SIG_CATCH (void(*)())3	/* posix; for now...it may change */
#endif

/* The following definitions are only used by kernel */
#define SIGNO_MASK	0xff
#define SIGDEFER	0x0100
#define SIGHOLD		0x0200
#define SIGRELSE	0x0400
#define SIGIGNORE	0x0800
#define SIGPAUSE	0x1000
/* more such defined for posix */
#define SIG_BLOCK	0x0001
#define SIG_UNBLOCK	0x0002
#define SIG_SETMASK	0x0004


/* SIGFPE codes */

#define	KINTOVF	1	/* integer overflow */
#define	KINTDIV	2	/* integer divide by zero */
#define	KFLTOVF	3	/* floating overflow */
#define	KFLTDIV	4	/* floating divide by zero */
#define	KDECDIV	KFLTDIV	/* decimal divide by zero */
#define	KFLTUND	5	/* floating underflow */
#define	KDECOVF	6	/* decimal overflow */
#define	KSUBRNG	7	/* subscript range */

/* The following codes correspond to new exceptions generated
** by the M68881 floating point chip.				*/
#define	KFPBSUN	18	/* FPU exc. - Branch or Set on UNordered cond.*/
#define	KFPINEX	19	/* FPU exc. - INEXact result */
#define	KFPDZ  	20	/* FPU exc. - Divide by Zero */
#define	KFPUNFL	21	/* FPU exc. - UNderFLow */
#define	KFPOPER	22	/* FPU exc. - OPerand ERror */
#define	KFPOVFL	23	/* FPU exc. - OVerFLow */
#define	KFPSNAN	24	/* FPU exc. - Signalling NAN */


/* FOR POSIX!!!!!*/
 /* since SIGCONT can be blocked, it can't be a part of CANTMASK */
#define	CANTMASK	(sigbit(SIGKILL)|sigbit(SIGSTOP))
#define	STOPSIGMASK	(sigbit(SIGSTOP)|sigbit(SIGTSTP)| \
			sigbit(SIGTTIN)|sigbit(SIGTTOU))

typedef int sigset_t;
typedef struct sigaction {	/*sigaction struct defined for posix */
	void(*sa_handler)();
	sigset_t 	 sa_mask;
	int		 sa_flags;
	} sigact_t;

#define	SA_NOCLDSTOP 0x1

#endif /* SYS_SIGNAL_H */
