/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) sh.proc.c: version 25.1 created on 12/2/91 at 14:08:36	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)sh.proc.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*
 * Copyright (c) 1980 Regents of the University of California.
 * All rights reserved.  The Berkeley Software License Agreement
 * specifies the terms and conditions for redistribution.
 */

#ifndef lint
static char *sccsid = "@(#)sh.proc.c	5.5 (Berkeley) 5/13/86";
#endif

#include "sys/signal.h"
#ifndef	NOJOBS
#ifdef	_POSIX_SOURCE
#ifdef	SIGTSTP
#include	<sys/sysarix.h>
#include <sys/proc.h>
extern	int	csh_has_job_control;	/* defined in sh.c - mu0	*/
#endif	/* SIGTSTP */
#endif	/* _POSIX_SOURCE */
#endif	/* NOJOBS */
#include "sh.h"
#include "sh.dir.h"
#include "sh.proc.h"
#include <sys/wait.h>
#include <sys/ioctl.h>

/*
 * C Shell - functions that manage processes, handling hanging, termination
 */

#define BIGINDEX	9	/* largest desirable job index */

/*
 * pchild - called at interrupt level by the SIGCHLD signal
 *	indicating that at least one child has terminated or stopped
 *	thus at least one wait system call will definitely return a
 *	childs status.  Top level routines (like pwait) must be sure
 *	to mask interrupts when playing with the proclist data structures!
 */
pchild()
{
	register struct process *pp;
	register struct process	*fp;
	register int pid;
	int jobflags;
	struct rusage ru;
	int high_bits;
	int low_bits;
	int HIGHMASK=00000000377000;
	int LOWMASK =0xff;
	int ret_wait;

#ifdef PORT	/* jc22 */
	int wait_stat;
#else
	union wait w;
#endif /* PORT */

loop:

#ifdef PORT	/* jc22 */
	if (csh_has_job_control) {	/* mu0	*/
		pid = waitpid(-1,&wait_stat,setintr?WNOHANG|WUNTRACED:WNOHANG);
		ret_wait = 0;
	} else {			/* mu0	*/
		pid = wait(&wait_stat);
		ret_wait = -1;
	}				/* mu0	*/
	if (pid <= ret_wait) {
		if (errno == EINTR) {
			errno = 0;
			goto loop;
		}
		if (errno == ECHILD) 	/* the calling process has no */
					/* existing unwaited for child */
			(void) sigact(SIGCHLD, pchild); /* jc4 reset value */
							/* for SIGCHLD */	
			return;     /* change goto loop to this - jc */
	}
#else
	pid = wait3(&w, (setintr ? WNOHANG|WUNTRACED:WNOHANG), &ru);
		/* if child terminated due to a signal (not stopped or */
		/* exited) then wait3 returns "0" ...*/
	if (pid <= 0) {
		if (errno == EINTR) {
			errno = 0;
			return; 
			goto loop; 
		}
		pnoprocesses = pid == -1; /* this means no new processes to */
					  /* wait for - we don't do that */
		return;
	}
#endif /*PORT */

	for (pp = proclist.p_next; pp != PNULL; pp = pp->p_next)
		if (pid == pp->p_pid)
			goto found;
	goto loop;
found:
	if (pid == atoi(value("child")))
		unsetv("child");
	high_bits=((wait_stat>>8) & LOWMASK);
	low_bits=(wait_stat & LOWMASK);
	pp->p_flags &= ~(PRUNNING|PSTOPPED|PREPORTED);

#ifdef PORT	/* jc22 */
	if (csh_has_job_control) {	/* mu0	*/
		if(WIFSTOPPED(wait_stat)) {
			pp->p_flags |= PSTOPPED;
			pp->p_reason = WSTOPSIG(wait_stat);
			goto around_csh_svid_mode;
		} else
			goto csh_svid_mode;
	} else {			/* mu0	*/
		/* low 8 bits = 0177 */
		if ((low_bits & 0177) == 0177) {
			pp->p_flags |= PSTOPPED;
			/* high bits only */
			pp->p_reason = (high_bits);
			goto around_csh_svid_mode;
		} else
			goto csh_svid_mode;
	}				/* mu0	*/
#else
	if (WIFSTOPPED(w)) {
		pp->p_flags |= PSTOPPED;
		pp->p_reason = w.w_stopsig;
	} else
#endif /* ifdef PORT */
	{
csh_svid_mode:

#ifdef NOTIMING	/* jc6 */
#ifdef DEBUGPORT
		printf("in sh.proc.c: pchild:  don't have gettimeofday\n");
#endif /* DEBUGPORT */
#else
		if (pp->p_flags & (PTIME|PPTIME) || adrof("time"))
			(void) gettimeofday(&pp->p_etime, (struct timezone *)0);
		pp->p_rusage = ru;
#endif /* ifdef NOTIMING */

#ifdef PORT	/* jc22 */
		if (csh_has_job_control) {	/* mu0	*/
			if(WIFSIGNALED(wait_stat)) {
				/* case:  signaled */
				/* which low 7 bits are set? */
				if (low_bits&0x7f == SIGINT)
					pp->p_flags |= PINTERRUPTED;
				else
					pp->p_flags |= PSIGNALED;
				/* check for core dump */
				if ((low_bits & 0x80) == 0x80)
					pp->p_flags |= PDUMPED;
				/*hh0 : strip dump bit*/
				pp->p_reason = low_bits & 0x7f;
			} else {
				/* if low 8 bits  = 0 , case=exit*/
				/* child's exit code = high 8 bits */ 
				pp->p_reason = WEXITSTATUS(wait_stat);
				if (pp->p_reason != 0)
					pp->p_flags |= PAEXITED;
				else
					pp->p_flags |= PNEXITED;
			}
		} else {			/* mu0	*/
			if (!low_bits) {
				/* if low 8 bits  = 0 , case=exit*/
				/* child's exit code = high 8 bits */ 
				pp->p_reason = high_bits;
				if (pp->p_reason != 0)
					pp->p_flags |= PAEXITED;
				else
					pp->p_flags |= PNEXITED;
			} else {
				/* case:  signaled */
				/* which low 8 bits are set? */
				if ((low_bits & 0177) == SIGINT)
					pp->p_flags |= PINTERRUPTED;
				else
					pp->p_flags |= PSIGNALED;
				/* check for core dump */
				if ((low_bits & 0200) == 0200)
					pp->p_flags |= PDUMPED;
				/*hh0 : strip dump bit*/
				pp->p_reason = low_bits & 0177;
			}
		}				/* mu0	*/
#else
		if (WIFSIGNALED(w)) { 
			if (w.w_termsig == SIGINT)
				pp->p_flags |= PINTERRUPTED;
			else
				pp->p_flags |= PSIGNALED;
			if (w.w_coredump)
				pp->p_flags |= PDUMPED;
			pp->p_reason = w.w_termsig;
		} else {
			pp->p_reason = w.w_retcode;
			if (pp->p_reason != 0)
				pp->p_flags |= PAEXITED;
			else
				pp->p_flags |= PNEXITED;
		}
#endif /* PORT */
	}
around_csh_svid_mode:
	jobflags = 0;
	fp = pp;
	do {
		if ((fp->p_flags & (PPTIME|PRUNNING|PSTOPPED)) == 0 &&
		    !child && adrof("time") &&
		    fp->p_rusage.ru_utime.tv_sec+fp->p_rusage.ru_stime.tv_sec >=
		     atoi(value("time")))
			fp->p_flags |= PTIME;
		jobflags |= fp->p_flags;
	} while ((fp = fp->p_friends) != pp);
	pp->p_flags &= ~PFOREGND;
	if (pp == pp->p_friends && (pp->p_flags & PPTIME)) {
		pp->p_flags &= ~PPTIME;
		pp->p_flags |= PTIME;
	}
	if ((jobflags & (PRUNNING|PREPORTED)) == 0) {
		fp = pp;
		do {
			if (fp->p_flags&PSTOPPED)
				fp->p_flags |= PREPORTED;
		} while((fp = fp->p_friends) != pp);
		while(fp->p_pid != fp->p_jobid)
			fp = fp->p_friends;
		if (jobflags&PSTOPPED) {
			if (pcurrent && pcurrent != fp)
				pprevious = pcurrent;
			pcurrent = fp;
		} else
			pclrcurr(fp);
		if (jobflags&PFOREGND) {
			if (jobflags & (PSIGNALED|PSTOPPED|PPTIME) ||
#ifdef IIASA
			    jobflags & PAEXITED ||
#endif /* IIASA */
			    !eq(dcwd->di_name, fp->p_cwd->di_name)) {
				;	/* print in pjwait */
			}
/*
		else if ((jobflags & (PTIME|PSTOPPED)) == PTIME)
				ptprint(fp);
*/
		} else {
			if (jobflags&PNOTIFY || adrof("notify")) {
				(void) pprint(pp, NUMBER|NAME|REASON);
				if ((jobflags&PSTOPPED) == 0)
					pflush(pp);
			} else {
				fp->p_flags |= PNEEDNOTE;
				neednote++;
			}
		}
	}
	if (csh_has_job_control) {	/* mu0	*/
		goto loop;
	} else {			/* mu0	*/
		/*
		 * It is always the last time now -
		 * don't loop waiting for more children or it will hang
		 * if there is anything in the background.
		 */
		(void) sigact(SIGCHLD, pchild); /*jc4 reset value for SIGCHLD */	
		return; 	/* we're done */
	}				/* mu0	*/
}

pnote()
{
	register struct process *pp;
	int flags, omask,newmask;

	neednote = 0;

	for (pp = proclist.p_next; pp != PNULL; pp = pp->p_next) {
		if (pp->p_flags & PNEEDNOTE) {
			if (csh_has_job_control) {	/* mu0	*/
				sigemptyset(&newmask);
				sigaddset(&newmask,SIGCHLD);
				sigprocmask(SIG_BLOCK,&newmask,&omask);
			} else {			/* mu0	*/
				omask = sigblock(sigmask(SIGCHLD));
			}				/* mu0	*/
			pp->p_flags &= ~PNEEDNOTE;
			flags = pprint(pp, NUMBER|NAME|REASON);
			if ((flags&(PRUNNING|PSTOPPED)) == 0)
				pflush(pp);
			if (csh_has_job_control) {	/* mu0	*/
				sigprocmask(SIG_SETMASK,&omask,NULL);
			} else {			/* mu0	*/
				(void) sigsetmask(omask);
			}				/* mu0	*/
		}
	}
}
 
/*
 * pwait - wait for current job to terminate, maintaining integrity
 *	of current and previous job indicators.
 */
pwait()
{
	register struct process *fp, *pp;
	int omask,newmask;

	/*
	 * Here's where dead procs get flushed.
	 */

	if (csh_has_job_control) {	/* mu0	*/
		sigemptyset(&newmask);
		sigaddset(&newmask,SIGCHLD);
		/* set SIGCHLD to SIG_IGN */
		sigprocmask(SIG_BLOCK,&newmask,&omask);
	} else {			/* mu0	*/
		omask = sigblock(sigmask(SIGCHLD)); /* set SIGCHLD to SIG_IGN */
	}				/* mu0	*/
	for (pp = (fp = &proclist)->p_next; pp != PNULL; pp = (fp = pp)->p_next)
		if (pp->p_pid == 0) {
			fp->p_next = pp->p_next;
			xfree(pp->p_command);
			if (pp->p_cwd && --pp->p_cwd->di_count == 0)
				if (pp->p_cwd->di_next == 0)
					dfree(pp->p_cwd);
			xfree((char *)pp);
			pp = fp;
		}
	/* restore prior handling of SIGCHLD,*/
	if (csh_has_job_control) {	/* mu0	*/
		sigprocmask(SIG_SETMASK,&omask,NULL);
	} else {			/* mu0	*/
		(void) sigsetmask(omask);
	}				/* mu0	*/

	/* which should be "pchild" */
	pjwait(pcurrjob);
}

/*
 * pjwait - wait for a job to finish or become stopped
 *	It is assumed to be in the foreground state (PFOREGND)
 */
pjwait(pp)
	register struct process *pp;
{
	register struct process *fp;
	int jobflags, reason, omask,newmask;

	while (pp->p_pid != pp->p_jobid)
		pp = pp->p_friends;
	fp = pp;
	do {
		if ((fp->p_flags&(PFOREGND|PRUNNING)) == PRUNNING)
			printf("csh: BUG: waiting for background job!\n");
	} while ((fp = fp->p_friends) != pp);
	/*
	 * Now keep pausing as long as we are not interrupted (SIGINT),
	 * and the target process, or any of its friends, are running
	 */
	fp = pp;
	if (csh_has_job_control) {	/* mu0	*/
		sigemptyset(&newmask);
		sigaddset(&newmask,SIGCHLD);
		sigprocmask(SIG_BLOCK,&newmask,&omask);
	} else {			/* mu0	*/
		omask = sigblock(sigmask(SIGCHLD));
	}				/* mu0	*/
	for (;;) { 
		jobflags = 0;
		do
			jobflags |= fp->p_flags;
		while ((fp = (fp->p_friends)) != pp)
			;
		if ((jobflags & PRUNNING) == 0)
			break; 
#ifdef PORT	
		if (csh_has_job_control) {	/* mu0	*/
			/*
			 * hh1 - Remove SIGCHLD from mask passed to sigsuspend,
			 *	 otherwise SIGCHLD will be blocked and
			 *	 sigsuspend will wait forever.
			 *	 This can happen to second generation shells
			 *	 which already block SIGCHLD - maybe this is
			 *	 a bug and child shells should reset their
			 *	 signals before exec'ing.
			 */
			newmask = omask;
			sigdelset(&newmask,SIGCHLD);
			sigsuspend(&newmask); 
		} else {			/* mu0	*/
			sigpause(SIGCHLD);
		}				/* mu0	*/
#else
		sigpause(sigblock(0) &~ sigmask(SIGCHLD));
#endif
	}
	if (csh_has_job_control) {	/* mu0	*/
		sigprocmask(SIG_SETMASK,&omask,NULL);
		if (tpgrp > 0)
			tcsetpgrp(FSHTTY,tpgrp);
	} else {			/* mu0	*/
		(void) sigsetmask(omask);
	}				/* mu0	*/
	if ((jobflags&(PSIGNALED|PSTOPPED|PTIME)) ||
	     !eq(dcwd->di_name, fp->p_cwd->di_name)) {
		if (jobflags&PSTOPPED)
			printf("\n");
		(void) pprint(pp, AREASON|SHELLDIR);
	}
	if ((jobflags&(PINTERRUPTED|PSTOPPED)) && setintr &&
	    (!gointr || !eq(gointr, "-"))) {
		if ((jobflags & PSTOPPED) == 0)
			pflush(pp);
		pintr1(0);
		/*NOTREACHED*/
	}
	reason = 0;
	fp = pp;
	do {
		/* as used below, QUOTE is the note from wait that a core */
		/* file exists - port */
		if (fp->p_reason)	/* added paren for clarity - port */
			reason = (fp->p_flags & (PSIGNALED|PINTERRUPTED)) ?
				(fp->p_reason | QUOTE) : fp->p_reason;
	} while ((fp = fp->p_friends) != pp);
	set("status", putn(reason));
	if (reason && exiterr)
		exitstat();
	pflush(pp);
}

/*
 * dowait - wait for all processes to finish
 */
dowait()
{
	register struct process *pp;
	int omask,newmask;

	pjobs++;

	if (csh_has_job_control) {	/* mu0	*/
		sigemptyset(&newmask);
		sigaddset(&newmask,SIGCHLD);
		sigprocmask(SIG_BLOCK,&newmask,&omask);
	} else {			/* mu0	*/
		omask = sigblock(sigmask(SIGCHLD));
	}				/* mu0	*/
loop:
	for (pp = proclist.p_next; pp; pp = pp->p_next)
		if (pp->p_pid && /* pp->p_pid == pp->p_jobid && */
		    pp->p_flags&PRUNNING) {
#ifdef PORT
			if (csh_has_job_control) {	/* mu0	*/
				/*
				 * hh1 - Remove SIGCHLD from mask passed to
				 *	sigsuspend, otherwise SIGCHLD will be
				 *	blocked and sigsuspend will wait
				 *	forever.
				 *	This can happen to second generation
				 *	shells which already block SIGCHLD -
				 *	maybe this is a bug and child shells
				 *	should reset their signals before
				 *	exec'ing.
				 */
				newmask = omask;
				sigdelset(&newmask,SIGCHLD);
				sigsuspend(&newmask); 
			} else {			/* mu0	*/
				sigpause(SIGCHLD);
			}				/* mu0	*/
#else
			sigpause(0);
#endif
			goto loop;
		}
	if (csh_has_job_control) {	/* mu0	*/
		sigprocmask(SIG_SETMASK,&omask,NULL);
	} else {			/* mu0	*/
		(void) sigsetmask(omask);
	}				/* mu0	*/
	pjobs = 0;
}

/*
 * pflushall - flush all jobs from list (e.g. at fork())
 */
pflushall()
{
	register struct process	*pp;

	for (pp = proclist.p_next; pp != PNULL; pp = pp->p_next)
		if (pp->p_pid)
			pflush(pp);
}

/*
 * pflush - flag all process structures in the same job as the
 *	the argument process for deletion.  The actual free of the
 *	space is not done here since pflush is called at interrupt level.
 */
pflush(pp)
	register struct process	*pp;
{
	register struct process *np;
	register int index;

	if (pp->p_pid == 0) {
		printf("csh: BUG: process flushed twice!\n");
		return;
	}
	while (pp->p_pid != pp->p_jobid)
		pp = pp->p_friends;
	pclrcurr(pp);
	if (pp == pcurrjob)
		pcurrjob = 0;
	index = pp->p_index;
	np = pp;
	do {
		np->p_index = np->p_pid = 0;
		np->p_flags &= ~PNEEDNOTE;
	} while ((np = np->p_friends) != pp);
	if (index == pmaxindex) {
		for (np = proclist.p_next, index = 0; np; np = np->p_next)
			if (np->p_index > index)
				index = np->p_index;
		pmaxindex = index;
	}
}

/*
 * pclrcurr - make sure the given job is not the current or previous job;
 *	pp MUST be the job leader
 */
pclrcurr(pp)
	register struct process *pp;
{

	if (pp == pcurrent)
		if (pprevious != PNULL) {
			pcurrent = pprevious;
			pprevious = pgetcurr(pp);
		} else {
			pcurrent = pgetcurr(pp);
			pprevious = pgetcurr(pp);
		}
	else if (pp == pprevious)
		pprevious = pgetcurr(pp);
}

/* +4 here is 1 for '\0', 1 ea for << >& >> */
char	command[PMAXLEN+4];
int	cmdlen;
char	*cmdp;
/*
 * palloc - allocate a process structure and fill it up.
 *	an important assumption is made that the process is running.
 */
palloc(pid, t)
	int pid;
	register struct command *t;
{
	register struct process	*pp;
	int i;

	pp = (struct process *)calloc(1, sizeof(struct process));
	pp->p_pid = pid;
	pp->p_flags = t->t_dflg & FAND ? PRUNNING : PRUNNING|PFOREGND;
	if (t->t_dflg & FTIME)
		pp->p_flags |= PPTIME;
	cmdp = command;
	cmdlen = 0;
	padd(t);
	*cmdp++ = 0;
	if (t->t_dflg & FPOU) {
		pp->p_flags |= PPOU;
		if (t->t_dflg & FDIAG)
			pp->p_flags |= PDIAG;
	}
	pp->p_command = savestr(command);
	if (pcurrjob) {
		struct process *fp;
		/* careful here with interrupt level */
		pp->p_cwd = 0;
		pp->p_index = pcurrjob->p_index;
		pp->p_friends = pcurrjob;
		pp->p_jobid = pcurrjob->p_pid;
		for (fp = pcurrjob; fp->p_friends != pcurrjob; fp = fp->p_friends)
			;
		fp->p_friends = pp;
	} else {
		pcurrjob = pp;
		pp->p_jobid = pid;
		pp->p_friends = pp;
		pp->p_cwd = dcwd;
		dcwd->di_count++;
		if (pmaxindex < BIGINDEX)
			pp->p_index = ++pmaxindex;
		else {
			struct process *np;

			for (i = 1; ; i++) {
				for (np = proclist.p_next; np; np = np->p_next)
					if (np->p_index == i)
						goto tryagain;
				pp->p_index = i;
				if (i > pmaxindex)
					pmaxindex = i;
				break;			
			tryagain:;
			}
		}
		if (pcurrent == PNULL)
			pcurrent = pp;
		else if (pprevious == PNULL)
			pprevious = pp;
	}
	pp->p_next = proclist.p_next;
	proclist.p_next = pp;
#ifdef NOTIMING	/* jc6 */
#ifdef DEBUGPORT
	printf("In sh.proc.c: palloc, we don't have gettimeofday\n");
#endif /* DEBUGPORT */
#else
	(void) gettimeofday(&pp->p_btime, (struct timezone *)0);
#endif
}

padd(t)
	register struct command *t;
{
	char **argp;

	if (t == 0)
		return;
	switch (t->t_dtyp) {

	case TPAR:
		pads("( ");
		padd(t->t_dspr);
		pads(" )");
		break;

	case TCOM:
		for (argp = t->t_dcom; *argp; argp++) {
			pads(*argp);
			if (argp[1])
				pads(" ");
		}
		break;

	case TOR:
	case TAND:
	case TFIL:
	case TLST:
		padd(t->t_dcar);
		switch (t->t_dtyp) {
		case TOR:
			pads(" || ");
			break;
		case TAND:
			pads(" && ");
			break;
		case TFIL:
			pads(" | ");
			break;
		case TLST:
			pads("; ");
			break;
		}
		padd(t->t_dcdr);
		return;
	}
	if ((t->t_dflg & FPIN) == 0 && t->t_dlef) {
		pads((t->t_dflg & FHERE) ? " << " : " < ");
		pads(t->t_dlef);
	}
	if ((t->t_dflg & FPOU) == 0 && t->t_drit) {
		pads((t->t_dflg & FCAT) ? " >>" : " >");
		if (t->t_dflg & FDIAG)
			pads("&");
		pads(" ");
		pads(t->t_drit);
	}
}

pads(cp)
	char *cp;
{
	register int i = strlen(cp);

	if (cmdlen >= PMAXLEN)
		return;
	if (cmdlen + i >= PMAXLEN) {
		(void) strcpy(cmdp, " ...");
		cmdlen = PMAXLEN;
		cmdp += 4;
		return;
	}
	(void) strcpy(cmdp, cp);
	cmdp += i;
	cmdlen += i;
}

/*
 * psavejob - temporarily save the current job on a one level stack
 *	so another job can be created.  Used for { } in exp6
 *	and `` in globbing.
 */
psavejob()
{

	pholdjob = pcurrjob;
	pcurrjob = PNULL;
}

/*
 * prestjob - opposite of psavejob.  This may be missed if we are interrupted
 *	somewhere, but pendjob cleans up anyway.
 */
prestjob()
{

	pcurrjob = pholdjob;
	pholdjob = PNULL;
}

/*
 * pendjob - indicate that a job (set of commands) has been completed
 *	or is about to begin.
 */
pendjob()
{
	register struct process *pp, *tp;

	if (pcurrjob && (pcurrjob->p_flags&(PFOREGND|PSTOPPED)) == 0) {
		pp = pcurrjob;
		while (pp->p_pid != pp->p_jobid)
			pp = pp->p_friends;
		printf("[%d]", pp->p_index);
		tp = pp;
		do {
			printf(" %d", pp->p_pid);
			pp = pp->p_friends;
		} while (pp != tp);
		printf("\n");
	}
	pholdjob = pcurrjob = 0;
}

/*
 * pprint - print a job
 */
pprint(pp, flag)
	register struct process	*pp;
{
	register status, reason;
	struct process *tp;
	extern char *linp, linbuf[];
	int jobflags, pstatus;
	char *format;

	while (pp->p_pid != pp->p_jobid)
		pp = pp->p_friends;
	if (pp == pp->p_friends && (pp->p_flags & PPTIME)) {
		pp->p_flags &= ~PPTIME;
		pp->p_flags |= PTIME;
	}
	tp = pp;
	status = reason = -1; 
	jobflags = 0;
	do {
		jobflags |= pp->p_flags;
		pstatus = pp->p_flags & PALLSTATES;
		if (tp != pp && linp != linbuf && !(flag&FANCY) &&
		    (pstatus == status && pp->p_reason == reason ||
		     !(flag&REASON)))
			printf(" ");
		else {
			if (tp != pp && linp != linbuf)
				printf("\n");
			if(flag&NUMBER)
				if (pp == tp)
					printf("[%d]%s %c ", pp->p_index,
					    pp->p_index < 10 ? " " : "",
					    pp==pcurrent ? '+' :
						(pp == pprevious ? '-' : ' '));
				else
					printf("       ");
			if (flag&FANCY)
				printf("%5d ", pp->p_pid);
			if (flag&(REASON|AREASON)) {
				if (flag&NAME)
					format = "%-21s";
				else
					format = "%s";
				if (pstatus == status)
					if (pp->p_reason == reason) {
						printf(format, "");
						goto prcomd;
					} else
						reason = pp->p_reason;
				else {
					status = pstatus;
					reason = pp->p_reason;
				}
				switch (status) {

				case PRUNNING:
					printf(format, "Running ");
					break;

				case PINTERRUPTED:
				case PSTOPPED:
				case PSIGNALED:
					if ((flag&(REASON|AREASON))
					    && reason != SIGINT
					    && reason != SIGPIPE)
						printf(format, mesg[pp->p_reason].pname);
					break;

				case PNEXITED:
				case PAEXITED:
					if (flag & REASON)
						if (pp->p_reason)
							printf("Exit %-16d", pp->p_reason);
						else
							printf(format, "Done");
					break;

				default:
					printf("csh: BUG: status=%-9o", status);
				}
			}
		}
prcomd:
		if (flag&NAME) {
			printf("%s", pp->p_command);
			if (pp->p_flags & PPOU)
				printf(" |");
			if (pp->p_flags & PDIAG)
				printf("&");
		}
		if (flag&(REASON|AREASON) && pp->p_flags&PDUMPED)
			printf(" (core dumped)"); 
		if (tp == pp->p_friends) {
			if (flag&AMPERSAND)
				printf(" &");
			if (flag&JOBDIR &&
			    !eq(tp->p_cwd->di_name, dcwd->di_name)) {
				printf(" (wd: ");
				dtildepr(value("home"), tp->p_cwd->di_name);
				printf(")");
			}
		}
		if (pp->p_flags&PPTIME && !(status&(PSTOPPED|PRUNNING))) {
			if (linp != linbuf)
				printf("\n\t");
			{ static struct rusage zru;
			  prusage(&zru, &pp->p_rusage, &pp->p_etime,
			    &pp->p_btime);
			}
		}
		if (tp == pp->p_friends) {
			if (linp != linbuf)
				printf("\n");
			if (flag&SHELLDIR && !eq(tp->p_cwd->di_name, dcwd->di_name)) {
				printf("(wd now: ");
				dtildepr(value("home"), dcwd->di_name);
				printf(")\n");
			}
		}
	} while ((pp = pp->p_friends) != tp);
	if (jobflags&PTIME && (jobflags&(PSTOPPED|PRUNNING)) == 0) {
		if (jobflags & NUMBER)
			printf("       ");
		ptprint(tp);
	}
	return (jobflags);
}

ptprint(tp)
	register struct process *tp;
{
	struct timeval tetime, diff;
	static struct timeval ztime;
	struct rusage ru;
	static struct rusage zru;
	register struct process *pp = tp;

#ifdef NOTIMING	/* jc6 */
#ifdef DEBUGPORT
	printf("in sh.proc.c: ptprint: avoiding ruadd, and timercmp\n");
#endif
#else
	ru = zru;
	tetime = ztime;
	do {
		ruadd(&ru, &pp->p_rusage);
		tvsub(&diff, &pp->p_etime, &pp->p_btime);
		if (timercmp(&diff, &tetime, >))
			tetime = diff;
	} while ((pp = pp->p_friends) != tp);
	prusage(&zru, &ru, &tetime, &ztime);
#endif
}

/*
 * dojobs - print all jobs
 */
dojobs(v)
	char **v;
{
	register struct process *pp;
	register int flag = NUMBER|NAME|REASON;
	int i;

	if (chkstop)
		chkstop = 2;
	if (*++v) {
		if (v[1] || !eq(*v, "-l"))
			error("Usage: jobs [ -l ]");
		flag |= FANCY|JOBDIR;
	}
	for (i = 1; i <= pmaxindex; i++)
		for (pp = proclist.p_next; pp; pp = pp->p_next)
			if (pp->p_index == i && pp->p_pid == pp->p_jobid) {
				pp->p_flags &= ~PNEEDNOTE;
				if (!(pprint(pp, flag) & (PRUNNING|PSTOPPED)))
					pflush(pp);
				break;
			}
}

/*
 * dofg - builtin - put the job into the foreground
 */
dofg(v)
	char **v;
{
	register struct process *pp;

#ifdef NOJOBS	/* jc8 */
	printf("Sorry, \"fg\" is not available.\n");
#else
	okpcntl();
	++v;
	do {
		pp = pfind(*v);
		sh_pstart(pp, 1);
		pjwait(pp);
	} while (*v && *++v);
#endif /* NOJOBS */
}

/*
 * %... - builtin - put the job into the foreground
 */
dofg1(v)
	char **v;
{
	register struct process *pp;

#ifdef NOJOBS	/* jc8 */
	printf("Sorry, the \"%sjob\" feature is not supported.\n","%");
#else
	okpcntl();
	pp = pfind(v[0]);
	sh_pstart(pp, 1);
	pjwait(pp);
#endif /* NOJOBS */
}

/*
 * dobg - builtin - put the job into the background
 */
dobg(v)
	char **v;
{
	register struct process *pp;

#ifdef NOJOBS	/* jc8 */
	printf("Sorry, \"bg\" is not available.\n");
#else
	okpcntl();
	++v;
	do {
		pp = pfind(*v);
		sh_pstart(pp, 0);
	} while (*v && *++v);
#endif /* NOJOBS */
}

/*
 * %... & - builtin - put the job into the background
 */
dobg1(v)
	char **v;
{
	register struct process *pp;

#ifdef NOJOBS	/* jc8 */
	printf("Sorry, \"%sjob \&\" is not available.\n","%");
#else /* NOJOBS */
	okpcntl();
	pp = pfind(v[0]);
	sh_pstart(pp, 0);
#endif /* NOJOBS */
}

/*
 * dostop - builtin - stop the job
 */
dostop(v)
	char **v;
{
#ifdef NOJOBS	/* jc8 */
	printf("Sorry, \"stop\" is not available.\n");
#else
	okpcntl();
	pkill(++v, SIGSTOP);
#endif
}

#ifdef	KILL
/*
 * dokill - builtin - superset of kill (1)
 */
dokill(v)
	char **v;
{
	register int signum;
	register char *name;

	v++;
	if (v[0] && v[0][0] == '-') {
		if (v[0][1] == 'l') {
			for (signum = 1; signum <= NSIG; signum++) {
#ifndef	NOJOBS
#ifdef	_POSIX_SOURCE
#ifdef	SIGTSTP
				if (!csh_has_job_control)
					if ((signum >= SIGSTOP) &&
							(signum <= SIGTTOU))
						continue;
#endif	/* SIGTSTP */
#endif	/* _POSIX_SOURCE */
#endif	/* NOJOBS */
				if (name = mesg[signum].iname)
					printf("%s ", name);
				if ((signum % 16) == 0)
					putchar('\n');
			}
			putchar('\n');
			return;
		}
		if (digit(v[0][1])) {
			signum = atoi(v[0]+1);
			if (signum < 0 || signum > NSIG)
				bferr("Bad signal number");
		} else {
			name = &v[0][1];
			for (signum = 1; signum <= NSIG; signum++) {
#ifndef	NOJOBS
#ifdef	_POSIX_SOURCE
#ifdef	SIGTSTP
				if (!csh_has_job_control)
					if ((signum >= SIGSTOP) &&
							(signum <= SIGTTOU))
						continue;
#endif	/* SIGTSTP */
#endif	/* _POSIX_SOURCE */
#endif	/* NOJOBS */
				if (mesg[signum].iname &&
						eq(name, mesg[signum].iname))
					goto gotsig;
			}
			setname(name);
			bferr("Unknown signal; kill -l lists signals");
		}
gotsig:
		v++;
	} else
		signum = SIGTERM;
	pkill(v, signum);
}
#endif	/* KILL */

pkill(v, signum)
	char **v;
	int signum;
{
	register struct process *pp, *np;
	register int jobflags = 0;
	int omask, pid, err = 0;
	int newmask;
	char *cp;
	extern char *sys_errlist[];

	/* don't combine the following ifs */
	if (csh_has_job_control) {	/* mu0	*/
		sigemptyset(&newmask);
		sigaddset(&newmask,SIGCHLD);
	} else {			/* mu0	*/
		omask = sigmask(SIGCHLD);
	}				/* mu0	*/
	if (csh_has_job_control) {	/* mu0	*/
		if (setintr)
			sigaddset(&newmask,SIGINT);
		sigprocmask(SIG_BLOCK,&newmask,&omask);
	} else {			/* mu0	*/
		if (setintr)
			omask |= sigmask(SIGINT);
		omask = sigblock(omask) & ~omask;
	}				/* mu0	*/
	while (*v) {
		cp = globone(*v);
		if (*cp == '%') {
			np = pp = pfind(cp);
			do
				jobflags |= np->p_flags;
			while ((np = np->p_friends) != pp);
#ifndef NOJOBS	/* jc8 */
#ifdef	_POSIX_SOURCE
#ifdef	SIGTSTP
			if (csh_has_job_control) {	/* mu0	*/
				switch (signum) {
				case SIGSTOP:
				case SIGTSTP:
				case SIGTTIN:
				case SIGTTOU:
					if ((jobflags & PRUNNING) == 0) {
						printf("%s: Already stopped\n",
							cp);
						err++;
						goto cont;
					}
				}
			}				/* mu0	*/
#endif	/* SIGTSTP */
#endif	/* _POSIX_SOURCE */
#endif /* NOJOBS */
			if (killpg(pp->p_jobid, signum) < 0) {
				printf("%s: ", cp);
				printf("%s\n", sys_errlist[errno]);
				err++;
			}
#ifndef NOJOBS	/* jc8 */
#ifdef	_POSIX_SOURCE
#ifdef	SIGTSTP
			if (csh_has_job_control)	/* mu0	*/
				if (signum == SIGTERM || signum == SIGHUP)
					(void) killpg(pp->p_jobid, SIGCONT);
#endif	/* SIGTSTP */
#endif	/* _POSIX_SOURCE */
#endif /* NOJOBS */
		} else if (!(digit(*cp) || *cp == '-'))
			bferr("Arguments should be jobs or process id's");
		else {
			pid = atoi(cp);
#ifndef NOJOBS	/* jc8 */
#ifdef	_POSIX_SOURCE
#ifdef	SIGTSTP
			if (csh_has_job_control) {	/* mu0	*/
				int	shpid, ppid, pflags;

				shpid = getpid();
				ppid  = getppid();
				switch (signum) {
				case SIGSTOP:
				case SIGTSTP:
				case SIGTTIN:
				case SIGTTOU:
					if ((pid == shpid) && ((ppid == 1) ||
#ifdef	ARIXPOSIX
						((sysarix(ARIXPOSIX,ARIXGETPOSFLAGS,ppid,&pflags) < 0) ||
						(!(pflags & JOB_CONTROL_PROC)))
#else	/* ARIXPOSIX */
					1
#endif	/* ARIXPOSIX */
					)) {
						if ((pid == shpid) && (ppid == 1))
							printf("%d: Cannot stop login shell\n",pid);
						else
							printf("%d: Cannot stop this shell, no job control in parent\n",pid);
						err++;
						goto cont;
					}
					break;
				}
			}
#endif	/* SIGTSTP */
#endif	/* _POSIX_SOURCE */
#endif /* NOJOBS */
			if (kill(pid, signum) < 0) {
				printf("%d: ", pid);
				printf("%s\n", sys_errlist[errno]);
				err++;
				goto cont;
			}
#ifndef NOJOBS	/* jc8 */
#ifdef	_POSIX_SOURCE
#ifdef	SIGTSTP
			if (csh_has_job_control)	/* mu0	*/
				if (signum == SIGTERM || signum == SIGHUP)
					(void) kill(pid, SIGCONT);
#endif	/* SIGTSTP */
#endif	/* _POSIX_SOURCE */
#endif /* NOJOBS */
		}
cont:
		xfree(cp);
		v++;
	}
	if (csh_has_job_control) {	/* mu0	*/
		sigprocmask(SIG_SETMASK,&omask,NULL);
	} else {			/* mu0	*/
		(void) sigsetmask(omask);
	}				/* mu0	*/
	if (err)
		error(NOSTR);
}

/*
 * sh_pstart - start the job in foreground/background
 */
sh_pstart(pp, foregnd)
	register struct process *pp;
	int foregnd;
{
	register struct process *np;
	int omask, jobflags = 0;
	int newmask;

	if (csh_has_job_control) {	/* mu0	*/
		sigemptyset(&newmask);
		sigaddset(&newmask,SIGCHLD);
		sigprocmask(SIG_BLOCK,&newmask,&omask);
	} else {			/* mu0	*/
		omask = sigblock(sigmask(SIGCHLD));
	}				/* mu0	*/
	np = pp;
	do {
		jobflags |= np->p_flags;
		if (np->p_flags&(PRUNNING|PSTOPPED)) {
			np->p_flags |= PRUNNING;
			np->p_flags &= ~PSTOPPED;
			if (foregnd)
				np->p_flags |= PFOREGND;
			else
				np->p_flags &= ~PFOREGND;
		}
	} while((np = np->p_friends) != pp);
	if (!foregnd)
		pclrcurr(pp);
	(void) pprint(pp, foregnd ? NAME|JOBDIR : NUMBER|NAME|AMPERSAND);
	if (foregnd){
		if (csh_has_job_control) {	/* mu0	*/
			if( tcsetpgrp(FSHTTY,pp->p_jobid) )
				printf("csh: cannot set pgrp (error %x)\n",
					errno);
		}				/* mu0	*/
	}
#ifndef NOJOBS	/* jc8 */
#ifdef	_POSIX_SOURCE
#ifdef	SIGTSTP
	if (csh_has_job_control) {	/* mu0	*/
		if (jobflags&PSTOPPED){
			/*
			if(killpg(pp->p_jobid, SIGCONT) < 0)
		printf("csh: error sending kill sig %x (error %x)\n",
					pp->p_jobid|1<<31,errno);
			*/
			killpg(pp->p_jobid, SIGCONT);

		}
	}				/* mu0	*/
#endif	/* SIGTSTP */
#endif	/* _POSIX_SOURCE */
	if (jobflags&PSTOPPED)
		(void) killpg(pp->p_jobid, SIGCONT);
#endif /* NOJOBS */

	if (csh_has_job_control) {	/* mu0	*/
		sigprocmask(SIG_SETMASK,&omask,NULL);
	} else {			/* mu0	*/
		(void) sigsetmask(omask);
	}				/* mu0	*/
}

panystop(neednl)
{
	register struct process *pp;

	chkstop = 2;
	for (pp = proclist.p_next; pp; pp = pp->p_next)
		if (pp->p_flags & PSTOPPED)
			error("\nThere are stopped jobs" + 1 - neednl);
}

struct process *
pfind(cp)
	char *cp;
{
	register struct process *pp, *np;

	if (cp == 0 || cp[1] == 0 || eq(cp, "%%") || eq(cp, "%+")) {
		if (pcurrent == PNULL)
			bferr("No current job");
		return (pcurrent);
	}
	if (eq(cp, "%-") || eq(cp, "%#")) {
		if (pprevious == PNULL)
			bferr("No previous job");
		return (pprevious);
	}
	if (digit(cp[1])) {
		int index = atoi(cp+1);
		for (pp = proclist.p_next; pp; pp = pp->p_next)
			if (pp->p_index == index && pp->p_pid == pp->p_jobid)
				return (pp);
		bferr("No such job");
	}
	np = PNULL;
	for (pp = proclist.p_next; pp; pp = pp->p_next)
		if (pp->p_pid == pp->p_jobid) {
			if (cp[1] == '?') {
				register char *dp;
				for (dp = pp->p_command; *dp; dp++) {
					if (*dp != cp[2])
						continue;
					if (prefix(cp+2, dp))
						goto match;
				}
			} else if (prefix(cp+1, pp->p_command)) {
match:
				if (np)
					bferr("Ambiguous");
				np = pp;
			}
		}
	if (np)
		return (np);
	if (cp[1] == '?')
		bferr("No job matches pattern");
	else
		bferr("No such job");
	/*NOTREACHED*/
}

/*
 * pgetcurr - find most recent job that is not pp, preferably stopped
 */
struct process *
pgetcurr(pp)
	register struct process *pp;
{
	register struct process *np;
	register struct process *xp = PNULL;

	for (np = proclist.p_next; np; np = np->p_next)
		if (np != pcurrent && np != pp && np->p_pid &&
		    np->p_pid == np->p_jobid) {
			if (np->p_flags & PSTOPPED)
				return (np);
			if (xp == PNULL)
				xp = np;
		}
	return (xp);
}

/*
 * donotify - flag the job so as to report termination asynchronously
 */
donotify(v)
	char **v;
{
	register struct process *pp;

	pp = pfind(*++v);
	pp->p_flags |= PNOTIFY;
}

/*
 * Do the fork and whatever should be done in the child side that
 * should not be done if we are not forking at all (like for simple builtin's)
 * Also do everything that needs any signals fiddled with in the parent side
 *
 * Wanttty tells whether process and/or tty pgrps are to be manipulated:
 *	-1:	leave tty alone; inherit pgrp from parent
 *	 0:	already have tty; manipulate process pgrps only
 *	 1:	want to claim tty; manipulate process and tty pgrps
 * It is usually just the value of tpgrp.
 */
pfork(t, wanttty)
	struct command *t;	/* command we are forking for */
	int wanttty;
{
	register int pid;
	bool ignint = 0;
	int pgrp, omask,newmask;
	int pgrp1;

	/*
	 * A child will be uninterruptible only under very special
	 * conditions. Remember that the semantics of '&' is
	 * implemented by disconnecting the process from the tty so
	 * signals do not need to ignored just for '&'.
	 * Thus signals are set to default action for children unless:
	 *	we have had an "onintr -" (then specifically ignored)
	 *	we are not playing with signals (inherit action)
	 */
	if (setintr)
		ignint = (tpgrp == -1 && (t->t_dflg&FINT))
		    || (gointr && eq(gointr, "-"));
	/*
	 * Hold SIGCHLD until we have the process installed in our table.
	 */
	if (csh_has_job_control) {	/* mu0	*/
		sigemptyset(&newmask);
		sigaddset(&newmask,SIGCHLD);
		sigprocmask(SIG_BLOCK,&newmask,&omask);
	} else {			/* mu0	*/
		omask = sigblock(sigmask(SIGCHLD));
	}				/* mu0	*/
#ifndef NOFORK /* for debugging with cdb - added for PORT */ /* jc21 */
	while ((pid = fork()) < 0)
		if (setintr == 0)
			sleep(FORKSLEEP);
		else {
			if (csh_has_job_control) {	/* mu0	*/
				(void) sigprocmask(SIG_SETMASK,&omask,NULL);
			} else {			/* mu0	*/
				(void) sigsetmask(omask);
			}				/* mu0	*/
			error("No more processes");
		}
	if (pid == 0) {
#endif
		settimes();
		pgrp = pcurrjob ? pcurrjob->p_jobid : getpid();
		pflushall();
		pcurrjob = PNULL;
		child++;
		if (setintr) {
			setintr = 0;		/* until I think otherwise */
			/*
			 * Children just get blown away on SIGINT, SIGQUIT
			 * unless "onintr -" seen.
			 */
			(void) sigact(SIGINT, ignint ? SIG_IGN : SIG_DFL);
			(void) sigact(SIGQUIT, ignint ? SIG_IGN : SIG_DFL);
#ifndef NOJOBS	/* jc8 */
#ifdef	_POSIX_SOURCE
#ifdef	SIGTSTP
			if (csh_has_job_control) {	/* mu0	*/
				if (wanttty >= 0) {
					/* make stoppable */
					(void) sigact(SIGTSTP, SIG_DFL);
					(void) sigact(SIGTTIN, SIG_DFL);
					(void) sigact(SIGTTOU, SIG_DFL);
				}
			}				/* mu0	*/
#endif	/* SIGTSTP */
#endif	/* _POSIX_SOURCE */
#endif /* NOJOBS */
			(void) sigact(SIGTERM, parterm);
		} else if (tpgrp == -1 && (t->t_dflg&FINT)) {
			(void) sigact(SIGINT, SIG_IGN);
			(void) sigact(SIGQUIT, SIG_IGN);
		}
		if (csh_has_job_control) {	/* mu0	*/
			if (wanttty > 0)
				tcsetpgrp(FSHTTY,pgrp);
			if (wanttty >= 0 && tpgrp >= 0){
				if(setpgid(0, pgrp))
					printf("csh: setpgid failed (error %x)\n",
						errno);
			}
		}				/* mu0	*/
		if (tpgrp > 0)
			tpgrp = 0;		/* gave tty away */
		/*
		 * Nohup and nice apply only to TCOM's but it would be
		 * nice (?!?) if you could say "nohup (foo;bar)"
		 * Then the parser would have to know about nice/nohup/time
		 */
		if (t->t_dflg & FNOHUP)
			(void) sigact(SIGHUP, SIG_IGN);
		if (t->t_dflg & FNICE)
			(void) setpriority(PRIO_PROCESS, 0, t->t_nice);
#ifndef NOFORK /* jc21 */
	} else {
		palloc(pid, t);
		if (csh_has_job_control) {	/* mu0	*/
			sigprocmask(SIG_SETMASK,&omask,NULL);
		} else {			/* mu0	*/
			(void) sigsetmask(omask);
		}				/* mu0	*/
	}
#endif

	return (pid);
}

okpcntl()
{
#ifdef	_POSIX_SOURCE
#ifdef	SIGTSTP
	if (!csh_has_job_control)			/* mu0	*/
		error("Job control not available");	/* mu0	*/
#endif	/* SIGTSTP */
#endif	/* _POSIX_SOURCE */
	if (tpgrp == -1)
		error("No job control in this shell");
	if (tpgrp == 0)
		error("No job control in subshells");
}
