/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) portdefs.h: version 25.1 created on 12/2/91 at 14:07:03	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)portdefs.h	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/* change critical definitions to make subsequent ports easier. */

#include <string.h>
#include <limits.h> /* jc13 works for 5.3, but not 5.2 - to supply PATH_MAX */

#ifdef	bzero
#undef	bzero
#endif
#define bzero(a, b)	memset((a), 0, (b))

/* killpg is the same as kill with the pid turned into a negative number */
#ifdef	killpg
#undef	killpg
#endif
#define	killpg(pid,sig)	kill(-pid,sig)

#ifdef	MAXPATHLEN	/* jc13 */
#undef	MAXPATHLEN
#endif
#define	MAXPATHLEN	PATH_MAX 

#define	PRIO_PROCESS	0	/* from resource.h, needed for setpriority */

/* old setpriority:  (void) setpriority(PRIO_PROCESS, 0, t->t_nice); 
 * The parameters to setpriority, as used in the csh code, are such that "nice"
 * is an acceptable substitute.  "which" is always PRIO_PROCESS (selecting 
 * setting process priority), "who" is always "0" which represents the current 
 * process (I interpreted that as "calling" process) - port */

#ifdef	setpriority
#undef	setpriority
#endif
#define	setpriority(which, who, priority)	nice(priority) 

#ifdef	SIGCHLD
#undef	SIGCHLD
#endif
#define SIGCHLD	SIGCLD

/* SIGMASK, taken from from Berkeley signal.h: */
 
/* Macro for converting signal number to a mask suitable for
 * sigblock().
 */
#define sigmask(m)	(1 << ((m)-1))
#ifdef sigblock
#undef sigblock
#endif


