#	START NEW ARIX SCCS HEADER
#
#	@(#) cron.mk: version 25.3 created on 4/1/93 at 11:22:40
#
#	Copyright (c) 1990 by Arix Corporation
#	All Rights Reserved
#
#	@(#)cron.mk	25.3	4/1/93 Copyright (c) 1990 by Arix Corporation
#
#	END NEW ARIX SCCS HEADER
#
#	Copyright (c) 1984 AT&T
#	  All Rights Reserved

#	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T
#	The copyright notice above does not evidence any
#	actual or intended publication of such source code.

#	ATT #ident	"cron:cron.mk	1.18"

#ident "@(#)cron:cron.mk	25.3"

include $(IROOT)/macdefs

SVID_FLAG=
ETC=$(ROOT)/etc
USR=$(ROOT)/usr
INSDIR=$(ROOT)/usr/bin
SPL=$(USR)/spool
SPOOL=$(USR)/spool/cron
LIB=$(USR)/lib

CRONLIB=$(LIB)/cron
CRONSPOOL=$(SPOOL)/crontabs
ATSPOOL=$(SPOOL)/atjobs
SOURCE= at.c cron.c crontab.c elm.c funcs.c permit.c

XDIRS= $(ROOT) $(ETC) $(USR) $(INSDIR) $(LIB) $(SPL) $(SPOOL)\
      $(CRONLIB) $(CRONSPOOL) $(ATSPOOL)

DIRS= $(SPL) $(SPOOL) $(CRONLIB) $(CRONSPOOL) $(ATSPOOL)

CMDS= cron at crontab batch

.c.o:
	$(CC) $(CFLAGS) -c  $<

all:	$(CMDS)

install:	dirs install_cron install_at install_crontab install_batch

install_cron:	cron
	$(INS) cron $(ETC)/cron
	chown root $(ETC)/cron
	chgrp sys $(ETC)/cron
	chmod 700 $(ETC)/cron

install_at:	at
	$(INS) at $(ETC)/at
	chown root $(ETC)/at
	chgrp sys $(ETC)/at
	chmod 4755 $(ETC)/at

install_crontab:	crontab
	$(INS) crontab $(ETC)/crontab
	chown root $(ETC)/crontab
	chgrp sys $(ETC)/crontab
	chmod 4755 $(ETC)/crontab

install_batch:	batch
	$(INS) batch $(ETC)/batch
	chown bin $(ETC)/batch
	chgrp bin $(ETC)/batch
	chmod 755 $(ETC)/batch

libelm.a: elm.o
	ar cr libelm.a elm.o

cron:	cron.o funcs.o libelm.a
	$(CC) $(CFLAGS)  cron.o funcs.o libelm.a -o cron $(LDFLAGS) $(LDLIBS) -lsec

crontab:	crontab.o permit.o funcs.o
	$(CC) $(CFLAGS)  crontab.o permit.o funcs.o -o crontab $(LDFLAGS) -lsec

at:	at.o att1.o att2.o funcs.o permit.o
	$(CC) $(CFLAGS)  at.o att1.o att2.o funcs.o permit.o -o at $(LDFLAGS)  -lsec

batch:	batch.sh
	cp batch.sh batch

att1.c att1.h:	att1.y
	$(YACC) -d att1.y
	mv y.tab.c att1.c
	mv y.tab.h att1.h

att2.c:	att2.l
	$(LEX) att2.l
	ed - lex.yy.c < att2.ed
	mv lex.yy.c att2.c

att2.o:	att1.h

cron.o:	cron.c cron.h
crontab.o:	crontab.c cron.h
at.o:	at.c cron.h

dirs:	$(DIRS)

$(DIRS):
	-mkdir $@
	-chmod 755 $@
	-chgrp sys $@
	-chown root $@
	-touch $(NEWDATE) $@

ctags:
	ctags	$(SOURCE)
	echo 'grep $$* \\' > greplist
	for i in $(SOURCE)		;\
	do echo "$$i \\" >> greplist	;\
	done
	echo /dev/null >> greplist
	chmod +x greplist

clean:
	rm -f *.o libelm.a att1.h att1.c att2.c tags greplist

clobber:	clean
	rm -f $(CMDS)
