/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) u.c: version 1.1 created on 4/17/90 at 19:18:12	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)u.c	1.1	4/17/90 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*	ATT:#ident	"crash-3b2:u.c	1.20"	*/

/*	kd0	modified getublock to support 25Mhz cpu		*/
/*	kd1	removed previous changes and fixed in new way
	
#ident	"@(#)crash:u.c	25.1"

/*
 * This file contains code for the crash functions:  user, pcb, stack,
 * trace, and kfp.
 */

#include "sys/param.h"
#include "a.out.h"
#include "stdio.h"
#include "signal.h"
#include "sys/sysmacros.h"
#include "sys/types.h"
#include "sys/immu.h"
#include "sys/var.h"
#include "sys/acct.h"
#include "sys/user.h"
#include "sys/file.h"
#include "sys/region.h"
#include "sys/proc.h"
#include "sys/inode.h"
#include "sys/lock.h"
#ifdef S3000
#	include "sys/kmem.h"
#else	/* a1000 */
#	define	ADDR_U_STRUCT	0x1000 	
#endif /* S3000 */
#include "crash.h"

#include "sys/ofile.h"

typedef struct {
	struct file	*fp;
	char		oflag;
} u_fp_flag_t;

u_fp_flag_t	*get_fp_and_flags();

#undef n_name

#define FP	1
#define AP	0
#define DECR	4
#define USTKADDR 0xc0020000
#define UBADDR 0xc0000000
#define UPCBADDR 0xc000000c
#define UKPCBADDR 0xc000007c
#define min(a,b) ((a) > (b) ? (b) : (a))

extern struct user *ubp;		/* ublock pointer */
extern int active;			/* active system flag */
struct proc procbuf;			/* proc entry buffer */
static long Kfp = 0;			/* kernal frame pointer */
extern	char	*strtbl ;		/* pointer to string table */
int	*stk_bptr;			/* stack pointer */
extern struct xtra_nvr xtranvram;	/* xtra nvram buffer */
extern	struct	syment	*Proc, *File,
	*Inode, *Curproc, *Panic, *V;	/* namelist symbol pointers */
extern char *ctime();
extern struct	syment	*findsym();
extern int nlist();
extern long vtop();
extern long lseek();
extern char *malloc();
extern char *namelist;
void free();


/* read ublock into buffer */
int
getublock(slot)
int slot;
{
	int 	i,cnt;
	long	pslot_va;
	int	ubpsize = sizeof(user_t);

	if(slot == -1) 
		slot = getcurproc();
	if(slot >=  vbuf.v_proc || slot < 0)
	{
		prerrmes("%d out of range\n",slot);
		return(1);
	}
	pslot_va = (long)(Proc->n_value+slot*sizeof(struct proc));
	readmem(pslot_va,1,slot,(char *)&procbuf,sizeof procbuf,
		"process table");
	if (!procbuf.p_stat)
	{
		prerrmes("%d is not a valid process\n",slot);
		return(-1);
	}
	if (procbuf.p_stat == SZOMB)
		error("%d is a zombie process\n",slot);
	ubp=(user_t *)malloc( ubpsize );

	/* get u page ... */ /*kd1*/

#ifdef S3000 /* p_userp doesn't exist in A1000 header files (sys/proc.h) */
	if(lseek(mem,kv_to_mem((uint)procbuf.p_userp),0) == -1)
		error("\nlseek error on ublock p_userp=%x kv_to_mem=%x\n",
			procbuf.p_userp,kv_to_mem((uint)procbuf.p_userp));
#else
	if(lseek(mem,(procbuf.p_addr.pgi.pg_pde & 0x3fff0000) >> 4,0) == -1)
		error("lseek error on ublock\n");
#endif
	
	if (read(mem,(char *)ubp,ubpsize) != ubpsize)
		error("read error on ublock\n");
}

/* allocate buffer for stack */
unsigned
setbf(top, bottom, slot)
long top;
long bottom;
int slot;
{
	unsigned range;
	char *bptr;
	long remainder;
	long nbyte;
	long paddr;


	if (bottom > top) 
		error("Top of stack value less than bottom of stack\n");
	range = (unsigned)(top - bottom);
	if((stk_bptr = (int *)malloc(range)) == NULL)
	{
		prerrmes("Insufficient memory available for stack buffering.\n"); 
		prerrmes("Only the most recently pushed 4K bytes will be dumped from the stack.\n");
		prerrmes("New stack lower bound: %8.8x\n",top - range);
		range = 4096;
		if((stk_bptr = (int *)malloc(range)) == 0)
			error("Second attempt to allocate memory for stack buffering failed, try again later\n");

	}
	
	bottom = top - range;
	bptr = (char *)stk_bptr;
	do {
		remainder = ((bottom + NBPP) & ~((long)NBPP -1)) - bottom;
		nbyte = min(remainder, top-bottom);
		if((paddr = vtop(bottom,slot)) == -1) {
			free((char *)stk_bptr);
			stk_bptr = NULL;
			error("The stack lower bound, %x, is an invalid address\nThe saved stack frame pointer is %x\n",bottom,top);
		}
#ifdef S3000
		if(lseek(kmem,kv_to_kmem(paddr),0) == -1) {
#else
		if(lseek(kmem,paddr,0) == -1) {
#endif
			free((char *)stk_bptr);
			error("seek error on stack\n");
		}
		if(read(kmem,bptr,(unsigned)nbyte) != (unsigned)nbyte) {
			free((char *)stk_bptr);
			stk_bptr = NULL;
			error("read error on stack\n");
		}
		bptr += nbyte;
		bottom += nbyte;
	} while (bottom < top);
	return(range);
}

/* get arguments for user function */
int
getuser()
{
	int slot = Procslot;
	int full = 0;
	int all = 0;
	long arg1 = -1;
	long arg2 = -1;
	unsigned lastproc;
	int c;

	optind = 1;
	while((c = getopt(argcnt,args,"efw:")) !=EOF) {
		switch(c) {
			case 'e' :	all = 1;
					break;
			case 'f' :	full = 1;
					break;
			case 'w' :	redirect();
					break;
			default  :	longjmp(syn,0);
		}
	}
	if(args[optind]) {
		do {
			getargs(vbuf.v_proc,&arg1,&arg2);
			if(arg1 == -1)
				continue;
			if(arg2 != -1)
				for(slot = arg1; slot <= arg2; slot++)
					pruser(full,arg1);
			else
			{if (arg1 < vbuf.v_proc)
			   { slot=arg1;
			     pruser(full,arg1);
			   }
			 else
			   {fprintf(fp, "Process table entry out of range\n");
			    return;
			    }		
			}
		    slot = arg1 = arg2 = -1;
		}while(args[++optind]);
	}
	else if(all) {
		readmem((long)V->n_value,1,-1,(char *)&vbuf,
			sizeof vbuf,"var structure");
		lastproc = (unsigned)(vbuf.ve_proc - Proc->n_value) /
			sizeof (struct proc);
		for(slot =0; slot < lastproc; slot++) 
			pruser(full,slot);
	}
	else pruser(full,slot);
}

/* print ublock */
int
pruser(full,slot)
int full,slot;
{
	register  int  i,j, endi, sig;
	unsigned offset;

	if(getublock(slot) == -1)
		return;
	if(slot == -1)
		slot = getcurproc();
	fprintf(fp,"PER PROCESS USER AREA FOR PROCESS %d\n",slot);
	fprintf(fp,"USER ID's:\t");
	fprintf(fp,"uid: %u, gid: %u, real uid: %u, real gid: %u\n",
		ubp->u_uid,
		ubp->u_gid,
		ubp->u_ruid,
		ubp->u_rgid);
	fprintf(fp,"PROCESS TIMES:\t");
	fprintf(fp,"user: %ld, sys: %ld, child user: %ld, child sys: %ld\n",
		ubp->u_utime,
		ubp->u_stime,
		ubp->u_cutime,
		ubp->u_cstime);
/* gil hunt - squeeze display to keep to one screen */
	fprintf(fp,"PROCESS MISC:\tstart: %s", ctime(&ubp->u_start));
	fprintf(fp,"\tcommand: %s,", ubp->u_comm);
	fprintf(fp," psargs: %s\n", ubp->u_psargs);
	fprintf(fp,"\tproc slot: %d", ((unsigned)ubp->u_procp - Proc->n_value)
		/sizeof (struct proc));
	if(ubp->u_ttyp != 0)
		fprintf(fp,", cntrl tty: %3u,%-3u\n",
			major(ubp->u_ttyd),
			minor(ubp->u_ttyd));
	else fprintf(fp,", cntrl tty: maj(??) min(??)\n");
	fprintf(fp,"\tmem: %x, type: %s%s\n", ubp->u_mem,
		ubp->u_acflag & AFORK ? "fork" : "exec",
		ubp->u_acflag & ASU ? "su-user" : "");
	fprintf(fp,"proc/text lock:%s%s%s%s\n",
		ubp->u_lock & TXTLOCK ? " txtlock" : "",
		ubp->u_lock & DATLOCK ? " datlock" : "",
		ubp->u_lock & PROCLOCK ? " proclock" : "",
		ubp->u_lock & (PROCLOCK|TXTLOCK|DATLOCK) ? "" : " none");
	fprintf(fp,"\tinode of current directory: ");
	slot = ((unsigned)ubp->u_cdir - Inode->n_value) /
			sizeof (struct inode);
	if((slot >= 0) && (slot < vbuf.v_inode))
		fprintf(fp,"%d",slot);
	else fprintf(fp," - ");
	if(ubp->u_rdir) {
		fprintf(fp,", inode of root directory: ");
		slot = ((unsigned)ubp->u_rdir - Inode->n_value) /
			sizeof (struct inode);
		if((slot >= 0) && (slot < vbuf.v_inode))
			fprintf(fp,"%d,",slot);
		else fprintf(fp," - ,");
	}
	fprintf(fp,"\nOPEN FILES AND POFILE FLAGS:\n");
	for(i = 0, j = 0; i < ubp->u_nofiles; i++){
		u_fp_flag_t *ufp = get_fp_and_flags(ubp, i);
		if (!ufp->fp)
			continue;
		if(j++ == 4) {
			j = 1;
			fprintf(fp,"\n");
		}
		fprintf(fp,"\t[%d]: F#%d,", i, 
		      ((unsigned)ufp->fp - File->n_value)/sizeof (struct file));
		fprintf(fp," %x",ufp->oflag);
	}

	fprintf(fp,"\n");
/* gil hunt - squeeze display to keep to one screen */
	fprintf(fp,"FILE I/O: u_base: 0x%x,",ubp->u_base);
	fprintf(fp," file offset: %d (0x%x), bytes: %d\n",
		ubp->u_offset,
		ubp->u_offset,
		ubp->u_count);
	fprintf(fp,"\tsegment: %s,", ubp->u_segflg == 0 ? "data" :
		(ubp->u_segflg == 1 ? "sys" : "text"));
	fprintf(fp," cmask: %4.4o, ulimit: %d\n",
		ubp->u_cmask,
		ubp->u_limit);
	fprintf(fp,"\tfile mode(s):");	
/*	fprintf(fp,"%s%s%s%s%s%s%s%s%s\n", - removed one "%s" - changed */
/*	to match kelly's note below - june #jc0 */
	fprintf(fp,"%s%s%s%s%s%s%s%s\n",
		ubp->u_fmode & FREAD ? " read" : "",
		ubp->u_fmode & FWRITE ? " write" : "",
		ubp->u_fmode & FAPPEND ? " append" : "",
		ubp->u_fmode & FSYNC ? " sync" : "",
/* kelly commented out because mcm removed from file.h. will ask why 
		ubp->u_fmode & FNET ? " net" : "",
*/
		ubp->u_fmode & FCREAT ? " creat" : "",
		ubp->u_fmode & FTRUNC ? " trunc" : "",
		ubp->u_fmode & FEXCL ? " excl" : "",
		ubp->u_fmode & FNDELAY ? " ndelay" : "");
/* gil hunt - print 5 signals per line to keep display to one screen */
	for (j = 0; j < NSIG ; j += 5)
	{
		endi = 5;
		if (endi > (NSIG - j))
			endi = NSIG - j;
		if (j == 0)
			fprintf(fp,"SIGNALS:");
		else	fprintf(fp, "\t");
		for (i = 0; i < endi; i++)
		{
			sig = j + i;
			fprintf(fp,"%3d: ", sig+1);
			if ((int)ubp->u_signal[sig] == 0
			 || (int)ubp->u_signal[sig] == 1)
				fprintf(fp,"%-8s", (int)ubp->u_signal[sig] ? "ignore" : "default");
			else	fprintf(fp,"%-8x",(int)ubp->u_signal[sig]);
		}
		fprintf(fp, "\n");
	}
	if(full) {
		fprintf(fp,"\tux_uid: %u, ux_gid: %u,",
			ubp->u_exuid,
			ubp->u_exgid);
		fprintf(fp," ux_mode: %s%s%s%s%s%s%s%s\n",
			ubp->u_exmode & FREAD ? " read" : "",
			ubp->u_exmode & FWRITE ? " write" : "",
			ubp->u_exmode & FAPPEND ? " append" : "",
			ubp->u_exmode & FSYNC ? " sync" : "",
	/* add %s if when this is returned
			ubp->u_exmode & FNET ? " net" : "",
	*/
			ubp->u_exmode & FCREAT ? " creat" : "",
			ubp->u_exmode & FTRUNC ? " trunc" : "",
			ubp->u_exmode & FEXCL ? " excl" : "",
			ubp->u_exmode & FNDELAY ? " ndelay" : "");
		fprintf(fp,"\tcomp: %x, nextcp: %x\n",
			ubp->u_comp,
			ubp->u_nextcp);
		fprintf(fp,"\tap: %x, u_r: %x, pbsize: %d\n",
			ubp->u_ap,
			ubp->u_rval1,
			ubp->u_pbsize);
		fprintf(fp,"\tpboff: %d,",ubp->u_pboff);
		fprintf(fp," pbdev: %3u,%-3u,",
			major(ubp->u_pbdev),
			minor(ubp->u_pbdev));
		fprintf(fp," rablock: %x, errcnt: %d\n",
			ubp->u_rablock,
			ubp->u_errcnt);
		fprintf(fp,"\tdirp: %x,",ubp->u_dirp);
		fprintf(fp," dent.d_ino: %d",ubp->u_dent.d_ino);
		fprintf(fp," dent.d_name: %.14s,",ubp->u_dent.d_name); 
		fprintf(fp," pdir: ");
		slot = ((unsigned)ubp->u_pdir - Inode->n_value) /
			sizeof (struct inode);
		if((slot >= 0) && (slot < vbuf.v_inode))
			fprintf(fp,"%d\n",slot);
		else fprintf(fp," - \n");
		fprintf(fp,"\tttyip: ");
		slot = ((unsigned)ubp->u_ttyip - Inode->n_value)/
			sizeof (struct inode);
		if((slot >= 0) && (slot < vbuf.v_inode))
			fprintf(fp,"%d,",slot);
		else fprintf(fp," - ,");
		fprintf(fp," tsize: %x, dsize: %x, ssize: %x\n",
			ubp->u_tsize,
			ubp->u_dsize,
			ubp->u_ssize);
		fprintf(fp,"\targ[0]: %x, arg[1]: %x, arg[2]: %x\n",
			ubp->u_arg[0],
			ubp->u_arg[1],
			ubp->u_arg[2]);
		fprintf(fp,"\targ[3]: %x, arg[4]: %x, arg[5]: %x\n",
			ubp->u_arg[3],
			ubp->u_arg[4],
			ubp->u_arg[5]);	
		fprintf(fp,"\tpr_base: %x, pr_size: %d, pr_off: %x, pr_scale: %d\n",
			ubp->u_prof.pr_base,
			ubp->u_prof.pr_size,
			ubp->u_prof.pr_off,
			ubp->u_prof.pr_scale);
		fprintf(fp,"\tior: %x, iow: %x, iosw: %x, ioch: %x\n",
			ubp->u_ior,
			ubp->u_iow,
			ubp->u_iosw,
			ubp->u_ioch);
		fprintf(fp,"\tEXDATA:\n");
		fprintf(fp,"\tip: ");
		slot = ((unsigned)ubp->u_exdata.ip - Inode->n_value) /
				sizeof (struct inode);
		if((slot >= 0) && (slot < vbuf.v_inode))
			fprintf(fp," %d,",slot);
		else fprintf(fp," - , ");
		fprintf(fp,"tsize: %x, dsize: %x, bsize: %x, lsize: %x\n",
			ubp->u_exdata.ux_tsize,
			ubp->u_exdata.ux_dsize,
			ubp->u_exdata.ux_bsize,
			ubp->u_exdata.ux_lsize);
		fprintf(fp,"\tmagic#: %o, toffset: %x, doffset: %x, loffset: %x\n",
			ubp->u_exdata.ux_mag,
			ubp->u_exdata.ux_toffset,
			ubp->u_exdata.ux_doffset,
			ubp->u_exdata.ux_loffset);
		fprintf(fp,"\ttxtorg: %x, datorg: %x, entloc: %x, nshlibs: %d\n",
			ubp->u_exdata.ux_txtorg,
			ubp->u_exdata.ux_datorg,
			ubp->u_exdata.ux_entloc,
			ubp->u_exdata.ux_nshlibs);
		fprintf(fp,"\texecsz: %x\n",ubp->u_execsz);
#ifndef S3000 /* u_tracepc does not exist in s3000 user.h - hh */
		fprintf(fp,"\ttracepc: %x\n",ubp->u_tracepc);
#endif
		fprintf(fp,"\tRFS:\n");
		fprintf(fp,"\trflags:%s%s%s\n",
			ubp->u_rflags & U_RSYS ? " rsys" : "",
			ubp->u_rflags & U_DOTDOT ? " dotdot" : "",
			ubp->u_rflags & U_RCOPY ? " rcopy" : "");
		fprintf(fp,"\tsyscall: %d, mntindx: %d, gift: %x\n",
			ubp->u_syscall,
			ubp->u_mntindx,
			ubp->u_gift);
		fprintf(fp,"\tcopymsg: %x, copybp: %x, msgend: %x\n",
			ubp->u_copymsg,
			ubp->u_copybp,
			ubp->u_msgend);
	}
}

/* get arguments for pcb function */
int
getpcb()
{
#ifdef B3b
	int proc = Procslot;
	int phys = 0;
	char type = 'n';
	long addr = -1;
	int c;
	struct syment *sp;

	optind = 1;
	while((c = getopt(argcnt,args,"iukpw:")) !=EOF) {
		switch(c) {
			case 'w' :	redirect();
					break;
			case 'p' :	phys = 1;
					break;
			case 'i' :	type = 'i';
					break;
			case 'u' :	type = 'u';
					break;
			case 'k' :	type = 'k';
					break;
			default  :	longjmp(syn,0);
		}
	}
	if(type == 'i') {
		if(!args[optind])
			longjmp(syn,0);
		if(*args[optind] == '(')  {
			if((addr = eval(++args[optind])) == -1)
				error("\n");
		}
		else if(sp = symsrch(args[optind])) 
			addr = (long)sp->n_value;
		else if(isasymbol(args[optind]))
			error("%s not found in symbol table\n",args[optind]);
		else if((addr = strcon(args[optind],'h')) == -1)
				error("\n");
		pripcb(phys,addr);
		}
	else {
		if(args[optind]) {
			if((proc = strcon(args[optind],'d')) == -1)
				error("\n");
			if((proc > vbuf.v_proc) || (proc < 0))
				error("%d out of range\n",proc);
			prpcb(proc,type);
		}
		else prpcb(proc,type);
	}
#endif
}



/* print user, kernel, or active pcb */
int
prpcb(proc,type)
int proc;
char type;
{
#ifdef B3b
	int	i, j;
	struct kpcb *kpcbp;
	struct pcb *pcbp;

	getublock(proc);
	switch(type) {
		case 'n' : kpcbp = (struct kpcb *)(((long)ubp->u_pcbp - 
				sizeof (struct ipcb) - UBADDR) + (long)ubp);
			   break;
		case 'u' : kpcbp = (struct kpcb*)&ubp->u_pcb;
			   break;
		case 'k' : kpcbp = (struct kpcb *)((long)&ubp->u_kpcb);
			   break;
		default  : longjmp(syn,0);
			   break;
	}
	pcbp = (struct pcb *)&kpcbp->psw;
	if (!pcbp->psw.I) {
		fprintf(fp,"ipsw: %08x   ipc: %08x   isp: %08x\n",
			kpcbp->ipcb.psw,
			kpcbp->ipcb.pc,
			kpcbp->ipcb.sp);
		fprintf(fp,"psw: %08x   pc: %08x   sp: %08x   slb: %08x   sub: %08x\n",
			pcbp->psw,
			pcbp->pc,
			pcbp->sp,
			pcbp->slb,
			pcbp->sub);
		fprintf(fp,"AP: %08x    FP: %08x   r0: %08x   r1: %08x    r2: %08x\n",
			pcbp->regsave[0],
			pcbp->regsave[1],
			pcbp->regsave[2],
			pcbp->regsave[3],
			pcbp->regsave[4]);
		fprintf(fp,"r3: %08x    r4: %08x   r5: %08x   r6: %08x    r7: %08x\n",
			pcbp->regsave[5],
			pcbp->regsave[6],
			pcbp->regsave[7],
			pcbp->regsave[8],
			pcbp->regsave[9]);
		fprintf(fp,"r8: %08x\n", pcbp->regsave[10]);
		if (pcbp->mapinfo[1].movesize != NULL) 
			for (i = 1; i > MAPINFO; i++) {
				fprintf(fp,"pcb map block # %08x\n", i);
				for (j = 1; j > MOVEDATA; j++) {
					fprintf(fp,"Data to move: %08x\n",pcbp->mapinfo[i].movedata[j]);
				}
			}
	}
	else error("initial pcb\n");
#else
	fprintf(fp, "prpcb(%d, 0x%x) ??\n", proc, type);
#endif
}

/* print interrupt pcb */
int
pripcb(phys,addr)
int phys;
long addr;
{
#ifdef B3b
	struct 	kpcb 	pcbuf;

	readbuf(addr,addr,phys,-1,(char *)&pcbuf,sizeof pcbuf,"interrupt pcb");
	fprintf(fp,"ipcb.psw: %08x   ipcb.pc: %08x   ipcb.sp: %08x\n",
		pcbuf.ipcb.psw,
		pcbuf.ipcb.pc,
		pcbuf.ipcb.sp);
	fprintf(fp,"psw: %08x   pc: %08x   sp: %08x   slb: %08x   sub: %08x\n",
		pcbuf.psw,
		pcbuf.pc,
		pcbuf.sp,
		pcbuf.slb,
		pcbuf.sub);
	fprintf(fp,"AP: %08x   FP: %08x   r0: %08x   r1: %08x   r2: %08x\n",
		pcbuf.regsave[0],
		pcbuf.regsave[1],
		pcbuf.regsave[2],
		pcbuf.regsave[3],
		pcbuf.regsave[4]);
	fprintf(fp,"r3: %08x   r4: %08x   r5: %08x   r6: %08x   r7: %08x\n",
		pcbuf.regsave[5],
		pcbuf.regsave[6],
		pcbuf.regsave[7],
		pcbuf.regsave[8],
		pcbuf.regsave[9]);
	fprintf(fp,"r8: %08x\n", pcbuf.regsave[10]);
#else
	fprintf(fp,"pripcb()\n");
#endif
}

/* print kernel stack */
int
prkstk(proc)
int proc;
{
#ifdef B3b
	int panicstr;
	long stkfp ;
	long stklo ;

	getublock(proc);
	if((proc == -1) || (proc == getcurproc())){
		seekmem((long)Panic->n_value,1,-1);
		if((read(mem,(char *)&panicstr,sizeof panicstr)
			!= sizeof panicstr))
				error("read error on panic string\n");
		if(panicstr == 0) 
			error("information to process stack for current process not available\n");
		if(((long)ubp->u_stack <= UBADDR)  ||
			((long)ubp->u_stack >= USTKADDR))
			error("kernel stack not valid for current process\n");
		stklo = (long)ubp->u_stack;
		stkfp = xtranvram.systate.lfp;
	}
	else {
		if(ubp->u_kpcb.psw.CM == PS_USER)
			error("user mode\n");
		if(procbuf.p_flag == SSYS) 
			stklo = (long)ubp->u_stack;
		else stklo = (long) ubp->u_kpcb.slb;
		stkfp = ubp->u_kpcb.regsave[FP] ;
	}
	prstack(stkfp,stklo,proc);
#endif
}


/* print user stack */
int
prustk(proc)
int proc;
{
#ifdef B3b
	int			panicstr;
	long			stkfp ;
	long			stklo ;

	getublock(proc);
	if((proc == -1) || (proc == getcurproc())){
		seekmem((long)Panic->n_value,1,-1);
		if((read(mem,(char *)&panicstr,sizeof panicstr)
			!= sizeof panicstr))
				error("read error on panic string\n");
		if(panicstr == 0)
			error("information to process stack for current process not available\n");
		if((long)ubp->u_stack < USTKADDR)
			error("user stack not valid for current process\n");
		stkfp = xtranvram.systate.lfp;
	}
	else stkfp = ubp->u_pcb.regsave[FP] ;
	stklo = USTKADDR;
	prstack(stkfp,stklo,proc);
#endif
}

/* print interrupt stack */
int
pristk(phys,addr)
int phys;
long addr;
{
#ifdef B3b
	struct kpcb kpcbuf;
	long stkfp,stklo;

	if(active)
		error("invalid interrupt stack on running system\n");
	readbuf(addr,addr,phys,-1,(char *)&kpcbuf,sizeof kpcbuf,
		"interrupt process pcb");
	stkfp = kpcbuf.regsave[FP];
	if(procbuf.p_flag == SSYS) 
		stklo = (long)ubp->u_stack;
	else stklo = (long)kpcbuf.slb;
	prstack(stkfp,stklo,-1);
#endif
}

/* dump stack */
int
prstack(stkfp,stklo,slot)
long stkfp,stklo;
int slot;
{
	unsigned dmpcnt;
	int *stkptr;
	int prcnt;

	fprintf(fp,"FP: %x\n",stkfp);
#ifdef B3b
	fprintf(fp,"LOWER BOUND: %x\n",stklo) ;
	
	if ( stkfp < stklo)
		error("upper bound < lower bound, unable to process stack\n") ;
	
	dmpcnt = setbf(stkfp, stklo, slot);
	stklo = stkfp - dmpcnt ;
	stkptr = (int *)(stk_bptr);

	prcnt = 0;
	for(; dmpcnt != 0; stkptr++, dmpcnt -= DECR)
	{
		if((prcnt++ % 4) == 0){
			fprintf(fp,"\n%8.8x: ",
				(int)(((long)stkptr - (long)stk_bptr) + stklo));
		}
		fprintf(fp,"  %8.8x", *stkptr);
	}
	free((char *)stk_bptr);
	stk_bptr = NULL;

	fprintf(fp,"\n\nSTACK FRAME:\n");
	fprintf(fp,"	ARG1 ... ARGN  RA'  AP'  FP'  (REGS  6 WORDS)  LOCAL1 ...\n");
	fprintf(fp,"  AP-----^					FP------^\n");
#endif
}


/* print kernel trace */
int
prktrace(proc,kfpset)
int proc,kfpset;
{
#ifdef B3b
	int panicstr;
	struct 	pcb	pcbuf;
	long	stklo, stkhi, pcbaddr;
	long	savefp,savesp,saveap,savepc;
	struct syment *symsrch();
	unsigned range;

	
	getublock(proc);
	if((proc == -1) || (proc == getcurproc())){
		seekmem((long)Panic->n_value,1,-1);
		if((read(mem,(char *)&panicstr,sizeof panicstr)
			!= sizeof panicstr))
				error("read error on panic string\n");
		if(panicstr == 0)
			error("information to process stack trace for current process not available\n");
		if(((long)ubp->u_stack <= UBADDR)  ||
			((long)ubp->u_stack >= USTKADDR))
			error("kernel stack not valid for current process\n");
		stklo = (long)ubp->u_stack;
		savesp = (long)xtranvram.systate.ofp;
		saveap = (long)xtranvram.systate.oap;
		savefp = (long)xtranvram.systate.ofp;
		savepc = (long)xtranvram.systate.opc;
		stkhi = savefp;
		if ( stkhi < stklo)
			error("upper bound < lower bound, unable to process stack\n") ;
		range = setbf(stkhi,stklo,proc);
		stklo = stkhi - range;	
	}
	else {
		pcbaddr = (long)ubp->u_pcbp;
		readmem((long)pcbaddr,1,proc,(char *)&pcbuf,sizeof pcbuf,"pcb");
		if(pcbuf.psw.CM == PS_USER) 
			error("user mode\n");
		if(procbuf.p_flag == SSYS) {
			stklo = (long)ubp->u_stack;
			stkhi = (long)pcbuf.regsave[K_SP];
		}
		else {
			stklo = (long)pcbuf.slb;
			stkhi = (long)pcbuf.sub;	
		}
		if ( stkhi < stklo)
			error("upper bound < lower bound, unable to process stack\n") ;
		range = setbf(stkhi,stklo,proc);
		stklo = stkhi - range;	
		if((procbuf.p_wchan == 0) && (procbuf.p_stat != SXBRK)) {
			/* proc did not go through sleep() */
			savesp = (long)pcbuf.regsave[K_SP];
			saveap = (long)pcbuf.regsave[K_AP];
			savepc = (long)pcbuf.regsave[K_PC];
			savefp = pcbuf.regsave[K_FP];
		}	
		else {			/* proc went through sleep() */
			savesp = (long)pcbuf.regsave[K_AP];
			saveap = stk_bptr[(((long)pcbuf.sp-sizeof(long))-stklo)/
				sizeof(long)];
			savepc = stk_bptr[(((long)pcbuf.sp-2*sizeof(long))-
				stklo)/ sizeof(long)];
			savefp = pcbuf.regsave[K_FP];
		}
	}
	if(kfpset) {
		if(Kfp)
			savefp = Kfp;
		else error("stack frame pointer not saved\n");
	}
	puttrace(stklo,savefp,savesp,saveap,savepc,kfpset);
#else
	fprintf(fp, "prktrace(proc,kfpset)\n");
#endif
}

#ifdef B3b
/* print interrupt trace */
int
pritrace(phys,addr,kfpset,proc)
int phys,kfpset,proc;
long addr;
{
	struct kpcb kpcbuf;
	long stklo,stkhi,savefp,savesp,saveap,savepc;
	unsigned range;

	if(active)
		error("invalid trace of interrupt stack on running system\n");
	readbuf(addr,addr,phys,-1,(char *)&kpcbuf,sizeof kpcbuf,
		"interrupt process pcb");
	if(kfpset) {
		if(Kfp)
			savefp = Kfp;
		else error("stack frame pointer not saved\n");
	}
	else savefp = kpcbuf.regsave[FP];
	if(procbuf.p_flag == SSYS) {
		stklo = (long)ubp->u_stack;
		stkhi = (long)kpcbuf.regsave[K_SP];
	}
	else {
		stklo = (long)kpcbuf.slb;
		stkhi = (long)kpcbuf.sub;
	}
	if ( stkhi < stklo)
		error("upper bound < lower bound, unable to process stack\n") ;
	range = setbf(stkhi,stklo,proc);
	stklo = stkhi - range;	
	savepc = (long)kpcbuf.pc;
	savesp = (long)kpcbuf.sp;
	saveap = (long)kpcbuf.regsave[AP];
	puttrace(stklo,savefp,savesp,saveap,savepc,kfpset);
}


/* print kfp */
int
prkfp(value,proc,reset)
long value;
int proc,reset;
{
	int panicstr;
	
	if(value != -1)
		Kfp = value;
	else if(reset) {
		getublock(proc);
		if((proc == -1) || (proc == getcurproc())){
			seekmem((long)Panic->n_value,1,proc);
			if((read(mem,(char *)&panicstr,sizeof panicstr) ==
				sizeof panicstr) && (panicstr != 0)
				&& ( xtranvram.systate.pcbp == UPCBADDR)) 
					Kfp = xtranvram.systate.lfp;
			else error("Kfp not available for current process on running system\n");
		}
		else {
			if(ubp->u_kpcb.psw.CM == PS_USER) 
				error("process in user mode, no valid Kfp for kernel stack\n");
			else Kfp = ubp->u_kpcb.regsave[FP] ;
		}
	}
}


/* get arguments for stack function */
int
getstack()
{
	int proc = Procslot;
	int phys = 0;
	char type = 'k';
	long addr = -1;
	int c;
	struct syment *sp;

	optind = 1;
	while((c = getopt(argcnt,args,"iukpw:")) !=EOF) {
		switch(c) {
			case 'w' :	redirect();
					break;
			case 'p' :	phys = 1;
					break;
			case 'i' :	type = 'i';
					break;
			case 'u' :	type = 'u';
					break;
			case 'k' :	type = 'k';
					break;
			default  :	longjmp(syn,0);
		}
	}
	if(type == 'i') {
		if(!args[optind])
			longjmp(syn,0);
		if(*args[optind] == '(') {
			if((addr = eval(++args[optind])) == -1)
				error("\n");
		}
		else if(sp = symsrch(args[optind])) 
			addr = (long)sp->n_value;
		else if(isasymbol(args[optind]))
			error("%s not found in symbol table\n",args[optind]);
			else if((addr = strcon(args[optind],'h')) == -1)
				error("\n");
		pristk(phys,addr);
	}
	else {
		if(args[optind]) {
			if((proc = strcon(args[optind],'d')) == -1)
				error("\n");
			if((proc > vbuf.v_proc) || (proc < 0))
				error("%d out of range\n",proc);
			if(type == 'u')
				prustk(proc);
			else prkstk(proc);
		}
		else if(type == 'u')
			prustk(proc);
		else prkstk(proc);
	}
}



/* get arguments for trace function */
int
gettrace()
{
	int proc = Procslot;
	int phys = 0;
	int kfpset = 0;
	char type = 'k';
	long addr = -1;
	int c;
	struct syment *sp;

	optind = 1;
	while((c = getopt(argcnt,args,"irpw:")) !=EOF) {
		switch(c) {
			case 'w' :	redirect();
					break;
			case 'p' :	phys = 1;
					break;
			case 'r' :	kfpset = 1;
					break;
			case 'i' :	type = 'i';
					break;
			default  :	longjmp(syn,0);
		}
	}
	if(type == 'i') {
		if(!args[optind])
			longjmp(syn,0);
		if(*args[optind] == '(') {
			if((addr = eval(++args[optind])) == -1)
				error("\n");
		}
		else if(sp = symsrch(args[optind])) 
			addr = (long)sp->n_value;
		else if(isasymbol(args[optind]))
			error("%s not found in symbol table\n",args[optind]);
			else if((addr = strcon(args[optind],'h')) == -1)
				error("\n");
		pritrace(phys,addr,kfpset,proc);
	}
	else {
		if(args[optind]) {
			if((proc = strcon(args[optind],'d')) == -1)
				error("\n");
			if((proc > vbuf.v_proc) || (proc < 0))
				error("%d out of range\n",proc);
			prktrace(proc,kfpset);
		}
		else prktrace(proc,kfpset);
	}
}


/* dump trace */
int
puttrace(stklo,savefp,savesp,saveap,savepc,kfpset)
long stklo,savefp,savesp,saveap,savepc;
int kfpset;
{
#define RET	(unsigned long)stk_bptr[(sfp - stklo) / sizeof (long) - 9]
#define OAP	(unsigned long)stk_bptr[(sfp - stklo) / sizeof (long) - 8]
#define OFP	(unsigned long)stk_bptr[(sfp - stklo) / sizeof (long) - 7]

	struct syment *func_nm;
	unsigned long sfp,sap,*argp;
	extern short N_TEXT;
	int noaptr = 0;
	static char tname[SYMNMLEN+1];
	char *name;
	
	if(kfpset) {
		sfp = savefp;
		fprintf(fp,"SET FRAMEPTR = %x\n\n",sfp);
		fprintf(fp,"STKADDR   FRAMEPTR   ARGPTR   FUNCTION\n");
	}
	else {
		sfp = savefp;
		sap = saveap;
		fprintf(fp,"STKADDR   FRAMEPTR   ARGPTR   FUNCTION\n");
	
		fprintf(fp,"%8.8x  %8.8x  %8.8x",savesp,savefp,sap);
		if((savepc == 0) ||
		   ((func_nm = findsym((unsigned long)savepc)) == 0))
				fprintf(fp,"  %8.8x",(long)savepc);
		else {
			if(func_nm -> n_zeroes) {
				strncpy(tname,func_nm->n_name,SYMNMLEN);
				name = tname;
			}
			else name = strtbl+func_nm -> n_offset;
			fprintf(fp,"  %-8.8s", name);
		}
		fprintf(fp,"(");
		argp=(unsigned long *)&stk_bptr[(sap-stklo)/sizeof(long)];
		if(argp < (unsigned long *)&stk_bptr[(sfp-stklo)/
			sizeof(long)-9])
			fprintf(fp,"%x",*argp++);
		while(argp < (unsigned long *)&stk_bptr[(sfp-stklo)/
			sizeof(long)-9])
			fprintf(fp,",%x",*argp++);
		fprintf(fp,")\n");
	}
	
	while((sfp > (stklo+36)) && (sfp <= savefp)){
		if(!RET)
			break;
		if(noaptr)
			error("next argument pointer, %x, not valid\n",sap);
		if((OFP < stklo) || (OFP > savefp))
			error("next stack frame pointer, %x, is out of range\n",
				OFP);
		fprintf(fp,"%8.8x  %8.8x  %8.8x",sap,OFP,OAP);
		
		if((func_nm = findsym((unsigned long)RET)) == 0)
			fprintf(fp,"  %8.8x", RET);
		else {
			if(func_nm -> n_zeroes) {
				strncpy(tname,func_nm->n_name,SYMNMLEN);
				name = tname;
			}
			else name = strtbl+func_nm -> n_offset;
			fprintf(fp,"  %-8.8s", name);
		}
		sap = OAP;
		sfp = OFP;
		fprintf(fp,"(");
		if((sap < stklo) || (sap > savefp))
			noaptr = 1;
		else {
			argp=(unsigned long *)&stk_bptr[(sap-stklo)/
				sizeof(long)];
			if(argp < (unsigned long *)&stk_bptr[(sfp-stklo)/
				sizeof(long)-9]) {
				fprintf(fp,"%x",*argp++);
				while(argp < (unsigned long *)&stk_bptr[(sfp-stklo)/
					sizeof(long)-9])
					fprintf(fp,",%x",*argp++);
			}
		}
		fprintf(fp,")\n");
	}
	free((char *)stk_bptr);
	stk_bptr = NULL;
}

/* get arguments for kfp function */
int
getkfp()
{
	int c;
	struct syment *sp;
	int reset = 0;
	int proc = Procslot;
	long value;

	optind = 1;
	while((c = getopt(argcnt,args,"w:s:r")) !=EOF) {
		switch(c) {
			case 'w' :	redirect();
					break;
			case 's' :	proc = setproc();
					break;
			case 'r' :	reset = 1;
					break;
			default  :	longjmp(syn,0);
		}
	}
	if(args[optind]) {
		if(*args[optind] == '(') {
			if((value = eval(++args[optind])) == -1)
				error("\n");
			prkfp(value,proc,reset);
		}
		else if(sp = symsrch(args[optind])) 
			prkfp((long)sp->n_value,proc,reset);
		else if(isasymbol(args[optind]))
			error("%s not found in symbol table\n",args[optind]);
		else {
			if((value = strcon(args[optind],'h')) == -1)
				error("\n");
			prkfp(value,proc,reset);
		}
	}
	else prkfp(-1,proc,reset);
}
#endif

u_fp_flag_t *
get_fp_and_flags(uap, fd)
user_t	*uap;
int 	fd;
{
	static u_fp_flag_t	ufp;
	ofile_chain_t		*chain_p = uap->u_ofile_chain;

	if (fd < NOFILES_IN_U) {
		ufp.fp = uap->u_fp[fd];
		ufp.oflag = uap->u_oflag[fd];
		return(&ufp);
	}

	fd -= NOFILES_IN_U;

	for (; fd > NOFILES_PER_CHAIN; fd -= NOFILES_PER_CHAIN) {
		readmem(&chain_p->link, 0, 0, &chain_p, sizeof(chain_p),
			"ofile chain");
		if (chain_p == NULL) {
			ufp.fp = NULL;
			return(&ufp);
		}
	}

	readmem(&chain_p->fp[fd], 0, 0, &ufp.fp, sizeof(ufp.fp),
		"file pointer");

	readmem(&chain_p->oflag[fd], 0, 0, &ufp.oflag, sizeof(ufp.oflag),
		"file flags");

	return(&ufp);
}
