/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) stream.c: version 25.1 created on 12/2/91 at 14:05:10	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)stream.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*
 * This file contains code for the crash functions:  stream, queue, mblock,
 * mbfree, dblock, dbfree, strstat, linkblk, dballoc, qrun.
 */

#include "sys/param.h"
#include "a.out.h"
#include "stdio.h"
#include "sys/sysmacros.h"
#include "sys/types.h"
#include "sys/fs/s5dir.h"
#include "sys/var.h"
#include "sys/immu.h"
#include "sys/region.h"
#include "sys/proc.h"
#include "sys/inode.h"
#include "sys/mount.h"
#include "sys/sbus.h"
#include "sys/poll.h"
#include "sys/stream.h"
#include "sys/strstat.h"
#include "sys/stropts.h"
#include "sys/stat.h"
#include "dirent.h"
#include "crash.h"
#include "tree.h"
#include "sys/spm_mem.h"
#include "sys/kmem.h"
#include "sys/sbus_iopm.h"
#define IOPM_OS
#include "sys/iopm/sys/stream.h"
#include "sys/iopmcomm.h"
#include "sys/iopmstream.h"
#include "sys/iopmioctl.h"
#include "sys/sbus_spm.h"
#include "sys/iopm_mmu.h"

struct syment *Dblock, *Qhead, *Mbfree, *Dbfree,
	*Linkblk, *Nmuxlink, *Dballoc, *Strst;	/* namelist symbol pointers */
struct syment *Queue, *Mblock, *Spm_mem;

int max_iops;
int mach_slot;				/* hardware slot number */
int talking_to_pm;			/* TRUE if accessing streams on PM */
char slot_name[8];			/* hardware slot name (x.yy?) */
char stream_slot[8];			/* stream slot number in kernel */
char dev_slot_name[32];			/* slot name (/dev/iopm/iopmx.yy) */
char iop_slot_name[8];			/* hardware slot name (x.yy?) */
char dev_rbuf[32];			/* device name (e.g., /dev/tty02) */

struct iopm_comm Iopcomm;
int iopmem = -1;		/* file descriptor for opened iopm slot */
extern struct syment *Inode, *Streams, *Proc;
int ndblock = 0;	 /* number of data blocks */
int nmblock = 0;	 /* number of message blocks */

struct spm_mem spm_mem;
struct iopm_ctl  iopmctl;
struct iopm_comm *icp;
struct stdata strm;
struct strstat strst;
long pm_mblkp, pm_dblkp;
long iop_mblkp, iop_dblkp;
int mcont;
mblk_t mblk;
dblk_t dblk;
queue_t que;
queue_t	*print_one_queue_pair();

ushort rbsize[] = { 4, 16, 64, 128, 256, 512, 1024, 2048, 4096 };

#define DEV_SIZE	8
#define SLOT_SIZE	8
dev_t dev_tbl[DEV_SIZE];
int slot_tbl[SLOT_SIZE];
int line_not_empty;
char line_buffer[100];
int lastcls;
char *msg_heading = "  ADDR    SLOT  NEXT  CONT  PREV   RPTR      WPTR    DATAB   TYPE     SIZE\n";

/*--------------------------------------------------------------------------*/
node_t *nodeBase, *nodeHead, *node_tail;
node_t *nodetbl = NULL, *nodetbl_end;
int nodetbl_cnt;

typedef struct linkblk linkblk_t;
linkblk_t *linktbl = NULL;
int nmuxlink;
queue_t *trace_wq;
int	trace_wq_found;
int search_links;

node_t * find_top();
node_t * find_bot();
/*--------------------------------------------------------------------------*/
/*
 *	STREAM - show info about one or more streams
 */
int
getstream()
{
	queue_t *quep;
	queue_t  *qnext;
	int msg_slot;
	int slot = -1;
	int full = 0;
	int show_links = 0;
	int showall = 0;
	int all = 0;
	int phys = 0;
	int first_time = 0;
	long arg1 = -1;
	long arg2 = -1;
	int c;
	struct	stat	buf;
	int return_stat;
	int i, dev_count = 0, slot_count = 0;
	int display_iop = 0;
	char *heading = "SLOT  IOPM   DEV    WRQ   PGRP IOCWT WOFF  ERR FLAG\n";

	streaminit();
	trace_wq = NULL;
	optind = 1;
	talking_to_pm = TRUE;
	while((c = getopt(argcnt,args,"acd:efh:lLpq:s:w:z")) !=EOF)
	{
		switch(c)
		{
		case 'a' :
			showall = 1;
			break;
		case 'c' :
			print_flag_codes();
			return;
		case 'd' :
			if (stat(optarg, &buf) != 0)
				error("unable to stat device %s\n", optarg);
			else if (dev_count < DEV_SIZE)
				dev_tbl[dev_count++] = buf.st_rdev;
			else	error("too many devices, max=%d\n",DEV_SIZE);
			break;
		case 'e' :
			all = 1;
			break;
		case 'f' :
			full = 1;
			break;
		case 'h' :
			if (!get_mach_slot())
				return;
			break;
		case 'l' :
			show_links = 1;
			break;
		case 'L' :
			show_links = 2;
			break;
		case 'Q' :
			search_links = 1;
		case 'q' :
			arg1 = atoi(optarg);
			break;
		case 's' :
			if (slot_count < SLOT_SIZE)
				slot_tbl[slot_count++] = atoi(optarg);
			else	error("too many stream slots, max=%d\n",SLOT_SIZE);
			break;
		case 'w' :
			redirect();
			break;
		case 'p' :
			phys = 1;
			break;
		default  :
			longjmp(syn,0);
		}
	}
	if (show_links)
	{
		build_node_tbl();
		if (show_links == 2)
			debug();
		fprintf(fp, "slot (top queue, bottom queue) links\n");
		for (nodeHead = nodeBase; nodeHead != NULL; nodeHead = nodeHead->rlink)
			trav_tree(nodeHead, nodeHead);
		free_node_and_link();
		return;
	}
	if (arg1 != -1)
	{
		if ((slot = trace_iopm_back(arg1, phys)) != -1)
			show_trace_of_queue(slot, phys, full);
		return;
	}
	if (showall)
	{
		for (slot = 0; slot < vbuf.v_nstream; slot++)
			show_one_stream_slot(slot, phys, full, first_time++);
		return;
	}
	for (i = 0; i < dev_count; i++)
		show_one_stream_dev(dev_tbl[i], phys, full, first_time++);
	for (i = 0; i < slot_count; i++)
		show_one_stream_slot(slot_tbl[i], phys, full, first_time++);
	if (dev_count == 0 && slot_count == 0)
	{
		fprintf(fp,"STREAM TABLE SIZE = %d\n",vbuf.v_nstream);
		if (!full)
			fprintf(fp,"%s",heading);
		if (!args[optind])
		{
			for (slot = 0; slot < vbuf.v_nstream; slot++)
				prstream(all,full,slot,phys,heading);
			return;
		}
		for (; args[optind] != 0; optind++)
		{
			getargs(vbuf.v_nstream,&arg1,&arg2);
			if (arg1 == -1) 
				continue;
			if (arg2 != -1)
			{
				for (slot = arg1; slot <= arg2; slot++)
					prstream(all,full,slot,phys, heading);
			}
			else if (arg1 < vbuf.v_nstream)
			{
				slot = arg1;
				prstream(all,full,slot,phys,heading);
			}	
			else 
			{
				fprintf(fp,"Stream table entry out of range\n");
				return;
			}
			arg1 = arg2 = -1;
		}
	}
}
print_flag_codes()
{
	fprintf(fp,"\n");
	fprintf(fp,"iocw = IOCWAIT    waiting for ioctl to complete\n");
	fprintf(fp,"rslp = RSLEEP     sleeping on a read\n");
	fprintf(fp,"wslp = WSLEEP     sleeping on a write\n");
	fprintf(fp,"pri  = STRPRI     an M_PCPROTO is at stream head\n");
	fprintf(fp,"hup  = STRHUP     device has vanished\n");
	fprintf(fp,"stwo = STWOPEN    sleeping waiting for first open to complete\n");
	fprintf(fp,"plex = STPLEX     stream is being multiplexed\n");
	fprintf(fp,"ctty = CTTYFLG    used to create controlling tty\n");
	fprintf(fp,"mdis = RMSGDIS    unread data in msg discarded after read\n");
	fprintf(fp,"mnds = RMSGNODIS  unread data in msg NOT discarded after read\n");
	fprintf(fp,"err  = STRERR     fatal error from M_ERROR\n");
	fprintf(fp,"sttm = STRTIME    waiting to close stream\n");
	fprintf(fp,"s2tm = STR2TIME   waiting for outstanding ioctl to complete\n");
	fprintf(fp,"s3tm = STR3TIME   waiting for current ioctl acknowledgement\n");
	fprintf(fp,"clos = STRCLOSE   waiting for close to complete\n");
	fprintf(fp,"read = SNDMREAD   notify downstream via M_READ msg when user issues read\n");
	fprintf(fp,"otty = OLDNDELAY  use old TTY semantics for NDELAY reads\n");
	fprintf(fp,"rbfw = RDBUFWAIT  request for M_READ msg failed, waiting for bufcall\n");
	fprintf(fp,"sstp = STRTOSTOP  TOSTOP flag (POSIX job control)\n");
	fprintf(fp,"rmot = REMOTE     stream terminates on another board (e.g., IOPM)\n");
}
show_trace_of_queue(stream_slot, phys, full)
int	stream_slot;
long	phys;
int	full;
{
	long offset;
	int first_time = 0;

	trace_wq_found = 0;
	offset = (long)(Streams->n_value + stream_slot*sizeof strm);
	readbuf(-1, offset, phys, -1, &strm, sizeof strm,"streams table slot");
	trace_wq = strm.sd_wrq;		/*write queue at head of (partial?) stream*/
	build_node_tbl();
	for (nodeHead = nodeBase; nodeHead != NULL; nodeHead = nodeHead->rlink)
		trav_tree(nodeHead, nodeHead);
	free_node_and_link();
	if (trace_wq_found == 0)
		show_one_stream_slot(stream_slot, phys, full, 0);
}
/*
 *	show one stream given a device number
 */
show_one_stream_dev(dev, phys, full, first_time)
ushort	dev;
long	phys;
int	full;
int	first_time;
{
	int slot;
	long offset;

	for (slot = 0; slot < vbuf.v_nstream; slot++)
	{
		offset = (long)(Streams->n_value + slot*sizeof strm);
		readbuf(-1, offset, phys, -1, &strm, sizeof strm,"streams table slot");
		if (!(strm.sd_wrq))
			continue;
		if (strm.sd_rdev == dev)
			break;
	}
	if (slot == vbuf.v_nstream)
		return;
	show_one_stream(slot, phys, first_time);
	if (full)
		prfullstream(offset);
}
/*
 *	show one stream given a streams slot
 */
show_one_stream_slot(stream_slot, phys, full, first_time)
int	stream_slot;
long	phys;
int	full;
int	first_time;
{
	long offset;

	if (first_time == -1)
	{
		show_one_stream(stream_slot, phys, first_time);
		return;
	}
	if (stream_slot >= vbuf.v_nstream)
		return;
	offset = (long)(Streams->n_value + stream_slot*sizeof strm);
	readbuf(-1, offset, phys, -1, &strm, sizeof strm,"streams table slot");
	if (!(strm.sd_wrq))
		return;
	show_one_stream(stream_slot, phys, first_time);
	if (full)
		prfullstream(offset);
}

show_one_stream(slot, phys, first_time)
int	slot;
long	phys;
int	first_time;
{
	queue_t  *qnext, *q_previous;
	int	first;

	if (first_time == -1)
	{
		print_stream_slot_header(slot, phys);
		return;
	}
	if (first_time > 0)
		fprintf(fp,"\n");
	if (first_time != -2)
		print_stream_slot_header(slot, phys);
	streaminit();
	qnext = strm.sd_wrq;
	first = 0;		/* 1st display line for kernel */
	while (qnext != NULL)
	{
		q_previous = qnext;
		qnext = print_one_queue_pair(TRUE, qnext, phys);
	}
	if (!(strm.sd_flag & REMOTE))
		return;		/* don't bother to look for IOPM link */

	/* ----------------- move to IOPM ----------------- */
	/* get wq info */
	get_iopm_name(phys);
	slot = getslot(q_previous, (long)Queue->n_value, sizeof que,
							phys, vbuf.v_nqueue);
	readbuf(-1, q_previous, phys,-1, &que, sizeof que, "queue slot");
	/* get iopm ctl struct info */
	readbuf(-1, que.q_ptr, phys,-1, &iopmctl, sizeof iopmctl, "iopmctl");

	iopstreaminit();
	qnext = (queue_t *)iopmctl.ic_iwq;	/* write queue on iopm */
	first = 0;		/* 1st display line for iopm */
	while (qnext != NULL)
	{
		q_previous = qnext;
		qnext = print_one_queue_pair(FALSE, qnext, phys);
	}
}
print_stream_slot_header(slot, phys)
int slot, phys;
{
	long offset;

	fprintf(fp,"stream slot = %3d\t", slot);
	offset = (long)(Streams->n_value + slot*sizeof strm);
	readbuf(-1, offset, phys, -1, &strm, sizeof strm,"streams table slot");
	if (devname(strm.sd_rdev, "/dev"))
		fprintf(fp,"device = %s", dev_rbuf);
	else	fprintf(fp, "major,minor = %d,%d", major(strm.sd_rdev), minor(strm.sd_rdev));
	if (get_iopm_name(phys))
		fprintf(fp,"\tIOP = %s", dev_slot_name);
	fprintf(fp,"\n");
	fprintf(fp,"mod_name    slot  wq addr  cnt  msg  flags  slot  rq addr  cnt  msg  flags\n");
}
/*
 *	display info for one queue pair (read and write queue)
 */
queue_t	*
print_one_queue_pair(pm_flag, wq, phys)
int	pm_flag;
queue_t	*wq;
long	phys;
{
	
	char *kernel_name = "KERNEL";
	char *iopm_name = "IOP   ";
	char *hdr1 = "PM ";
	char *hdr2 = "IOP";
	char *hdr3 = "  ";
	int slot, msg_slot;
	queue_t  *qnext, *rq;
	long	addr;

	rq = wq - 1;
	if (pm_flag)
	{
		streaminit();
		slot = getslot(wq,Queue->n_value,sizeof que,phys,vbuf.v_nqueue);
		addr = Queue->n_value+slot*sizeof que;
		readbuf(-1, (long)Queue->n_value+slot*sizeof que, phys,-1,
		         (char *)&que, sizeof que, "queue slot");
		msg_slot = getslot(que.q_first,pm_mblkp,
					sizeof(mblk_t), phys, nmblock);
		qnext = que.q_next;
		print_mod_name(pm_flag);
		print_one_queue(hdr1, wq, slot, msg_slot);

		slot = getslot(rq,Queue->n_value,sizeof que,phys,vbuf.v_nqueue);
		readbuf(-1, (long)Queue->n_value+slot*sizeof que, phys,-1,
		         (char *)&que, sizeof que, "queue slot");
		msg_slot = getslot(que.q_first,pm_mblkp,
					sizeof(mblk_t), phys, nmblock);
		print_one_queue(hdr3, rq, slot, msg_slot);
		fprintf(fp,"\n");
	}
	else
	{
		iopstreaminit();
		slot = getslot(wq, (long)Iopcomm.queuep, sizeof que,
					 phys, Iopcomm.nqueue);
		readiop(wq, (char *)&que, sizeof que);
		msg_slot = getslot(que.q_first,iop_mblkp,
					 sizeof(mblk_t), phys, nmblock);
		qnext = que.q_next;
		print_mod_name(pm_flag);
		print_one_queue(hdr2, wq, slot, msg_slot);

		slot = getslot(rq, (long)Iopcomm.queuep, sizeof que,
					 phys, Iopcomm.nqueue);
		readiop(rq, (char *)&que, sizeof que);
		msg_slot = getslot(que.q_first,iop_mblkp,
					 sizeof(mblk_t), phys, nmblock);
		print_one_queue(hdr3, rq, slot, msg_slot);
		fprintf(fp,"\n");
	}
	return(qnext);
}

print_one_queue(hdr, q, slot, msg_slot)
unchar *hdr;
queue_t	*q;
int slot, msg_slot;
{
	fprintf(fp,"%s %3d %x %4d %4d",
		hdr, slot, q, que.q_count, msg_slot);
	fprintf(fp,"  %s%s%s%s%s",
		((que.q_flag & QENAB)  ? "e" : "-"),
		((que.q_flag & QWANTR) ? "r" : "-"),
		((que.q_flag & QWANTW) ? "w" : "-"),
		((que.q_flag & QFULL)  ? "f" : "-"),
		((que.q_flag & QNOENB) ? "n" : "-"));
}
/*
 *	print module/driver name
 */
print_mod_name(in_pm)
int	in_pm;
{
	char *chpr;
	struct	qinit		qinit;	/* procs and limits for queue */
	struct module_info	minfo;	/* module information structure */
	char modName[16];
	char *blanks = "        ";

	if (que.q_qinfo == NULL)
		goto print_mod_none;
	if (in_pm)
	{
		readmem(que.q_qinfo, 1, -1, &qinit, sizeof qinit, "qinit");
		if (qinit.qi_minfo == NULL)
			goto print_mod_none;
		readmem(qinit.qi_minfo, 1, -1, &minfo, sizeof minfo, "minfo");
		readmem(minfo.mi_idname,1,-1,modName,sizeof modName,"mod_name");
	}
	else
	{
		readiop(que.q_qinfo, &qinit, sizeof qinit);
		if (qinit.qi_minfo == NULL)
			goto print_mod_none;

		readiop(qinit.qi_minfo, &minfo, sizeof minfo);
		readiop(minfo.mi_idname, modName, sizeof modName);
	}
	strncat(modName, blanks, 8);
	modName[8] = 0;
	fprintf(fp, "%8s ", modName);
	return;
print_mod_none:
	fprintf(fp, "0        ");
}/*--------------------------------------------------------------------------*/
/*
 *	print streams table
 */
int
prstream(all,full,slot,phys,heading)
int all,full,slot,phys;
char *heading;
{
	int ioc_slot; 
	int offset;
	char loc_slot_name[8];			/* hardware slot name (x.yy?) */

	streaminit();
	offset = (long)(Streams->n_value+slot*sizeof strm);
	readbuf(-1,offset,phys,-1, &strm, sizeof strm,"streams table slot");
	if (!strm.sd_wrq && !all) 
		return;
	if (full)
		fprintf(fp,"%s",heading);
	if (slot == -1)
		fprintf(fp,"   - ");
	else fprintf(fp,"%4d  ",slot);

	if (get_iopm_name(phys))
	{
		if (strlen(slot_name) < 3)
			sprintf(loc_slot_name,"   %s",slot_name);
		else
			sprintf(loc_slot_name,"%s",slot_name);
		fprintf(fp,"%4s", loc_slot_name);
	}
	else
		fprintf(fp,"   -");
	fprintf(fp, " %3d,%-3d", major(strm.sd_rdev), minor(strm.sd_rdev));
	fprintf(fp," %4d ",((long)strm.sd_wrq - Queue->n_value)/
			sizeof(struct queue));
	fprintf(fp," %5d %5d %4d %4x ",
		(ushort *)strm.sd_pgrp,
		strm.sd_iocwait, strm.sd_wroff, strm.sd_error);
	fprintf(fp,"%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s\n",
		((strm.sd_flag & IOCWAIT) ? "iocw " : ""),
		((strm.sd_flag & RSLEEP) ? "rslp " : ""),
		((strm.sd_flag & WSLEEP) ? "wslp " : ""),
		((strm.sd_flag & STRPRI) ? "pri " : ""),
		((strm.sd_flag & STRHUP) ? "hup " : ""),
		((strm.sd_flag & STWOPEN) ? "stwo " : ""),
		((strm.sd_flag & STPLEX) ? "plex " : ""),
		((strm.sd_flag & CTTYFLG) ? "ctty " : ""),
		((strm.sd_flag & RMSGDIS) ? "mdis " : ""),
		((strm.sd_flag & RMSGNODIS) ? "mnds " : ""),
		((strm.sd_flag & STRERR) ? "err " : ""),
		((strm.sd_flag & STRTIME) ? "sttm " : ""),
		((strm.sd_flag & STR2TIME) ? "s2tm " : ""),
		((strm.sd_flag & STR3TIME) ? "s3tm " : ""),
		((strm.sd_flag & STRCLOSE) ? "clos " : ""),
		((strm.sd_flag & SNDMREAD) ? "read " : ""),
		((strm.sd_flag & OLDNDELAY) ? "otty " : ""),
		((strm.sd_flag & RDBUFWAIT) ? "rbfw " : ""),
#ifdef _POSIX_SOURCE
		((strm.sd_flag & STRTOSTOP) ? "sstp " : ""),
#else
		(0 ? "" : ""),
#endif
		((strm.sd_flag & REMOTE) ? "rmot " : ""));

	if (full)
		prfullstream(offset);
}
/*
 *	print full info about a stream
 */
prfullstream(addr)
long addr;
{
	struct strevent evbuf;
	struct strevent *next;
	int list_name_printed;

	fprintf(fp,"  stdata %8x  pgrp %d RCNT %2d",
		addr, strm.sd_pgrp, strm.sd_pushcnt);
	fprintf(fp,"  SIGFLAGS: %s%s%s%s",
		((strm.sd_sigflags & S_INPUT) ? " input" : ""),
		((strm.sd_sigflags & S_HIPRI) ? " hipri" : ""),
		((strm.sd_sigflags & S_OUTPUT) ? " output" : ""),
		((strm.sd_sigflags & S_MSG) ? " msg" : ""));
	fprintf(fp,"\tPOLLFLAGS: %s%s%s\n",
		((strm.sd_pollflags & POLLIN) ? " in" : ""),
		((strm.sd_pollflags & POLLPRI) ? " pri" : ""),
		((strm.sd_pollflags & POLLOUT) ? " out" : ""));
	list_name_printed = 0;
	next = strm.sd_siglist;
	while(next)
	{
		if (!list_name_printed)
		{
			list_name_printed++;
			fprintf(fp,"  SIGLIST:");
		}
		readmem((long)next,1,-1,(char *)&evbuf,
			sizeof evbuf,"stream event buffer");
		fprintf(fp,"\tPROC:  %3d   %s%s%s%s\n",
			((long)evbuf.se_procp-Proc->n_value)/
				sizeof(struct proc),
			((evbuf.se_events & S_INPUT) ? " input" : ""),
			((evbuf.se_events & S_HIPRI) ? " hipri" : ""),
			((evbuf.se_events & S_OUTPUT) ? " output" : ""),
			((evbuf.se_events & S_MSG) ? " msg" : ""));
		next = evbuf.se_next;	
	}
	list_name_printed = 0;
	next = strm.sd_pollist;
	while(next)
	{
		if (!list_name_printed)
		{
			list_name_printed++;
			fprintf(fp,"  POLLIST:");
		}
		readmem((long)next,1,-1,(char *)&evbuf,
			sizeof evbuf,"stream event buffer");
		fprintf(fp,"\tPROC:  %3d   %s%s%s\n",
			((long)evbuf.se_procp-Proc->n_value)/
				sizeof(struct proc),
			((evbuf.se_events & POLLIN) ? " in" : ""),
			((evbuf.se_events & POLLPRI) ? " pri" : ""),
			((evbuf.se_events & POLLOUT) ? " out" : ""));
		next = evbuf.se_next;	
	}
}/*--------------------------------------------------------------------------*/
trav_tree(p, q)
node_t *p, *q;
{
	if (p == NULL)
		return;
	if (p->llink == NULL && !(p->flags & POINTED_TO))
		return;
	if (p->llink != NULL)
	{
		p->chain = p->llink;
		trav_tree(p->llink, p);
	}
	else if (trace_wq)
		check_for_queue_in_tree();
	else	print_tree();

	if (p->flags & POINTED_TO)
	{
		q->chain = p->rlink;
		trav_tree(p->rlink, q);
	}
}
check_for_queue_in_tree()
{
	node_t *p;

	for (p = nodeHead; p != NULL; p = p->chain)
		if (p->top == trace_wq)
		{
			show_tree();
			trace_wq_found = 1;
		}
}
show_tree()
{
	node_t *p;
	queue_t *q_base;
	int phys = 0;
	int full = 0;
	int slot;

	/* print header only */
	show_one_stream_slot(nodeHead->slot, phys, full, -1);
	q_base = (queue_t *)Queue->n_value;
	for (p = nodeHead; p != NULL; p = p->chain)
		show_one_stream_slot(p->slot, phys, full, -2);
}
print_tree()
{
	node_t *p;
	queue_t *q_base;
	int phys = 0;

	q_base = (queue_t *)Queue->n_value;
	for (p = nodeHead; p != NULL; p = p->chain)
		printf("%3d (%3d,%3d)\t", p->slot,
			getslot(p->top, (long)q_base, sizeof que, phys, vbuf.v_nqueue),
			getslot(p->bot, (long)q_base, sizeof que, phys, vbuf.v_nqueue));
	printf("\n");
}
build_node_tbl()
{
	node_t *p, *q, *r, *s;
	queue_t	*wq, *wq_p;
	int i, j, top, bot;
	linkblk_t *addr, *linkptr;

	if (nodetbl != NULL)
		return;
	create_node_tbl();
	create_link_tbl();
	for (i = 0, linkptr = linktbl; i < nmuxlink; i++, linkptr++)
	{
		if ((p = find_bot(linkptr->l_qtop)) == NULL)
			continue;
		if ((q = find_top(linkptr->l_qbot)) == NULL)
			continue;
		if (q->flags & POINTED_TO)
		{
			r = nodetbl_end++;
			r->top = q->top, r->bot = q->bot;
			r->llink = q->llink, r->rlink = NULL;
			r->flags |= POINTED_TO;
			nodetbl_cnt++;
			p->llink = r;
			continue;
		}
		q->flags |= POINTED_TO;
		if ((r = p->llink) == NULL)
			p->llink = q;
		else
		{
			for (; r->rlink != NULL; r = r->rlink)
				;
			r->rlink = q;
		}
	}
	nodeBase = NULL;
	for (i = 0; i < nodetbl_cnt; i++)
	{
		p = &nodetbl[i];
		if (!(p->flags & POINTED_TO))
		{
			if (nodeBase == NULL)
				nodeBase = p;
			else
				node_tail->rlink = p;
			node_tail = p;
		}
	}
	nodeHead = nodeBase;
}
node_t *
find_top(top)
queue_t *top;
{
	int i;

	for (i = 0; i < nodetbl_cnt; i++)
		if (nodetbl[i].top == top)
			return(&nodetbl[i]);
	return(NULL);
}
node_t *
find_bot(bot)
queue_t *bot;
{
	int i;

	for (i = 0; i < nodetbl_cnt; i++)
		if (nodetbl[i].bot == bot)
			return(&nodetbl[i]);
	return(NULL);
}
create_node_tbl()
{
	node_t *p;
	queue_t	*wq, *wq_p;
	struct stdata *addr;
	int slot;
	int phys = 0;

	readmem((long)Nmuxlink->n_value,1,-1,(char *)&nmuxlink,
		sizeof nmuxlink,"linkblk table size");
	/* get twice as many nodes as we need in case we need to dup some */
	if ((nodetbl = (node_t *)calloc(vbuf.v_nstream,sizeof(node_t) * 2)) == NULL)
	{
		printf("unable to calloc\n");
		exit(1);
	}
	p = &nodetbl[0];
	addr = (struct stdata *)(Streams->n_value);
	for (slot = 0; slot < vbuf.v_nstream; slot++, addr++)
	{
		readbuf(-1, addr, phys, -1, &strm, sizeof strm,"streams table slot");
		if ((wq = strm.sd_wrq) == NULL)
			continue;
		p->slot = slot;
		p->top = wq;			/* write queue at top of list of queues */

		while (wq != NULL)
		{
			wq_p = wq;	/* get pointer to bottom write queue */
			readbuf(-1, wq, phys,-1, (char *)&que, sizeof que, "queue slot");
			wq = que.q_next;
		}
		p->bot = wq_p;
		p++;
	}
	nodetbl_end = p;
	nodetbl_cnt = nodetbl_end - nodetbl;
}
create_link_tbl()
{
	int slot;
	int phys = 0;
	linkblk_t *addr, *linkptr;

	readmem((long)Nmuxlink->n_value,1,-1,(char *)&nmuxlink,
		sizeof nmuxlink,"linkblk table size");
	if ((linktbl = (linkblk_t *)calloc(nmuxlink,sizeof(linkblk_t))) == NULL)
		error("enable to alloc space for linkblk table\n");

	addr = (linkblk_t *)Linkblk->n_value;
	linkptr = linktbl;
	for (slot = 0; slot < nmuxlink; slot++, addr++, linkptr++)
		readbuf(-1,(long)addr,phys,-1, (char *)linkptr,
				sizeof(linkblk_t),"linkblk table");
}
free_node_and_link()
{
	if (nodetbl != NULL)
		free(nodetbl);
	if (linktbl != NULL)
		free(linktbl);
	nodetbl = NULL;
	linktbl = NULL;
}
debug()
{
	node_t *p;
	int		i;
	int phys = 0;
	queue_t *q_base;

	q_base = (queue_t *)Queue->n_value;
	printf("nodeHead = %d node_tail = %d\n",
		 nodeHead - nodetbl, node_tail - nodetbl);
	printf("loc\tllink\trlink\tslot\ttop\tbot\tflags\n");
	for (i = 0; i < nodetbl_cnt; i++)
	{
		p = &nodetbl[i];
		printf("%d\t%d\t%d\t%d\t%d\t%d\t%x\n", i,
			p->llink ? p->llink - nodetbl : 0,
			p->rlink ? p->rlink - nodetbl : 0,
			p->slot,
			getslot(p->top, (long)q_base, sizeof que, phys, vbuf.v_nqueue),
			getslot(p->bot, (long)q_base, sizeof que, phys, vbuf.v_nqueue),
			p->flags);
	}
}/*--------------------------------------------------------------------------*/
/*
 *	QUEUE - show list of allocated queues
 */
int
getqueue()
{
	int slot = -1;
	int all = 0;
	int phys = 0;
	int showModName = 1;
	long arg1 = -1;
	long arg2 = -1;
	int c;
	int nqueue;

	talking_to_pm = TRUE;
	optind = 1;
	while((c = getopt(argcnt,args,"h:eipw:")) !=EOF)
	{
		switch(c)
		{
		case 'e' :	all = 1;
				break;
		case 'h' :	if (!get_mach_slot())
					return;
				break;
		case 'i' :	showModName = 0;	
				break;
		case 'w' :	redirect();
				break;
		case 'p' :	phys = 1;
				break;
		default  :	longjmp(syn,0);
		}
	}
	if (talking_to_pm)
	{
		streaminit();
		nqueue = vbuf.v_nqueue;
		fprintf(fp,"KERNEL QUEUE TABLE SIZE = %d\n",nqueue);
	}
	else
	{
		iopstreaminit();
		nqueue = icp->nqueue;
		fprintf(fp,"slot %s QUEUE TABLE SIZE = %d\n",slot_name,nqueue);
	}

	fprintf(fp,"SLOT INFO    NEXT LINK    Q_PTR RCNT HEAD TAIL MINP MAXP  HIWT  LOWT FLAG\n");

	if (!args[optind])
	{
		for (slot = 0; slot < nqueue; slot++)
			prqueue(all,slot,phys,showModName);
		return;
	}
	for (; args[optind] != 0; optind++)
	{
		getargs(nqueue,&arg1,&arg2);
		if (arg1 == -1) 
			continue;
		if (arg2 != -1)
			for (slot = arg1; slot <= arg2; slot++)
				prqueue(all,slot,phys,showModName);
		else if (arg1 < nqueue)
		{
			slot = arg1;
			prqueue(all,slot,phys,showModName);
		}
		else
		{
			fprintf(fp,"Queue table entry out of range\n");
			return;
		}
		arg1 = arg2 = -1;
	}
}

/* print queue table */
int
prqueue(all,slot,phys,showModName)
int all,slot,phys;
int showModName;
{
	int qn, ql;
	int    nqueue;
	long  mblkp;
	register long  queuep;

	if (talking_to_pm)
	{
		queuep = (long)Queue->n_value;
		nqueue = vbuf.v_nqueue;
		readbuf(-1, queuep+slot*sizeof que, phys,-1,
		         &que, sizeof que, "queue slot");
	}
	else
	{
		queuep = (long)icp->queuep;
		nqueue = icp->nqueue;
		readiop(queuep+slot*sizeof que, &que, sizeof que);
	}
	if (!(que.q_flag & QUSE) && !all)
		return;

	if (slot == -1)
		fprintf(fp," -  ");
        else	fprintf(fp,"%3d ",slot);

	if (showModName)
		print_mod_name(talking_to_pm);
	else	fprintf(fp,"%-8x ",que.q_qinfo);

	qn = ((long)que.q_next - queuep)/(sizeof(struct queue));
	ql = ((long)que.q_link - queuep)/(sizeof(struct queue));
	if ((qn >= 0) && (qn < nqueue))
		fprintf(fp,"%4d ",qn);
	else	fprintf(fp,"   - ");

	if ((ql >= 0) && (ql < nqueue))
		fprintf(fp,"%4d ",ql);
	else	fprintf(fp,"   - ");

	fprintf(fp,"%8x",que.q_ptr);
	fprintf(fp,"%5d",que.q_count);

	pr_msg_slot(que.q_first);
	pr_msg_slot(que.q_last);

	fprintf(fp,"%4d %4d %5d %5d",
		que.q_minpsz, que.q_maxpsz, que.q_hiwat, que.q_lowat);

	fprintf(fp,"%s%s%s%s%s%s\n",
		((que.q_flag & QENAB) ? " en" : ""),
		((que.q_flag & QWANTR) ? " wr" : ""),
		((que.q_flag & QWANTW) ? " ww" : ""),
		((que.q_flag & QFULL) ? " fl" : ""),
		((que.q_flag & QREADR) ? " rr" : ""),
		((que.q_flag & QNOENB) ? " ne" : ""));
}
pr_msg_slot(m)
mblk_t *m;
{
	char	op_char;

	if (m != NULL)
	{
		if ((uint)m < IOPM_RAM_START)
		{
			if (talking_to_pm)
				op_char = ' ';
			else	op_char = 'I';
			fprintf(fp,"%c%4d",op_char,
				((long)m - pm_mblkp)/(sizeof(mblk_t)));
		}
		else
		{
			if (talking_to_pm)
				op_char = 'K';
			else	op_char = ' ';
			fprintf(fp,"%c%4d",op_char,
				 ((long)m - iop_mblkp)/(sizeof(mblk_t)));
		}
	}
	else	fprintf(fp,"    -");
}/*--------------------------------------------------------------------------*/
/*	
 *	MBLOCK - show list of allocated streams messages
 */
int
getmess()
{
	int slot = -1;
	int all = 0;
	int dump_flag = 0;
	int phys = 0;
	long arg1 = -1;
	long arg2 = -1;
	int c;
	int first_time = 0;

	talking_to_pm = TRUE;
	optind = 1;
	while((c = getopt(argcnt,args,"h:acdepw:")) !=EOF)
	{
		switch(c)
		{
		case 'h' :	if (!get_mach_slot())
					return;
				break;
		case 'a' :	dump_flag |= 4;
				break;
		case 'c' :	dump_flag |= 2;
				break;
		case 'd' :	dump_flag |= 1;
				break;
		case 'e' :	all = 1;
				break;
		case 'w' :	redirect();
				break;
		case 'p' :	phys = 1;
				break;
		default  :	longjmp(syn,0);
		}
	}
	if (talking_to_pm)
	{
		streaminit();
		fprintf(fp,"KERNEL MESSAGE BLOCK TABLE SIZE = %d\n",nmblock);
	}
	else
	{
		iopstreaminit();
		fprintf(fp,"slot %s MESSAGE BLOCK TABLE SIZE = %d\n",
							slot_name,nmblock);
	}
	fprintf(fp,"%s", msg_heading);

	if (!args[optind])
	{
		for (slot = 0; slot < nmblock; slot++)
			prmess(all,slot,phys,dump_flag, first_time++);
		return;
	}
	for (; args[optind] != 0; optind++)
	{
		getargs(nmblock,&arg1,&arg2);
		if (arg1 == -1) 
			continue;
		else if (arg2 != -1)
			for (slot = arg1; slot <= arg2; slot++)
				prmess(all,slot,phys,dump_flag, first_time++);
		else if (arg1 < nmblock)
			prmess(all,arg1,phys, dump_flag, first_time++);
		else
		{
			fprintf(fp,"Message block table entry out of range\n");
			return;
		}
		arg1 = arg2 = -1;
	}
}
/*
 *	print mblock table
 */
int
prmess(all,slot,phys, dump_flag, first)
int all,slot,phys;
int dump_flag;
int	first;
{
	do
	{
		slot = pr_one_msg(all,slot,phys,dump_flag, first++);
	}
	while (slot != -1 && dump_flag & 4);
}
	
pr_one_msg(all,slot,phys, dump_flag, first_time)
int all,slot,phys;
int dump_flag;
int	first_time;
{
	int mnext, datap, mprev;
	int data_size;
	long mblkp, dblkp;
	long addr;
	extern int stream_prod();

	if (talking_to_pm)
	{
		mblkp = pm_mblkp;
		dblkp = pm_dblkp;
	}
	else
	{
		mblkp = iop_mblkp;
		dblkp = iop_dblkp;
	}
	if (slot == -1)
		return(-1);
	addr = read_mblk(slot, phys);

	if (!mblk.b_datap && !all) 
		return(-1);

	if (dump_flag != 0 && first_time != 0)
		fprintf(fp,"%s", msg_heading);
	fprintf(fp,"%8x ",addr);
	if (slot == -1)
		fprintf(fp,"   -  ");
	else	fprintf(fp,"%5d ",slot);

	mnext = ((long)mblk.b_next - mblkp)/sizeof(mblk_t);
	if (mnext >= 0 && mnext < nmblock)
		fprintf(fp,"%5d ",mnext);
	else
	{
		mnext = -1;
		if (mblk.b_next == 0)
			fprintf(fp,"    - ");		/* end of line */
		else	fprintf(fp,"%-x ", mblk.b_next); /* bad value */
	}
	mcont = ((long)mblk.b_cont - mblkp)/sizeof(mblk_t);
	if (mcont >= 0 && mcont < nmblock)
		fprintf(fp,"%5d ",mcont);
	else
	{
		mcont = -1;
		if (mblk.b_cont == 0)
			fprintf(fp,"    - ");		/* end of line */
		else	fprintf(fp,"%-x ", mblk.b_cont); /* bad value */
	}
	mprev = ((long)mblk.b_prev - mblkp)/sizeof(mblk_t);
	if (mprev >= 0 && mprev < nmblock)
		fprintf(fp,"%5d ",mprev);
	else
	{
		mprev = -1;
		if (mblk.b_prev == 0)
			fprintf(fp,"    - ");		/* end of line */
		else	fprintf(fp,"%-x ", mblk.b_prev); /* bad value */
	}
	fprintf(fp,"%8x  %8x  ", mblk.b_rptr, mblk.b_wptr);

	if (mblk.b_datap) 
	{
		datap = ((long)mblk.b_datap - dblkp)/sizeof(dblk_t);
		if (datap >= 0 && datap < ndblock)
			fprintf(fp,"%5d   ",datap);
		else
		{
			datap = -1;
			if (mblk.b_datap == 0)
				fprintf(fp,"    -   ");		/* end of line*/
			else	fprintf(fp,"%-x  ", mblk.b_next); /* bad value*/
		}
		prdb_type(dblk.db_type);
		fprintf(fp,"  ");
		prdb_size(dblk.db_class);	/* print data block size */
	
		fprintf(fp,"\n");

		if (dump_flag && (data_size = mblk.b_wptr - mblk.b_rptr) != 0)
			stream_prod(mblk.b_rptr, data_size, phys, Procslot);
	}
	else	fprintf(fp,"\n");
	if (dump_flag & 2)
		pr_one_msg(all, mcont, phys, dump_flag, 1);
	return(mnext);
}
read_mblk(slot, phys)
int	slot, phys;
{
	long	addr;

	if (talking_to_pm)
	{
		addr = pm_mblkp + slot * sizeof mblk;
		readbuf(-1,addr,phys,-1, &mblk,sizeof mblk,"message block");
		if (mblk.b_datap) 
			readbuf(mblk.b_datap,0,phys,-1,
				&dblk, sizeof dblk,"data block");
	}
	else
	{
		addr = iop_mblkp + slot * sizeof mblk;
		readiop(addr, &mblk, sizeof mblk);
		if (mblk.b_datap) 
			readiop(mblk.b_datap, &dblk, sizeof dblk);
	}
	return(addr);
}/*--------------------------------------------------------------------------*/
/*
 *	MBFREE - show list of free streams messages
 */
int
getmbfree()
{
	int c;
	mblk_t *m;
	int  mnext;
	long  mblkp;

	talking_to_pm = TRUE;
	optind = 1;
	while((c = getopt(argcnt,args,"h:w:")) !=EOF)
	{
		switch(c)
		{
		case 'h' :	if (!get_mach_slot())
					return;
				break;
		case 'w' :	redirect();
				break;
		default  :	longjmp(syn,0);
		}
	}
	if (talking_to_pm)
	{
		streaminit();
		fprintf(fp,"KERNEL mbfree\n");
	}
	else
	{
		iopstreaminit();
		fprintf(fp,"slot %s mbfree\n",slot_name);
	}
	fprintf(fp,"  ADDR    SLOT  NEXT  CONT  PREV    RPTR      WPTR\n");

	if (args[optind]) 
		longjmp(syn,0);

	/* print mblock free list */

	if (talking_to_pm)
	{
		mblkp = pm_mblkp;
		readmem((long)Mbfree->n_value, 1, -1, (char *)&m, sizeof m,
		         "mbfreelist");
	}
	else
	{
		mblkp = iop_mblkp;
		m = Iopcomm.imbfreelist;
	}
	mnext = ((long)m - mblkp)/sizeof(struct msgb);
	while ((mnext >=0) && (mnext < nmblock))
		mnext = prmess(1,mnext,0, 0, 0);
}/*--------------------------------------------------------------------------*/
/*
 *	DBLOCK - show list of allocated data blocks
 */
int
getdblk()
{
	int slot = -1;
	int all = 0;
	int phys = 0;
	int class = 0;
	long arg2 = -1;
	long arg1 = -1;
	int c;
	int klass;

	talking_to_pm = TRUE;
	optind = 1;
	while((c = getopt(argcnt,args,"h:epcw:")) !=EOF)
	{
		switch(c)
		{
		case 'h' :	if (!get_mach_slot())
					return;
				break;
		case 'e' :	all = 1;
				break;
		case 'p' :	phys = 1;
				break;
		case 'c' :	class = 1;
				break;
		case 'w' :	redirect();
				break;
		default  :	longjmp(syn,0);
		}
	}
	if (talking_to_pm)
	{
		streaminit();
		fprintf(fp,"KERNEL DATA BLOCK TABLE SIZE = %d\n",ndblock);
	}
	else
	{
		iopstreaminit();
		fprintf(fp,"slot %s DATA BLOCK TABLE SIZE = %d\n",
				slot_name, ndblock);
	}
	lastcls = -1; 		/* cause header to print on first call */
	if (!args[optind])
	{
		for (slot = 0; slot < ndblock; slot++)
			prdblk(all,slot,phys);
		return;
	}
	for (; args[optind] != 0; optind++)
	{
		if (class) 
		{
			if ((klass = (int)strcon(args[optind],'d')) != -1)
				prclass(klass);
		}
		else
		{
			getargs(ndblock,&arg1,&arg2);
			if (arg1 == -1) 
				continue;
			else if (arg2 != -1)
			{
				for (slot = arg1; slot <= arg2; slot++)
					prdblk(all,slot,phys);
			}
			else if (arg1 < ndblock)
				prdblk(all,arg1,phys);
			else
			{
				fprintf(fp,
				    "Data block table entry out of range\n");
				return;
			} 
			arg1 = arg2 = -1;
		}
	}
}

/* print dblock table */
int
prdblk(all,slot,phys)
int all,slot,phys;
{
	int dfree;
	long  dblkp;

	if (talking_to_pm)
	{
		dblkp = pm_dblkp;
		readbuf(-1,dblkp+slot*sizeof dblk,phys,-1,
		        (char *)&dblk, sizeof dblk,"data block");
	}
	else
	{
		dblkp = iop_dblkp;
		readiop(dblkp+slot*sizeof dblk, (char *)&dblk, sizeof dblk);
	}

	if (!dblk.db_ref && !all)
		return(-1);

	if (dblk.db_class != lastcls)
	{
		fprintf(fp, "SLOT CLASS SIZE REF  TYPE       BASE     LIMIT   FREEP\n");
		lastcls=dblk.db_class;
	}
	if (slot == -1)
		fprintf(fp,"  - ");
	else	fprintf(fp,"%4d",slot);

	fprintf(fp," %5d ", dblk.db_class);

	prdb_size(dblk.db_class);	/* print data block size */

	fprintf(fp," %3d  ", dblk.db_ref); 

	prdb_type(dblk.db_type);		/* print data block type */

	fprintf(fp,"  %8x  %8x ", dblk.db_base, dblk.db_lim);

	dfree = ((long)dblk.db_freep - dblkp)/sizeof(struct datab);

	if ((dfree >= 0) && (dfree < ndblock))
		fprintf(fp," %4d\n",dfree);
	else	fprintf(fp,"  -\n");

	return(dfree);
}

prdb_size(class)
unsigned char class;
{
	switch (class)
	{
	case 0: fprintf(fp,"   4"); break;
	case 1: fprintf(fp,"  16"); break;
	case 2: fprintf(fp,"  64"); break;
	case 3: fprintf(fp," 128"); break;
	case 4: fprintf(fp," 256"); break;
	case 5: fprintf(fp," 512"); break;
	case 6: fprintf(fp,"1024"); break;
	case 7: fprintf(fp,"2048"); break;
	case 8: fprintf(fp,"4096"); break;
	default: fprintf(fp,"   -");
	}
}

prdb_type(type)
unsigned char type;
{
	switch (type)
	{
		case M_DATA:	fprintf(fp,"data   "); break;
		case M_PROTO:	fprintf(fp,"proto  "); break;
		case M_BREAK:	fprintf(fp,"break  "); break;
		case M_PASSFP:	fprintf(fp,"passfs "); break;
		case M_SIG:	fprintf(fp,"sig    "); break;
		case M_DELAY:	fprintf(fp,"delay  "); break;
		case M_CTL:	fprintf(fp,"ctl    "); break;
		case M_IOCTL:	fprintf(fp,"ioctl  "); break;
		case M_SETOPTS:	fprintf(fp,"setopts"); break;
		case M_RSE:	fprintf(fp,"rse    "); break;
		case M_KILL:	fprintf(fp,"kill   "); break;
		case M_OPEN:	fprintf(fp,"open   "); break;
		case M_CLOSE:	fprintf(fp,"close  "); break;
		case M_HICOPY:	fprintf(fp,"hicopy "); break;
		case M_LOCOPY:	fprintf(fp,"locopy "); break;
		case M_RFLOW:	fprintf(fp,"rflow  "); break;
		case M_WFLOW:	fprintf(fp,"wflow  "); break;
		case M_KILLS:	fprintf(fp,"kills  "); break;
		case M_CLOSES:	fprintf(fp,"closes "); break;
		case M_IOCACK:	fprintf(fp,"iocack "); break;
		case M_IOCNAK:	fprintf(fp,"iocnak "); break;
		case M_PCPROTO:	fprintf(fp,"pcproto"); break;
		case M_PCSIG:	fprintf(fp,"pcsig  "); break;
		case M_READ:	fprintf(fp,"read   "); break;
		case M_FLUSH:	fprintf(fp,"flush  "); break;
		case M_STOP:	fprintf(fp,"stop   "); break;
		case M_START:	fprintf(fp,"start  "); break;
		case M_HANGUP:	fprintf(fp,"hangup "); break;
		case M_ERROR:	fprintf(fp,"error  "); break;
		case M_COPYIN:	fprintf(fp,"copyin "); break;
		case M_COPYOUT:	fprintf(fp,"copyout"); break;
		case M_IOCDATA:	fprintf(fp,"iocdata"); break;
		case M_PCRSE:	fprintf(fp,"pcrse  "); break;
		default:	fprintf(fp,"%2x     ",type);
	}
}

/* print all dblock for given class */
int
prclass(class)
int class;
{
	int i,n, *p;
	int clasize[NCLASS];

	if ((class < 0) || (class > NCLASS-1))
		error("%d is out of range\n",class);

	if (talking_to_pm)
		p = &(vbuf.v_nblk4096);
	else	p = (int *)&Iopcomm.nblk[0];

	for (i=NCLASS-1; i>=0; i--)
		clasize[i] = *p++;  /* load size of each block class */ 

	n=0;
	for (i=NCLASS-1; i>class; i--)
		n+=clasize[i];	/* compute slot of first block */ 

	for (i=0; i<clasize[class]; i++)
		prdblk(1,n++,0,-1);
}/*--------------------------------------------------------------------------*/
/*
 *	DBFREE - show free data blocks
 */
int
getdbfree()
{
	int c;
	int class;
	int klass;

	talking_to_pm = TRUE;
	optind = 1;
	while((c = getopt(argcnt,args,"h:w:")) !=EOF)
	{
		switch(c)
		{
		case 'h' :	if (!get_mach_slot())
					return;
				break;
		case 'w' :	redirect();
				break;
		default  :	longjmp(syn,0);
		}
	}
	if (talking_to_pm)
	{
		streaminit();
		fprintf(fp,"KERNEL dbfree\n");
	}
	else
	{
		iopstreaminit();
		fprintf(fp,"slot %s dbfree\n",slot_name);
	}
	lastcls = -1; 		/* cause header to print on first call */

	if (!args[optind])
	{
		for (class = 0; class < NCLASS; class++)
			prdbfree(class);
		return;
	}
	for (; args[optind] != 0; optind++)
	{
		if ((klass = (int)strcon(args[optind],'d')) != -1)
			prdbfree(klass);
	}
}

/* print dblock free list */
int
prdbfree(class)
int class;
{
	dblk_t *d;
	int  dnext;
	long  dblkp;

	if ((class < 0) || (class > NCLASS-1))
		error("%d is out of class range\n",class);
	if (talking_to_pm)
	{
		readmem((long)(Dbfree->n_value+class*sizeof d),1,-1,(char *)&d,
		         sizeof d,"dbfreelist");
		dblkp = pm_dblkp;
	}
	else
	{
		d = Iopcomm.idbfreelist[class];
		dblkp = iop_dblkp;
	}

	dnext = ((long)d - dblkp)/sizeof(struct datab);
	while ((dnext >=0) && (dnext < ndblock))
		dnext = prdblk(1,dnext,0,-1);
}/*--------------------------------------------------------------------------*/
/*
 *	QRUN - show list of queues scheduled to be run
 */
int
getqrun()
{
	int c;
	queue_t *q;
	int  ql;
	long  queuep;

	talking_to_pm = TRUE;
	optind = 1;
	while((c = getopt(argcnt,args,"h:w:")) !=EOF)
	{
		switch(c)
		{
		case 'h' :	if (!get_mach_slot())
					return;
				break;
		case 'w' :	redirect();
				break;
		default  :	longjmp(syn,0);
		}
	}
	if (talking_to_pm)
	{
		streaminit();
		fprintf(fp,"KERNEL runqueue\n");
		queuep = (long)Queue->n_value;
		readmem((long)Qhead->n_value,1,-1,(char *)&q,
		        sizeof q,"qhead");
	}
	else
	{
		iopstreaminit();
		fprintf(fp,"slot %s runqueue\n",slot_name);
		queuep = (long)Iopcomm.queuep;
		q = (queue_t *)Iopcomm.qihead;
	}
	fprintf(fp,"Queue slots scheduled for service: ");
	for ( ; q != NULL; q = que.q_link)
	{
		ql = ((long)q - queuep)/(sizeof(struct queue));
		fprintf(fp,"%4d ",ql);
		if (talking_to_pm)
			readmem(q,1,-1,&que, sizeof que,"scanning queue list");
		else	readiop((long)q, (char *)&que, sizeof que);
	}
	fprintf(fp,"\n");
}/*--------------------------------------------------------------------------*/
/*
 *	STRSTAT - show stream stats
 */
int
getstrstat()
{
	int c;
	queue_t *q;
	int qruncnt;

	talking_to_pm = TRUE;
	optind = 1;
	while((c = getopt(argcnt,args,"h:w:")) !=EOF)
	{
		switch(c)
		{
		case 'h' :	if (!get_mach_slot())
					return;
				break;
		case 'w' :	redirect();
				break;
		default  :	longjmp(syn,0);
		}
	}
	/*	print stream statistics		*/
	qruncnt = 0;
	if (talking_to_pm)
	{	
		streaminit();
		fprintf(fp,"Statistics for KERNEL\n");
		readmem((long)Qhead->n_value,1,-1,(char *)&q, sizeof q,"qhead");
		for ( ; q != NULL; q = que.q_link)
		{
			qruncnt++;
			readmem((long)q,1,-1,&que,sizeof que,"queue run list");
		}
		seekmem((long)Strst->n_value, 1, -1);
		if (read(kmem, &strst, sizeof strst) != sizeof strst)
			error(fp,"read error for strst\n");

		show_strstat(vbuf.v_nqueue, qruncnt, &strst, &vbuf.v_nblk4096);
	}
	else
	{
		iopstreaminit();
		fprintf(fp,"Statistics for slot %s\n",slot_name);
		for (q = (queue_t *)icp->qihead; q != NULL; q = que.q_link)
		{
			qruncnt++;
			readiop((long)q, (char *)&que, sizeof que);
		}
		show_strstat(icp->nqueue, qruncnt, &icp->istrst, &icp->nblk[0]);
	}
}
/*
 *	show streams stats
 */
show_strstat(nqueue, qruncnt, stp, p)
int nqueue, qruncnt;
struct strstat *stp;
int *p;
{
	int dcc[NCLASS];
	int i,j;

	for (i=NCLASS-1; i>=0; i--)
		dcc[i] = *p++;

	fprintf(fp,"ITEM                  CONFIG    ALLOC    FREE          TOTAL    MAX    FAIL\n");
	/* always show 'streams' stats from kernel since iopm doesn't have
	 * seperate streams stats */
	fprintf(fp,"streams                 %4d     %4d    %4d    %10d    %4d    %4d\n",
		vbuf.v_nstream, strst.stream.use, vbuf.v_nstream - strst.stream.use, strst.stream.total, strst.stream.max, strst.stream.fail);
	fprintf(fp,"queues                  %4d     %4d    %4d    %10d    %4d    %4d\n",
		nqueue, stp->queue.use *2, nqueue - (stp->queue.use*2), stp->queue.total, stp->queue.max * 2, stp->queue.fail);
	fprintf(fp,"message blocks         %5d    %5d   %5d    %10d%8d%8d\n",
		nmblock, stp->mblock.use, nmblock - stp->mblock.use, stp->mblock.total, stp->mblock.max, stp->mblock.fail);
	fprintf(fp,"data block totals      %5d    %5d   %5d    %10d%8d%8d\n",
		ndblock, stp->dblock.use, ndblock - stp->dblock.use, 
		stp->dblock.total, stp->dblock.max, stp->dblock.fail);
	for (i=0; i<NCLASS; i++) 
	{
		fprintf(fp,"data block size ");
		switch (i)
		{
		case 0: fprintf(fp,"   4  "); break;
		case 1: fprintf(fp,"  16  "); break;
		case 2: fprintf(fp,"  64  "); break;
		case 3: fprintf(fp," 128  "); break;
		case 4: fprintf(fp," 256  "); break;
		case 5: fprintf(fp," 512  "); break;
		case 6: fprintf(fp,"1024  "); break;
		case 7: fprintf(fp,"2048  "); break;
		case 8: fprintf(fp,"4096  "); break;
		default: fprintf(fp,"   -  ");
		}
		fprintf(fp,"  %4d     %4d    %4d    %10d%8d%8d\n",
			dcc[i], stp->dblk[i].use, dcc[i] - stp->dblk[i].use, 
			stp->dblk[i].total, stp->dblk[i].max,stp->dblk[i].fail);
	}
	fprintf(fp,"\nCount of scheduled queues:%4d\n", qruncnt);
}/*--------------------------------------------------------------------------*/
/*
 *	LINKBLK
 */
/* kernel only. no IOPM counterpart */
int
getlinkblk()
{
	int c;
	int slot = -1;
	int all = 0;
	int phys = 0;
	long addr = -1;
	long arg2 = -1;
	long arg1 = -1;

	if (!Linkblk)
		if (!(Linkblk = symsrch("linkblk")))
			error("linkblk not found in symbol table\n");
	if (!Nmuxlink)
		if (!(Nmuxlink = symsrch("nmuxlink")))
			error("nmuxlink not found in symbol table\n");
	if (!Queue)
		if (!(Queue = symsrch("queue")))
			error("queue not found in symbol table\n");
	optind = 1;
	while((c = getopt(argcnt,args,"epw:")) !=EOF)
	{
		switch(c)
		{
		case 'e' :	all = 1;
				break;
		case 'p' :	phys = 1;
				break;
		case 'w' :	redirect();
				break;
		default  :	longjmp(syn,0);
		}
	}
	readmem((long)Nmuxlink->n_value,1,-1,(char *)&nmuxlink,
		sizeof nmuxlink,"linkblk table size");
	fprintf(fp,"LINKBLK TABLE SIZE = %d\n",nmuxlink);
	fprintf(fp,"SLOT     QTOP     QBOT   INDEX\n");
	if (!args[optind])
	{
		for (slot = 0; slot < nmuxlink; slot++)
			prlinkblk(all,slot,phys,addr,nmuxlink);	
		return;
	}
	for (; args[optind] != 0; optind++)
	{
		getargs(nmuxlink,&arg1,&arg2);
		if (arg1 == -1) 
			continue;
		if (arg2 != -1)
		{
			for (slot = arg1; slot <= arg2; slot++)
				prlinkblk(all,slot,phys,addr,nmuxlink);
		}
		else if (arg1 < nmuxlink)
		{
			slot = arg1;
			prlinkblk(all,slot,phys,addr,nmuxlink);
		} 
		else 
		{
			fprintf(fp,"Linkblk table entry out of range\n");
			return;
		}
		addr = arg1 = arg2 = -1;
	}
}

/* print linkblk table */
int
prlinkblk(all,slot,phys,addr,max)
int all,slot,phys,max;
long addr;
{
	linkblk_t linkbuf;

	readbuf(addr,(long)(Linkblk->n_value+slot*sizeof linkbuf),phys,-1,
		(char *)&linkbuf,sizeof linkbuf,"linkblk table");
	if (!linkbuf.l_qtop && !all)
		return;
	if (addr > -1)
		slot = getslot(addr,Linkblk->n_value,sizeof linkbuf,phys, max);
	if (slot == -1)
		fprintf(fp,"  - ");
	else	fprintf(fp,"%4d", slot);

	slot = ((long)linkbuf.l_qtop-Queue->n_value)/ sizeof(struct queue);
	if ((slot >= 0) && (slot < vbuf.v_nqueue))
		fprintf(fp,"    %5d",slot);
	else	fprintf(fp," %8x",linkbuf.l_qtop);

	slot = ((long)linkbuf.l_qbot-Queue->n_value)/ sizeof(struct queue);
	if ((slot >= 0) && (slot < vbuf.v_nqueue))
		fprintf(fp,"    %5d",slot);
	else	fprintf(fp," %8x",linkbuf.l_qbot);
	fprintf(fp,"   %5d\n",linkbuf.l_index);
}/*--------------------------------------------------------------------------*/
/*
 *	DBALLOC - show functions waiting for a buffer to become available
 */
int
getdballoc()
{
	int c,class;

	talking_to_pm = TRUE;
	optind = 1;
	while((c = getopt(argcnt,args,"h:w:")) !=EOF)
	{
		switch(c)
		{
		case 'h' :	if (!get_mach_slot())
					return;
				break;
		case 'w' :	redirect();
				break;
		default  :	longjmp(syn,0);
		}
	}
	if (talking_to_pm)
	{
		streaminit();
		fprintf(fp,"dballoc for KERNEL\n");
	}
	else
	{
		iopstreaminit();
		fprintf(fp,"dballoc for slot %s\n", slot_name);
	}
	if (!args[optind])
	{
		for (class = 0; class < NCLASS; class++)
			prdballoc(class);
		return;
	}
	for (; args[optind] != 0; optind++)
	{
		if ((class = strcon(args[optind],'d')) == -1)
			continue;
		if ((class >= 0) && (class < NCLASS))
			prdballoc(class);
		else	fprintf(fp,"%d is out of class range\n", class);
	}
}

/* print dballoc table */
int
prdballoc(class)
int class;
{
	struct dbalcst dbalbuf;
	struct strevent *nextlo, *nextmed, *nexthi;
	struct strevent *prfuncname();
	int header_printed;
	int *p;
	int dcc[NCLASS], i;

	if (talking_to_pm)
	{
		readmem((long)(Dballoc->n_value+class*sizeof dbalbuf),1,-1,
		        (char *)&dbalbuf,sizeof dbalbuf,"dballoc table");
		seekmem((long)Strst->n_value, 1, -1);
		p = &vbuf.v_nblk4096;
	}
	else
	{
		dbalbuf = Iopcomm.idballoc[class];
		p = (int *)&Iopcomm.nblk[0];
	}
	for (i = NCLASS-1; i >= 0; i--)
		dcc[i] = *p++;

	fprintf(fp,"class %d  size %4d  in use %4d  lo_pri %4d  med_pri %4d  hi_pri %4d\n",
		class, rbsize[class], dbalbuf.dba_cnt,
		dbalbuf.dba_lo, dbalbuf.dba_med, dcc[class]);
	nextlo = dbalbuf.dba_lop;
	nextmed = dbalbuf.dba_medp;
	nexthi = dbalbuf.dba_hip;
	header_printed = 0;
	while (1)
	{
		line_not_empty = 0;
		nextlo  = prfuncname(nextlo,  &line_buffer[0]);
		nextmed = prfuncname(nextmed, &line_buffer[26]);
		nexthi  = prfuncname(nexthi,  &line_buffer[52]);
		if (line_not_empty)
		{
			if (!header_printed)
			{
				header_printed++;
				fprintf(fp, "  LOW FUNCTION    LOW ARG ");
				fprintf(fp, "  MED FUNCTION    MED ARG ");
				fprintf(fp, "  HI  FUNCTION    HI  ARG\n");
			}
			line_buffer[78] = 0;
			fprintf(fp, "%s\n", line_buffer);
		}
		else	return;
	}
}
/*
 *	print function name for dballoc
 */
struct strevent *
prfuncname(addr, ptr)
unchar *addr;
char *ptr;
{
	struct syment *sp;
	extern struct syment *findsym();
	extern char *strtbl;
	struct strevent evbuf;
	static char tname[SYMNMLEN+1];
	char *name;
	
	if (addr == NULL)
	{
		strncpy(ptr, "                        ", 26);
		return(NULL);
	}
	line_not_empty++;
	strncpy(ptr, "  ", 2);
	if (talking_to_pm)
	{
		readmem((long)addr,1,-1,(char *)&evbuf,
		        sizeof evbuf,"stream event buffer");
		if ((sp = findsym((unsigned long)evbuf.se_func)) != NULL)
		{
			if (sp->n_zeroes)
			{
				strncpy(tname,sp->n_name,SYMNMLEN);
				name = tname;
			}
			else	name = strtbl + sp->n_offset;
			sprintf(ptr+2,"%-15s",name);
		}
		else	sprintf(ptr+2, "%8x       ", evbuf.se_func);
	}
	else
	{
		readiop((long)addr, (char *)&evbuf, sizeof evbuf);
		sprintf(ptr+2, "%8x       ", evbuf.se_func);
	}
	sprintf(ptr+17," %8x",evbuf.se_arg);
	return(evbuf.se_next);
}/*--------------------------------------------------------------------------*/
/*
 *	read iopm common structure for iopm at slot 'slot_name'
 */
readiopcomm()
{
	/* FIX *** seek assumes that 'iopcomm' is at address IOPM_RAM_START
	 * so change if 'iopcomm' moves */

	long	addr = 0;

	if (iopmem != -1)
		close(iopmem);
	if ((iopmem = open(dev_slot_name, 0)) == -1)
		error("failed to open %s\n", dev_slot_name);

	if (lseek(iopmem,addr,0) == -1)
		error("seek error on IOPM address %x\n",addr);

	if (read(iopmem,&Iopcomm,sizeof(struct iopm_comm)) ==-1)
		error("failed to read iopcomm\n");

	if (Iopcomm.iopm_version != IOPM_VERSION)
		error("incompatable magic no. in iopcomm for %s, is %x, should be %x\n",slot_name, Iopcomm.iopm_version, IOPM_VERSION);
	icp = &Iopcomm;
}/*--------------------------------------------------------------------------*/
/*
 *	read some data from an iopm
 */
readiop(addr, buffer, size)
long addr;
char *buffer;
{
	caddr_t  iopm_vtop();

	/* convert address from virtual to physical if necessary */
#if defined LIVING_IOPM_ONLY
	if (addr < IOPM_RAM_START)
		addr = ioctl(iopmem, VTOP, addr);
#else
	if (addr < IOPM_RAM_START)
		addr = (long)iopm_vtop(addr);
#endif

	if (lseek(iopmem,addr-IOPM_RAM_START,0) == -1)
		error("seek error on IOPM address %x\n",addr);

	if (read(iopmem,buffer,size) != size)
		error("read error on IOPM address %x\n",addr);
}/*--------------------------------------------------------------------------*/
/*
 *	do vtop in the IOPM by doing a table walk
 *
 *	returns valid IOPM physical addr or 0 for failure
 */
caddr_t
iopm_vtop(vaddr)
register caddr_t  vaddr;
{
	struct mmutbl  *stblp;
	struct mmutbl  stbl;
	uint           *ptblp;
	uint           ptbl;

	if ( vaddr >= (caddr_t)IOPM_DB_BASE )
		return vaddr;		/* iopm physical mem or db or regs */

	if ( vaddr >= (caddr_t)ADDR_SYS_SEGS )
		return 0;		/* kernel system segs or physical */

	stblp = (struct mmutbl *)Iopcomm.stblp + ((uint)vaddr >> SEG_SHFT);

	readiop(stblp, &stbl, sizeof stbl);
	if ( (stbl.limit & DTMASK) == PGDESC )
		return (caddr_t)((stbl.tblp & PAMASK) +
		                 ((uint)vaddr & SEG_SIZE-1));

	if ( (stbl.limit & DTMASK) == PTDESC4 )
	{
		ptblp = (uint *)(stbl.tblp & 0xfffffff0) +
		        (((uint)vaddr >> PNUMSHFT) & (NPDPPT - 1));
		if ( ptblp >= (uint *)IOPM_RAM_START )
		{
			readiop(ptblp, &ptbl, sizeof ptbl);
			return (caddr_t)((ptbl & ~POFFMASK) + poff(vaddr));
		}
		else
			return 0;
	}

	return 0;
}/*--------------------------------------------------------------------------*/
/*
 *	see if iopm at slot specified by '-h' option
 *
 *	return	TRUE  if iopm in slot
 *		talking_to_pm = FALSE
 *
 *	return	FALSE if no iopm in slot
 */
get_mach_slot()
{
	int fd;

	strcpy(slot_name, optarg);
	sprintf(dev_slot_name,"/dev/iopm/iopm%s",slot_name);
	if ((fd = open(dev_slot_name, 0)) == -1)
	{
		fprintf(fp, "failed to open %s\n", dev_slot_name);
		return(FALSE);
	}
	else
	{
		talking_to_pm = FALSE;
		close(fd);
		return(TRUE);
	}
}/*--------------------------------------------------------------------------*/
/*
 *	PM initialization for namelist symbols
 */
int
streaminit()
{
	if (!Linkblk)
		if (!(Linkblk = symsrch("linkblk")))
			error("linkblk not found in symbol table\n");
	if (!Nmuxlink)
		if (!(Nmuxlink = symsrch("nmuxlink")))
			error("nmuxlink not found in symbol table\n");
	if (!Queue)
		if (!(Queue = symsrch("queue")))
			error("queue not found in symbol table\n");
	if (!Streams)
		if (!(Streams = symsrch("streams")))
			error("streams not found in symbol table\n");
	if (!Mblock)
		if (!(Mblock = symsrch("mblock")))
			error("mblock not found in symbol table\n");
	if (!Dblock)
		if (!(Dblock = symsrch("dblock")))
			error("dblock not found in symbol table\n");
	if (!Qhead)
		if (!(Qhead = symsrch("qhead")))
			error("qhead not found in symbol table\n");
	if (!Dbfree)
		if (!(Dbfree = symsrch("dbfreelist")))
			error("dbfreelist not found in symbol table\n");
	if (!Dballoc)
		if (!(Dballoc = symsrch("dballoc")))
			error("dballoc not found in symbol table\n");
	if (!Mbfree)
		if (!(Mbfree = symsrch("mbfreelist")))
			error("mbfreelist not found in symbol table\n");
	if (!Strst)
		if (!(Strst = symsrch("strst")))
			error("strst not found in symbol table\n");
	pm_mblkp = Mblock->n_value;
	pm_dblkp = Dblock->n_value;
	blockinit();
}
/*
 *	IOPM initialization for namelist symbols
 */
iopstreaminit()
{
	if (!Streams)
		if (!(Streams = symsrch("streams")))
			error("streams not found in symbol table\n");
	readiopcomm();
	iop_mblkp = (long)Iopcomm.mblkp;
	iop_dblkp = (long)Iopcomm.dblkp;
	iopblockinit();
}/*--------------------------------------------------------------------------*/
/*
 * NOTE: rfs functions not fixed. They use blockinit and streaminit,
 * hence iopblockinit and iopstreaminit.
 */
int
blockinit()
{
	/* Initialize streams data block and message block counts - these  */
	/* formulas should match those in space.h                          */

	ndblock = vbuf.v_nblk4096 + vbuf.v_nblk2048 + vbuf.v_nblk1024 +
		  vbuf.v_nblk512  + vbuf.v_nblk256  + vbuf.v_nblk128 +
		  vbuf.v_nblk64   + vbuf.v_nblk16   + vbuf.v_nblk4;   
	nmblock = ndblock + ndblock/4;
}
/*
 *	Initialize IOPM streams data block and message block counts
 */
iopblockinit()
{
	ndblock = Iopcomm.nblk[0] + Iopcomm.nblk[1] + Iopcomm.nblk[2] +
		  Iopcomm.nblk[3] + Iopcomm.nblk[4] + Iopcomm.nblk[5] +
		  Iopcomm.nblk[6] + Iopcomm.nblk[7] + Iopcomm.nblk[8];   
	nmblock = ndblock + ndblock/4;
}/*--------------------------------------------------------------------------*/
/*
 * devname(devnumber): return "/dev/name" in dev_rbuf[], which is the name
 * of the  dev belonging to device number devnm.
 *
 * This program works in two passes: the first pass tries to
 * find the device by matching device and inode numbers; if
 * that doesn't work, it tries a second time, this time doing a
 * stat on every file in /dev and trying to match device numbers
 * only. If that fails too, NULL is returned.
 */
devname(devnm, devdir)
dev_t	devnm;
char	*devdir;
{
	struct stat tsb;
	struct dirent *db;
	DIR *df;
	char tmp_dev_rbuf[32];		/* device name (e.g., /dev/tty02) */

	if ((df = opendir(devdir)) == NULL)
		return(0);
	while ((db = readdir(df)) != NULL)
	{
		if (strcmp(db->d_name, ".") == 0
		 || strcmp(db->d_name, "..") == 0)
			continue;
		strcpy(dev_rbuf, devdir);
		strcat(dev_rbuf, "/");
		strcat(dev_rbuf, db->d_name);
		if (stat(dev_rbuf, &tsb) < 0)
			continue;
		if ((tsb.st_mode & S_IFMT) == S_IFDIR)
		{
			strcpy(tmp_dev_rbuf, dev_rbuf);
			/* recursive call for sub-directories */
			if (devname(devnm, tmp_dev_rbuf))
				return(1);
			else	continue;
		}
		if (tsb.st_rdev == devnm)
		{
			closedir(df);
			return(1);
		}
	}
	closedir(df);
	return(0);
}/*--------------------------------------------------------------------------*/
get_iopm_name(phys)
long	phys;
{
	queue_t  *qnext, *q_previous;

	if (!(strm.sd_flag & REMOTE))
		return(0);		/* don't bother to look for IOPM link */

	qnext = strm.sd_wrq;		/* start at stream head in PM */
	/* troll down queue list to end of PM */
	while (qnext != NULL)
	{
		readbuf(-1, qnext, phys,-1, &que, sizeof que, "queue slot");
		q_previous = qnext;
		qnext = que.q_next;
	}
	/* ----------------- move to IOPM ----------------- */
	/* get iopm ctl struct info */
	readbuf(-1,que.q_ptr,phys,-1,&iopmctl,sizeof iopmctl,"iopmctl");

	mach_slot = iopmctl.ic_iopmslot;
	if ((mach_slot & 0xf) == 0xf)
		sprintf(slot_name,"%d",    mach_slot >> 4);
	else	sprintf(slot_name,"%d.%d", mach_slot >> 4, mach_slot & 0xf);
	sprintf(dev_slot_name,"/dev/iopm/iopm%s",slot_name);
	return(1);
}/*--------------------------------------------------------------------------*/
/*
 *	find the stream containing the specified queue
 *
 *	return	stream slot number if found
 *		-1 otherwise
 */
trace_iopm_back(qnum, phys)
int	qnum;
long	phys;
{
	int	nqueue;
	int	slot;
	long	queuep, offset;
	queue_t  *qnext, *q_prev;

	if (!talking_to_pm)		/* first queue is on iopm */
	{
		iopstreaminit();
		if (qnum >= icp->nqueue)
			error("Queue table entry out of range\n");
		qnext = icp->queuep + qnum;
		readiop(qnext, &que, sizeof que);
		if (!(que.q_flag & QUSE))
			return(-1);		/* queue not in use */
		/* if the selected queue is a write queue, get read side */
		if (!(que.q_flag & QREADR))
		{
			qnext -= 1;
			readiop(qnext, &que, sizeof que);
		}
		while (qnext != NULL)
		{
			readiop(qnext, &que, sizeof que);
			qnext = que.q_next;
		}
		readbuf(-1,que.q_ptr,phys,-1,&iopmctl,sizeof iopmctl,"iopmctl");
		qnext = iopmctl.ic_krq;		/* cross over to PM */
		qnum = getslot(qnext,Queue->n_value,sizeof que,
						phys, vbuf.v_nqueue);
	}
	streaminit();
	if (qnum >= vbuf.v_nqueue)
		error("Queue table entry out of range\n");
	qnext = (queue_t *)(Queue->n_value) + qnum;
	readbuf(-1, qnext, phys,-1, &que, sizeof que, "queue slot");
	if (!(que.q_flag & QUSE))
		return(-1);		/* queue not in use */
	if (!(que.q_flag & QREADR))
		qnext -= 1;
	while (qnext != NULL)
	{
		readbuf(-1, qnext, phys,-1, &que, sizeof que, "queue slot");
		q_prev = qnext;
		qnext = que.q_next;
	}
	/* we are now at the stream head. Get the write queue address of
	 * this stream and look for a matching strm.sd_wrq
	 */
	qnext = q_prev + 1;
	/* normally q_ptr points to stream head structure */
	slot = getslot(que.q_ptr, Streams->n_value, sizeof strm,
						phys, vbuf.v_nstream);
	if (slot != -1)
		return(slot);
		/* not a normal stream, so see if any stream slot points here */
	for (slot = 0; slot < vbuf.v_nstream; slot++)
	{
		offset = (long)(Streams->n_value + slot*sizeof strm);
		readbuf(-1, offset, phys, -1, &strm, sizeof strm,"streams table slot");
		if (strm.sd_wrq == qnext)
			return(slot);
	}
	return(-1);		/* no match, don't know what stream this is */
}/*--------------------------------------------------------------------------*/
/*
 *	'findaddr' and 'findslot' for iopm
 *
 *--------------------------------------------------------------------------*/
struct iop_nametab
{
	char *name;
	char *symbol;
};
struct iop_nametab iop_nametab[] = {
	"datab","dblock",
	"dblk","dblock",
	"dblock","dblock",
	"mblk","mblock",
	"mblock","mblock",
	"msgb","mblock",
	"queue","queue",
	NULL, NULL,
};	
struct size_iop_netable
{
	char *symbol;
	unsigned size;
	int *addr;
};
struct size_iop_netable siz_iop_ntab[] = {
	"dblock",sizeof (struct datab),	(int *)&Iopcomm.dblkp,
	"mblock",sizeof (struct msgb),	(int *)&Iopcomm.mblkp,
	"queue",sizeof (struct iqueue),	(int *)&Iopcomm.queuep,
	NULL, NULL, NULL,
};	

/* get iopm symbol name and size */
int
get_iop_netsym(name,slot)
char *name;
int slot;
{
	struct iop_nametab *sn;
	struct size_iop_netable *st;
	unsigned long addr;
	int found = 0;

	readiopcomm();
	for (sn = iop_nametab; sn->name != NULL; sn++) 
	{
		if (!(strcmp(sn->name,name)))
		{
			found++;
			break;
		}
	}
	if (found == 0)
		error("no match for %s on %s\n",name, dev_slot_name);
	for (st = siz_iop_ntab; st->symbol; st++) 
	{
		if (!(strcmp(st->symbol,sn->symbol)))
		{
			addr = *(st->addr);
			fprintf(fp,"%8x\n",(char *)addr + (st->size * slot));
			return;
		}
	}
	error("no match for %s in sizetable\n",name);
}/*--------------------------------------------------------------------------*/
/* print iopm slot */
prfind_iop_slot(addr)
long addr;
{
	struct size_iop_netable *st;
	struct size_iop_netable *save;
	unsigned long value, tmp_value;
	int slot, offset;

	value = 0;
	save = NULL;
	readiopcomm();
	for (st = siz_iop_ntab; st->symbol; st++) 
	{
		tmp_value = (unsigned long)*(st->addr);
		if (tmp_value <= addr && tmp_value > value)
		{
			value = tmp_value;
			save = st;
		}
	}
	if (save != NULL)
	{
		slot = (addr - value)/save->size;
		offset = (addr - value)%save->size;
		fprintf(fp,"%s",save->symbol);
		fprintf(fp,", slot %d, offset %d\n",slot,offset);
	}
}/*--------------------------------------------------------------------------*/
