/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) proc.c: version 25.1 created on 12/2/91 at 14:04:44	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)proc.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*	ATT:#ident	"crash-3b2:proc.c	1.15.6.3"	*/
/*	ATT:#ident	"crash-3b2:proc.c	1.15"	*/
/*	kd1 2/17/88 the ublock was being accessed incorrectly	*/
	
#ident	"@(#)crash:proc.c	25.1"

/*
 * This file contains code for the crash functions:  proc, defproc.
 */

#include "sys/param.h"
#include "a.out.h"
#include "stdio.h"
#include "signal.h"
#include "time.h"
#include "sys/sysmacros.h"
#include "sys/types.h"
#include "sys/immu.h"
#include "sys/user.h"
#include "sys/var.h"
#include "sys/region.h"
#include "sys/proc.h"
#include "sys/iopmcomm.h"
#include "sys/iopm/sys/tcb.h"
#include "crash.h"

#define min(a,b) (a>b ? b:a)

extern struct user *ubp;		/* pointer to the ublock */
extern struct syment *Proc,*Curproc,*Region;	/* namelist symbol pointers */
static struct syment *Pregpp;

extern talking_to_pm;
extern struct iopm_comm  Iopcomm;

static char *tcb_heading =
  "SLOT ST   PID  PGRP  SESS   UID PRI     EVENT  NAME\n";

/* get arguments for proc function */
int
getproc()
{
	int slot = Procslot;
	int all = 0;
	int full = 0;
	int phys = 0;
	int run = 0;
	long addr = -1;
	long arg1 = -1;
	long arg2 = -1;
	int id = -1;
	int c;
	char *heading =
	  "SLOT ST  PID  PPID  PGRP   UID PRI CPU   EVENT  NAME     FLAGS\n";
	uint maxentries;

	talking_to_pm = TRUE;
	if(!Pregpp)
		if(!(Pregpp = symsrch("pregpp")))
			error("pregpp not found in symbol table\n");
	if(!Region)
		if(!(Region = symsrch("region")))
			error("region not found in symbol table\n");

	optind = 1;
	while((c = getopt(argcnt,args,"h:efprw:")) !=EOF) {
		switch(c) {
			case 'h' :	if ( !get_mach_slot() )
						return;
					break;
			case 'e' :	all = 1;
					break;
			case 'f' :	full = 1;
					break;
			case 'w' :	redirect();
					break;
			case 'r' :	run = 1;
					break;
			case 'p' :	phys = 1;
					break;
			default  :	longjmp(syn,0);
		}
	}

	if ( talking_to_pm )
	{
		maxentries = vbuf.v_proc;
		fprintf(fp,"PROC TABLE SIZE = %d\n",maxentries);
	}
	else
	{
		readiopcomm();
		maxentries = Iopcomm.numtcb;
		fprintf(fp,"NUMBER OF TCB'S = %d\n", maxentries);
	}

	if(!full)
		if ( talking_to_pm )
			fprintf(fp,"%s",heading);
		else
			fprintf(fp, "%s", tcb_heading);

	if(args[optind]) {
		all = 1;
		do {
			if(*args[optind] == '#') {
				if((id = strcon(++args[optind],'d')) == -1)
					error("\n");
				if ( talking_to_pm )
					prproc(all,full,slot,id,phys,run,addr,
					  heading);
				else
					prtcb(all, full, slot, id, run, addr);
			}
			else {
				getargs(maxentries,&arg1,&arg2);
				if(arg1 == -1) 
					continue;
				if(arg2 != -1)
					for(slot = arg1; slot <= arg2; slot++)
						if ( talking_to_pm )
							prproc(all,full,slot,id,
							 phys,run,addr,heading);
						else
							prtcb(all, full, slot,
							  id, run, addr);
				else {
				  if(arg1 < maxentries)
				    {slot = arg1;
					if ( talking_to_pm )
						prproc(all,full,slot,id,phys,
						  run,addr,heading) ;
					else
						prtcb(all, full, slot, id, run,
						  addr);
				     }
				   else
				     { fprintf(fp,
					"Process table entry out of range\n"); 
					return;
				     }
				}
			    }
			id = slot = addr = arg1 = arg2 = -1;
		}while(args[++optind]);
	}
	else for(slot = 0; slot < maxentries; slot++)
		if ( talking_to_pm )
			prproc(all,full,slot,id,phys,run,addr,heading);
		else
			prtcb(all, full, slot, id, run, addr);
}

/* print proc table */
int
prproc(all,full,slot,id,phys,run,addr,heading)
int all,full,slot,id,phys,run;
long addr;
char *heading;
{
	char ch,*typ;
	char cp[DIRSIZ+1];
	struct proc procbuf;
	struct pregion pregbuf;
	int i,j,cnt,pregpp,regslot;
	long pslot_va;
	extern long lseek();

	if(id != -1) {
		for(slot = 0; slot < vbuf.v_proc; slot++) {
			readmem((long)(Proc->n_value+slot*sizeof procbuf),1,
				slot,(char *)&procbuf,sizeof procbuf,
					"proc table");
				if(procbuf.p_pid == id) 
					break;
		}
		if(slot == vbuf.v_proc) {
			fprintf(fp,"%d not valid process id\n",id);
			return;
		}
	}
	else readbuf(addr,(long)(Proc->n_value+slot*sizeof procbuf),phys,-1,
		(char *)&procbuf,sizeof procbuf,"proc table");

	if(!procbuf.p_stat && !all)
		return;
	if(run)
		if(!(procbuf.p_stat == SRUN || procbuf.p_stat == SONPROC))
			return;
	if(addr > -1) 
		slot = getslot(addr,(long)Proc->n_value,sizeof procbuf,
		  phys,vbuf.v_proc);
	if(full)
		fprintf(fp,"%s",heading);
	switch(procbuf.p_stat) {
	case NULL:   ch = ' '; break;
	case SSLEEP: ch = 's'; break;
	case SRUN:   ch = 'r'; break;
	case SIDL:   ch = 'i'; break;
	case SZOMB:  ch = 'z'; break;
	case SSTOP:  ch = 't'; break;
	case SONPROC:  ch = 'p'; break;
	case SXBRK:  ch = 'x'; break;
	default:     ch = '?'; break;
	}
	if(slot == -1)
		fprintf(fp," - ");
	else fprintf(fp,"%4d",slot);
	fprintf(fp," %c %5u %5u %5u %5u  %2u %3u",
		ch,
		procbuf.p_pid,
		procbuf.p_ppid,
		procbuf.p_pgrp,
		procbuf.p_uid,
		procbuf.p_pri,
		procbuf.p_cpu);
	if(procbuf.p_stat == SONPROC)
		fprintf(fp,"          ");
	else fprintf(fp," %08lx ",procbuf.p_wchan);

	if(procbuf.p_stat == SZOMB)
		strcpy(cp,"zombie");
	else {
		getublock(slot); /*kd1*/
		strcpy(cp,ubp->u_comm);
	}

	for(i = 0; i < 8 && cp[i]; i++) {
		if(cp[i] < 040 || cp[i] > 0176) {
			strcpy(cp,"unprint");
			break;
		}
	}
	fprintf(fp,"%-8s", cp);
	fprintf(fp,"%s%s%s%s%s%s%s%s%s%s\n",
		procbuf.p_flag & SLOAD ? " load" : "",
		procbuf.p_flag & SSYS ? " sys" : "",
		procbuf.p_flag & SLOCK ? " lock" : "",
		procbuf.p_flag & STRC ? " trc" : "",
 		procbuf.p_flag & SWTED ? " wted" : "",
 		procbuf.p_flag & SNWAKE ? " nwak" : "",
 		procbuf.p_flag & SRSIG ? " rsig" : "",
 		procbuf.p_flag & SPOLL ? " poll" : "",
 		procbuf.p_flag & SNOSTOP ? " nstp" : "",
 		procbuf.p_flag & SPTRX ? " ptrx" : "");
	if(!full)
		return;
 	fprintf(fp,"\ttime: %d, nice: %d, exit %d\n",
		procbuf.p_time,
		procbuf.p_nice,  
		procbuf.p_xstat);  
	fprintf(fp,"\tsig: %x, cursig: %d, clktim: %d, suid: %d, sgid: %d, psize: %d\n",
		procbuf.p_sig,
		procbuf.p_cursig,
		procbuf.p_clktim,
		procbuf.p_suid,
		procbuf.p_sgid,
		procbuf.p_size);
	fprintf(fp,"\tparent: %x\tchild: %x\tsibling: %x\n",
		procbuf.p_parent,
		procbuf.p_child,
		procbuf.p_sibling);
	if(procbuf.p_link)
		fprintf(fp,"\tflink: %d",
		((unsigned)procbuf.p_link - Proc->n_value) /sizeof (procbuf));
	if(procbuf.p_mlink)
		fprintf(fp,"\tmlink: %d\n",
		((unsigned)procbuf.p_mlink - Proc->n_value) /sizeof (procbuf));
	fprintf(fp,"\tutime: %ld\tstime: %ld\n",
		procbuf.p_utime,procbuf.p_stime);
#ifdef B3b
	fprintf(fp, "\tubptbl:  ");
	for(i = 0,j = 1;  i < USIZE + 7  ;  i++) 
		if(*(int *)&procbuf.p_ubptbl[i] != 0) {
			if(!(j++ & 3))
				fprintf(fp,"\n\t");
			fprintf(fp,"%d: %8x   ",i,procbuf.p_ubptbl[i]);
		}	
#endif
#if m68k | M68020
	fprintf(fp, "\taddr:  ");
	if(*(int *)&procbuf.p_userp != 0)
			fprintf(fp,"%8x   ",procbuf.p_userp);
#endif
	fprintf(fp,"\n\tepid: %d, sysid: %x, minwd: %x, rlink: %x\n",
		procbuf.p_epid,
		procbuf.p_sysid,
		procbuf.p_minwd,
		procbuf.p_rlink);
	fprintf(fp," mpgneed: %d\n",procbuf.p_mpgneed);
	fprintf(fp,"\thold: %x, chold: %x\n",
		procbuf.p_hold,
		procbuf.p_chold);
	fprintf(fp,"\twhystop: %d, whatstop: %d\n",
		procbuf.p_whystop, procbuf.p_whatstop);

	/* locate and print per process region table */

	readmem((long)Pregpp->n_value,1,slot,(char *)&pregpp,
		sizeof pregpp,"pregpp");

	fprintf(fp,"\tpreg reg#   regva  type  flags\n");
	for( i = 0; i < pregpp; i++) {
	readmem((long)(procbuf.p_region+i),1,slot,
		(char *)&pregbuf,sizeof pregbuf,"pregion table");

		if(!pregbuf.p_reg) 
			break;
		fprintf(fp,"\t%4d ",i);
		regslot = ((long)pregbuf.p_reg-Region->n_value)/
			sizeof(struct region);
		if((regslot >= 0) && (regslot < vbuf.v_region))
			fprintf(fp,"%4d ",regslot);
		else fprintf(fp,"  -  ");
		fprintf(fp,"%8x ",pregbuf.p_regva);
		switch(pregbuf.p_type) {
			case PT_UNUSED: typ = "unusd"; break;
			case PT_TEXT: typ = "text"; break;
			case PT_DATA: typ = "data"; break;
			case PT_STACK: typ = "stack"; break;
			case PT_SHMEM: typ = "shmem"; break;
			case PT_DMM: typ = "dmm"; break;
			case PT_LIBTXT: typ = "lbtxt"; break;
			case PT_LIBDAT: typ = "lbdat"; break;
			default: typ = ""; break;
		}
		fprintf(fp,"%5s ",typ);
		fprintf(fp,"%s\n",
			pregbuf.p_flags & PF_RDONLY ? "rdonly" : "");
	}
	fprintf(fp,"\n");
}

prtcb(all, full, slot, id, run, addr)
{
	struct tcb  tcb;
	struct tcb  *tcbp = Iopcomm.tcbarray;
	uint        numtcb = Iopcomm.numtcb;
	uint        procslot;
	struct proc procbuf;
	char        cp[DIRSIZ+1];
	int         i;

	if(id != -1) {
		for(slot = 0; slot < numtcb; slot++) {
			readiop(tcbp + slot, &tcb, sizeof tcb);
				if(tcb.p_pid == id) 
					break;
		}
		if(slot == numtcb) {
			fprintf(fp,"%d not valid process id\n",id);
			return;
		}
	}
	else readiop(tcbp + slot, &tcb, sizeof tcb);

	if ( !tcb.tcb_flags && !all )
		return;

	if ( run )
		if ( !(tcb.tcb_flags == T_RUNQ || tcb.tcb_flags == T_CURRENT) )
			return;

	if ( addr != -1 )
		slot = getslot(addr, tcbp, sizeof tcb, 0, numtcb);

	if ( full )
		fprintf(fp, "%s", tcb_heading);

	if ( slot == -1 )
		fprintf(fp, "  - ");
	else
		fprintf(fp, "%4d", slot);

	switch ( tcb.tcb_flags )
	{
	    case T_CURRENT:
		fprintf(fp, "  p ");
		break;
	    case T_RUNQ:
		fprintf(fp, "  r ");
		break;
	    case T_SLEEPQ:
		fprintf(fp, "  s ");
		break;
	    default:
		fprintf(fp, "  ? ");
		break;
	}

	if ( tcb.p_pid )
		fprintf(fp, "%5u %5u %5u %5u  ",
		  tcb.p_pid, tcb.p_pgrp, tcb.p_session_id, tcb.u_uid);
	else
		fprintf(fp, "   -     -     -     -   ");

	fprintf(fp, "%2u", tcb.tcb_pri);

	if ( tcb.tcb_flags == T_CURRENT)
		fprintf(fp, "           ");
	else
		fprintf(fp, "  %08lx ", tcb.tcb_wchan);

	if ( tcb.p_pid )
	{
		for ( procslot = 0; procslot < vbuf.v_proc; procslot++ )
		{
			readmem(
			  (long)(Proc->n_value + procslot * sizeof procbuf), 1,
			  procslot, (char *)&procbuf, sizeof procbuf,
			  "proc table");
			if ( procbuf.p_pid == tcb.p_pid ) 
				break;
		}
		if ( procslot == vbuf.v_proc )
		{
			fprintf(fp,"%d not valid process id\n",id);
			return;
		}

		getublock(procslot);
		strcpy(cp,ubp->u_comm);

		for ( i = 0; i < 8 && cp[i]; i++ )
		{
			if ( cp[i] < 040 || cp[i] > 0176 )
			{
				strcpy(cp, "unprint");
				break;
			}
		}
		fprintf(fp, "%-8s\n", cp);
	}
	else
		fprintf(fp, "\n");

	if ( !full )
		return;

	fprintf(fp, "signal %d,  u_gid %d,  u_ruid %d,  u_rgid %d\n",
	 tcb.tcb_sig, tcb.u_gid, tcb.u_ruid, tcb.u_rgid);

	fprintf(fp, "u_error %d,  u_rval 0x%08lx, u_ttyp 0x%08lx\n",
	 tcb.u_error, tcb.u_rval, tcb.u_ttyp);

	fprintf(fp, "tcb @ %08lx,  kbp %08lx,  ", tcbp + slot, tcb.u_kbp);
	if ( tcb.tcb_flags != T_CURRENT )
		fprintf(fp, "sp %08lx,  ", tcb.tcb_rsav[SP]);
	else
		fprintf(fp, "sp  RUNNING,  ");
	i = getslot(tcb.tcb_link, tcbp, sizeof tcb, 0, numtcb);
	if ( i != -1 )
		fprintf(fp, "link %d\n\n", i);
	else
		fprintf(fp, "link -\n\n");
}

/* get arguments for defproc function */
int
getdefproc()
{
	int c;
	int proc = -1;
	int reset = 0;

	optind = 1;
	while((c = getopt(argcnt,args,"cw:")) !=EOF) {
		switch(c) {
			case 'w' :	redirect();
					break;
			case 'c' :	reset = 1;
					break;
			default  :	longjmp(syn,0);
		}
	}
	if(args[optind]) 
		if((proc = strcon(args[optind],'d')) == -1)
			error("\n");
	prdefproc(proc,reset);
}

/* print results of defproc function */
int
prdefproc(proc,reset)
int proc,reset;
{

	if(reset)
		Procslot = getcurproc();
	else if(proc > -1) {
		if((proc > vbuf.v_proc) || (proc < 0))
			error("%d out of range\n",proc);
		Procslot = proc;
	}
	fprintf(fp,"Procslot = %d\n",Procslot);
}
