/*							*/
/*	@(#) main.c: version 1.1 created on 4/17/90 at 19:16:26	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)main.c	1.1	4/17/90 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*	ATT:#ident	"crash-3b2:main.c	1.18.2.2"	*/
/*	ATT:#ident	"crash-3b2:main.c	1.18"	*/
	
#ident	"@(#)crash:main.c	1.1"

/*
 * This file contains code for the crash functions:  ?, help, redirect,
 * and quit, as well as the command interpreter.
 *
 * 03-30-90 - gil hunt - added 'new' command to describe new features
 */

#include "sys/param.h"
#include "a.out.h"
#include "stdio.h"
#include "signal.h"
#include "sys/types.h"
#include "sys/var.h"
#include "sys/immu.h"
#include "sys/user.h"
#include "setjmp.h"
#include "crash.h"

#define NARGS 25		/* number of arguments to one function */
#define LINESIZE 256		/* size of function input line */

int mem;			/* file descriptor for dump file for upage */
int kmem;			/* file descriptor for dump file */
char *namelist = "/arix";
char *dumpfile = "/dev/mem";
char *kdumpfile = "/dev/kmem";
struct user *ubp;			/* pointer to ublock buffer */
FILE *fp;				/* output file pointer */
FILE *rp;				/* redirect file pointer */
int opipe = 0;				/* open pipe flag */
struct var vbuf;			/* var structure buffer */
int Procslot;				/* current process slot */
int Virtmode = 1;			/* virtual or physical mode flag*/
long pipesig;				/* pipe signal catch */

/* namelist symbol pointers */
struct syment *File,*Inode,*Mount,*Proc,*V,*Panic,
	*Curproc,*Streams, *Rcvd, *Nrcvd, *Sndd, *Nsndd; 

short N_TEXT;		/* used in symtab.c */
short N_DATA;		/* used in symtab.c */
short N_BSS;		/* used in symtab.c */
int active;	/* Flag set if crash is examining an active system */
jmp_buf	jmp,syn;	/* labels for jump */
void exit();


/* function calls */
extern int getadv(),getbufhdr(),getbuffer(),getcallout(),getdblock(),getdis();
	getgdp(),getinode(),getlcks(),getpfdat(),getdblk(),
	getmap(),getmess(),getmount(),getnm(),getod(),getpcb(),
	getproc(),getqrun(),getqueue(),getquit(),getrcvd(),getpdt(),
	getregion(),getsndd(),getsrmount(),
	getstack(),getstream(),getstrstat(),gettrace(),getsymbol(),getnew();
	getuser(),getvar(),getvtop(),getfuncs(),getbase(),gethelp(),
	getsearch(),getdbfree(),getmbfree(),getsearch(),getfile(),getdefproc(),
	getmode(),getredirect(),getmajor(),getsize(),getfindslot(),
	getiopmstat(),
	getfindaddr(),getfs(),getlinkblk(),getdballoc(),getstat();
#ifdef B3b
extern getnvram(),getmmu(),getsrams(),getsdt(),getstat(),getkfp(),
#endif

/* function definition */
struct func {
	char *name;
	char *syntax;
	int (*call)();
	char *description;
};

/* function table */
/* entries with NA description fields should be removed in 3.1 */
struct func functab[] = {
	"adv","[-e] [-wfilename] [tbl_entry[s]]",
		getadv,"advertise table",
	"b"," ",getbuffer,"(buffer)",
	"base","[-wfilename] number[s]",
		getbase,"base conversions",
	"buf"," ",getbufhdr,"(bufhdr)",
	"buffer","[-w file] [-bcdxoir] [-t type] (bufferslot |[-p] st_addr)", 
		getbuffer,"buffer data",
	"bufhdr","[-f] [-h iopm_slot] [-wfilename] [-t type] [[-p] tbl_entry[s]]",
		getbufhdr,"buffer headers",
	"c"," ",getcallout,"(callout)",
	"callout","[-wfilename] [-h iopm_slot]",
		getcallout,"callout table",
	"dballoc","[-h iopm_slot] [-wfilename] [class[es]]",
		getdballoc,"dballoc table",
	"dbfree","[-h iopm_slot] [-wfilename] [class[es]]",
		getdbfree,"free data block headers",
	"dblock","[-h iopm_slot] [-e] [-wfilename] ([-c class[es] | [-p] tbl_entry[s]])",
		getdblk,"allocated stream data block headers",
	"defproc","[-wfilename] [-c | slot]",
		getdefproc,"set default process slot",
	"dis","[-wfilename] [-a] st_addr [count]",
		getdis,"disassembler",
	"ds","[-wfilename] virtual_address[es]",
		getsymbol,"data address namelist search",
	"f"," ",getfile,"(file)",
	"file","[-e] [-wfilename] [[-p] tbl_entry[s]]",
		getfile,"file table",
	"findaddr","[-h iopm_slot] [-wfilename] table slot",
		getfindaddr,"find address for given table and slot",
	"findslot","[-h iopm_slot] [-wfilename] virtual_address[es]",
		getfindslot,"find table and slot number for given address",
	"fs","[-wfilename] [[-p] tbl_entry[s]]",
		getfs,"file system information table",
	"gdp","[-e] [-f] [-wfilename] [[-p] tbl_entry[s]]",
		getgdp,"gdp structure",
	"help","[-wfilename] function[s]",
		gethelp,"help function",
	"i"," ",getinode,"(inode)",
	"inode","[-e] [-f] [-wfilename] [[-p] tbl_entry[s]]",
		getinode,"inode table",
	"iopmstat","-h iopm_slot",getiopmstat, "iopm usage statistics",
#ifdef B3b
	"kfp","[-wfilename] [-sprocess] [-r | value]",
		getkfp,"frame pointer for start of stack trace",
#endif
	"l"," ",getlcks,"(lck)",
	"lck","[-e] [-wfilename] [[-p] tbl_entry[s]]",
		getlcks,"record lock tables",
	"linkblk","[-e] [-wfilename] [[-p] tbl_entry[s]]",
		getlinkblk,"linkblk table",
	"m"," ",getmount,"(mount)",
#ifdef B3b
	"major","[-wfilename] [entry[ies]]",
		getmajor,"MAJOR table",
#endif
	"map","[-wfilename] mapname[s]",
		getmap,"map structures",
	"mbfree","[-h iopm_slot] [-wfilename]",
		getmbfree,"free message block headers",
	"mblock","[-a] [-c] [-d] [-h iopm_slot] [-e] [-wfilename] [[-p] tbl_entry[s]]",
		getmess,"allocated stream message block headers\n\t-a dumps all linked msgs blocks and data\n\t-c dumps current msg and data (plus all blks linked thru b_cont)\n\t-d dumps data for current msg block",
#ifdef B3b
	"mmu","[-wfilename]",
		getmmu,"mmu registers",
#endif
	"mode","[-wfilename] [v | p]",
		getmode,"address mode",
	"mount","[-e] [-wfilename] [[-p] tbl_entry[s]]",
		getmount,"mount table",
	"new","[-wfilename]",
		getnew,"describe new features",
	"nm","[-wfilename] symbol[s]",
		getnm,"name search",
#ifdef B3b
	"nvram","[-wfilename] fwnvr|unxnvr|systate|errlog",
		getnvram,"non-volatile RAM",
#endif
	"od","[-H iopm_slot] [-wfilename] [-c|-d|-x|-o|-a|-h] [-l|-t|-b]\n   [-sprocess] [-p] st_addr [count]",
		getod,"dump symbol values",
	"p"," ",getproc,"(proc)",
#ifdef B3b
	"pcb","[-wfilename] [[-u | -k] [process] | -i [-p] st_addr]",
		getpcb,"process control block",
#endif
	"pdt","[-e] [-wfilename] [-sprocess] (section segment|[-p] st_addr [count])",
		getpdt,"page descriptor tables",
	"pfdat","[-e] [-wfilename] [[-p] tbl_entry[s]]",
		getpfdat,"pfdat structure",
	"proc","[-e] [-h iopm_slot] [-f] [-wfilename] [([-p] tbl_entry | #procid)[s] | -r)]",
		getproc,"process table",
	"q"," ",getquit,"(quit)",
	"qrun","[-h iopm_slot] [-wfilename]",
		getqrun,"list of servicable stream queues",
	"queue","[-e] [-h iopm_slot] [-i] [-wfilename] [[-p] tbl_entry[s]]",
		getqueue,"allocated stream queues (-i shows info ptr instead of mod name)",
	"quit"," ",
		getquit,"exit",
	"rcvd","[-e] [-f] [-wfilename] [[-p] tbl_entry[s]]",
		getrcvd,"receive descriptor",
	"rd"," ",getod,"(od)",
	"redirect","[-wfilename] [-c | filename]",
		getredirect,"output redirection",
	"region","[-e] [-f] [-wfilename] [[-p] tbl_entry[s]]",
		getregion,"region table",
#ifdef B3b
	"regs"," ",getmmu,"(mmu)",
	"s"," ",getstack,"(stack)",
	"sdt","[-e] [-wfilename] [-sprocess] (section |[-p] st_addr [count])",
		getsdt,"segment descriptor table",
#endif
	"search","[-wfilename] [-mmask] [-sprocess] pattern [-p] st_addr length",
		getsearch,"memory search",
	"size","[-x] [-wfilename] structurename[s]",
		getsize,"symbol size",
	"sndd","[-e] [-wfilename] [[-p] tbl_entry[s]]",
		getsndd,"send descriptor",
#ifdef B3b
	"srams","[-wfilename]",
		getsrams,"srams",
#endif
	"srmount","[-e] [-wfilename] [[-p] tbl_entry[s]]",
		getsrmount,"server mount table",
#ifdef B3b
	"stack","[-wfilename] [[-u | -k] [process] | -i [-p] st_addr]",
		getstack,"stack dump",
#endif
	"stat","[-wfilename]",
		getstat,"dump statistics",
	"stream","[-a] [-e] [-f] [-d device name] [-s slot] [-wfilename]\n\t [-h iopm_slot] [-q queue slot number] [[-p] tbl_entry[s]]",
		getstream,"allocated stream table slots\n\tspecify device name input in the form  /dev/tty03\n\tspecify up to 8 stream slots and/or 8 device names\n\t-a dumps all streams\n\t-q shows the stream containing the specified queue slot\n\t-h specifies iopm slot if [-q] used and queue is on iopm",
	"strstat","[-h iopm_slot] [-wfilename]",
		getstrstat,"streams statistics",
#ifdef B3b
	"t"," ",gettrace,"(trace)",
	"trace","[-wfilename] [[-r] [process] | -i [-p] st_addr]",
		gettrace,"kernel stack trace",
#endif
	"ts","[-wfilename] virtual_address[es]",
		getsymbol,"text address namelist search",
	"u"," ",getuser,"(user)",
	"user","[-f] [-wfilename] [process]",
		getuser,"uarea",
	"v"," ",getvar,"(var)",
	"var","[-wfilename]",
		getvar,"system variables",
	"vtop","[-wfilename] [-sprocess] st_addr[s]",
		getvtop,"virtual to physical address",
	"?","[-wfilename]",
		getfuncs,"print list of available commands",
	"!cmd"," ",NULL,"escape to shell",
	"hdr"," ",getbufhdr,"NA",
	"files"," ",getfile,"NA",
	"mnt"," ",getmount,"NA",
	"dump"," ",getod,"NA",
	"ps"," ",getproc,"NA",
#ifdef B3b
	"fp"," ",getkfp,"NA",
	"r9"," ",getkfp,"NA",
	"k"," ",getstack,"NA",
	"kernel"," ",getstack,"NA",
	"stk"," ",getstack,"NA",
#endif
	"u_area"," ",getuser,"NA",
	"uarea"," ",getuser,"NA",
	"ublock"," ",getuser,"NA",
	"tunable"," ",getvar,"NA",
	"tunables"," ",getvar,"NA",
	"tune"," ",getvar,"NA",
	"calls"," ",getcallout,"NA",
	"call"," ",getcallout,"NA",
	"timeout"," ",getcallout,"NA",
	"time"," ",getcallout,"NA",
	"tout"," ",getcallout,"NA",
	"freelist"," ",getmess,"NA",
	NULL,NULL,NULL,NULL
};

char *args[NARGS];		/* argument array */
int argcnt;			/* argument count */
char outfile[100];		/* output file for redirection */
static int tabsize;		/* size of function table */

/* main program with call to functions */
main(argc,argv)
int argc;
char **argv;
{
	struct func *a,*f;
	int c,i,found;
	extern int opterr;
	int arglength;

	if(setjmp(jmp))
		exit(1);
	fp = stdout;
	strcpy(outfile,"stdout");
	optind = 1;		/* remove in next release */
	opterr = 0;		/* suppress getopt error messages */

	for(tabsize = 0,f = functab; f->name; f++,tabsize++) 
		if(!strcmp(f->description,"NA"))  /* remove in next release */
			break;

	while((c = getopt(argc,argv,"d:n:w:")) !=EOF) {
		switch(c) {
			case 'd' :	dumpfile = optarg;
				 	break;
			case 'n' : 	namelist = optarg;
					break;
			case 'w' : 	strncpy(outfile,optarg,ARGLEN);
					if(!(rp = fopen(outfile,"a")))
						fatal("unable to open %s\n",
							outfile);
					break;
			default  :	fatal("usage: crash [-d dumpfile] [-n namelist] [-w outfile]\n");
		}
	}
	/* backward compatible code */
	if(argv[optind]) {
		dumpfile = argv[optind++];
		if(argv[optind])
			namelist = argv[optind++];
		if(argv[optind])
			fatal("usage: crash [-d dumpfile] [-n namelist] [-w outfile]\n");
	}
	/* remove in next release */
	if(rp)
		fprintf(rp,"dumpfile = %s, namelist = %s, outfile = %s\n",dumpfile,namelist,outfile);
	fprintf(fp,"dumpfile = %s, namelist = %s, outfile = %s\n",kdumpfile,namelist,outfile);
	fprintf(fp,"type 'new' for new features, '?' for list of funtions, 'help' for details\n");
	init();

	setjmp(jmp);

	for(;;) {
		getcmd();
		if(argcnt == 0)
			continue;
		if(rp) {
			fp = rp;
			fprintf(fp,"\n> ");
			for(i = 0;i<argcnt;i++)
				fprintf(fp,"%s ",args[i]);
			fprintf(fp,"\n");
		}
		found = 0;
		for(f = functab; f->name; f++) 
			if(!strcmp(f->name,args[0])) {
				found = 1;
				break;
			}
		if(!found) {
			arglength = strlen(args[0]);
			for(f = functab; f->name; f++) {
				if(!strcmp(f->description,"NA")) 
					break;     /* remove in next release */
				if(!strncmp(f->name,args[0],arglength)) {
					found++;
					a = f;
				}
			}
			if(found) {
				if(found > 1)
					error("%s is an ambiguous function name\n",args[0]);
				else f = a;
			}	
			else 
				fprintf(fp,"huh?\n");
		}
		if(found) {
			if(!strcmp(f->description,"NA")) /* remove in next release */
				pralias(f);
			if(setjmp(syn)) {
				while(getopt(argcnt,args,"") != EOF);
				if(*f->syntax == ' ') {
					for(a = functab;a->name;a++)
						if((a->call == f->call) &&
						(*a->syntax != ' '))
							error("%s: usage: %s %s\n",f->name,f->name,a->syntax);
				}
				else error("%s: usage: %s %s\n",f->name,f->name,f->syntax);
			}
			else (*(f->call))();
		}
		else prerrmes(fp,"unrecognized function name\n");
		fflush(fp);
		resetfp();
	}
}

/* returns argcnt, and args contains all arguments */
int
getcmd()
{
	char *p;
	int i;
	static char line[LINESIZE+1];
	FILE *ofp;
	
	ofp = fp;
	printf("> ");
	fflush(stdout);
	if(fgets(line,LINESIZE,stdin) == NULL)
		exit(0);
	line[LINESIZE] = '\n';
	p = line;
	while(*p == ' ' || *p == '\t') {
		p++;
	}
	if(*p == '!') {
		system(p+1);
		argcnt = 0;
	}
	else {
		for(i = 0; i < NARGS; i++) {
			if(*p == '\n') {
				*p = '\0';
				break;
			}
			while(*p == ' ' || *p == '\t')
				p++;
			args[i] = p;
			if(strlen(args[i]) == 1)
				break;
			if(*p == '!') {
				p = args[i];
				if(strlen(++args[i]) == 1)
					error("no shell command after '!'\n");
				pipesig = (long)signal(SIGPIPE,SIG_IGN);
				if((fp = popen(++p,"w")) == NULL) {
					fp = ofp;
					error("cannot open pipe\n");
				}
				if(rp != NULL)
					error("cannot use pipe with redirected output\n");
				opipe = 1;
				break;
			}
			if(*p == '(')
				while((*p != ')') && (*p != '\n'))
					p++;
			while(*p != ' ' && *p != '\n')
				p++;
			if(*p == ' ' || *p == '\t')
				*p++ = '\0';
		}
		args[i] = NULL;
		argcnt = i;
	}
}


/* get arguments for ? function */
int
getfuncs()
{
	int c;

	while((c = getopt(argcnt,args,"w:")) !=EOF) {
		switch(c) {
			case 'w' :	redirect();
					break;
			default  :	longjmp(syn,0);
		}
	}
	prfuncs();
}

/* print all function names in columns */
int
prfuncs()
{
	int i,j,len;
	struct func *ff;
	char tempbuf[20];

	len = (tabsize + 3) / 4;
	for(i = 0; i < len; i++) {
		ff = functab + i;
		for(j = 0; j < 4; j++) {
			if(*ff->description != '(')
				fprintf(fp,"%-15s",ff->name);
			else {
				tempbuf[0] = 0;
				strcat(tempbuf,ff->name);
				strcat(tempbuf," ");
				strcat(tempbuf,ff->description);
				fprintf(fp,"%-15s",tempbuf);
			}
			ff += len;
			if((ff - functab) >= tabsize)
				break;
		}
		fprintf(fp,"\n");
	}
	fprintf(fp,"\n");
}

getnew()
{
	int c;

	while((c = getopt(argcnt,args,"w:")) !=EOF)
	{
		switch(c)
		{
		case 'w' :	redirect();
				break;
		default  :	longjmp(syn,0);
		}
	}
	fprintf(fp,"The following new streams-related features have been added to 'crash':\n");
	fprintf(fp,"1. IOP slot number:\n");
	fprintf(fp,"   Where applicable, information can be obtained from an IOP by specifying\n   the hardware slot via the '-[-h iopm_slot]' option (e.g. -h4 or -h9.3)\n");
	fprintf(fp,"   Also, the [-h iopm_slot] option can be used with:\n");
	fprintf(fp,"   - 'od' (dump memory) (e.g. od -x -H4 f8000000 4)");
	fprintf(fp," (use '-H' since\n\t\t\t\t'-h' is already used form somethine else)\n");
	fprintf(fp,"   - 'findaddr' (only understands 'mblock', 'dblock', and 'qaueue'\n");
	fprintf(fp,"   - 'findslot' (only understands 'mblock', 'dblock', and 'qaueue'\n");
	fprintf(fp,"\n");
	fprintf(fp,"2. 'streams' command additions:\n");
	fprintf(fp,"   - 'stream -a'\tdisplay complete path for all streams\n");
	fprintf(fp,"   - 'stream -d device'\tdisplay complete path for device (stream -d /dev/tty03)\n");
	fprintf(fp,"   - 'stream -s stream'\tdisplay complete path for a stream slot\n");
	fprintf(fp,"   - 'stream -q queue'\tdisplay stream which contains specified queue slot\n");
	fprintf(fp,"   - 'stream -q queue -h iopm_slot' display path which contains IOP queue\n");
	fprintf(fp,"\n");
	fprintf(fp,"3. 'mblock' command additions:\n");
	fprintf(fp,"   - 'mblock -a <msg slot>'\tshow message and all msgs linked by 'b_next'\n");
	fprintf(fp,"   - 'mblock -c <msg slot>'\tshow message and all blocks linked by 'b_cont'\n");
	fprintf(fp,"   - 'mblock -d <msg slot>'\tshow message\n");
	fprintf(fp,"   NOTE: the '-a', '-c', and '-d' option cause the contents of the attached\n         data block to be displayed, from b_rptr through b_wptr\n");
}
/* get arguments for help function */
int
gethelp()
{
	int c;

	optind = 1;
	while((c = getopt(argcnt,args,"w:")) !=EOF) {
		switch(c) {
			case 'w' :	redirect();
					break;
			default  :	longjmp(syn,0);
		}
	}
	if(args[optind]) {
		do {
			prhelp(args[optind++]);
		}while(args[optind]);
	}
	else prhelp("help");
}

/* print function information */
int
prhelp(string)
char *string;
{
	int found = 0;
	struct func *ff,*a,*aa;

	for(ff=functab;ff->name;ff++) {
		if(!strcmp(ff->name,string)){
			found = 1;
			break;
		}
	}
	if(!found)
		error("%s does not match in function list\n",string);
	if(!strcmp(ff->description,"NA"))  /* remove in next release */
		pralias(ff);
	if(*ff->description == '(') {
		for(a = functab;a->name != NULL;a++)
			if((a->call == ff->call) && (*a->description != '('))
					break;
		fprintf(fp,"%s %s\n",ff->name,a->syntax);
		if(findstring(a->syntax,"iopm_slot"))
			fprintf(fp,"\tiopm_slot = hardware slot number of iopm (e.g., 5 or 9.12)\n");
		if(findstring(a->syntax,"tbl_entry"))
			fprintf(fp,"\ttbl_entry = slot number | address | symbol | expression | range\n");
		if(findstring(a->syntax,"st_addr"))
			fprintf(fp,"\tst_addr = address | symbol | expression\n");
		fprintf(fp,"%s\n",a->description);
	}
	else {
		fprintf(fp,"%s %s\n",ff->name,ff->syntax);
		if(findstring(ff->syntax,"iopm_slot"))
			fprintf(fp,"\tiopm_slot = hardware slot number of iopm (e.g., 5 or 9.12)\n");
		if(findstring(ff->syntax,"tbl_entry"))
			fprintf(fp,"\ttbl_entry = slot number | address | symbol | expression | range\n");
		if(findstring(ff->syntax,"st_addr"))
			fprintf(fp,"\tst_addr = address | symbol | expression\n");
		fprintf(fp,"%s\n",ff->description);
	}
	fprintf(fp,"alias: ");
	for(aa = functab;aa->name != NULL;aa++)
		if((aa->call == ff->call) && (strcmp(aa->name,ff->name)) &&
			strcmp(aa->description,"NA"))
				fprintf(fp,"%s ",aa->name);
	fprintf(fp,"\n");
	fprintf(fp,"\tacceptable aliases are uniquely identifiable initial substrings\n");
}

/* find tbl_entry or st_addr in syntax string */
int
findstring(syntax,substring)
char *syntax;
char *substring;
{
	char string[256];
	char *token;

	strcpy(string,syntax);
	token = strtok(string,"[] ");
	while(token) {
		if(!strcmp(token,substring))
			return(1);
		token = strtok(NULL,"[] ");
	}
	return(0);
}

/* this function and all obsolete aliases should be removed in 3.1 */
/* print valid function names for obsolete aliases */
int
pralias(ff)
struct func *ff;
{
	struct func *a;

	fprintf(fp,"Valid calls to this function are:  ");
	for(a = functab;a->name;a++)
		if((a->call == ff->call) && (strcmp(a->name,ff->name)) &&
			(strcmp(a->description,"NA")))
				fprintf(fp,"%s ",a->name);
	error("\nThe alias %s is not supported on this processor\n",
		ff->name);
}


/* terminate crash session */
int
getquit()
{
	if(rp)
		fclose(rp);
	exit(0);
}

/* get arguments for redirect function */
int
getredirect()
{
	int c;
	int close = 0;

	optind = 1;
	while((c = getopt(argcnt,args,"w:c")) !=EOF) {
		switch(c) {
			case 'w' :	redirect();
					break;
			case 'c' :	close = 1;
					break;
			default  :	longjmp(syn,0);
		}
	}
	if(args[optind]) 
		prredirect(args[optind],close);
	else prredirect(NULL,close);
}

/* print results of redirect function */
int
prredirect(string,close)
char *string;
int close;
{
	if(close)
		if(rp) {
			fclose(rp);
			rp = NULL;
			strcpy(outfile,"stdout");
			fp = stdout;
		}
	if(string) {
		if(rp) {
			fclose(rp);
			rp = NULL;
		}
		if(!(rp = fopen(string,"a")))
			error("unable to open %s\n",string);
		fp = rp;
		strncpy(outfile,string,ARGLEN);
	}
	fprintf(fp,"outfile = %s\n",outfile);
	if(rp)
		fprintf(stdout,"outfile = %s\n",outfile);
}
