/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) init.c: version 25.1 created on 12/2/91 at 14:03:23	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)init.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*	ATT:#ident	"crash-3b2:init.c	1.7"	*/
	
#ident	"@(#)crash:init.c	25.1"

/*
 * This file contains code for the crash initialization.
 */

#include "sys/param.h"
#include "a.out.h"
#include "signal.h"
#include "stdio.h"
#include "sys/types.h"
#include "sys/immu.h"
#include "sys/user.h"
#include "sys/var.h"
#ifdef S3000
#include "sys/own.h"   /* hh - need to find offset of o_curproc in own struct */
#endif
#include "crash.h"

int	nmlst_tstamp ,		/* timestamps for namelist and cdumpfiles */
	dmp_tstamp ;
extern char *strtbl ;		/* pointer to string table in symtab.c */
#ifdef B3b
extern struct fw_nvr fwnvram;	/* nvram buffers */
extern struct unx_nvr unxnvram;
extern struct xtra_nvr xtranvram;
#endif
extern char *dumpfile;		
extern char *kdumpfile;		
extern char *namelist;
extern char *mmusrama, *mmusramb;
extern char * sramapt[4];
#ifdef notdef
extern SRAMB srambpt[4];
#endif
extern int active;		/* flag for active system */
extern long vtop();
extern long lseek();
extern char *malloc();
struct syment *sp;		/* pointer to symbol table */
/* struct nvparams nvp;			structure for sys3b call  */
struct user *ubp;		/* pointer to ublock buffer */
long fltcrptr;			/* configuration registers */
long fltarptr;
long conrptr;
extern struct syment *File, *Proc, *Inode, *Mount, *V,
	*Panic, *Curproc;	/* namelist symbol pointers */
#ifdef S3000
own_t own;	/* hh - need to find offset of o_curproc in own struct */
#endif


/* initialize buffers, symbols, and global variables for crash session */
int
init()
{
	int offset ;
	struct syment	*ts_symb = NULL;
	extern void sigint();
	
	if((mem = open(dumpfile, 0)) < 0)	/* open dump file, if error print */
		fatal("cannot open dump file %s\n",dumpfile);

	if((kmem = open(kdumpfile, 0)) < 0)	/* open dump file, if error print */
		fatal("cannot open dump file %s\n",kdumpfile);
	/*
	 * Set a flag if the dumpfile is of an active system.
	 */
	if((strcmp(dumpfile,"/dev/mem")==0) || (strcmp(dumpfile,"/dev/kmem")==0))
		active = 1;
#ifdef B3b
	else {
		offset = 0x1000 /* SPMEM - MAINSTORE - CHDR_OFFSET */ ;
		if(lseek(mem,(long)offset, 0) == -1
		  || read(mem,(char *)(&crash_hdr),sizeof (crash_hdr)) !=
			 sizeof (crash_hdr)
		  || strcmp(crash_hdr.sanity,CRASHSANITY) != 0)
			active = 1;
	}

	/* go get the mmu info */
	offset += sizeof(crash_hdr) ;
	if(lseek( mem, (long)offset, 0) == -1)
		fatal("seek error on mmu information\n");;
#endif

	rdsymtab();			/* open and read the symbol table */

	/* timestamps are for crash dumps not active system */
	/* commented out
	if(nmlst_tstamp == 0 || !(ts_symb = symsrch("crash_sync")))
		fprintf(fp,"WARNING - could not find timestamps, timestamps not checked\n") ;
	else
	{
		if((lseek(kmem,vtop((long)ts_symb->n_value,-1),0) == -1)
		  || read(kmem, (char *)&dmp_tstamp,sizeof(int)) != sizeof(int))
			fatal("could not process dumpfile with supplied namelist %s\n",namelist) ;

		if(dmp_tstamp != nmlst_tstamp)
		{
			fprintf(fp,"WARNING - namelist and system image not of the same vintage\n") ;
			fprintf(fp,"          crash results unpredictable\n") ;
		}
	}
*/

	if(!(V = symsrch("v")))
		fatal("var structure not found in symbol table\n");
	if(!(Inode = symsrch("inode")))
		fatal("inode not found in symbol table\n");
	if(!(Proc = symsrch("proc")))
		fatal("proc not found in symbol table\n");
	if(!(File = symsrch("file")))
		fatal("file not found in symbol table\n");
	if(!(Mount = symsrch("mount")))
		fatal("mount not found in symbol table\n");
	if(!(Panic = symsrch("panicstr")))
		fatal("panicstr not found in symbol table\n");
#ifndef S3000	/* hh */
/* kelly - changed to work with mcm's kernel
	if(!(Curproc = symsrch("curproc")))
*/
	if(!(Curproc = symsrch("own_curproc")))
		fatal("curproc not found in symbol table\n");

#else 	/***hh**** changed for s3000 kernel. **/

	if(!(Curproc = symsrch("own"))) 	/* get addr of own structure  */
		fatal("own not found in symbol table\n");
	else					/* set to &own.o_curproc (hh) */
		Curproc->n_value += (uint)&own.o_curproc - (uint)&own;
#endif	/* ndef S3000 */


	readmem((long)V->n_value,1,-1,(char *)&vbuf,
		sizeof vbuf,"var structure");

	/* Allocate ublock buffer */
	ubp = (user_t*)malloc((unsigned)(sizeof(user_t) +
		sizeof(int)*vbuf.v_nofiles));

	Procslot = getcurproc();
	/* setup break signal handling */
	if(signal(SIGINT,sigint) == SIG_IGN)
		signal(SIGINT,SIG_IGN);
}

