#	START NEW ARIX SCCS HEADER
#
#	@(#) crash.mk: version 25.1 created on 12/2/91 at 14:03:11
#
#	Copyright (c) 1990 by Arix Corporation
#	All Rights Reserved
#
#	@(#)crash.mk	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation
#
#	END NEW ARIX SCCS HEADER
#
#	Copyright (c) 1984 AT&T
#	  All Rights Reserved

#	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T
#	The copyright notice above does not evidence any
#	actual or intended publication of such source code.
#	ATT:#ident	"crash-3b2:crash.mk	1.11"

#ident	"@(#)crash:crash.mk	25.1"

IROOT =
include $(IROOT)/macdefs

# Posix binary
SVID_FLAG=

INSDIR = $(ROOT)/etc
DFLAG = -DSTREAM

FPS=NOFPU
PROCESSOR=$(MACH)
DEFINES= -Dm68k -DFLEXNAMES -I. -D$(PROCESSOR) -DSDB -D$(FPS) -DDEBUG=4 -DSECURITY

COM = $(SROOT)/cmd/sdb/com	# copied head.h from sdb/com - hh
DISDIR = $(SROOT)/cmd/sgs/dis/mach
DISDIRP = $(DISDIR)/$(FAMILY)
DISINC = -I$(DISDIR) -I$(DISDIRP) -I$(SROOT)/cmd/sgs/inc

DIS.H=	$(DISDIR)/dis.h	$(DISDIRP)/names.h
DIS.C=	$(DISDIRP)/text_dis.c	$(DISDIRP)/names.c	$(DISDIRP)/881_gen.c \
	$(DISDIRP)/cp_gen.c	$(DISDIRP)/extended.c 
DIS.O=	text_dis.o names.o 881_gen.o cp_gen.o extended.o 

COM.H=$(COM)/head.h 

CFILES = \
	base.c init.c rfs.c stream.c var.c buf.c inode.c map.c search.c \
	symtab.c vtop.c callout.c mount.c size.c dis.c lck.c  \
	page.c sizenet.c  u.c fs.c main.c proc.c stat.c util.c 

FRC =

OFILES= \
	base.o init.o rfs.o stream.o var.o buf.o inode.o map.o search.o \
	symtab.o vtop.o callout.o mount.o size.o dis.o lck.o  \
	page.o sizenet.o  u.o fs.o main.o proc.o stat.o util.o 

all: crash 
	
crash:	$(OFILES) $(DIS.O)
	$(CC) $(DEFINES) $(CFLAGS) $(FFLAG) -o crash $(OFILES) $(DIS.O) $(LDFLAGS)

install: all
	$(INS) crash $(INSDIR)/crash
	chmod 755 $(INSDIR)/crash
	chgrp sys $(INSDIR)/crash
	chown root $(INSDIR)/crash


base.o: base.c
	$(CC) -c  $(CFLAGS) $(DFLAG) $*.c
buf.o: buf.c
	$(CC) -c  $(CFLAGS) $(DFLAG) $*.c
callout.o: callout.c
	$(CC) -c  $(CFLAGS) $(DFLAG) $*.c
dis.o: dis.c
	$(CC) -c  $(CFLAGS) $(DFLAG) $*.c
fs.o: fs.c
	$(CC) -c  $(CFLAGS) $(DFLAG) $*.c
init.o: init.c
	$(CC) -c  $(CFLAGS) $(DFLAG) $*.c
inode.o: inode.c
	$(CC) -c  $(CFLAGS) $(DFLAG) $*.c
lck.o: lck.c
	$(CC) -c  $(CFLAGS) $(DFLAG) $*.c
main.o: main.c
	$(CC) -c  $(CFLAGS) $(DFLAG) $*.c
map.o: map.c
	$(CC) -c  $(CFLAGS) $(DFLAG) $*.c
mount.o: mount.c
	$(CC) -c  $(CFLAGS) $(DFLAG) $*.c
page.o: page.c
	$(CC) -c  $(CFLAGS) $(DFLAG) $*.c
proc.o: proc.c
	$(CC) -c  $(CFLAGS) $(DFLAG) $*.c
rfs.o: rfs.c
	$(CC) -c  $(CFLAGS) $(DFLAG) $*.c
search.o: search.c
	$(CC) -c  $(CFLAGS) $(DFLAG) $*.c
size.o: size.c
	$(CC) -c  $(CFLAGS) $(DFLAG) $*.c
sizenet.o: sizenet.c
	$(CC) -c  $(CFLAGS) $(DFLAG) $*.c
stat.o: stat.c
	$(CC) -c  $(CFLAGS) $(DFLAG) $*.c
stream.o: stream.c
	$(CC) -c  $(CFLAGS) $(DFLAG) $*.c
symtab.o: symtab.c
	$(CC) -c  $(CFLAGS) $(DFLAG) $*.c
u.o: u.c
	$(CC) -c  $(CFLAGS) $(DFLAG) $*.c
util.o: util.c
	$(CC) -c  $(CFLAGS) $(DFLAG) $*.c
var.o: var.c
	$(CC) -c  $(CFLAGS) $(DFLAG) $*.c
vtop.o: vtop.c
	$(CC) -c  $(CFLAGS) $(DFLAG) $*.c

#			Build files for disassembler.
#			source is from the utility 'dis'.
#
disobjs:	$(DIS.O) $(DIS.H)
text_dis.o: $(DISDIRP)/text_dis.c $(DIS.H)
	$(CC) $(DISINC) $(DEFINES) -c  $(CFLAGS) $(DISDIRP)/text_dis.c

names.o: $(DISDIRP)/names.c $(DIS.H)
	$(CC) $(DEFINES)  -c $(CFLAGS) $(DISINC) $(DISDIRP)/names.c

extended.o: $(DISDIRP)/extended.c $(DIS.H)
	$(CC) $(DEFINES) -c  $(CFLAGS) $(DISINC) $(DISDIRP)/extended.c

881_gen.o: $(DISDIRP)/881_gen.c $(DIS.H)
	$(CC) $(DEFINES) -c  $(CFLAGS) $(DISINC) $(DISDIRP)/881_gen.c

cp_gen.o: $(DISDIRP)/cp_gen.c $(DIS.H)
	$(CC) $(DEFINES) -c  $(CFLAGS) $(DISINC) $(DISDIRP)/cp_gen.c

#
#
#			End of disassembler related files
#

ctags:
	ctags	$(CFILES)
	echo 'grep $$* \\' > greplist
	for i in $(CFILES)		;\
	do echo "$$i \\" >> greplist	;\
	done
	echo /dev/null >> greplist
	chmod +x greplist

clean:
	-rm -f *.o tags greplist

clobber: clean
	-rm -f crash

xref: $(CFILES) $(HFILES) 
	cxref -c  $(COMFLAGS) $(CFILES) | pr -h crash.cxref | opr

lint: $(CFILES) $(HFILES) 
	lint $(COMFLAGS) -uh $(CFILES) 

prall:
	pr -n $(CFILES) | opr
	pr -n $(HFILES) | opr

FRC:
