/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) callout.c: version 25.1 created on 12/2/91 at 14:03:00	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)callout.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*	ATT:#ident	"crash-3b2:callout.c	1.8"	*/
	
#ident	"@(#)crash:callout.c	25.1"

/*
 * This file contains code for the crash function callout.
 */

#include "stdio.h"
#include "a.out.h"
#include "sys/types.h"
#include "sys/callo.h"
#include "sys/iopmcomm.h"
#include "sys/iopm/sys/callo.h"
#include "crash.h"

extern talking_to_pm;
extern struct iopm_comm  Iopcomm;

struct syment *Callout;			/* namelist symbol pointer */
struct syment *Calltodo;		/* namelist symbol pointer */
extern char *strtbl;			/* pointer to string table */
extern short N_TEXT;			/* used in symbol table search */

/* get arguments for callout function */
int
getcallout()
{
	int c;

	if(!Callout)
		if(!(Callout = symsrch("callout")))
			error("callout not found in symbol table\n");

	if ( !Calltodo && !(Calltodo = symsrch("calltodo")) )
			error("calltodo not found in symbol table\n");

	talking_to_pm = TRUE;
	optind = 1;
	while((c = getopt(argcnt,args,"h:w:")) !=EOF) {
		switch(c) {
			case 'h' :	if ( !get_mach_slot() )
						return;
					break;
			case 'w' :	redirect();
					break;
			default  :	longjmp(syn,0);
		}
	}
	fprintf(fp,"FUNCTION        ARGUMENT   TIME       ID\n");
	if(args[optind]) 
		longjmp(syn,0);

	if ( talking_to_pm )
		prcallout();
	else
	{
		readiopcomm();
		priopmcallo();
	}
}

/* print callout table */
int
prcallout()
{
	struct syment *sp;
	extern struct syment *findsym();
	struct callo callbuf;
	static char tname[SYMNMLEN+1];
	char *name;
	int data_in_table = 0;

	seekmem((long)Calltodo->n_value,1,-1);
		if(read(kmem,(char *)&callbuf,sizeof callbuf)!=sizeof callbuf) 
			error("read error on callout table\n");
	if ( !callbuf.c_next )
	{
		printf("There is nothing in callout table\n");
		return;
	}

	while(callbuf.c_next) {
		seekmem((long)callbuf.c_next,1,-1);
		if(read(kmem,(char *)&callbuf,sizeof callbuf)!=sizeof callbuf) 
			error("read error on callout table\n");
		data_in_table++;
		if(!(sp = findsym((unsigned long)callbuf.c_func)))
			error("%8x does not match in symbol table\n",
				callbuf.c_func);
		if(sp->n_zeroes){
			strncpy(tname,sp->n_name,SYMNMLEN);
			name = tname;
		}
		else name = strtbl + sp->n_offset;
		fprintf(fp,"%-15s",name);
		fprintf(fp," %08lx  %5u %8x\n", 
			callbuf.c_arg,
			callbuf.c_time,
			callbuf.c_id);
	}
}

priopmcallo()
{
	struct icallo  *callop = Iopcomm.callo_head;
	struct icallo  callbuf;

	if ( !callop )
		printf("There is nothing in callout table\n");

	while ( callop )
	{
		readiop(callop, &callbuf, sizeof callbuf);

		fprintf(fp, "%08lx       ", callbuf.c_func);
		fprintf(fp," %08lx  %5u %8x\n", 
			callbuf.c_arg,
			callbuf.c_time,
			callbuf.c_id);

		callop = callbuf.c_next;
	}
}
