/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) buf.c: version 25.1 created on 12/2/91 at 14:02:56	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)buf.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*	ATT;#ident	"crash-3b2:buf.c	1.12.2.1"	*/


/*
 * This file contains code for the crash functions: bufhdr, buffer, od, iopmstat
 */

#include "a.out.h"
#include "stdio.h"
#include "signal.h"
#include "sys/sysmacros.h"
#include "sys/types.h"
#include "sys/param.h"
#include "sys/fs/s5param.h"
#include "sys/fs/s5inode.h"
#include "sys/immu.h"
#include "sys/user.h"
#include "sys/var.h"
#include "sys/region.h"
#include "sys/proc.h"
#include "sys/inode.h"
#include "sys/ino.h"
#include "sys/buf.h"
#include "sys/rbuf.h"
#include "sys/iopmcomm.h"
#include "sys/iopmioctl.h"
#include "sys/kmem.h"
#include "crash.h"
#define IOPM_OS
#include "sys/iopm/sys/buf.h"
#include "sys/iopmstat.h"

#define BSZ  1		/* byte size */
#define SSZ  2		/* short size */
#define LSZ  4		/* long size */

static struct syment *Bufhdr;	/* namelist symbol pointer */
static struct syment *Buf;	/* namelist symbol pointer */

	static struct syment *Bufhdr4k;	
#	define NBTYPS 5
#	define BTYPDEF 1
	static	struct bsizes {
			char  nm[10];
			short sz;
		} btyp, btyps[NBTYPS] = { 	
				{ "", 0 },
				{ "1k", 0x400 },
				{ "2k", 0x800 },
				{ "", 0 },
				{ "4k", 0x1000 } };
#	undef SBUFSIZE
#	define SBUFSIZE	( btyp.sz )
	char buffer[MAXBSIZE];
static char bformat = 'x';	/* buffer format */
static int type = LSZ;		/* od type */
static char mode = 'x';		/* od mode */
struct	buf bbuf;		/* used by buffer for bufhdr */
extern char *ctime();
extern long vtop();
extern long lseek();
extern int talking_to_pm;
extern char dev_slot_name[];
extern struct iopm_comm  Iopcomm;
static char *iopmheading =
	  "SLOT MAJ/MIN    BLOCK   KBP  ADDRESS      AVF      AVB FLAGS\n";

/* get arguments for bufhdr function */
int
getbufhdr()
{
	int slot = -1;
	int full = 0;
	int phys = 0;
	long addr = -1;
	long arg1 = -1;
	long arg2 = -1;
	int c;
	struct syment	*tmphdr = (struct syment *)0 ;
	int i;
	char *heading =
	  "SLOT MAJ/MIN    BLOCK  ADDRESS FOR BCK AVF AVB FLAGS\n";
	uint  maxentries;

	talking_to_pm = TRUE;
	if(!Bufhdr)
		if(!(Bufhdr = symsrch("bufhdrs")))
			error("bufhdrs not found in symbol table\n");
	if(!Bufhdr4k && !(Bufhdr4k = symsrch("bufhdrs4k")))
		btyps[4].sz = 0;
	btyp = btyps[BTYPDEF];

	optind = 1;
	while((c = getopt(argcnt,args,"fpt:w:h:")) !=EOF) {
		switch(c) {
			case 'h' :	if ( !get_mach_slot() )
						return;
					break;
			case 'f' :	full = 1;
					break;
			case 'w' :	redirect();
					break;
			case 'p' :	phys = 1;
					break;
			case 't' :	i = atoi(optarg) ;
					if ( i<0 || i>NBTYPS || btyps[i].sz==0 )
						btyp = btyps[BTYPDEF];
					else {
						btyp = btyps[i];
						tmphdr = Bufhdr;
						Bufhdr  = Bufhdr4k;
					}
					break;
			default  :	longjmp(syn,0);
		}
	}

	if ( talking_to_pm )
	{
		maxentries = vbuf.v_buf;
		fprintf(fp,"%s BUFFER HEADER TABLE SIZE = %d\n",
		  btyp.nm, maxentries);
	}
	else
	{
		readiopcomm();
		maxentries = Iopcomm.numbp;
		fprintf(fp, "IOPM BUFFER HEADER TABLE SIZE = %d\n",
		  maxentries);
	}

	if(!full)
		if ( talking_to_pm )
			fprintf(fp,"%s",heading);
		else
			fprintf(fp, "%s", iopmheading);

	if(args[optind]) 
		do {
			getargs(maxentries,&arg1,&arg2);
			if(arg1 == -1) 
				continue;
			if(arg2 != -1)
				for(slot = arg1; slot <= arg2; slot++)
					if ( talking_to_pm )
						prbufhdr(full,slot,phys,addr,
						  heading);
					else
						priopmbp(full,slot,phys,addr);
			else {
				if(arg1 < maxentries) {
					slot = arg1;
					if ( talking_to_pm )
						prbufhdr(full,slot,phys,addr,
						  heading);
					else
						priopmbp(full,slot,phys,addr);
				}
				else {
					fprintf(fp,
				   "System buffer header entry out of range\n");
					return;
				} 
			}
			slot = addr = arg1 = arg2 = -1;
		}while(args[++optind]);
	else for(slot = 0; slot < maxentries; slot++)
		if ( talking_to_pm )
			prbufhdr(full,slot,phys,addr,heading);
		else
			priopmbp(full, slot, phys, addr);
	if (tmphdr) 
		Bufhdr = tmphdr;
}


/* print buffer headers */
int
prbufhdr(full,slot,phys,addr,heading)
int full,slot,phys;
long addr;
char *heading;
{
	struct buf bhbuf;
	struct rbuf rbhbuf;
	register int b_flags;
	extern struct syment *Proc;
	int procslot,forw,back,avf,avb,fforw,fback;

	readbuf(addr,(long)(Bufhdr->n_value+slot*sizeof bhbuf),phys,-1,
		(char *)&bhbuf,sizeof bhbuf,"buffer header");
	if(bhbuf.b_flags & B_REMOTE) {
		readbuf(addr,(long)(Bufhdr->n_value+slot*sizeof rbhbuf),phys,-1,
			(char *)&rbhbuf,sizeof rbhbuf,"buffer header");
		if(full)
			fprintf(fp,"%s",heading);
		if(addr > -1) 
			slot = getslot(addr,(long)Bufhdr->n_value,sizeof rbhbuf,phys,
				vbuf.v_buf);
		if(slot == -1)
			fprintf(fp,"  - ");
		else fprintf(fp,"%4d",slot);
		fprintf(fp,"  - , -  %8x %8x",
			rbhbuf.b_blkno,
			rbhbuf.b_un.b_addr);
		forw = ((long)rbhbuf.b_forw - Bufhdr->n_value)/sizeof rbhbuf;
		if((forw >= 0) && (forw < vbuf.v_buf))
			fprintf(fp," %3d",forw);
		else fprintf(fp,"  - ");
		back = ((long)rbhbuf.b_back - Bufhdr->n_value)/sizeof rbhbuf;
		if((back >= 0) && (back < vbuf.v_buf))
			fprintf(fp," %3d",back);
		else fprintf(fp,"  - ");
		if(!(rbhbuf.b_flags & B_BUSY)) {
			avf = ((long)rbhbuf.av_forw - Bufhdr->n_value)/sizeof rbhbuf;
			if((avf >= 0) && (avf < vbuf.v_buf))
				fprintf(fp," %3d",avf);
			else fprintf(fp,"  - ");
			avb = ((long)rbhbuf.av_back - Bufhdr->n_value)/sizeof rbhbuf;
			if((avb >= 0) && (avb < vbuf.v_buf))
				fprintf(fp," %3d",avb);
			else fprintf(fp,"  - ");
		}
		else fprintf(fp,"  -   - ");
		b_flags = rbhbuf.b_flags;
		fprintf(fp,"%s%s%s%s%s%s%s%s%s%s%s%s%s\n",
			b_flags & B_READ ? " read" : " write",
			b_flags & B_DONE ? " done" : "",
			b_flags & B_ERROR ? " error" : "",
			b_flags & B_BUSY ? " busy" : "",
			b_flags & B_PHYS ? " phys" : "",
			b_flags & B_WANTED ? " wanted" : "",
			b_flags & B_AGE ? " age" : "",
			b_flags & B_ASYNC ? " async" : "",
			b_flags & B_DELWRI ? " delwri" : "",
			b_flags & B_OPEN ? " open" : "",
			b_flags & B_STALE ? " stale" : "",
			b_flags & B_S54K ? " 4k" : "",
			b_flags & B_REMOTE ? " remote" : "");

		if(full) {
			fprintf(fp,"\tF_FOR F_BCK  FHANDLE    QUEUE MNTINDX    VCODE  RELTIME\n");
			fforw = ((long)rbhbuf.b_forw - Bufhdr->n_value)/sizeof rbhbuf;
			if((fforw >= 0) && (fforw < vbuf.v_buf))
				fprintf(fp,"\t%5d",fforw);
			else fprintf(fp,"\t  -  ");
			fback = ((long)rbhbuf.b_back - Bufhdr->n_value)/sizeof rbhbuf;
			if((fback >= 0) && (fback < vbuf.v_buf))
				fprintf(fp," %5d",fback);
			else fprintf(fp,"   -  ");
			fprintf(fp," %8x %8x    %4x %8x %8x\n",
				rbhbuf.b_fhandle,
				rbhbuf.b_queue,
				rbhbuf.b_mntindx,
				rbhbuf.b_vcode,
				rbhbuf.b_reltime);
			fprintf(fp,"\n");
			}
	}
	else {
		if(full)
			fprintf(fp,"%s",heading);
		if(addr > -1) 
			slot = getslot(addr,(long)Bufhdr->n_value,sizeof bhbuf,phys,
				vbuf.v_buf);
		if(slot == -1)
			fprintf(fp,"  - ");
		else fprintf(fp,"%4d",slot);
		fprintf(fp," %3u,%-3u %8x %8x",
			major(bhbuf.b_dev)&0177,
			minor(bhbuf.b_dev),
			bhbuf.b_blkno,
			bhbuf.b_un.b_addr);
		forw = ((long)bhbuf.b_forw - Bufhdr->n_value)/sizeof bhbuf;
		if((forw >= 0) && (forw < vbuf.v_buf))
			fprintf(fp," %3d",forw);
		else fprintf(fp,"  - ");
		back = ((long)bhbuf.b_back - Bufhdr->n_value)/sizeof bhbuf;
		if((back >= 0) && (back < vbuf.v_buf))
			fprintf(fp," %3d",back);
		else fprintf(fp,"  - ");
		if(!(bhbuf.b_flags & B_BUSY)) {
			avf = ((long)bhbuf.av_forw - Bufhdr->n_value)/sizeof bhbuf;
			if((avf >= 0) && (avf < vbuf.v_buf))
				fprintf(fp," %3d",avf);
			else fprintf(fp,"  - ");
			avb = ((long)bhbuf.av_back - Bufhdr->n_value)/sizeof bhbuf;
			if((avb >= 0) && (avb < vbuf.v_buf))
				fprintf(fp," %3d",avb);
			else fprintf(fp,"  - ");
		}
		else fprintf(fp,"  -   - ");
		b_flags = bhbuf.b_flags;
		fprintf(fp,"%s%s%s%s%s%s%s%s%s%s%s%s%s\n",
			b_flags & B_READ ? " read" : " write",
			b_flags & B_DONE ? " done" : "",
			b_flags & B_ERROR ? " error" : "",
			b_flags & B_BUSY ? " busy" : "",
			b_flags & B_PHYS ? " phys" : "",
			b_flags & B_WANTED ? " wanted" : "",
			b_flags & B_AGE ? " age" : "",
			b_flags & B_ASYNC ? " async" : "",
			b_flags & B_DELWRI ? " delwri" : "",
			b_flags & B_OPEN ? " open" : "",
			b_flags & B_STALE ? " stale" : "",
			b_flags & B_S54K ? " 4k" : "",
			b_flags & B_REMOTE ? " remote" : "");
		if(full) {
			fprintf(fp,"\tBCNT ERR RESI   START  PROC  RELTIME\n");
			fprintf(fp,"\t%4d %3d %4d %8x",
				bhbuf.b_bcount,
				bhbuf.b_error,
				bhbuf.b_resid,
				bhbuf.b_start);
			procslot = ((long)bhbuf.b_proc - Proc->n_value)/
				sizeof (struct proc);
			if((procslot >= 0) && (procslot < vbuf.v_proc))
				fprintf(fp," %4d",procslot);
			else fprintf(fp,"  - ");
			fprintf(fp," %8x\n",bhbuf.b_reltime);
			fprintf(fp,"\n");
		}
	}
}

priopmbp(full, slot, phys, addr)
long addr;
{
	struct i_buf  *bp  = Iopcomm.bparray + slot;
	struct i_buf  bufhdr;
	uint          numbp = Iopcomm.numbp;
	register int b_flags;
	extern struct syment *Proc;
	int procslot,avf,avb,kslot;

	readiop(bp, &bufhdr, sizeof bufhdr);

	if ( full )
		fprintf(fp, "%s", iopmheading);

	if ( addr > -1 ) 
		slot = getslot(addr, (long)bp, sizeof bufhdr, phys, numbp);

	if ( slot == -1 )
		fprintf(fp,"  - ");
	else
		fprintf(fp,"%4d",slot);

	fprintf(fp," %3u,%-3u %8x",
		major(bufhdr.b_dev) & 0177,
		minor(bufhdr.b_dev),
		bufhdr.b_blkno);
	kslot = getslot(addr, bufhdr.b_kbp, (long)Bufhdr->n_value,
	  sizeof(struct buf), phys, vbuf.v_buf);
	if ( kslot == -1 )
		fprintf(fp, "    - ");
	else
		fprintf(fp, "  %4d", kslot);

	fprintf(fp, " %8x", bufhdr.b_un.b_addr);

	if ( !(bufhdr.b_flags & B_BUSY) )
	{
		avf = ((long)bufhdr.av_forw - (long)bp) / sizeof bufhdr;

		if ( (avf >= 0) && (avf < numbp) )
			fprintf(fp, " %3d", avf);
		else
			fprintf(fp, "  - ");

		avb = ((long)bufhdr.av_back - (long)bp) / sizeof bufhdr;

		if ( (avb >= 0) && (avb < numbp) )
			fprintf(fp, " %3d", avb);
		else
			fprintf(fp, "  - ");
	}
	else
		fprintf(fp, "  -   - ");

	b_flags = bufhdr.b_flags;
	fprintf(fp,"%s%s%s%s%s%s%s%s%s%s%s%s%s\n",
		b_flags & B_READ ? " read" : " write",
		b_flags & B_DONE ? " done" : "",
		b_flags & B_ERROR ? " error" : "",
		b_flags & B_BUSY ? " busy" : "",
		b_flags & B_PHYS ? " phys" : "",
		b_flags & B_WANTED ? " wanted" : "",
		b_flags & B_AGE ? " age" : "",
		b_flags & B_ASYNC ? " async" : "",
		b_flags & B_DELWRI ? " delwri" : "",
		b_flags & B_OPEN ? " open" : "",
		b_flags & B_STALE ? " stale" : "",
		b_flags & B_S54K ? " 4k" : "",
		b_flags & B_REMOTE ? " remote" : "");

	if ( full )
	{
		fprintf(fp, "\tBCNT ERR RESI    START PROC  RELTIME\n");
		fprintf(fp, "\t%4d %3d %4d %8x",
			bufhdr.b_bcount,
			bufhdr.b_error,
			bufhdr.b_resid,
			bufhdr.b_start);

		procslot = ((long)bufhdr.b_proc - Proc->n_value)/
			sizeof (struct proc);

		if ( (procslot >= 0) && (procslot < vbuf.v_proc) )
			fprintf(fp, " %4d", procslot);
		else
			fprintf(fp,"   - ");

		fprintf(fp, " %8x\n\n", bufhdr.b_reltime);
	}
}

/* get arguments for buffer function */
int
getbuffer()
{
	int slot = -1;
	int phys = 0;
	int fflag = 0;
	long addr = -1;
	long arg1 = -1;
	long arg2 = -1;
	int c;
	int i;
	struct syment *tmphdr = (struct syment *)0;

	if(!Bufhdr && !(Bufhdr = symsrch("bufhdrs")))
		error("bufhdr not found in symbol table\n");
	optind = 1;
	btyp = btyps[BTYPDEF];
	if(!Bufhdr4k && !(Bufhdr4k = symsrch("bufhdrs4k")))
		btyps[4].sz = 0;

	while((c = getopt(argcnt,args,"bcdrxiopt:w:")) !=EOF) {
		switch(c) {
			case 'w' :	redirect();
					break;
			case 'p' :	phys = 1;
					break;
			case 'b' :	bformat = 'b';
					fflag++;
					break;
			case 'c' :	bformat = 'c';
					fflag++;
					break;
			case 'd' :	bformat = 'd';
					fflag++;
					break;
			case 'x' :	bformat = 'x';
					fflag++;
					break;
			case 'i' :	bformat = 'i';
					fflag++;
					break;
			case 'r' :	bformat = 'r';
					fflag++;
					break;
			case 'o' :	bformat = 'o';
					fflag++;
					break;
			case 't' :	i = atoi(optarg) ;
					if (i<0 || i>NBTYPS || btyps[i].sz==0 )
						btyp = btyps[BTYPDEF];
					else {
						btyp = btyps[i];
						tmphdr = Bufhdr;
						Bufhdr  = Bufhdr4k;
					}
					break;
			default  :	longjmp(syn,0);
					break;
		}
	}
	if(fflag > 1)
		longjmp(syn,0);
	if(args[optind]) {
		getargs(vbuf.v_buf,&arg1,&arg2);
		if(arg1 != -1) {
		  if(arg1 < vbuf.v_buf)
		    {	slot = arg1;
			prbuffer(slot,phys,addr);
		    }
		  else 
		    { fprintf(fp, "Buffer entry out of range\n");
			return;
		    }
		}
	}
	else longjmp(syn,0);
	if (tmphdr)
		Bufhdr = tmphdr;
}


/* print buffer */
int
prbuffer(slot,phys,addr)
int slot,phys;
long addr;
{

	readbuf(addr,(long)(Bufhdr->n_value+slot*sizeof bbuf),phys,-1,
		(char *)&bbuf,sizeof bbuf,"buffer");
	if(slot > -1)
		fprintf(fp,"%s BUFFER %d:  \n", btyp.nm, slot);

	readmem((long)bbuf.b_un.b_addr,1,-1,(char *)buffer,
		sizeof buffer,"buffer");
	switch(bformat) {
		case 'b' :	prbalpha();
				break;
		case 'c' :	prbalpha();
				break;
		case 'd' :	prbnum();
				break;
		case 'x' :	prbnum();
				break;
		case 'i' :	prbinode();
				break;
		case 'r' :	prbdirect();
				break;
		case 'o' :	prbnum();
				break;
		default  :	error("unknown format\n");
				break;
	}
}

/* print buffer in numerical format */
int
prbnum()
{
	int *ip,i;

	for(i = 0, ip=(int *)buffer; ip !=(int *)&buffer[SBUFSIZE]; i++, ip++) {
		if(i % 4 == 0)
			fprintf(fp,"\n%5.5x:\t", i*4);
		fprintf(fp,bformat == 'o'? " %11.11o" :
			bformat == 'd'? " %10.10u" : " %8.8x", *ip);
	}
	fprintf(fp,"\n");
}


/* print buffer in character format */
int
prbalpha()
{
	char *cp;
	int i;

	for(i=0, cp = buffer; cp != &buffer[SBUFSIZE]; i++, cp++) {
		if(i % (bformat == 'c' ? 16 : 8) == 0)
			fprintf(fp,"\n%5.5x:\t", i);
		if(bformat == 'c') putch(*cp);
		else fprintf(fp," %4.4o", *cp & 0377);
	}
	fprintf(fp,"\n");
}


/* print buffer in inode format */
int
prbinode()
{
	struct	dinode	*dip;
	long	_3to4();
	int	i,j;

	for(i=1,dip = (struct dinode *)buffer;dip <
		 (struct dinode*)&buffer[SBUFSIZE]; i++, dip++) {
	fprintf(fp,"\ni#: %ld  md: ", (bbuf.b_blkno - 2) *
		INOPB + i);
		switch(dip->di_mode & IFMT) {
		case IFCHR: fprintf(fp,"c"); break;
		case IFBLK: fprintf(fp,"b"); break;
		case IFDIR: fprintf(fp,"d"); break;
		case IFREG: fprintf(fp,"f"); break;
		case IFIFO: fprintf(fp,"p"); break;
		default:    fprintf(fp,"-"); break;
		}
		fprintf(fp,"\n%s%s%s%3x",
			dip->di_mode & ISUID ? "u" : "-",
			dip->di_mode & ISGID ? "g" : "-",
			dip->di_mode & ISVTX ? "t" : "-",
			dip->di_mode & 0777);
		fprintf(fp,"  ln: %u  uid: %u  gid: %u  sz: %ld",
			dip->di_nlink, dip->di_uid,
			dip->di_gid, dip->di_size);
		if((dip->di_mode & IFMT) == IFCHR ||
			(dip->di_mode & IFMT) == IFBLK ||
			(dip->di_mode & IFMT) == IFIFO)
			fprintf(fp,"\nmaj: %d  min: %1.1o\n",
				dip->di_addr[0] & 0377,
				dip->di_addr[1] & 0377);
		else
			for(j = 0; j < NADDR; j++) {
				if(j % 7 == 0)
					fprintf(fp,"\n");
				fprintf(fp,"a%d: %ld  ", j,
					_3to4(&dip->di_addr[3 * j]));
			}
	
		fprintf(fp,"\nat: %s", ctime(&dip->di_atime));
		fprintf(fp,"mt: %s", ctime(&dip->di_mtime));
		fprintf(fp,"ct: %s", ctime(&dip->di_ctime));
	}
	fprintf(fp,"\n");
}


/* print buffer in directory format */
int
prbdirect()
{
	struct	direct	*dp;
	int	i,bad;
	char *cp;

	fprintf(fp,"\n");
	for(i=0,dp =(struct direct*) buffer;dp <
		(struct direct *)&buffer[SBUFSIZE];i++,dp++) {
		bad = 0;
		for(cp = dp->d_name; cp != &dp->d_name[DIRSIZ]; cp++)
			if((*cp < 040 || *cp > 0176) && *cp != '\0')
				bad++;
		fprintf(fp,"d%2d: %5u  ", i, dp->d_ino);
		if(bad) {
			fprintf(fp,"unprintable: ");
			for(cp = dp->d_name; cp != &dp->d_name[DIRSIZ];
				cp++)
				putch(*cp);
		} else fprintf(fp,"%.14s", dp->d_name);
		fprintf(fp,"\n");
	}
}



/* covert 3 byte disk block address to 4 byte address */
long
_3to4(ptr)
register  char  *ptr;
{
	long retval;
	register  char  *vptr;

	vptr = (char *)&retval;
	*vptr++ = 0;
	*vptr++ = *ptr++;
	*vptr++ = *ptr++;
	*vptr++ = *ptr++;
	return(retval);
}


/* get arguments for od function */
int
getod()
{
	int phys = 0;
	int count = 1;
	int proc = Procslot;
	long addr = -1;
	int c;
	struct syment *sp;
	int typeflag = 0;
	int modeflag = 0;
	talking_to_pm = TRUE;

	optind = 1;
	while((c = getopt(argcnt,args,"H:tlxcbdohapw:s:")) !=EOF) {
		switch(c) {
			case 'H' :
					if (!get_mach_slot())
						return;
					break;
			case 'w' :	redirect();
					break;
			case 's' :	proc = setproc();
					break;
			case 'p' :	phys = 1;
					break;
			case 'c' :	mode = 'c';
					if (!typeflag)
						type = BSZ;
					modeflag++;
					break;
			case 'a' :	mode = 'a';
					if (!typeflag)
						type = BSZ;
					modeflag++;
					break;
			case 'x' :	mode = 'x';
					if (!typeflag)
						type = LSZ;
					modeflag++;
					break;
			case 'd' :	mode = 'd';
					if (!typeflag)
						type = LSZ;
					modeflag++;
					break;
			case 'o' :	mode = 'o';
					if (!typeflag)
						type = LSZ;
					modeflag++;
					break;
			case 'h' :	mode = 'h';
					type = LSZ;
					typeflag++;
					modeflag++;
					break;
			case 'b' :	type = BSZ;
					typeflag++;
					break;
			case 't' :	type = SSZ;
					typeflag++;
					break;
			case 'l' :	type = LSZ;
					typeflag++;
					break;
			default  :	longjmp(syn,0);
		}
	}
	if(typeflag > 1) 
		error("only one type may be specified:  b, t, or l\n");	
	if(modeflag > 1) 
		error("only one mode may be specified:  a, c, o, d, or x\n");	
	if(args[optind]) {
		if(*args[optind] == '(') 
			addr = eval(++args[optind]);
		else if(sp = symsrch(args[optind])) 
			addr = sp->n_value;
		else if(isasymbol(args[optind]))
			error("%s not found in symbol table\n",args[optind]);
		else addr = strcon(args[optind],'h');	
		if(addr == -1)
			error("\n");
		if(args[++optind]) 
			if((count = strcon(args[optind],'d')) == -1)
				error("\n");
		prod(addr,count,phys,proc);
	}
	else longjmp(syn,0);
}

int
stream_prod(addr,count,phys,proc)
long addr;
int count,phys,proc;
{
	type = LSZ;
	mode = 'h';
	prod(addr,(count+3)/4,phys,proc);
}

/* print dump */
int
prod(addr,count,phys,proc)
long addr;
int count,phys,proc;
{
	int i,j;
	long padr;
	char ch;
	unsigned short shnum;
	long lnum;
	long value;
	char *format;
	int precision;
	char hexchar[16];
	char hexj;
	char *cp;
	int nbytes;
	int iopmem, read_mem;

	switch(type)
	{
	case LSZ :  
		if (addr & 0x3)
		{	/* word alignment */
    			fprintf(fp,"warning: word alignment performed\n");
    			addr &= ~0x3;
	 	}
	case SSZ :
	  	if (addr & 0x1)
		{	/* word alignment */
	    		fprintf(fp,"warning: word alignment performed\n");
	    		addr &= ~0x1;
	 	}
	}
	if(!phys) {
		padr = vtop(addr,proc);
		if(padr == -1)
			error("%x is an invalid address\n",addr);
	}
	else padr = addr;
	if (talking_to_pm)
	{
		padr=kv_to_mem(padr);
		if(lseek(mem,padr,0) == -1)
			error("%8x is out of range\n",addr);
	}
	else	/* seek on iopm */
	{
		if ((iopmem = open(dev_slot_name, 0)) == -1)
			error("failed to open %s\n", dev_slot_name);
		if (padr < IOPM_RAM_START)
			padr = iopm_vtop(iopmem);
		if (lseek(iopmem,padr-IOPM_RAM_START,0) == -1)
			error("seek error on IOPM address %x\n",addr);
	}
	if(mode == 'h') {
		cp = hexchar;
		nbytes = 0;
	}
	if (talking_to_pm)
		read_mem = mem;			/* reading from PM memory */
	else	read_mem = iopmem;		/* reading from iopm memory */

	for(i = 0; i < count; i++)
	{
		switch(type)
		{
		case BSZ:
			if(read(read_mem,&ch,sizeof (ch)) != sizeof (ch))
				error("read error in buffer\n");
			value = ch & 0377;
			break;
		case SSZ: 
			if(read(read_mem,(char *)&shnum, sizeof (short)) != sizeof (short))
				error("read error in buffer\n");
			value = shnum;
			break;	
		case LSZ:
			if (read(read_mem,(char *)&lnum,sizeof (long)) != sizeof (long))
				error("read error in buffer\n");
			value = lnum;
			break;
		}
		if (((mode == 'c') && ((i % 16) == 0))
		 || ((mode != 'a') && (mode != 'c') && (i % 4 == 0)))
		{
			if(i != 0)
			{
				if(mode == 'h')
				{
					fprintf(fp,"   ");
					for (j = 0; j < nbytes; j++)
					{
						hexj = hexchar[j];
						if (hexj < 040 || hexj > 0176)
							fprintf(fp,".");
						else	fprintf(fp,"%c", hexj);
					}
					cp = hexchar;
					nbytes = 0;
				}
				fprintf(fp,"\n");
			}
			fprintf(fp,"%8.8x:  ", addr + i * type);
		}
		switch(mode) {
			case 'a' :  switch(type) {
					case BSZ :  putc(ch,fp);
						    break;
					case SSZ :  putc((char)shnum,fp);
						    break;
					case LSZ :  putc((char)lnum,fp);
						    break;
				    }
				    break;
			case 'c' :  switch(type) {
					case BSZ :  putch(ch);
						    break;
					case SSZ :  putch((char)shnum);
						    break;
					case LSZ :  putch((char)lnum);
						    break;
				    }
				    break;
			case 'o' :  format = "%.*o   ";
				    switch(type) {
					case BSZ :  precision = 3;
						    break;
					case SSZ :  precision = 6;
						    break;
					case LSZ :  precision = 11;
						    break;
			   		}
			 	    fprintf(fp,format,precision,value);
			 	    break;
			case 'd' :  format = "%.*d   ";
				    switch(type) {
					case BSZ :  precision = 3;
						    break;
					case SSZ :  precision = 5;
						    break;
					case LSZ :  precision = 10;
						    break;
				    }
			 	    fprintf(fp,format,precision,value);
			   	    break;
			case 'x' :  format = "%.*x   ";
				    switch(type) {
					case BSZ :  precision = 2;
						    break;
					case SSZ :  precision = 4;
						    break;
					case LSZ :  precision = 8;
						    break;
				    }
			 	    fprintf(fp,format,precision,value);
				    break;
			case 'h' :  fprintf(fp,"%.*x   ",8,value);
				    *((long *)cp) = value;
				    cp +=4;
				    nbytes += 4;
				    break;
		}
	}
	if(mode == 'h') {
		if(i % 4 != 0)  
			for(j = 0; (j+(i%4)) < 4; j++)
				fprintf(fp,"           ");
		fprintf(fp,"   ");
		for(j = 0; j < nbytes; j++) 
			if(hexchar[j] < 040 || hexchar[j] > 0176)
				fprintf(fp,".");
			else fprintf(fp,"%c",hexchar[j]);
	}
	fprintf(fp,"\n");
	if (!talking_to_pm)
		close(read_mem);
}

getiopmstat()
{
	int c;
	struct bufstat  *ibufstat;

	talking_to_pm = TRUE;
	optind = 1;
	while((c = getopt(argcnt,args,"h:")) !=EOF) {
		switch(c) {
			case 'h' :	if ( !get_mach_slot() )
						return;
					break;
			default  :	longjmp(syn,0);
		}
	}

	if ( talking_to_pm )
		longjmp(syn, 0);

	readiopcomm();
	ibufstat = &Iopcomm.ibufstat;

	fprintf(fp,"ITEM                  CONFIG    ALLOC    FREE         TOTAL     MAX    FAIL\n");
	fprintf(fp,"bp                      %4d     %4d    %4d    %10d    %4d    %4d\n",
	  Iopcomm.numbp, ibufstat->bp.use, Iopcomm.numbp - (ibufstat->bp.use),
	  ibufstat->bp.total, ibufstat->bp.max, ibufstat->bp.fail);

	fprintf(fp,"buffers                 %4d     %4d    %4d    %10d    %4d    %4d\n",
	  Iopcomm.numbuf, ibufstat->buf.use,
	  Iopcomm.numbuf - (ibufstat->buf.use), ibufstat->buf.total,
	  ibufstat->buf.max, ibufstat->buf.fail);

	fprintf(fp,"eblk                    %4d     %4d    %4d    %10d    %4d    %4d\n",
	  Iopcomm.numeblk, ibufstat->eblk.use,
	  Iopcomm.numeblk - (ibufstat->eblk.use), ibufstat->eblk.total,
	  ibufstat->eblk.max, ibufstat->eblk.fail);

	fprintf(fp,"tcb                     %4d     %4d    %4d    %10d    %4d    %4d\n",
	  Iopcomm.numtcb, Iopcomm.itcbst.use,
	  Iopcomm.numtcb - (Iopcomm.itcbst.use), Iopcomm.itcbst.total,
	  Iopcomm.itcbst.max, Iopcomm.itcbst.fail);

	{
		struct iopminfo  Iopminfo;
		struct kbstat    Ikbstat;
		struct intrstat  Intrstat;
		struct strifstat Istrifstat;
		struct bufifstat Ibufifstat;
		uint class;

		readiop(Iopcomm.iopminfop, &Iopminfo, sizeof(struct iopminfo));
		readiop(Iopminfo.kbstatp, &Ikbstat, sizeof(Ikbstat));
		fprintf(fp, "IOPM kernel message block cache statistics\n");
fprintf(fp,
"size   kballoc       hit     hit2      fill   fill2    kbfree    flush    old\n");
		for ( class = 0; class < NCLASS; class++ )
		{
		switch (class)
		{
		case 0: fprintf(fp,"   4"); break;
		case 1: fprintf(fp,"  16"); break;
		case 2: fprintf(fp,"  64"); break;
		case 3: fprintf(fp," 128"); break;
		case 4: fprintf(fp," 256"); break;
		case 5: fprintf(fp," 512"); break;
		case 6: fprintf(fp,"1024"); break;
		case 7: fprintf(fp,"2048"); break;
		case 8: fprintf(fp,"4096"); break;
		default: fprintf(fp,"   -");
		}
			fprintf(fp, " %9d %9d %8d %9d %7d %9d %8d %5d\n",
			  Ikbstat.kab[class].called,
			  Ikbstat.kab[class].cachit[0],
			  Ikbstat.kab[class].cachit[1],
			  Ikbstat.kab[class].fill[0],
			  Ikbstat.kab[class].fill[1],
			  Ikbstat.kfb[class].called,
			  Ikbstat.kfb[class].flush,
			  Ikbstat.flush_old_kdb[class]);
		}
	}
}
