/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) cpio.c: version 25.1 created on 12/2/91 at 14:02:29	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)cpio.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*
 *	#ident	"@(#)cpio:cpio.c	1.30.3.23"
 *	/sccs/src/cmd/s.cpio.c
 *	cpio.c	1.30.3.23	6/9/87 17:33:41
 *	Reworked cpio which uses getopt(3) to interpret flag arguments and
 *	changes reels to the save file name.
 *	Performance and size improvements.
 */

#ifndef	ARIX
#define	ARIX	1	/* always define ARIX	*/
#endif	/* ARIX */

/*
 *	ARIX CHANGES
 *
 *
 *	NOTE
 *		ANY CPIO TAPE SHOULD BE READ WITH THE SAME OPTIONS THAT WERE
 *		USED FOR WRITING THE TAPE.  THIS CPIO WILL TRY TO AUTOMATICALLY
 *		HANDLE ANY INCONSISTENCIES BUT THE RESULT IS NOT GUARANTEED
 *		TO RESTORE DATA CORRECTLY IN SUCH A CASE.
 *
 *		This cpio automatically detects binary and ascii headers
 *		and processes them accordingly (added by AT&T in V.3.2).
 *
 *
 *	WRITE LOGIC
 *
 *
 *	READ LOGIC
 *
 *
 *	BIG NOTE:
 *      	MUCH of the CHANGE LOG changes have been removed: 3/22/91 taf
 *
 *	CHANGE LOG
 *		mu - Michael Umansky
 *
 *	mu? - v1.12 on 10/11/89 at 16:53:01
 *
 *	mu7 - v1.13 on 10/13/89 at 17:31:30
 *		1) More debugging fixes.
 *		2) Fix AT&T bug in buffer shifting in partial read/write.
 *		3) Remove ct_NOTFIRST flag.
 *		4) Cleanup smallbread() and bigbread().
 *		5) The smallbread() routine still has problems reading
 *		   tapes created by bigbread().
 *
 *	mu6 - v1.7 on 10/10/89 at 17:30:30
 *		1) Add debugging code ifdef'd by DEBUG.
 *		2) Add 'X' option for increasing debug output.
 *		3) Provide capability for automatic testing of EOM
 *		   handling by providing 'D' option which supplies a
 *		   file name which has the next device name(s) to be
 *		   used at EOM.
 *		4) All informative output now goes out to stderr except
 *		   during rename function and during verbose printout
 *		   of table of contents.
 *		CHANGED:  the listing of files in the cpio -it mode MUST
 *			  go to stdout.  This matches many utils which
 *			  depend on this and also matches cpio -itv. RLS
 *		5) Fix a bug in bwrite() for 128k/256k Arix IO.
 *
 *	mu5 - v1.6 on 10/9/89 at 21:47:30
 *		1) Clenaup NOTES and pseudo code for smallbread and bigbread.
 *		2) This version compiles cleanly.
 *		3) Start testing.
 *
 *	mu4 - v1.5 on 10/9/89 at 21:15:30
 *		1) Remove unnecessary ioctl's.
 *		2) Add an ioctl in chgreel() to check for cartridge
 *		   device again.
 *		3) Modify bread() to handle Arix 128k and 256k standards.
 *		4) Add all necessary routines for (3) above.
 *		5) Add logic for automatic detection/alignment of 128K/256K
 *		   block sizes.
 *		6) This version compiles cleanly.
 *
 *	mu3 - v1.4 on 10/5/89 at 19:19:30
 *		1) Add A and F flags to usage() output.
 *		2) Modify Bufsize based on A, F and C flags.
 *		3) Change bwrite() to handle default ARIX EOM mode
 *		   and the A and F flags correctly.
 *		4) Change chgreel() for correct default ARIX EOM handling.
 *		5) When prompting user for a new device name,
 *		   make sure he/she really wants to quit when only
 *		   a 'return/newline' is entered.
 *		6) Add description of the write logic.
 *
 *	mu2 - v1.3 on 10/5/89 at 16:55:30
 *		1) Preserve errno accross calls to fperr() and fperrno().
 *		2) Combine two switch()'s into one (case IN, OUT, PASS).
 *		3) Increase CPIOBSZ to from 4096 to (4096 * 10) BUT keep it
 *		   multiple of 4k page size (used in DISK IO).
 *		4) Allign all buffers on 4k page boundary (per David Stone).
 *		5) Add ioctl's to determine if IO is on a cartridge tape device.
 *		6) See chart above for description of usage of A, B, C, and F
 *		   options.
 *
 *	mu1 - v1.2 on 10/5/89 at 14:29:20
 *		1) General cleanup before adding ARIX specific handling.
 *		2) Applied some of the previous ARIX changes/fixes:
 *		    sw1  1/16/85 stone : align Cbuf on 4k boundary
 *		    sw5 12/18/86 ejb   : removed 'r' option from -p usage line
 *		    sw6 12/04/87 ???   : fixed bus error (reset namep to Name)
 *		3) The other ARIX changes/fixes were fixed by AT&T.
 */

/*
 *	cpio -- copy file collections
 *
 *	COMPILE:	cc -O cpio.c -s -i -o cpio -lgen
 */
#include "errmsg.h"
#include <errno.h>
#include <fcntl.h>
#include <memory.h>
#include <stdio.h>
#include <string.h>
#include <signal.h>
#include <varargs.h>
#include <sys/stat.h>
#include <sys/proc.h>
#include <sys/sysarix.h>
#include <sys/acl.h>

#define	SYMLINK	1	 /* So symbolic links will work */

#define TRUE 1
#define EQ(x,y)	(strcmp(x,y)==0)

				/* MKSHORT:  for VAX, Interdata, ...	*/
				/* Take a 4-byte long, lv, and turn it	*/
				/* into an array of two 2-byte shorts, v*/
#define MKSHORT(v,lv) {U.l=1L;if(U.c[0]) U.l=lv,v[0]=U.s[1],v[1]=U.s[0]; else U.l=lv,v[0]=U.s[0],v[1]=U.s[1];}

#define BINARY	0		/* Cflag setting */
#define ASCII	1		/* Cflag setting */
#define NONE	2		/* Cflag setting not verified */
#define M_ASCII "070707"	/* ASCII  magic number */
#define M_BINARY 070707		/* Binary magic number */
#define M_STRLEN 6		/* number bytes in ASCII magic number */
#define PATHSIZE 256		/* maximum PATH length */
#define IN	'i'		/* copy in */
#define OUT	'o'		/* copy out */
#define PASS	'p'		/* direct copy */
				/* header size minus filename field */
#define HDRSIZE	(Hdr.h_name - (char *)&Hdr)
#define UACL_LINKS	500	   /* no. of unamed acl links allocated per bunch */
#define LINKS		500	/* no. of links allocated per bunch */
#define DACL_RECS	20	   /* no. of dacl records allocated per bunch */
#define CHARS		76	/* ASCII header size minus filename field */
#define BUFSIZE		512	/* In u370, can't use BUFSIZ or BSIZE */

#define BBUFSIZE	5120	/* for -B option (mu1) */
#define ULIMBSIZE	512	/* size of a block, same as ulimit(1) (mu1) */
#define	PALIGNSZ	12288	/* align buffers on page boundary (mer1) */
#define	PALSIZE		4096	/* page size			  (mu2)	*/
#define	PALIGN(x)	((((x) + PALSIZE) - ((int)(x) % PALSIZE)) + PALSIZE) /* mer1 */
#define	HTRAILER	"TRAILER!!!"
#define SVID_ENVIRON	1
#define POSIX_ENVIRON	0

#ifdef	ARIX
#define CPIOBSZ (4096 * 10)	/* file read/write (mu2) */
#else	/* ARIX */
#define CPIOBSZ 4096		/* file read/write */
#endif	/* ARIX */
				/* Make unsigned shorts for portable  */
				/* header.  Hardware may only know    */
				/* integer operations and sign extend */
				/* the large unsigned short resulting */
				/* in 8 rather than 6 octal char in   */
				/* the header.			      */
#define MK_USHORT(a)	(a & 00000177777)

#define	FORMAT	"%b %e %H:%M:%S %Y"     /* Date time formats */
					/* b - abbreviated month name */
					/* e - day of month ( 1 - 31) */
					/* H - hour (00 -23) */
					/* M - minute (00 - 59) */
					/* S - seconds (00 -59) */
					/* Y - year as ccyy */

struct	stat	Statb, Xstatb, Astatb, Aclstat, Daclstat;

char Uaclname[] = "/tmp/uacl_U";
char Naclname[] = "/tmp/nacl_N";
char Daclname[] = "/tmp/dacl_D";
#define	BSIZE	4096
char Aclbuf[MAX_ACL_SIZE + PATHSIZE +1];
char Daclbuf[MAX_ACL_SIZE + PATHSIZE +1];
int Aclbufsize, Daclbufsize;

	/* Cpio header format */
struct header {
	short	h_magic;
	short	h_dev;
	ushort	h_ino;
	ushort	h_mode,
		h_uid,
		h_gid;
	short	h_nlink;
	short	h_rdev;
	short	h_mtime[2],
		h_namesize,
		h_filesize[2];
	char	h_name[256];
} Hdr, AclHdr, DaclHdr;

unsigned	Bufsize = BUFSIZE;		/* default record size */
char		*Buf;		/* main buffer for disk IO	*/
char		*Cbuf;		/* main buffer for archive IO	*/
char		*Cp;		/* temp for archive Output, used in bwrite() */
#ifdef	SYMLINK
char	Symlink_path[PATHSIZE];	/* used by readlink and symlink. */
#endif

short	Option,
	Dir,
	Uncond,
	PassLink,
	Rename,
	Toc,
	Verbose,
	Mod_time,
	Acc_time,
#ifdef	SYMLINK
	follow_flag;	/* ..follow symbolic links. */
#endif
	aclflag,
	Cflag,
	fflag,
	kflag,
	Swap,
	byteswap,
	bothswap,
	halfswap;

int	Ifile,
	Ofile,
	orig_umask,	/* umask inherited from cpio's parent process */
	df_mode = 0777,	/* default file/directory protection modes */
	Input = 0,
	Output = 1;
			/* sBlocks: short Blocks.  Cumulative character   */
			/* count for short reads in bread().  Encountered */
			/* with communication lines and pipes as in:      */
			/* split -100 cpio_archive; cat xa* | cpio -icd   */
long	sBlocks,
	Blocks,
	Longfile,
	Longtime;

/*mu7*/	long	filesz;	/* make global	*/

char	Fullname[256],
	Name[256];

int	Pathend;

char	*swfile;

char	*eommsg = "Change to part %d and press RETURN key. [q] ";

#ifdef	DEBUG
FILE	*chgfp;
char	*chgfname;
int	deblevel;
#endif	/* DEBUG */

FILE	*Rtty,
	*Wtty;

char	ttyname[] = "/dev/tty";

char	**Pattern = 0;

char	Chdr[500], AclChdr[500], DaclChdr[500];

int A_uacl ,A_nacl ,A_dacl ;

short	Dev;

ushort	Uid,
	A_directory,
	A_special,
	Filetype = S_IFMT;

extern	errno;
extern	void exit();
extern	ushort getuid();
extern	void perror();
extern	char *sys_errlist[];
extern	long lseek();
extern	long ulimit();
char	*malloc();
FILE 	*popen();

union {
	long l;
	short s[2];
	char c[4];
} U;

char	time_buf[50]; 		/* array to hold date and time */

#ifdef	ARIX

#include	<sys/ioctl.h>
#include	<sys/termio.h>

#define ct_IN		0x01		/* copy in   flag for ct_option	*/
#define ct_OUT		0x02		/* copy out  flag for ct_option	*/
#define	ct_IO		(ct_IN | ct_OUT)
#define	ct_SECOND	0x20		/* 2nd-ary buffer in current use*/
#define	ct_PARTIAL	0x40		/* partial read of BigBuf	*/
#define	ct_CHGREEL	0x80		/* reel has been changed	*/
#define	ct_CART		2		/* cartridge  device type	*/
#define	ct_NINE		4		/* nine track device type	*/
#define	FASTBSIZE	0x40000		/* big   buffer size - 256k	*/
#define	FASTSSIZE	0x20000		/* small buffer size - 128k	*/

char	*Cbuf1st;	/* 1st     buffer for archive Input ONLY */
char	*Cbuf2nd;	/* 2nd-ary buffer for archive Input ONLY */
int	CbufLen;	/* length of saved buffer (BigBuf)  ONLY */
int	ct_option;	/* option for IO device type	*/
int	ct_type;	/* IO device type from ioctl()	*/
long	Have;		/* already have in disk buffer	*/

#endif	/* ARIX */

int	cpio_environ;  /* SVID=1, POSIX=0 */
int	BigGflag = 0;
int	Gflag = 0;

char LastFile[PATHSIZE+1];  /* last file successfully imported and not a named acl, 
										 unnamed acl or default acl */
char RenamedFile[PATHSIZE+1];  /* not a named acl, unnamed acl or default acl */


/* for VAX, Interdata, ... */
long
mklong(v)
short v[];
{
	U.l = 1;
	if(U.c[0])
		U.s[0] = v[1], U.s[1] = v[0];
	else
		U.s[0] = v[0], U.s[1] = v[1];
	return U.l;
}

main(argc, argv)
char **argv;
{
	register ct;
	register char *fullp;
	register i;
/*mu7*/	/* make filesz global */
/*mu7*/	unsigned long	maxsz;		/* must be unsigned long */
/*mu7*/	long	tmpsz;			/* must be signed long */
	int ans,  rc, first;
	short select;			/* set when files are selected */
	extern char	*optarg;
	extern int	optind;
	uint posix_flags;
	char cpio_opts[40];

	errsource( *argv );
	errverb("notag,notofix");
	errexit( 2 );
	signal(SIGSYS, (void (*)()) 1);
	if(*argv[1] != '-')
		usage();
	Uid = getuid();
	orig_umask = umask(0);

	if (( sysarix(ARIXPOSIX, ARIXGETPOSFLAGS, 0, &posix_flags)) < 0) {
		fperrno("sysarix(ARIXGETPOSFLAGS) failure\n");
		exit(2);
	}

	strcpy(cpio_opts,"LaB");
	if (posix_flags & SVID_COMPAT_PROC) {
		cpio_environ = SVID_ENVIRON;
		strcat(cpio_opts,"c");
		Cflag = BINARY;
		posix_flags &= ~F_POSIX_BINARY;
		if (( sysarix(ARIXPOSIX, ARIXSETPOSFLAGS, 0, &posix_flags)) < 0) {
			fperrno("sysarix(ARIXSETPOSFLAGS) failure\n");
			exit(2);
		}
	}
	else {
		cpio_environ = POSIX_ENVIRON;
		strcat(cpio_opts,"g");
		Cflag = ASCII;
	}
	strcat(cpio_opts,"C:GifopdklmrSsbtuvVZM:6I:O:");
#ifdef	DEBUG
	if (deblevel)
		fperr("cpio_environ is %s\n",cpio_environ ? "SVID_ENVIRON" :
			"POSIX_ENVIRON");
#endif	/* DEBUG */

#ifdef	ARIX
#ifdef	DEBUG
	strcat(cpio_opts,"D:X");
#endif	/* DEBUG */
	while ((ans=getopt(argc,argv,cpio_opts)) != EOF)
#else	/* ARIX */
	while ((ans = getopt(argc,argv,"aBC:ifopcdklmrSsbtuvVM:6I:O:")) != EOF)
#endif	/* ARIX */
	{
		switch( ans ) {
		case 'a':	/* reset access time */
			Acc_time++;
			break;
		case 'Z':	/* process acls */
			aclflag = 1;
			break;
		case 'B':	/* change record size to BBUFSIZE bytes */
			Bufsize = BBUFSIZE;		/* mu1	*/
#ifdef	DEBUG
		if (deblevel)
/*mu6*/			fperr("'B' Bufsize set to %d\n",Bufsize);
#endif	/* DEBUG */
			break;
		case 'C':	/* reset buffer size to arbitrary value */
			if (optarg[strlen(optarg)-1] == 'k') {
				optarg[strlen(optarg)] = '\0';
				Bufsize = atoi( optarg ) * 1024;
			}
			else 
				Bufsize = atoi( optarg );
			if( Bufsize == 0 )
				errmsg( EERROR,
					"Illegal argument to -%c, '%s'.",
					ans, optarg );
#ifdef	DEBUG
		if (deblevel)
/*mu6*/			fperr("'C' Bufsize set to %d\n",Bufsize);
#endif	/* DEBUG */
			break;
		case 'G':	/* Non-partial reads only.  This will
				   only work on a cartridge tape that
				   was written with 128K or 256K blocksize
				   and was not written with partial 
				   blocks at the EOM.  This would be
				   ARIX tapes written by version 23.3
				   of cpio  */
			BigGflag = 1;
			break;
		case 'i':
			Option = IN;
			break;
		case 'f':	/* copy files not matched by patterns */
			fflag++;
			break;
		case 'o':
			Option = OUT;
			break;
		case 'p':
			Option = PASS;
			break;
		case 'c':		/* ASCII header */
			Cflag = ASCII;
			break;
		case 'g':		/* BINARY header */
			Cflag = BINARY;
			break;
		case 'd':		/* create directories when needed */
			Dir++;
			break;
		case 'l':		/* link files, when necessary */
			PassLink++;
			break;
		case 'm':		/* retain mod time */
			Mod_time++;
			break;
		case 'r':		/* rename files interactively */
			Rename++;
			Rtty = fopen(ttyname, "r");
			Wtty = fopen(ttyname, "w");
			if(Rtty==NULL || Wtty==NULL) {
				errmsg( EERROR, "Cannot rename (%s missing)",
					ttyname );
			}
			break;
		case 'S':		/* swap halfwords */
			halfswap++;
			Swap++;
			break;
		case 's':		/* swap bytes */
			byteswap++;
			Swap++;
			break;
		case 'b':		/* swap both bytes and halfwords */
			bothswap++;
			Swap++;
			break;
		case 't':		/* table of contents */
			Toc++;
			break;
		case 'u':		/* copy unconditionally */
			Uncond++;
			break;
		case 'v':		/* verbose - print out file names */
			Verbose = 1;
			break;
		case 'V':		/* print a dot '.' for each file */
			Verbose = 2;
			break;
#ifdef	SYMLINK
		case 'L':		/* Follow symbolic links. */
			follow_flag++;
			break;
#endif
		case 'M':		/* alternate message for end-of-media */
			eommsg = optarg;
			break;
#ifdef	DEBUG
		case 'X':		/* file with name of next device */
			deblevel++;
			break;
		case 'D':		/* file with name of next device */
			chgfname = optarg;
		if (deblevel)
/*mu6*/			fperr("'D' chgfname set to '%s'\n",chgfname);
			break;
#endif	/* DEBUG */
		case '6':		/* for old, sixth-edition files */
			Filetype = 060000;
			break;
		case 'I':
			chkswfile( swfile, ans, Option );
			close( Input );
			if( open( optarg, O_RDONLY ) != Input )
				cannotopen( optarg, "input" );
			swfile = optarg;
#ifdef	DEBUG
		if (deblevel)
/*mu6*/			fperr("'I' Input set to '%s'\n",swfile);
#endif	/* DEBUG */
			break;
		case 'O':
			chkswfile( swfile, ans, Option );
			close( Output );
			if( open( optarg, O_WRONLY | O_CREAT | O_TRUNC, 0666 )
				!= Output)
				cannotopen( optarg, "output" );
			swfile = optarg;
#ifdef	DEBUG
		if (deblevel)
/*mu6*/			fperr("'O' Output set to '%s'\n",swfile);
#endif	/* DEBUG */
			break;
		case 'k':
			kflag++;
			break;
		default:
			usage();
		}
	}
	Buf = (char *)zmalloc(EERROR, CPIOBSZ + PALIGNSZ);	/* mu2 */
	Buf = PALIGN(Buf);					/* mu2 */
	argc -= optind;
	argv += optind;
	switch(Option) {
	case OUT:
		if (kflag)
			fperr("`k' option is irrelevant with the `-o' option\n");
		if(argc != 0)
			usage();
		if (ioctl(Output,PERGET,&ct_type) >= 0) {
			if (ct_type == ct_CART || ct_type == ct_NINE)		
				ct_option |= ct_OUT;
		}				

		Cbuf = (char *)zmalloc( EERROR, Bufsize + PALIGNSZ); 
		Cp = Cbuf = PALIGN(Cbuf);			    
		(void)fstat(Output, &Astatb);
		/* get filename, copy header and file out */
		while(getname()) {
			if(!A_special && ident(&Statb, &Astatb))
				continue;
			filesz = mklong(Hdr.h_filesize);

			if (A_nacl) {
				if (Cflag)
					bwrite(AclChdr, CHARS + AclHdr.h_namesize);
				else
					bwrite(&AclHdr, HDRSIZE + AclHdr.h_namesize);
				bwrite(Aclbuf, Aclbufsize);
				if(Acc_time)
					utime(AclHdr.h_name, &Statb.st_atime);
				/* If verbose option, print out file's name. */
				if(Verbose)
					verbdot( stderr, Aclbuf);
				continue;
		 	} 
			/* If not a regular file or symbolic link (file size
			 * is 0) then write the header and continue....
			 */
			else if (filesz == 0L) {
				if( Cflag )
					bwrite(Chdr,CHARS+Hdr.h_namesize);
				else
					bwrite(&Hdr, HDRSIZE+Hdr.h_namesize);
				if(Verbose)
					verbdot( stderr, Hdr.h_name);
			}
#ifdef SYMLINK
			/* ...If its a symbolic link, write the header, read
			 * the symbolic link and write the link as contents of
			 * the file.....
			 */
			else if ((Statb.st_mode & S_IFMT) == S_IFLNK) {
				/* Write the header...*/
				if( Cflag )
					bwrite(Chdr,CHARS+Hdr.h_namesize);
				else
					bwrite(&Hdr, HDRSIZE+Hdr.h_namesize);

				/* ...read the link file... */
				if ((ct=readlink(Hdr.h_name,Buf,filesz)) < 0) {
			 		fperr("Cannot read symbolic link %s\n",
						Hdr.h_name);
					continue;
				}

 				/* ...append with a NULL... */
				*(Buf + ct) = (char)'\0';

				/* ...write the link file. */
				bwrite(Buf, filesz);

				/* If verbose option, print out file's name. */
				if(Verbose)
					verbdot( stderr, Hdr.h_name);

				/* If -a option (modify access time), change
				 * the access time.
				 */
				if(Acc_time)
					utime(Hdr.h_name, &Statb.st_atime);
				continue;
			}
#endif

			else {

			if((Ifile = open(Hdr.h_name, O_RDONLY)) < 0) {
				fperr("<%s> ?\n", Hdr.h_name);
				continue;
			}
			if ( Cflag )
				bwrite(Chdr,CHARS+Hdr.h_namesize);
			else
				bwrite(&Hdr, HDRSIZE+Hdr.h_namesize);
			for ( ; filesz > 0; filesz -= CPIOBSZ) {      
				ct = filesz>CPIOBSZ? CPIOBSZ: filesz;
				errno = 0;
				if(read(Ifile, Buf, (unsigned)ct) < 0) {
					fperr("Cannot read %s\n", Hdr.h_name);
					continue;
				}
				bwrite(Buf,ct);
			}
			close(Ifile);
			if(Acc_time)
				utime(Hdr.h_name, &Statb.st_atime);
			if(Verbose)
				verbdot( stderr, Hdr.h_name);
			} 

			if (A_uacl) {
				if (Cflag)
					bwrite(AclChdr, CHARS + AclHdr.h_namesize);
				else
					bwrite(&AclHdr, HDRSIZE + AclHdr.h_namesize);
				bwrite(Aclbuf, Aclbufsize);
		 	} 
			if (A_dacl) {
				if (Cflag)
					bwrite(DaclChdr, CHARS + DaclHdr.h_namesize);
				else
					bwrite(&DaclHdr, HDRSIZE + DaclHdr.h_namesize);
				bwrite(Daclbuf, Daclbufsize);
		 	} 
		}   /* end while (getname()) */
		/*
		 * Copy trailer, after all files have been copied.
		 */
		strcpy(Hdr.h_name, HTRAILER);
		Hdr.h_magic = M_BINARY;
		MKSHORT(Hdr.h_filesize, 0L);
		Hdr.h_namesize = strlen(HTRAILER) + 1;
#ifdef	DEBUG
		if (deblevel)
/*mu6*/			fperr("'o' write header for '%s'\n",Hdr.h_name);
#endif	/* DEBUG */
		if ( Cflag )  {
			bintochar(Chdr,Hdr.h_name,0L);
			bwrite(Chdr, CHARS+Hdr.h_namesize);
		}
		else
			bwrite(&Hdr, HDRSIZE+Hdr.h_namesize);
		if (Cbuf != Cp) /* Does the write buffer have any chars in it ? 
				   If yes then flush the buffer.*/
			bwrite(Cbuf, Bufsize);
		break;

	case IN:
		if (BigGflag && !(Bufsize == FASTBSIZE || Bufsize == FASTSSIZE)) {
			fperr( "-G option can only be used with -C option set \
to = %d or %d\n",FASTSSIZE,FASTBSIZE);
			exit(2);
		}
		
#ifdef	ARIX
		if (ioctl(Input,PERGET,&ct_type) >= 0) {	/* mu2	*/
			if (ct_type == ct_CART || ct_type == ct_NINE)	/* mu2	*/
				ct_option |= ct_IN;		/* mu2	*/
#ifdef	DEBUG
		if (deblevel)
/*mu6*/			fperr("'i' input device type is %d\n",ct_type);
#endif	/* DEBUG */
		}						/* mu2	*/
		if ((ct_option & ct_IO) && BigGflag && 
		    ((Bufsize == FASTSSIZE) || (Bufsize == FASTBSIZE))) {
			Cbuf2nd = (char *)zmalloc(EERROR,
				(Bufsize + CHARS + PATHSIZE + PALIGNSZ)) +
				CHARS + PATHSIZE;
			Cbuf2nd = PALIGN(Cbuf2nd);
		}						/* mu3	*/
#endif	/* ARIX */
#ifdef	DEBUG
		if (deblevel)
/*mu6*/			fperr("'i' Bufsize is %d\n",Bufsize);
#endif	/* DEBUG */
		Cbuf = (char *)zmalloc(EERROR,			   /* mu2 */
			(Bufsize + CHARS + PATHSIZE + PALIGNSZ)) + /* mu2 */
			CHARS + PATHSIZE;			   /* mu2 */
		Cbuf = PALIGN(Cbuf);			   /* mu2, mu4 */
#ifdef	ARIX
/*mu4*/		Cbuf1st = Cbuf;
#endif	/* ARIX */
		if(argc > 0 ) {	/* save patterns, if any */
			Pattern = argv;
		}
		Cflag = NONE;
		pwd();
		tmpsz = ULIMBSIZE * ulimit(1);			/* mu1 */
		/*
		 *	If we overflow then try to create the largest
		 *	positive number allowed.
		 *	mu1, mu7
		 */
		if (tmpsz < 0) {				/* mu1 */
			/*
			 *	DON'T merge the following two lines or
			 *	the sign conversion will kill the intent
			 *	to create the largest positive number.
			 *	mu1, mu7
			 */
			maxsz = -1;				/* mu1 */
			maxsz >>= 1;				/* mu1 */
		} else						/* mu1 */
			maxsz = tmpsz;				/* mu1 */

		while(gethdr()) {
				
			if (A_uacl) {
				if (Hdr.h_nlink > 1)
					if (!uacl_link_list(Hdr.h_name, &Hdr))
						continue;  /* unnamed acl was linked */
				if (acl(Hdr.h_name, SETACL, Aclbuf + Hdr.h_namesize,
				 	 Aclbufsize - Hdr.h_namesize) < 0) {
					fperrno("cpio: create unamed acl error %s\n", Hdr.h_name);
				}
				continue;
			}
			if (A_dacl) {
				add_to_daclist(Hdr.h_name, Aclbuf, &Hdr);
				continue;
			}

			if( (select = ckname(Hdr.h_name))  &&  !Toc ) 
				Ofile = openout(Hdr.h_name);
			else
				Ofile = 0;

			
			if (!A_nacl) {  /* non-acl processing */

				filesz=mklong(Hdr.h_filesize);
				if(select && maxsz < filesz) {
					select = Ofile = 0;
					fperr("%s skipped: exceeds ulimit by %d bytes\n",
						Hdr.h_name, filesz - maxsz);
				}
				first = 1;
				if (Cflag == BINARY && (filesz % 2) == 1)
					i = 1;
				else
					i = 0;
	
				for ( ; filesz > 0; filesz -= CPIOBSZ) {      
					ct = filesz>CPIOBSZ? CPIOBSZ: filesz;
					errno = 0;
					if(bread(Buf, ct, filesz + i) == -1) {
						fperr("cpio: i/o error, %s is corrupt\n",
							Hdr.h_name);
						break;
					}
					
					/* skip to next file */
					if(Ofile) {
						if(Swap)
							swap(Buf,ct);
						errno = 0;
						if((rc = write(Ofile, Buf, ct)) < ct) {
							if(rc < 0) {
								if(first++ == 1) {
						 			fperrno(
									"Cannot write %s\n",
									Hdr.h_name);
								}
								if (errno == EFBIG || errno == ENOSPC)
									continue;
								else
									exit(2);
							}
							else {
						 		fperr("%s truncated\n",
									Hdr.h_name);
								continue;
							}
						}
					}
				}  /* for loop end */
				if( Ofile ) {
					zclose( EERROR, Ofile );
					zchmod( EWARN, Hdr.h_name, Hdr.h_mode);
					set_time(Hdr.h_name,mklong(Hdr.h_mtime),
					mklong(Hdr.h_mtime));
				}
			} /* end of exclusive non-acl processing  */
			if(select) {
				if(Verbose)
					if(Toc)
						pentry(Hdr.h_name);
					else
						verbdot(stdout,Hdr.h_name);
				else
					if (Toc) {
						fputs(Hdr.h_name,stdout);
						fputc('\n',stdout);
					}
			}
		}  /* while (gethdr()) end */
		if (aclflag) 
			set_def_acl();
		break;

	case PASS:		/* move files around */
		if(Rename)
			errmsg(EERROR,"Pass and Rename cannot be used together.");
		if(kflag)
			fperr("`k' option is irrelevant with the `-p' option\n");
		if( Bufsize != BUFSIZE ) {
			fperr("`B' or `C' option is irrelevant with the '-p' option\n");
			Bufsize = BUFSIZE;
		}
		if(argc != 1)
			usage();
		if(access(argv[0], 2) == -1) {
			errmsg( EERROR, "cannot write in <%s>", argv[0]);
		}
		strcpy(Fullname, argv[0]);	/* destination directory */
		zstat( EERROR, Fullname, &Xstatb );
		if((Xstatb.st_mode&S_IFMT) != S_IFDIR)
			errmsg( EERROR, "<%s> not a directory.", Fullname );
		Dev = Xstatb.st_dev;
		if( Fullname[ strlen(Fullname) - 1 ] != '/' )
			strcat(Fullname, "/");
		fullp = Fullname + strlen(Fullname);
		while(getname()) {
			if (A_directory && !Dir)
				fperr("Use `-d' option to copy <%s>\n",
					Hdr.h_name);
			if(!ckname(Hdr.h_name))
				continue;
			i = 0;
			while(Hdr.h_name[i] == '/')
				i++;
			strcpy(fullp, &(Hdr.h_name[i]));

			/* for named acls we're linking if following if succeeds */
			if( PassLink  &&  !A_directory  &&  Dev == Statb.st_dev ) {
				if(link(Hdr.h_name, Fullname) < 0) {
					switch(errno) {
						case ENOENT:
							if(missdir(Fullname) != 0) {
								fperr(
									"cpio: cannot create directory for <%s>: %s\n",
									Fullname, sys_errlist[errno]);
								continue;
							}
							break;
						case EEXIST:
							if(unlink(Fullname) < 0) {
								fperr(
									"cpio: cannot unlink <%s>: %s\n",
									Fullname, sys_errlist[errno]);
								continue;
							}
							break;
						default:
							fperr(
								"Cpio: cannot link <%s> to <%s>: %s\n",
								Hdr.h_name, Fullname, sys_errlist[errno]);
							continue;
						}
					if(link(Hdr.h_name, Fullname) < 0) {
						fperr(
							"cpio: cannot link <%s> to <%s>: %s\n",
							Hdr.h_name, Fullname, sys_errlist[errno]);
						 continue; 
					}
				}

				goto ckverbose;
			}
#ifdef SYMLINK
			if (((Hdr.h_mode&S_IFMT) == S_IFLNK) && !follow_flag) {
				filesz = Statb.st_size;
				if ((readlink(Hdr.h_name,Symlink_path,filesz)) < 0) {
					fperr("Cannot read symbolic link %s\n",
						Hdr.h_name);
					continue;
				}
				Symlink_path[filesz] = '\0';
				missdir(Fullname);
				if (symlink(Symlink_path, Fullname) < 0) {
					fperr("Cannot create %s\n",
						Hdr.h_name);
					continue;
				}
			}
			else {
#endif
				Ofile = openout(Fullname);
				if (*LastFile != '\0') {
					if (A_uacl) {
						if (AclHdr.h_nlink > 1)
							if (!uacl_link_list(Fullname, &AclHdr))
								continue;  /* unnamed acl was linked */
						if (acl(Fullname, SETACL, Aclbuf + Hdr.h_namesize,
				 			 Aclbufsize - Hdr.h_namesize) < 0) {
							fperrno("cpio: create unamed acl error %s\n", Hdr.h_name);
						}
					}
					if (A_dacl) {
						add_to_daclist(Fullname, Daclbuf, &DaclHdr);
						continue;
					}
				}
				if (!Ofile)
					continue;

				if((Ifile = zopen( EWARN, Hdr.h_name, 0)) < 0) {
					close(Ofile);
					continue;
				}
				filesz = Statb.st_size;
				for(; filesz > 0; filesz -= CPIOBSZ) {
					ct = filesz>CPIOBSZ? CPIOBSZ: filesz;
					errno = 0;
					if(read(Ifile, Buf, (unsigned)ct) < 0) {
						fperr("Cannot read %s\n", Hdr.h_name);
						break;
					}
					if (Ofile) {
						errno = 0;
						if (write(Ofile, Buf, ct) < 0) {
							fperr("Cannot write %s\n", Hdr.h_name);
							break;
						}
					}
					/* Removed u370 ifdef which caused cpio */
					/* to report blocks in terms of 4096 bytes. */
					Blocks += ((ct + (BUFSIZE - 1)) / BUFSIZE);
				}
				close(Ifile);
				close(Ofile);
			}
			if(Acc_time)
				utime(Hdr.h_name, &Statb.st_atime);
			zchmod( EWARN, Fullname, Hdr.h_mode);
			set_time(Fullname, Statb.st_atime, mklong(Hdr.h_mtime));
ckverbose:
			if(Verbose)
				verbdot( stdout, Fullname );
		}
		if (aclflag)
			set_def_acl();
		break;

	default:
		errmsg(EERROR,"Options must include one: -o, -i, -p.");
	}
	/* print number of BUFSIZE blocks actually copied */
	Blocks = (Blocks * Bufsize + sBlocks + (BUFSIZE - 1))/BUFSIZE;
	fperr("%ld blocks\n", Blocks);
	exit(0);
}


usage()		/* cleanup usage (mu1) */
{
register char	*t;						/* mu3 */
extern	 char	*strrchr();					/* mu3 */
char ostring1[60], ostring2[60], istring1[80], istring2[80];

	strcpy(ostring1,"-o[acvVBLZ] [-Cbsize] [-Mmesg] [< name-list] > collection");
	strcpy(ostring2,"-o[acvVBLZ] -Ocollection [-Cbsize] [-Mmesg] [< name-list]");
	strcpy(istring1,"-i[bcdGkmrsStuvVfB6LZ] [-Cbsize] [-Mmesg] [pat ...] < collection");
	strcpy(istring2,"-i[bcdGkmrsStuvVfB6LZ] -Icollection [-Cbsize] [-Mmesg] [pat ...]");
	if (cpio_environ == POSIX_ENVIRON) {
		ostring1[4]='g';
		ostring2[4]='g';
		istring1[4]='g';
		istring2[4]='g';
	}
	errusage("%s\n\t%s\n\t%s\n\t%s\n\t%s\n",
#ifdef	ARIX
ostring1,
#else	/* ARIX */
"-o[acvVB] [-Cbufsize] [-Mmessage] [name-list] > collection",
#endif	/* ARIX */
#ifdef	ARIX
ostring2,
#else	/* ARIX */
"-o[acvVB] -Ocollection [-Cbufsize] [-Mmessage] [name-list]",
#endif	/* ARIX */
#ifdef	ARIX
istring1,
#else	/* ARIX */
"-i[bcdkmrsStuvVfB6] [-Cbufsize] [-Mmessage] [pat ...] < collection",
#endif	/* ARIX */
#ifdef	ARIX
istring2,
#else	/* ARIX */
"-i[bcdkmrsStuvVfB6] -Icollection [-Cbufsize] [-Mmessage] [pat ...]",
#endif	/* ARIX */
"-p[aAdlmuvVLZ] target-directory [name-list]");				/*mu3*/
}

chkswfile( sp, c, option )
char	*sp;
char	c;
short	option;
{
	if( !option )
		errmsg( EERROR, "-%c must be specified before -%c option.",
			c == 'I' ? 'i' : 'o', c );
	if( (c == 'I'  &&  option != IN)  ||  (c == 'O'  &&  option != OUT) )
		errmsg( EERROR, "-%c option not permitted with -%c option.", c,
			option );
	if( !sp )
		return;
	errmsg( EERROR, "No more than one -I or -O flag permitted.");
}

cannotopen( sp, mode )
char	*sp, *mode;
{
	errmsg( EERROR, "Cannot open <%s> for %s.", sp, mode );
}

getname()		/* get file name, get info for header */
{
	register char *namep;	/* sw6 */
	register ushort ftype;
	long tlong;

	for(;;) {
		namep = Name;	/* reset namep - sw6 */
		if(gets(namep) == NULL)
			return 0;
		while(*namep == '.' && namep[1] == '/') {
			namep++;
			while(*namep == '/') namep++;
		}
		strcpy(Hdr.h_name, namep);
#if SYMLINK
		if(lstat(namep, &Statb) < 0) {
			errmsg(EWARN, "Cannot lstat <%s>.", namep); 
			continue;
		}
		else if (((Statb.st_mode & S_IFMT) == S_IFLNK) && follow_flag) {
			if (stat(namep, &Statb) < 0) {
				errmsg(EWARN, "Cannot follow \"%s\"", namep);
				continue;
			}
		}
#else
		if(zstat( EWARN, namep, &Statb) < 0) {
			continue;
		}
#endif
		ftype = Statb.st_mode & Filetype;
		A_directory = (ftype == S_IFDIR);
		A_special = (ftype == S_IFBLK)
			|| (ftype == S_IFCHR)
			|| (ftype == S_IFIFO);
		A_uacl = A_nacl = A_dacl = 0;
		fill_bin_hdr(&Hdr, &Statb);
#ifdef SYMLINK
		if ((Hdr.h_mode&S_IFMT) == S_IFREG
		|| (Hdr.h_mode&S_IFMT) == S_IFLNK) {
				tlong = Statb.st_size;
		}
		else
			tlong = 0L;
#else
		tlong = (Hdr.h_mode&S_IFMT) == S_IFREG? Statb.st_size: 0L;
#endif
		MKSHORT(Hdr.h_filesize, tlong);
		if( Cflag )
			bintochar(Chdr, Hdr.h_name, tlong);
		if (aclflag) {
			if (acl(namep, ACLSTAT, &Aclstat) >= 0) {
				Aclbufsize = (int) Aclstat.st_size;
				if (Aclstat.st_ino == Statb.st_ino)
					A_nacl = 1;
				else 
					A_uacl = 1;
				if (Aclbufsize == 0) {
					if (A_nacl)
						continue;
					else 	
						A_uacl = 0;
				}
				else { /*  Aclbufsize != 0 */
					if (acl(namep, GETACL,&Aclbuf[strlen(namep)+1],
				    Aclbufsize) < 0) {
						if (A_nacl) {
							fperrno("Can't GETACL for named acl <%s>\n", namep);
							continue;
						}
						else {
							fperrno("Can't GETACL for file <%s>\n", namep);
							A_uacl = 0;
						}
					}
					else { /* GETACL was successful */
						strcpy(Aclbuf, namep);
						strcpy(AclHdr.h_name, A_nacl ? Naclname:
					       Uaclname);
						Aclstat.st_mode |= 0666;
						fill_bin_hdr(&AclHdr, &Aclstat);
						Aclbufsize += Hdr.h_namesize;
						tlong = Aclbufsize;
						MKSHORT(AclHdr.h_filesize, tlong);
						if (Cflag)
							bintochar(AclChdr, AclHdr.h_name, tlong);
						if (A_nacl)
							break;
					} 	/* end if acl(GETACL) */
				} /* end if Aclbufsize == 0  */
			} 	/* end if acl(ACLSTAT) */
			if (A_directory) {
				if (acl(namep, ACLSTAT_DEFAULT, &Daclstat) >= 0) {
					Daclbufsize = (int)Daclstat.st_size;
					if (Daclbufsize == 0) 
						A_dacl = 0;
					else {
						A_dacl = 1;
						if (acl(namep, GETACL_DEFAULT, &Daclbuf[strlen(namep)+1],
						    Daclbufsize) < 0) {
							fperrno("Can't GETACL_DEFAULT for directory <%s>\n", namep);
							A_dacl = 0;
						}
						else {
								strcpy(Daclbuf, namep);
								strcpy(DaclHdr.h_name, Daclname);
								Daclstat.st_mode |= 0666;
								fill_bin_hdr(&DaclHdr, &Daclstat);
								Daclbufsize += Hdr.h_namesize;
								tlong = Daclbufsize;
								MKSHORT(DaclHdr.h_filesize, tlong);
								if( Cflag )
									bintochar(DaclChdr, DaclHdr.h_name, tlong);
						} /* end if GETACL_DEFAULT  */
					} /* end if Daclbufsize ==0 */
				} /* end of ACLSTAT_DEFAULT */
			} /* end of A_directory  */
		} 
		else {  /* if !aclflag don't export named acls */
			if (!A_directory && !A_special) 
				if (acl(namep, ACLSTAT, &Aclstat) >= 0) {
					if (Aclstat.st_ino == Statb.st_ino)
						continue; /* don't export named acl */
				}
		}
 		break;
	} /* end for loop */
	return 1;
}

void
fill_bin_hdr(XHdr, Xstat)
struct header *XHdr;
struct stat *Xstat;
{
	XHdr->h_magic = M_BINARY;
	XHdr->h_namesize = strlen(XHdr->h_name) + 1;
	XHdr->h_uid = Xstat->st_uid;
	XHdr->h_gid = Xstat->st_gid;
	XHdr->h_dev = Xstat->st_dev;
	XHdr->h_ino = Xstat->st_ino;
	XHdr->h_mode = Xstat->st_mode;
	MKSHORT(XHdr->h_mtime, Xstat->st_mtime);
	XHdr->h_nlink = Xstat->st_nlink;
	XHdr->h_rdev = Xstat->st_rdev;
}

bintochar(Xhdr, BinHdrname, t)		/* ASCII header write */
char *Xhdr, *BinHdrname;
long t;
{
	sprintf(Xhdr,"%.6o%.6ho%.6ho%.6ho%.6ho%.6ho%.6ho%.6ho%.11lo%.6ho%.11lo%s",
		M_BINARY, MK_USHORT(Statb.st_dev), MK_USHORT(Statb.st_ino), Statb.st_mode, Statb.st_uid,
		Statb.st_gid, Statb.st_nlink, MK_USHORT(Statb.st_rdev),
		Statb.st_mtime, (short)strlen(BinHdrname)+1, t, BinHdrname);
}

chartobin()		/* ASCII header read */
{
	sscanf(Chdr, "%6ho%6ho%6ho%6ho%6ho%6ho%6ho%6ho%11lo%6ho%11lo",
		&Hdr.h_magic, &Hdr.h_dev, &Hdr.h_ino, &Hdr.h_mode, &Hdr.h_uid,
		&Hdr.h_gid, &Hdr.h_nlink, &Hdr.h_rdev, &Longtime,
		&Hdr.h_namesize, &Longfile);
	MKSHORT(Hdr.h_filesize, Longfile);
	MKSHORT(Hdr.h_mtime, Longtime);
}

gethdr()		/* get file headers */
{
	register ushort ftype;
	int i;

	for (;;) {
		A_uacl = A_nacl = A_dacl = 0;
		filesz = Have = 0;
		synch();
		if(EQ(Hdr.h_name, HTRAILER))
			return 0;
		ftype = Hdr.h_mode & Filetype;
		/* the file type for a default acl is a directory */
		A_directory = (ftype == S_IFDIR && strcmp(Daclname, Hdr.h_name) &&
							strcmp(Uaclname, Hdr.h_name));
		A_special = (ftype == S_IFBLK)
			||  (ftype == S_IFCHR)
			||  (ftype == S_IFIFO);
		if (!A_directory && !A_special) {
			if (!strcmp(Uaclname, Hdr.h_name)) {
				A_uacl = 1;
			}
			else if (!strcmp(Naclname, Hdr.h_name)) {
				A_nacl = 1;
			}
			else if (!strcmp(Daclname, Hdr.h_name)) {
				A_dacl = 1;
			}
			if (A_uacl || A_nacl || A_dacl) {
				filesz = mklong(Hdr.h_filesize);
				Aclbufsize = filesz;
				if (Cflag == BINARY && (filesz % 2) == 1)
					i = 1;
				else
					i = 0;
				if (bread(Aclbuf, filesz, filesz + i) == -1) {
					fperrno("cpio: i/o error %s is corrupt\n",Hdr.h_name);
					continue;
				}
			/* skip acl because acl processing not on */
				if (!aclflag)
					continue;
				else {
					strcpy(Hdr.h_name,Aclbuf);
					Hdr.h_namesize = strlen(Hdr.h_name) + 1;
					if (A_uacl || A_dacl) {
						if (Toc)
							continue;
					/* skip to next file if the file last successfully read
						was not related to this unnamed or default acl */
						if (*LastFile == '\0')
							continue;
						else {
							if (*RenamedFile == '\0') {
								if (strcmp(Aclbuf, LastFile))
									continue;
							}
							else {
								if (strcmp(Aclbuf, RenamedFile))
									continue;
								else 
									strcpy(Hdr.h_name, LastFile); /* new filename */
							}
						}
				   	return 1;
					}
				}
			}
		}
		*RenamedFile = '\0';
		*LastFile = '\0';
		return 1;
	} /*  end for loop  */
}

ckname(namep)	/* check filenames with patterns given on cmd line */
register char *namep;
{
	char	buf[sizeof Hdr.h_name];

	if(fflag ^ !nmatch(namep, Pattern)) {
		return 0;
	}
	if(Rename && !A_directory) {	/* rename interactively */
		fprintf(Wtty, "Rename <%s>\n", namep);
		fflush(Wtty);
		fgets(buf, sizeof buf, Rtty);
		if(feof(Rtty))
			exit(2);
		buf[strlen(buf) - 1] = '\0';
		if(EQ(buf, "")) {
			strcpy(namep,buf);
			printf("Skipped\n");
			return 0;
		}
		else if(EQ(buf, "."))
			printf("Same name\n");
		else {
			strcpy(RenamedFile,namep);
			strcpy(namep,buf);
		}
	}
	return  1;
}

openout(namep)	/* open files for writing, set all necessary info */
register char *namep;
{
	register f;
	register char *np;
	int ans;
	struct stat Temp_acl_stat;
  struct stat Temp_stat;
#ifdef	SYMLINK
	int	res;
	char	*illegal_ip_access();
	char	*llbufptr; /* points to low level buffer */
#endif

	if (aclflag)
		strcpy(LastFile, namep);
	if(!strncmp(namep, "./", 2))
		namep += 2;
	np = namep;
	/* Handle directories.... */
	if(A_directory) {
		if( !Dir ||  (Rename && !aclflag) ||  EQ(namep, ".")  ||  EQ(namep, "..")) {
			/* do not consider . or .. files */
			*LastFile = '\0';
			return 0;
		}
		if(stat(namep, &Xstatb) == -1) {

/* try creating (only twice) */
			(void) umask(orig_umask);
			ans = 0;
			do {
				if (mkdir(namep, df_mode)) {
					ans += 1;
				}else {
					ans = 0;
					break;
				}
			}while(ans < 2 && missdir(namep) == 0);
			(void) umask(0);
			if(ans == 1) {
				fperrno("Cannot create directory for <%s>",
					namep);
				*LastFile = '\0';
				return(0);
			}else if(ans == 2) {
				fperrno("Cannot create directory <%s>", namep);
				*LastFile = '\0';
				return(0);
			}
		}

ret:
		zchmod( EWARN, namep, Hdr.h_mode);
		if(Uid == 0)
			zchown( EWARN, namep, Hdr.h_uid, Hdr.h_gid);
		if (aclflag && A_directory && Uncond) {
			if (acl(namep, ACLSTAT, &Temp_acl_stat) >= 0) {
				if (acl(namep, ACL_UNLINK, (char *) 0, 0) < 0) {
					fperrno("cpio: unable to unlink ACL from directory %s \n",namep);
				}
			}
			if (acl(namep, ACLSTAT_DEFAULT, &Temp_acl_stat) >= 0 ) {
				if (acl(namep, ACL_UNLINK_DEFAULT, (char *) 0, 0) < 0) {
					fperrno("cpio: unable to unlink default ACL from directory %s \n",namep);
				}
			}
		}
		
		set_time(namep, mklong(Hdr.h_mtime), mklong(Hdr.h_mtime));
		return 0;
	}
	/* ...handle hard links... */
	if(Hdr.h_nlink > 1 && !A_nacl)
		if(!postml(namep, np))
			return 0;

#ifdef SYMLINK
	/* lstat the file, if it exists an uncond or special and not root, try
	 * to remove the file.
	 */
	if (lstat(namep, &Xstatb) == 0) {
#else
	if (stat(namep, &Xstatb) == 0) {
#endif
		if(Uncond && !((!(Xstatb.st_mode & S_IWRITE) || A_special) && (Uid != 0))) {
			/* this fixes a serious bug: that directories and the files they
			contain are destroyed if files with same names are allowed
 			to replace directories with the same name  */
			if (stat(namep,&Temp_stat) >= 0) {
				if (Temp_stat.st_mode & S_IFDIR) {
					fperr("cannot replace directory with a file that has the same \
name <%s>\n", namep);
					*LastFile = '\0';
					return 0;
				}
			}
			if(unlink(namep) < 0) {
				fperrno("cannot unlink current <%s>", namep);
			}
		}
		if(!Uncond && (mklong(Hdr.h_mtime) <= Xstatb.st_mtime)) {
		/* There's a newer or same aged version of file on destination */
			fperr("current <%s> newer or same age\n", np);
			*LastFile = '\0';
			return 0;
		}
	}
	if( Option == PASS
		&& Hdr.h_ino == Xstatb.st_ino
		&& Hdr.h_dev == Xstatb.st_dev) {
		errmsg( EERROR, "Attempt to pass file to self!");
	}
	/* ...handle special files... */
	if(A_special) {
		if((Hdr.h_mode & Filetype) == S_IFIFO)
			Hdr.h_rdev = 0;

/* try creating (only twice) */
		ans = 0;
		do {
			if(mknod(namep, Hdr.h_mode, Hdr.h_rdev) < 0) {
				ans += 1;
			}else {
				ans = 0;
				break;
			}
		}while(ans < 2 && missdir(np) == 0);
		if(ans == 1) {
			fperrno("Cannot create directory for <%s>", namep);
			*LastFile = '\0';
			return(0);
		}else if(ans == 2) {
			fperrno("Cannot mknod <%s>", namep);
			*LastFile = '\0';
			return(0);
		}

		goto ret;
	}

/* try creating (only twice) */
	/* Handle regular files (including symbolic links) */
	ans = 0;
	do {
#ifdef	SYMLINK
		if ((Hdr.h_mode&S_IFMT) == S_IFLNK) {
			llbufptr = illegal_ip_access();
			filesz = mklong(Hdr.h_filesize);
			strncpy(Symlink_path, llbufptr, filesz);
			Symlink_path[filesz] = '\0';
			if ((res = symlink(Symlink_path, Hdr.h_name)) >= 0) {
				ans = 0;
				break;
			}
			ans += 1;
		} 
		else 
#endif
			if (A_nacl) {
				if (acl( namep, SETNACL, Aclbuf + Hdr.h_namesize,
			 	 Aclbufsize - Hdr.h_namesize) < 0) 
					ans += 1;
				else {
					ans = 0;
					break;
				}
			}
			else 
				if((f = creat(namep, Hdr.h_mode)) < 0) {
					ans += 1;
				} else {
						ans = 0;
						break;
				}
	}while(ans < 2 && missdir(np) == 0);

	if(ans == 1) {
		fperrno("Cannot create directory for <%s>", namep);
		*LastFile = '\0';
		return(0);
	}else if(ans == 2) {
		if (A_nacl) 
			fperrno("cpio: create named acl error %s\n", namep);
		else 
			fperrno("Cannot create <%s>", namep);
		*LastFile = '\0';
		return(0);
	}

#ifdef	SYMLINK
	if ((Hdr.h_mode&S_IFMT) == S_IFLNK)
		return(0);
#endif

	if(Uid == 0)
		zchown( EWARN, namep, Hdr.h_uid, Hdr.h_gid);
	if (A_nacl)
		return 0;
	return f;
}


/*
 * Shared by bread(), synch() and rstbuf()
 */
int	nleft = 0;	/* unread chars left in Cbuf and expan buffer */
char	*ip;		/* pointer to next char to be read from Cbuf  */
				/* and expansion buffer*/
int	filbuf = 0;	/* flag to bread() to fill buffer but transfer*/
				/* no characters			*/

/* bread() is called by rstbuf() in order to read the next block	*/
/* from the input archive into Cbuf.  bread() is called by main(),	*/
/* case: IN, in order to read in file content to then be written out.	*/
/* In case of I/O error bread() exits with return code 2 unless kflag	*/
/* is set.  If kflag is set then bread attempts a max of 10 times to	*/
/* successfully lseek then read good data.  If 10 consecutive reads	*/
/* fail bread() exits with return code 2.  Upon a successful read()	*/
/* bread() leaves nleft and the pointers ip and p set correctly but no	*/
/* characters are copied and bread() returns -1.  In the case of no I/O	*/
/* errors bread() reads from the input archive to Cbuf and then copies	*/
/* chars to a target buffer unless filbuf is set by rstbuf().		*/

/* d, distance to lseek if I/O error encountered with -k option.*/
/* Converted to a multiple of Bufsize				*/
bread(b, c, d)
register char	*b;
register int	c;
long d;
{
	register char	*p = ip;
	register int	dcr;
	register int	rv;
	int rc = 0, delta = 0, i = 0;
	register int debc = c;

#ifdef	DEBUG
	if (deblevel > 2)
		fperr("\n");
#endif	/* DEBUG */
	if (filbuf == 1) {	/* fill buffer, memcpy no chars */
#ifdef	DEBUG
		if (deblevel > 2)
			fperr("'r' filbuf, c=%d, nleft=%d\n",c,nleft);
#endif	/* DEBUG */
		nleft = 0;
		c = 0;
	}
	if( !Cflag ) {
		/* round c up to an even number */
		c = (c+1)/2;
		c *= 2;
	}
	while ( c || filbuf )  {
		while (nleft == 0 ) {
#ifdef	DEBUG
		if (deblevel > 2)
			fperr("'r' ask=%d, have=%d, need=%d, fileleft=%d\n",
				debc,debc-c,c,filesz-debc+c);
#endif	/* DEBUG */
#ifdef	ARIX
			if ((ct_option & ct_IO) && BigGflag &&
		    	    (Bufsize == FASTBSIZE || Bufsize == FASTSSIZE)) {	
/*mu7*/				Have = debc - c;
/*mu4*/				if (Bufsize == FASTBSIZE)
/*mu4*/					rv = bigbread();
/*mu4*/				else
/*mu4*/					rv = smallbread();
/*mu4*/			} else
#endif	/* ARIX */
			while (TRUE) {
				errno = 0;
/* REE - adjust to bypass 2 GB limit - lseek has no real effect
  except to reset u.u_offset */
				if( ct_option & ct_IN && !(Blocks % 100000)) {
					lseek(Input,0,0);
				}

				rv = read(Input, Cbuf, Bufsize);
#ifdef	ARIX
/*mu4*/				if ((rv == 0) || ((rv == -1) && (errno == ENOSPC || errno == ENXIO || errno == EIO)))
#else	/* ARIX */
				if ((rv == 0) || ((rv == -1) && (errno == ENOSPC || errno == ENXIO)))
#endif	/* ARIX */
#ifdef	DEBUG
				{
		if (deblevel < 2)
			fperr("\n");
		if (deblevel)
			fperr("'r' ask=%d, got=%d, need=%d, fileleft=%d\n",
				Bufsize,rv,Bufsize-rv,filesz-rv-debc+c);
#endif	/* DEBUG */
					Input = chgreel(0, Input, rv);
#ifdef	DEBUG
				}
#endif	/* DEBUG */
				else
					break;
			}
			if( rv == -1 ) {
				int s, rvl;
				if( kflag ) {
					if (i++ > 10) {
						fperr("cpio: cannot recover from I/O error, %s\n",
							sys_errlist[errno]);
						exit(2);
					}
					rvl = lseek(Input,
						(s = d / Bufsize) == 0 ? Bufsize : s * Bufsize, 1); 
					if(i == 1) {
						if (rvl != -1 && (d % Bufsize)
						   && d > Bufsize)
							delta = (d % Bufsize);
						d = 0;
						rc = -1;
					}
					else
						delta = 0;
				}
				else
					errmsg( EERROR,
						"Read() in bread() failed\n");
			}
			else {
				if (rv == Bufsize)
					++Blocks;
				else 				/* short read */
					sBlocks += rv;
				if (rv > delta) {
					nleft = rv - delta;
					p = Cbuf + delta;
				}
				else {
					nleft = 0;
					delta -= rv;
				}
			}
		}
		if (filbuf || i > 0) {
			filbuf = 0;
			break;
		}
		if (nleft <= c)
			dcr = nleft;
		else
			dcr = c;
		memcpy( b, p, dcr );
		c -= dcr;
		d -= dcr;
		b += dcr;
		p += dcr;
		nleft -= dcr;
	}
	ip = p;
	return(rc);
}

/* synch() searches for headers.  Any Cflag specification by the */
/* user is ignored.  Cflag is set appropriately after a good    */
/* header is found.  It searches for and verifies all headers.  */
/* Unless kflag is set only one failure of the header causes an */
/* exit(2).  I/O errors during examination of any part of the   */
/* header causes synch() to throw away current data and begin	*/
/* again.  Other errors during examination of any part of the   */
/* header causes synch() to advance a single byte and continue   */
/* the examination.						*/
synch()
{
	register char	*magic;
	register int	hit = NONE, cnt = 0;
	int hsize, offset, align = 0;
	static int min = CHARS;
	union {
		char bite[2];
		ushort temp;
	} mag;

	if (Cflag == NONE) {
		filbuf = 1;
		if (bread(Chdr, 0, 0) == -1)
			fperr("cpio: I/O error, searching to next header\n");
	}
	magic = ip;
	do {
		while (nleft < min) {
			if (rstbuf(magic) == -1) ;
			magic = ip;
		}
		if (Cflag == ASCII || Cflag == NONE) {
			if (strncmp(magic, M_ASCII, M_STRLEN) == 0) {
				memcpy(Chdr, magic, CHARS);
				chartobin();
				hit = ASCII;
				hsize = CHARS + Hdr.h_namesize;
			}
		}
		if (Cflag == BINARY || Cflag == NONE) {
			mag.bite[0] = magic[0];
			mag.bite[1] = magic[1];
			if (mag.temp == M_BINARY) {
				memcpy(&Hdr, magic, HDRSIZE);
				hit = BINARY;
				hsize = HDRSIZE + Hdr.h_namesize;
				align =	((Hdr.h_namesize % 2) == 0 ? 0 : 1);
			}
		}
		if (hit == NONE) {
			magic++;
			nleft--;
		}
		else {
			if (hdck() == -1) {
				magic++;
				nleft--;
				hit = NONE;
				if (kflag)
				    fperr(
				    "cpio: header corrupted.  File(s) may be lost\n");
			}
			else {			/* consider possible alignment byte */
				while (nleft < hsize + align) {
					if (rstbuf(magic) == -1) {
						magic = ip;
						hit = NONE;
						break;
					}
					else 
						magic = ip;
				}
				if (hit == NONE)
					continue;
				if (*(magic + hsize - 1) != '\0') {
					magic++;
					nleft--;
					hit = NONE;
					continue;
				}
			}
		}
		if (cnt++ == 2)
			fperr(
			"cpio: out of sync.  searching for magic number/header\n");
	} while (hit == NONE && kflag);

	if (cnt > 2)
		fperr("cpio: re-synchronized on magic number/header\n");
	if (hit == NONE) {
		if (Cflag == NONE)
			errmsg( EERROR,
			"synch:  This is not a cpio file.  Bad header.");
		else
			errmsg( EERROR,
			"synch:  Out of sync.  Bad magic number/header.");
	}	
	if (hit == ASCII) {
		memcpy(Hdr.h_name, magic + CHARS, Hdr.h_namesize);
		Cflag = ASCII;
	}
	else {
		memcpy(Hdr.h_name, magic + HDRSIZE, Hdr.h_namesize + align);
		Cflag = BINARY;
		min = HDRSIZE;
	}
	offset = min + Hdr.h_namesize + align;
	ip = magic + offset;
	nleft -= offset;
}

/* rstbuf(), reset bread() buffer,  moves incomplete potential	*/
/* headers from Cbuf to an expansion buffer to the left of Cbuf.*/
/* It then forces bread() to replenish Cbuf.  Rstbuf() returns	*/
/* the value returned by bread() to warn synch() of I/O errors.	*/
/* nleft and ip are updated to reflect the new data available.	*/
rstbuf(ptr)
char *ptr;
{
	int rc = 0, eleft;		/* eleft: amt in expansion buffer */
	char	*expand_buf;		/* Where end of current expansion
					   buffer is, mer1 */

	/* There are 2 128k buffers, make sure that leftover data
	   is moved into the correct one, mer1 */
	if ( (!ct_option ) || (ct_option & ct_SECOND) || (!BigGflag) ) {
		expand_buf = Cbuf1st;
		}
	else {
		expand_buf = Cbuf2nd;
		}

	smemcpy(expand_buf - nleft, ptr, nleft); /* mv leftover bytes to expansion */
	eleft = nleft;			/*			   buffer */
	filbuf = 1;			/* force fill of Cbuf		  */

	if ((rc = bread(Chdr, 0, 0)) == -1)
		;		/* ip & nleft are ok */
	else {
		nleft += eleft;
		ip -= eleft;
	}

	return(rc);
}
			
#ifdef	SYMLINK
/* Sleazy routine allow me to access ip which should only be accessed by
 * bread(), synch() and rstbuf().
 */
char *
illegal_ip_access()
{
	return(ip);
}
#endif

/* hdck() sanity checks the fixed length portion of the cpio header	*/
/* -1 indicates a bad header and 0 indicates a good header		*/
hdck()
{
	if (Hdr.h_nlink < 1 ||
		mklong(Hdr.h_filesize) < 0 ||
		Hdr.h_namesize <= 0 ||
		Hdr.h_namesize >= PATHSIZE)
		return(-1);
	else
		return(0);
}

bwrite(rp, c)
register char *rp;
register c;
{
	register char	*cp = Cp;
	static unsigned	Ccnt = 0;
	register unsigned Cleft;
	register int	rv;

	if( !Cflag ) {
		/* round c up to an even number */
		c = (c + 1) >> 1;	/* mu3	*/
		c <<= 1;		/* mu3	*/
	}

/* REE - adjust to bypass 2 GB limit - lseek has no real effect
  except to reset u.u_offset */

	if( ct_option & ct_OUT && !(Blocks % 100000)) {
		lseek(Output,0,0);
	}

	while( c )  {
		if( (Cleft = Bufsize - Ccnt) <= c ) {
			memcpy( cp, rp, Cleft );
                        errno = 0;
                        rv = write(Output, Cbuf, Bufsize);
                        if( rv <= 0 )
                                rv = eomchgreel(rv);
			if( rv == Bufsize )
				{
				Ccnt = 0;
				cp = Cbuf;
				++Blocks;
				}
#ifdef	ARIX
			else
				if (rv < Bufsize) {
#ifdef	DEBUG
		if (deblevel)
			fperr("\n'w' wrote %d, should be %d\n",rv,Bufsize);
#endif	/* DEBUG */
					Output = chgreel(1,Output,0);
					smemcpy(Cbuf,&Cbuf[rv], (Bufsize-rv));
					Ccnt = Bufsize - rv;
					cp = &Cbuf[ Bufsize - rv ];
					sBlocks += rv;
				}
#else	/* ARIX */
			else if( rv < Bufsize )
				{
				Output = chgreel(1, Output, 0);
/*wrong*/			smemcpy( Cbuf, &Cbuf[ Bufsize - rv ], rv );
				Ccnt = Bufsize - rv;
/*wrong*/			cp = &Cbuf[ rv ];
				}
#endif	/* ARIX */
			else
				errmsg( EHALT,
					"Impossible return from write(), %d\n",
					rv );
			rp += Cleft;
			c -= Cleft;
		}
		else {
			memcpy( cp, rp, c );
			Ccnt += c;
			cp += c;
			/* rp += c;	/*	Don't need (mu3)	*/
			c = 0;
		}
	}
	Cp = cp;
}

struct dacllist {
	short	 d_dev;
	ushort d_ino;
	short	 d_link;
	long	filesize;
	char *file_contents;
} **dacl_list = 0;
unsigned daclsize = 0;
short dacl_recs = 0;

struct uacl {
	short	u_dev;
	ushort	u_ino;
	char	u_name[2];
} **uacl = 0;
unsigned	ulsize = 0;
unsigned	ulinks = 0;

/* add default acls to this list */
void 
add_to_daclist(Xname, Xaclbuf, DHdr) 
char *Xname;
char *Xaclbuf;
struct header *DHdr;
{
	/*   case IN:  The directory name is in Xname. gethdr() modified 
							   Hdr.h_name which was originally dacl_name and then 
								 case IN passed it to this routine.
		 case PASS:  The directory name in Xaclbuf has been prepended with 
								 the destination directory specified after the -p option
								 and placed in Xname */

	int filesz, Xnamesize, Xaclbuf_namesize;

	Xnamesize = strlen(Xname) + 1;
	Xaclbuf_namesize = strlen(Xaclbuf) + 1;
	filesz = (int) mklong(DHdr->h_filesize) - Xaclbuf_namesize + Xnamesize;
	if( !dacl_list ) {
		daclsize = DACL_RECS;
		dacl_list = (struct dacllist **) zmalloc( EERROR, daclsize * sizeof(struct dacllist *));
	}
	else 
		if( dacl_recs == daclsize ) {
			daclsize += DACL_RECS;
			dacl_list = (struct dacllist **) zrealloc( EERROR, 
								dacl_list, daclsize * sizeof(struct dacllist *));
		}

		if( !(dacl_list[dacl_recs] = (struct dacllist *) zmalloc( EWARN, sizeof(struct dacllist)))) {
			static int first2=1;

			if(first2)
				fperr("No memory for default acls - struct (%d)\n", dacl_recs);
			first2 = 0;
			return ;
	}

   /* remember that Xaclbuf first contains the filename that the default acl
      is associated with then the dacl contents */
	if( !(dacl_list[dacl_recs]->file_contents = 
	      (char *)zmalloc( EWARN, (unsigned int) filesz ))) {
		static int first1=1;

		if(first1)
			fperr("No memory for default acls - file_contents (%d)\n", dacl_recs);
		first1 = 0;
		return ;
	}
	
	dacl_list[dacl_recs]->d_dev = DHdr->h_dev;
	dacl_list[dacl_recs]->d_ino = DHdr->h_ino;
	dacl_list[dacl_recs]->d_link = DHdr->h_nlink;
	dacl_list[dacl_recs]->filesize = filesz;
	smemcpy(dacl_list[dacl_recs]->file_contents, Xname, Xnamesize);
	smemcpy(dacl_list[dacl_recs]->file_contents + Xnamesize, 
				Xaclbuf + Xaclbuf_namesize, filesz - Xnamesize);
	++dacl_recs;
}

void 
set_def_acl()
{
	int namesize, Uaclmatch;
	register int daclindex, uaclindex;
	register struct dacllist *dlp;

	for (daclindex=0; daclindex < dacl_recs; daclindex++) {
		dlp = dacl_list[daclindex];
		Uaclmatch = -1;

/* ----------------------------------------------------------------
	 remove this comment if they fix ACL_LINK_DEFAULT from non-dir file 
	 to directory 
		if (dlp->d_link == 1 || ulinks == 0)
			;
		else {
			for (uaclindex=0; uaclindex < ulinks; uaclindex++) {
			  if(uacl[uaclindex]->u_ino == dlp->d_ino && 
				uacl[uaclindex]->u_dev == dlp->d_dev) {
					Uaclmatch = uaclindex;
					break;
			  }
			}
		}
---------------------------------  final line in comment */

		namesize = strlen(dlp->file_contents) + 1;
		if (Uaclmatch == -1) {
			if (acl(dlp->file_contents, SETACL_DEFAULT, dlp->file_contents + namesize, 
				dlp->filesize - namesize) < 0) 
			 		fperrno("cpio: create default acl error %s\n", dlp->file_contents);
		}

/*  ----------------------------------------------------------------
	 remove this comment if they fix ACL_LINK_DEFAULT from non-dir file 
	 to directory 

		else 
			if (acl(uacl[Uaclmatch]->u_name, ACL_LINK_DEFAULT, dlp->file_contents, 0) < 0) 
				fperrno("cpio: link default acl error %s\n", dlp->file_contents);

---------------------------------  final line in comment */

	} /* end for loop */
}

uacl_link_list(Xname, XHdr)		/* linking function for unnamed acls  */
char *Xname;
struct header *XHdr;
{				
	register i;		
	register struct uacl *ulp;
	char	*lnamep;
	int	ans;

	if( !uacl ) {
		ulsize = UACL_LINKS;
		uacl = (struct uacl **) zmalloc( EERROR, ulsize * sizeof(struct uacl *));
	}
	else if( ulinks == ulsize ) {
		ulsize += UACL_LINKS;
		uacl = (struct uacl **) zrealloc( EERROR, uacl, ulsize * sizeof(struct uacl *));
	}
	for(i = 0; i < ulinks; ++i) {
		ulp = uacl[i];
		if (ulp->u_ino == XHdr->h_ino  &&  ulp->u_dev == XHdr->h_dev) {
				if (acl(ulp->u_name, ACL_LINK, Xname, 0) < 0) { 
					fperrno("Cannot link an acl associated with %s\n",ulp->u_name, Hdr.h_name);
				}
				return 0;
			}
	}
	if( !(uacl[ulinks] = (struct uacl *)zmalloc( EWARN, strlen(Xname) + 2 + sizeof(struct uacl)))) {
		static int first=1;

		if(first)
			fperr("No memory for unamed acl links (%d)\n", ulinks);
		first = 0;
		return 1;
	}
	uacl[ulinks]->u_dev = XHdr->h_dev;
	uacl[ulinks]->u_ino = XHdr->h_ino;
	strcpy(uacl[ulinks]->u_name, Xname);
	++ulinks;
	return 1;
}

postml(namep, np)		/* linking function:  Postml() is called after*/
register char *namep, *np;	/* namep is created.  Postml() checks to see  */
{				/* if namep should be linked to np.  If so,   */
				/* postml() removes the independent instance  */
	register i;		/* of namep and links namep to np.	      */
	static struct ml {
		short	m_dev;
		ushort	m_ino;
		char	m_name[2];
	} **ml = 0;
	static unsigned	mlsize = 0;
	static unsigned	mlinks = 0;
	register struct ml *mlp;
	char		*lnamep;
	int		ans;

	if( !ml ) {
		mlsize = LINKS;
		ml = (struct ml **) zmalloc( EERROR, mlsize * sizeof(struct ml *));
	}
	else if( mlinks == mlsize ) {
		mlsize += LINKS;
		ml = (struct ml **) zrealloc( EERROR, ml, mlsize * sizeof(struct ml *));
	}
	for(i = 0; i < mlinks; ++i) {
		mlp = ml[i];
		if(mlp->m_ino==Hdr.h_ino  &&  mlp->m_dev==Hdr.h_dev) {
			if(Verbose == 1)
				fperr("%s linked to %s\n", mlp->m_name, np);
			if(Verbose && Option == PASS)
/*mu6*/				verbdot(stdout, np);
			unlink(namep);

			if(Option == IN && *(mlp->m_name) != '/') {
				Fullname[Pathend] = '\0';
				strcat(Fullname, mlp->m_name);
				lnamep = Fullname;
			}

			lnamep = mlp->m_name;

/* try linking (only twice) */
			ans = 0;
			do {
				if(link(lnamep, namep) < 0) {
					ans += 1;
				}else {
					ans = 0;
					break;
				}
			}while(ans < 2 && missdir(np) == 0);
			if(ans == 1) {
				fperrno("Cannot create directory for <%s>", np);
				*LastFile = '\0';
				return(0);
			}else if(ans == 2) {
				fperrno("Cannot link <%s> & <%s>", lnamep, np);
				*LastFile = '\0';
				return(0);
			}

			set_time(namep, mklong(Hdr.h_mtime), mklong(Hdr.h_mtime));
			return 0;
		}
	}
	if( !(ml[mlinks] = (struct ml *)zmalloc( EWARN, strlen(np) + 2 + sizeof(struct ml)))) {
		static int first=1;

		if(first)
			fperr("No memory for links (%d)\n", mlinks);
		first = 0;
		return 1;
	}
	ml[mlinks]->m_dev = Hdr.h_dev;
	ml[mlinks]->m_ino = Hdr.h_ino;
	strcpy(ml[mlinks]->m_name, np);
	++mlinks;
	return 1;
}

pentry(namep)		/* print verbose table of contents */
register char *namep;
{

	static short lastid = -1;
#include <pwd.h>
	static struct passwd *pw;
	struct passwd *getpwuid();

	printf("%-7o", MK_USHORT(Hdr.h_mode));
	if(lastid == Hdr.h_uid)
		printf("%-6s", pw->pw_name);
	else {
		setpwent();
		if(pw = getpwuid((int)Hdr.h_uid)) {
			printf("%-6s", pw->pw_name);
			lastid = Hdr.h_uid;
		} else {
			printf("%-6d", Hdr.h_uid);
			lastid = -1;
		}
	}
	printf("%7ld ", mklong(Hdr.h_filesize));
	U.l = mklong(Hdr.h_mtime);
	cftime(time_buf, FORMAT, (long *)&U.l);
	printf(" %s  %s\n", time_buf, namep);
}

/* pattern matching functions */
nmatch(s, pat)
char *s, **pat;
{
	if( !pat )
		return 1;
	while(*pat) {
		if((**pat == '!' && !gmatch(s, *pat+1))
		|| gmatch(s, *pat))
			return 1;
		++pat;
	}
	return 0;
}

swap(buf, ct)		/* swap halfwords, bytes or both */
register ct;
register char *buf;
{
	register char c;
	register union swp { long	longw; short	shortv[2]; char charv[4]; } *pbuf;
	int savect, n, i;
	char *savebuf;
	short cc;

	savect = ct;	savebuf = buf;
	if(byteswap || bothswap) {
		if (ct % 2) buf[ct] = 0;
		ct = (ct + 1) / 2;
		while (ct--) {
			c = *buf;
			*buf = *(buf + 1);
			*(buf + 1) = c;
			buf += 2;
		}
		if (bothswap) {
			ct = savect;
			pbuf = (union swp *)savebuf;
			if (n = ct % sizeof(union swp)) {
				if(n % 2)
					for(i = ct + 1; i <= ct + (sizeof(union swp) - n); i++) pbuf->charv[i] = 0;
				else
					for (i = ct; i < ct + (sizeof(union swp) - n); i++) pbuf->charv[i] = 0;
			}
			ct = (ct + (sizeof(union swp) -1)) / sizeof(union swp);
			while(ct--) {
				cc = pbuf->shortv[0];
				pbuf->shortv[0] = pbuf->shortv[1];
				pbuf->shortv[1] = cc;
				++pbuf;
			}
		}
	}
	else if (halfswap) {
		pbuf = (union swp *)buf;
		if (n = ct % sizeof(union swp))
			for (i = ct; i < ct + (sizeof(union swp) - n); i++) pbuf->charv[i] = 0;
		ct = (ct + (sizeof(union swp) -1)) / sizeof(union swp);
		while (ct--) {
			cc = pbuf->shortv[0];
			pbuf->shortv[0] = pbuf->shortv[1];
			pbuf->shortv[1] = cc;
			++pbuf;
		}
	}
}

set_time(namep, atime, mtime)	/* set access and modification times */
register char *namep;
time_t atime, mtime;
{
	static time_t timevec[2];

	if(!Mod_time)
		return;
	timevec[0] = atime;
	timevec[1] = mtime;
	utime(namep, timevec);
}

int	reelcount = 1;	/* used below and in chgreel() */

/*
 * Change reel due to reaching end-of-media.
 * Keep trying to get a successful write before considering the
 * change-of-reel as successful.
 */
eomchgreel(rv)
int rv;
{
        while( 1 ) {
                Output = chgreel(1, Output, rv);
                errno = 0;
                rv = write(Output, Cbuf, Bufsize);
                if( rv == Bufsize )
                        return  rv;
                fperr( "Unable to write this medium.  Try again.\n" );
                reelcount--;
        }
        /*NOTREACHED*/
}

chgreel(x, fl, rv)
{
	register f;
	char str[BUFSIZ];
	struct stat statb;
	int tmperrno;

	tmperrno = errno;
	fstat(fl, &statb);
	if ((statb.st_mode&S_IFMT) != S_IFCHR)
		{
		if (x && rv == -1)
			switch (tmperrno)
				{
				case EFBIG:
				fperr("cpio: ulimit reached for output file\n");
					break;

				case ENOSPC:
				fperr("cpio: no space left for output file\n");
					break;

				default:
				errmsg( EERROR,"write() in bwrite() failed\n");
				}
		else
			fperr( "Can't read input:  end of file encountered \
prior to expected end of archive.\n");
		exit(2);
		}
#ifdef	ARIX
	if ((rv == 0) || ((ct_option & ct_IO) && (rv > 0) && BigGflag) ||
	    ((rv == -1) &&	
	     (tmperrno == ENOSPC || tmperrno == ENXIO || tmperrno == EIO)))
#else	/* ARIX */
	if ((rv == 0) || ((rv == -1) && (tmperrno == ENOSPC  ||  tmperrno == ENXIO)))
#endif	/* ARIX */
		fperr("\007Reached end of medium on %s.\n",x?"output":"input");
	else
		{
		fperrno("\007Encountered an error on %s",x?"output":"input");
		exit(2);
		}
	close(fl);
	reelcount++;
again:
	if( swfile ) {
#ifndef	DEBUG
askagain:
#endif	/* !DEBUG */
		fperr( eommsg, reelcount );
#ifdef	DEBUG
		if (chgfname && *chgfname) {
			if (chgfp == NULL)
				chgfp = zfopen(EERROR,chgfname,"r");
			fgets(str,sizeof str,chgfp);
		} else	{
#endif	/* DEBUG */
			if (Rtty == NULL)
				Rtty = zfopen(EERROR,ttyname,"r");
			fgets(str,sizeof str,Rtty);
#ifdef	DEBUG
		}
#endif	/* DEBUG */
		switch( *str ) {
		case '\0':
		case '\n':
			strcpy( str, swfile );
			break;
		case 'q':
			exit(2);
		default:
#ifdef	DEBUG
			str[strlen(str) - 1] = '\0';
			break;
#else	/* DEBUG */
			goto askagain;
#endif	/* DEBUG */
		}
	} else	{
reask:		/* mu3	*/
	fperr("If you want to go on, type device/file name when ready.\n");
#ifdef	DEBUG
		if (chgfname && *chgfname) {
			if (chgfp == NULL)
				chgfp = zfopen(EERROR,chgfname,"r");
			fgets(str,sizeof str,chgfp);
			fperr("%s",str);
			str[strlen(str) - 1] = '\0';	/* kill newline */
		} else	{
#endif	/* DEBUG */
			if (Rtty == NULL)
				Rtty = zfopen(EERROR,ttyname,"r");
			fgets(str,sizeof str,Rtty);
			str[strlen(str) - 1] = '\0';
/*mu3*/			if (!*str) {
/*mu3*/		fperr("Are you sure that you want to quit (yes or no) ?\n");
/*mu3*/				fgets(str, sizeof str, Rtty);
/*mu3*/				str[strlen(str) - 1] = '\0';
/*mu3*/				if (*str && ((*str == 'y') || (*str == 'Y')))
/*mu3*/					exit(2);
/*mu3*/				goto reask;
/*mu3*/			}
#ifdef	DEBUG
		}
#endif	/* DEBUG */
	}
	if((f = open(str, x? 1: 0)) < 0) {
		fperr("That didn't work, cannot open \"%s\"\n", str);
		if( errno )
			perror("");
		goto again;
	}
#ifdef	ARIX
	ct_option &= ~ct_IO;				/* mu4	*/
	ct_type = 0;					/* mu4	*/
	if (ioctl(f,PERGET,&ct_type) >= 0) {		/* mu4	*/
		if (ct_type == ct_CART)			/* mu4	*/
			if (x)				/* mu4	*/
				ct_option |= ct_OUT;	/* mu4	*/
			else				/* mu4	*/
				ct_option |= ct_IN;	/* mu4	*/
	}						/* mu4	*/
#endif	/* ARIX */
	return f;
}

missdir(namep)
register char *namep;
{
	register char *np;
	register ct = 2;

	for(np = namep; *np; ++np)
		if(*np == '/') {
			if(np == namep)
				continue;	/* skip over 'root slash' */
			*np = '\0';
			if(stat(namep, &Xstatb) == -1) {
				if(Dir) {
					(void) umask(orig_umask);
					ct = mkdir(namep, df_mode);
					(void) umask(0);
					if (ct != 0) {
						*np = '/';
						return(ct);
					}
				}else {
					fperr("missing 'd' option\n");
					return(-1);
				}
			}
			*np = '/';
		}
	if (ct == 2) ct = 0;		/* the file already exists */
	return ct;
}

pwd()		/* get working directory */
{
	FILE *dir;

	if((dir = popen("pwd", "r")) == NULL) {
	fperr("cpio: popen() failed, cannot determine working directory\n");
		exit(2);
	}
	fgets(Fullname, sizeof Fullname, dir);
	if(pclose(dir))
		exit(2);
	Pathend = strlen(Fullname);
	Fullname[Pathend - 1] = '/';
}

int	verbcount = 0;
FILE	*verbout = 0;

/*
 * In -V verbose mode, print out a dot for each file processed.
 */
verbdot( fp, cp )
FILE	*fp;
char	*cp;
{
	if( !verbout )
		verbout = fp;
	if( Verbose == 2 ) {
		fputc( '.', fp );
		if( ++verbcount >= 50 ) {
			/* start a new line of dots */
			verbcount = 0;
			fputc( '\n', fp );
		}
	}
	else {
		fputs( cp, fp );
		fputc( '\n', fp );
	}
}

/*
 * Print message on the stderr.
 * Use tmperrno to prevent this function from modifying errno.
 */
fperr( va_alist )
va_dcl
{
	va_list	args;
	char	*fmt;
	int	tmperrno;	/* mu2 */

	tmperrno = errno;	/* mu2 */
	resetverbcount();
	va_start( args );
	fmt = va_arg( args, char * );
	vfprintf( stderr, fmt, args );
	fflush( stderr );
	errno = tmperrno;	/* for return() - mu2 */
}

/*
 * Print message on the stderr followed by error number and meaning.
 * Use tmperrno to prevent this function from modifying errno.
 */
fperrno( va_alist )
va_dcl
{
	va_list	args;
	char	*fmt;
	int	tmperrno;	/* mu2 */

	tmperrno = errno;	/* mu2 */
	resetverbcount();
	va_start( args );
	fmt = va_arg( args, char * );
	vfprintf( stderr, fmt, args );
	fprintf( stderr, ", errno %d, ", tmperrno );	/* mu2 */
	fflush( stderr );
	errno = tmperrno;	/* for perror() - mu2 */
	perror("");
	errno = tmperrno;	/* for return() - mu2 */
}

resetverbcount()
{
	if( Verbose == 2  &&  verbcount ) {
		fputc( '\n', verbout );
		verbcount = 0;
	}
}

/* ident() accepts pointers to two stat structures and	  */
/* determines if they correspond to identical files.	  */
/* ident() assumes that if the device and inode are the	  */
/* same then files are identical.  ident()'s purpose is to*/
/* prevent putting the archive name in the output archive.*/
ident(in, ot)
struct stat *in, *ot;
{
	if (in->st_ino == ot->st_ino &&
	    in->st_dev == ot->st_dev)
		return(1);
	else
		return(0);
}

#ifdef	ARIX

/*
 *	smallbread()
 *
 *	Automatically handle 128K reads of tapes created either by
 *	128K or 256K writes.  Uses dual buffering for determining
 *	whether the tape was written with 128K or 256K block size.
 *	Will handle huge data files containing same data in every byte
 *	(like zeroes) by searching for a valid cpio header after
 *	determining that two buffers are identical.
 *
 *	NOTE:	if size of file plus size of cpio header is exaclty
 *		128K and the file was written at least twice to cpio
 *		tape (How?) in succession then this has the effect of
 *		ignoring the last occurance of the file.
 *	
 *	Pseudo-Code:
 *
 *	clear REEL_WAS_CHANGED
 *	while forever
 *	do
 *		if NOT_FIRST_READ is set and REEL_WAS_CHANGED is NOT set
 *			switch input buffer pointers
 *		endif
 *		READ into current buffer pointer (Bufsize is 128K)
 *		if REEL_WAS_CHANGED is NOT set
 *			if READ what was asked for
 *				break from while loop
 *			endif
 *		endif
 *		if EOM or EOF
 *			if READ less than what was asked for but more than zero
 *				if valid cpio TRAILER header is in buffer
 *					break from while loop
 *				endif
 *			endif
 *			change reel
 *			set REEL_WAS_CHANGED
 *			continue with while loop
 *		endif
 *		if NOT_FIRST_READ is set and REEL_WAS_CHANGED is set
 *			clear REEL_WAS_CHANGED
 *			if saved buffer is same as current buffer
 *			   and has at least one valid cpio header
 *				continue with while loop
 *			endif
 *		endif
 *		break from while loop
 *	done
 *	set NOT_FIRST_READ
 *	return bytes read
 */
smallbread()
{
register int	rv, fneed;

	ct_option &= ~ct_CHGREEL;
	while (TRUE) {
		if (!(ct_option & ct_CHGREEL)) {
			if (ct_option & ct_SECOND) {
#ifdef	DEBUG
		if (deblevel > 1)
				fperr(" s1");
#endif	/* DEBUG */
				Cbuf = Cbuf1st;
				ct_option &= ~ct_SECOND;
			} else	{
#ifdef	DEBUG
		if (deblevel > 1)
				fperr(" s2");
#endif	/* DEBUG */
				Cbuf = Cbuf2nd;
				ct_option |= ct_SECOND;
			}
		}
		errno = 0;
		rv = read(Input,Cbuf,Bufsize);
		if (!(ct_option & ct_CHGREEL))
			if (rv == Bufsize)
				break;		/* while (TRUE)	*/
		fneed = filesz - Have;
		if (((rv >= 0) && (rv < Bufsize)) || ((rv == -1) &&
			(errno == ENOSPC || errno == ENXIO || errno == EIO))) {
#ifdef	DEBUG
		if (deblevel)
			fperr("\n's' ask=%d, got=%d, need=%d, fileleft=%d\n",
				Bufsize,rv,Bufsize-rv,fneed);
#endif	/* DEBUG */
			if (rv > fneed) {
				if (ct_findhdr((int)Cbuf+fneed,rv-fneed,
						HTRAILER)) {
#ifdef	DEBUG
		if (deblevel)
			fperr("'s' found '%s' in partial read\n",HTRAILER);
#endif	/* DEBUG */
					break;	/* while (TRUE)	*/
				}
			}
			Input = chgreel(0,Input,rv);
			ct_option |= ct_CHGREEL;
			continue;		/* while (TRUE)	*/
		}
		if (ct_option & ct_CHGREEL) {
			ct_option &= ~ct_CHGREEL;
			if (ct_bcmp(Cbuf,((ct_option & ct_SECOND) ?
					Cbuf1st : Cbuf2nd),Bufsize)) {
#ifdef	DEBUG
if (deblevel)
	fperr("'s' (next to last blk on vol N) & (1st blk on vol N+1) are same\n");
#endif	/* DEBUG */
				if (ct_findhdr(Cbuf,Bufsize,0)) {
#ifdef	DEBUG
if (deblevel)
	fperr("'s' 1st blk on vol N+1 ignored, it has a valid cpio header\n");
#endif	/* DEBUG */
					continue;	/* while (TRUE) */
				}
			}
		}
		break;				/* while (TRUE)	*/
	}
	return (rv);
}

/*
 *	bigbread()
 *
 *	Automatically handle 256K reads of tapes created either by
 *	128K or 256K writes.  Uses dual buffering for determining
 *	whether the tape was written with 128K or 256K block size.
 *	Will handle huge data files containing same data in every byte
 *	(like zeroes) by searching for a valid cpio header after
 *	determining that two buffers are identical.
 *
 *	clear REEL_WAS_CHANGED
 *	if PARTIAL_READ is set
 *		switch input buffer pointers
 *		clear PARTIAL_READ
 *		return SAVE_BUF_LEN
 *	endif
 *	set SAVE_BUF_LEN to Bufsize (256K)
 *	while forever
 *	do
 *		READ into current buffer pointer (Bufsize is 256K)
 *		if REEL_WAS_CHANGED is NOT set
 *			if READ what was expected
 *				break from while loop
 *		endif
 *		if EOM or EOF
 *			if READ less than what was asked for but more than zero
 *				if valid cpio TRAILER header is in buffer
 *					if REEL_WAS_CHANGED is set
 *						goto faster_code
 *				else
 *						break from while loop
 *				endif
 *			endif
 *			change reel
 *			if REEL_WAS_CHANGED is NOT set
 *				set SAVE_BUF_LEN to READ count
 *				switch input buffer pointers
 *			endif
 *			set REEL_WAS_CHANGED
 *			continue with while loop
 *		endif
 *	faster_code:
 *		if REEL_WAS_CHANGED is set
 *			clear REEL_WAS_CHANGED
 *			if saved buffer is same as current buffer
 *				break from while loop
 *			endif
 *			if 2nd half of saved buffer is same as
 *			   1st half of current buffer
 *				switch input buffer pointers
 *				set SAVE_BUF_LEN to READ count
 *				set READ count to FASTSSIZE (128K)
 *				set PARTIAL_READ
 *				break from while loop
 *			else
 *				report out of sync error message
 *				exit from cpio
 *			endif
 *		endif
 *		break from while loop
 *	done
 *	set NOT_FIRST_READ
 *	return bytes read
 */
bigbread()
{
register int	rv, fneed;

	ct_option &= ~ct_CHGREEL;
	if (ct_option & ct_PARTIAL) {
		if (ct_option & ct_SECOND) {
#ifdef	DEBUG
		if (deblevel > 1)
				fperr(" pb1");
#endif	/* DEBUG */
			Cbuf = Cbuf1st;
			ct_option &= ~ct_SECOND;
		} else	{
#ifdef	DEBUG
		if (deblevel > 1)
				fperr(" pb2");
#endif	/* DEBUG */
			Cbuf = Cbuf2nd;
			ct_option |= ct_SECOND;
		}
		ct_option &= ~ct_PARTIAL;
		return (CbufLen);
	}
	CbufLen = Bufsize;
	while (TRUE) {
		errno = 0;
		rv = read(Input,Cbuf,Bufsize);
		if (!(ct_option & ct_CHGREEL))
			if (rv == Bufsize)
				break;		/* while (TRUE)	*/
		fneed = filesz - Have;
		if (((rv >= 0) && (rv < Bufsize)) || ((rv == -1) &&
			(errno == ENOSPC || errno == ENXIO || errno == EIO))) {
#ifdef	DEBUG
		if (deblevel)
			fperr("\n'b' ask=%d, got=%d, need=%d, fileleft=%d\n",
				Bufsize,rv,Bufsize-rv,fneed);
#endif	/* DEBUG */
			if (rv > fneed) {
				if (ct_findhdr((int)Cbuf+fneed,rv-fneed,
						HTRAILER)) {
#ifdef	DEBUG
		if (deblevel)
			fperr("'b' found '%s' in partial read\n",HTRAILER);
#endif	/* DEBUG */
					if (ct_option & ct_CHGREEL)
						goto faster_code;
					else
						break;	/* while (TRUE)	*/
				}
			}
			Input = chgreel(0,Input,rv);
			if (!(ct_option & ct_CHGREEL)) {
				CbufLen = rv;
				if (ct_option & ct_SECOND) {
#ifdef	DEBUG
		if (deblevel > 1)
				fperr(" b1");
#endif	/* DEBUG */
					Cbuf = Cbuf1st;
					ct_option &= ~ct_SECOND;
				} else	{
#ifdef	DEBUG
		if (deblevel > 1)
				fperr(" b2");
#endif	/* DEBUG */
					Cbuf = Cbuf2nd;
					ct_option |= ct_SECOND;
				}
			}
			ct_option |= ct_CHGREEL;
			continue;		/* while (TRUE)	*/
		}
faster_code:
		if (ct_option & ct_CHGREEL) {
			ct_option &= ~ct_CHGREEL;
			if (ct_bcmp(Cbuf,((ct_option & ct_SECOND) ?
					Cbuf1st : Cbuf2nd),CbufLen)) {
#ifdef	DEBUG
if (deblevel)
	fperr("'b' (last blk on vol N) & (1st blk on vol N+1) are same\n");
#endif	/* DEBUG */
				break;	/* while (TRUE) */
			}
			if (ct_bcmp(Cbuf,((ct_option & ct_SECOND) ?
					Cbuf1st : Cbuf2nd) + FASTSSIZE,
						CbufLen-FASTSSIZE)) {
#ifdef	DEBUG
if (deblevel)
	fperr("'b' (2nd half of last blk on vol N) & (1st half of 1st blk on vol N+1) are same\n");
#endif	/* DEBUG */
				if (ct_option & ct_SECOND) {
					Cbuf = Cbuf1st;
					ct_option &= ~ct_SECOND;
				} else	{
					Cbuf = Cbuf2nd;
					ct_option |= ct_SECOND;
				}
				CbufLen = rv;
				rv = FASTSSIZE;
				ct_option |= ct_PARTIAL;
				break;	/* while (TRUE)	*/
			} else	{
				if (Cflag == NONE)
					errmsg( EERROR,
				"This is not a cpio file.  Bad header.");
				else
					errmsg( EERROR,
				"Out of sync.  Bad magic number/header.");
			}
		}
		break;				/* while (TRUE)	*/
	}
	return (rv);
}

/*
 * Check if two buffers are identical and have at least one valid cpio header.
 */
ct_bcmp(a,b,c)
register char	*a, *b;
register int	c;
{
register char	*t = a;
register int	n = c;

#ifdef	DEBUG
	if (deblevel)
		fperr("'c' bcmp: current=0x%x, previous=0x%x, size=%d\n",
			a,b,c);
#endif	/* DEBUG */
	while (c--)
		if (*a != *b)
			return (0);	/* not same			*/
		else
			a++, b++;
	/*
	 * At this point the buffers are found to be identical.
	 */
	return (1);
}

/*
 * Check if there is at least one valid cpio header in passed buffer.
 * If name is NULL then find first valid cpio header, otherwise
 * try to find a match for the name.
 */
ct_findhdr(magic,ct_nleft,name)
register char		*magic, *name;
register int		ct_nleft;
{
register int		hit, hsize, align;
static	struct	header	ct_Hdr;
static	long		ct_Longfile, ct_Longtime;
union	{
	char	bite[2];
	ushort	temp;
} mag;

#ifdef	DEBUG
if (deblevel > 2)
	fperr("'f' findhdr: buf=0x%x, size=%d, name='%s', min1=%d, min2=%d\n",
		magic,ct_nleft,(name ? name : ""),sizeof(struct header),CHARS);
#endif	/* DEBUG */
	hit = NONE;
	/*
	 * Don't change the order of checks in the following if.
	 */
	if ((ct_nleft < sizeof(struct header)) || (ct_nleft < CHARS)) {
#ifdef	DEBUG
if (deblevel > 2)
	fperr("'f' findhdr: size=%d < (min1=%d || min2=%d)\n",
		ct_nleft,sizeof(struct header),CHARS);
#endif	/* DEBUG */
		return (0);
	}
	while ((hit == NONE) && ct_nleft) {
		if ((Cflag == ASCII) || (Cflag == NONE)) {
			if (strncmp(magic,M_ASCII,M_STRLEN) == 0) {
		sscanf(magic,"%6ho%6ho%6ho%6ho%6ho%6ho%6ho%6ho%11lo%6ho%11lo",
					&ct_Hdr.h_magic,
					&ct_Hdr.h_dev,
					&ct_Hdr.h_ino,
					&ct_Hdr.h_mode,
					&ct_Hdr.h_uid,
					&ct_Hdr.h_gid,
					&ct_Hdr.h_nlink,
					&ct_Hdr.h_rdev,
					&ct_Longtime,
					&ct_Hdr.h_namesize,
					&ct_Longfile);
				MKSHORT(ct_Hdr.h_filesize,ct_Longfile);
				MKSHORT(ct_Hdr.h_mtime,ct_Longtime);
				hit = ASCII;
				hsize = CHARS + ct_Hdr.h_namesize;
				align = 0;
#ifdef	DEBUG
if (deblevel > 2)
	fperr("'f' findhdr: ascii magic present, nleft=%d, nsize=%d, hsize=%d\n",
		ct_nleft,ct_Hdr.h_namesize,hsize);
#endif	/* DEBUG */
			}
		}
		if ((Cflag == BINARY) || (Cflag == NONE)) {
			mag.bite[0] = magic[0];
			mag.bite[1] = magic[1];
			if (mag.temp == M_BINARY) {
				memcpy(&ct_Hdr,magic,HDRSIZE);
				hit = BINARY;
				hsize = HDRSIZE + ct_Hdr.h_namesize;
				align =	((ct_Hdr.h_namesize % 2) == 0 ? 0 : 1);
#ifdef	DEBUG
if (deblevel > 2)
	fperr("'f' findhdr: binary magic present, nleft=%d, nsize=%d, hsize=%d, align=%d\n",
		ct_nleft,ct_Hdr.h_namesize,hsize,align);
#endif	/* DEBUG */
			}
		}
		if (hit != NONE) {
#ifdef	DEBUG
if (deblevel > 2)
	fperr("'f' h");
#endif	/* DEBUG */
			if ((ct_Hdr.h_nlink >= 1) &&
					(mklong(ct_Hdr.h_filesize) >= 0) &&
					(ct_Hdr.h_namesize > 0) &&
					(ct_Hdr.h_namesize < PATHSIZE)) {
#ifdef	DEBUG
if (deblevel > 2)
	fperr(" v");
#endif	/* DEBUG */
				if (ct_nleft >= (hsize + align)) {
#ifdef	DEBUG
if (deblevel > 2)
	fperr(" n");
#endif	/* DEBUG */
					if (*(magic + hsize - 1) == '\0') {
#ifdef	DEBUG
if (deblevel > 2)
	fperr(" m");
#endif	/* DEBUG */
						if (hit == ASCII) {
#ifdef	DEBUG
if (deblevel > 2)
	fperr(" a");
#endif	/* DEBUG */
							memcpy(ct_Hdr.h_name,
							magic+CHARS,
							ct_Hdr.h_namesize);
						} else	{
#ifdef	DEBUG
if (deblevel > 2)
	fperr(" b");
#endif	/* DEBUG */
							memcpy(ct_Hdr.h_name,
							magic+HDRSIZE,
							ct_Hdr.h_namesize+
							align);
						}
						if (name) {
						    if (strcmp(ct_Hdr.h_name,
								name)) {
#ifdef	DEBUG
if (deblevel > 2)
	fperr(" no match '%s'\n",ct_Hdr.h_name);
#endif	/* DEBUG */
							magic++;
							ct_nleft--;
							hit = NONE;
							continue; /* while */
						    }
						}
#ifdef	DEBUG
if (deblevel > 2)
	fperr(" match '%s'\n",ct_Hdr.h_name);
#endif	/* DEBUG */
						return (1);
					}
				}
			}
		}
		magic++;
		ct_nleft--;
		hit = NONE;
		/*
		 * Don't change the order of the following ifs.
		 */
		if (ct_nleft < sizeof(struct header))
			break;
		if (ct_nleft < CHARS)
			break;
	}
	if (hit == NONE)
		return (0);
	if (ct_nleft)
		return (1);
	return (0);
}
#endif	/* ARIX */
