/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) config.c: version 25.1 created on 12/2/91 at 14:02:11	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)config.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*   @(#)config.c       1.1     */
/*	kd0	9/7/88	the printf for "init, " had an extra space at the
			end; therefore the line was ending up: xxinit(),; rather
			than xxinit();
*/

#include "stdio.h"
#define ASIZE   40              /* max alias table */
#define PSIZE   256             /* max keyword table */
#define BSIZE   16              /* max block device table */
#define CSIZE   256             /* max character device table */
#define LSIZE   50              /* max linesw table */

#define ONCE    0200            /* allow only one specification of device */
#define NOCNT   0100            /* suppress device count field */
#define REQ      020            /* required device */
#define BLOCK    010            /* block type device */
#define CHAR      04             /* character type device */
#define LKERN   0400            /* define bit for large kernel */

#define STR     0400            /* str header exists */
#define TTYS    0200            /* tty header exists (linesw entry) */
#define INIT    0100            /* initialization routine exists */
#define PWR     040             /* power fail routine exists */
#define OPEN    020             /* open routine exists */
#define CLOSE   010             /* close routine exists */
#define READ    04              /* read routine exists */
#define WRITE   02              /* write routine exists */
#define IOCTL   01              /* ioctl routine exists */

#define MDMINT  0200            /* modem interrupt routine exists */
#define TXINT   0100            /* transmit interrupt routine exists */
#define RXINT   040             /* receive interrupt routine exists */

struct  t       {
        struct t *next;         /* next in list */
        char    *devname;       /* pointer to device name */
        short   type;           /* ONCE,NOCNT,REQ,BLOCK,CHAR  */
        char    *handler;       /* pointer to interrupt handler */
        short   count;          /* sequence number for this device */
        short   blk;            /* major device number if block type device */
        short   chr;            /* major device number if char. type device */
        short   mc;             /* number of controllers */
        short   md;             /* number of physical devices */
        short   ml[1];          /* number of logical devices */
}       *table = NULL;

struct  t2      {
        struct t2 *next;
        char    dev[9];         /* device name */
        short   mask;           /* device mask indicating existing handlers */
        short   type2;          /* ONCE,NOCNT,REQ,BLOCK,CHAR  */
        char    hndlr[10];      /* handler name */
        short   block;          /* major device number if block type device */
        short   charr;          /* major device number if char. type device */
        short   mult;           /* max number of controllers */
        short   phys;           /* max number of physical devices / ctrlr */
        short   log;            /* max number of logical devices / phys */
        char    linsw[10];      /* linesw handler name */
        short   line;           /* linesw entry if line discipline on */
        short   lmsk;           /* linesw mask indicating existing handlers */
        short   dcount;         /* number of controllers present */
}       *devinfo = NULL;

struct  t3      {
        char    new[9];         /* alias of device */
        char    old[9];         /* reference name of device */
}       alias   [ASIZE];

struct  t4      {
        char    indef[21];              /* input parameter keyword */
        char    oudef[21];              /* output definition symbol */
        char    value[21];              /* actual parameter value */
        char    defval[21];             /* default parameter value */
}       parms   [PSIZE];


struct  t2      *bdevices[BSIZE];       /* pointers to block devices */
struct  t2      *cdevices[CSIZE];       /* pointers to char. devices */
struct  t2      *ldevices[LSIZE] = { NULL };
struct  t3      *r;                     /* alias table pointer */
struct  t4      *kwdptr;                /* keyword table pointer */
struct  t       *newp(),
                *config();
struct  t2      *newq(),
                *master();
struct  t4      *lookup();
char    *uppermap();

short   power   = 0;    /* power fail restart flag */
short   eflag   = 0;    /* error in configuration */
short   tflag   = 0;    /* table flag */
short   bmax    = -1;   /* dynamic max. major device number for block device */
short   cmax    = -1;   /* dynamic max. major device number for char. device */
short   blockex = 0;    /* dynamic end of block device table */
short   charex  = 0;    /* dynamic end of character device table */
short   subv    = 0;    /* low core double-word subscript */
short   subtmp  = 0;    /* temporary; for subscripting */
short   lbound  = -1;   /* current linesw table size */
short   abound  = -1;   /* current alias table size */
short   pbound  = -1;   /* current keyword table size */
short   rtmaj   = -1;   /* major device number for root device */
short   swpmaj  = -1;   /* major device number for swap device */
short   pipmaj  = -1;   /* major device number for pipe device */
short   dmpmaj  = -1;   /* major device number for dump device */
short   rtmin   = -1;   /* minor device number for root device */
short   swpmin  = -1;   /* minor device number for swap device */
short   pipmin  = -1;   /* minor device number for pipe device */
short   dmpmin  = -1;   /* minor device number for dump device */
long    swplo   = -1;   /* low disc address for swap area */
long    nswap   = -1;   /* number of disc blocks in swap area */
FILE    *fdconf;        /* configuration file descriptor */
FILE    *fdhdr;         /* configuration header file descriptor */
struct t *dmppt;        /* pointer to dump entry */
char    *mfile;         /* master device file */
char    *cfile;         /* output configuration table file */
char    *hfile;         /* output configuration header file */
char    *infile;        /* input configuration file */
char    line[101];      /* input line buffer area */
char    dump[81];       /* trap filler for dump routine */
char    pwrbf[513];     /* power fail routine buffer */
char    initbf[513];    /* initialization routine buffer */
char    xbf[111];       /* buffer for external symbol definitions */
char    d[9];           /* buffer area */
char    capitals[9];    /* buffer area */
short   mc;             /* maximum # controllers in config */
short   cn;             /* controller number for physical device */
short   md;             /* maximum # phys devices / controller */
short   dn;             /* physical device number for logical device */
short   ml;             /* maximum # log devices / phys device */

char    *opterror =             /* option error message */
{
        "Option re-specification\n"
};

char    *sdev[] = {
        "dm11",
        "hisdm",
        NULL
};

main(argc,argv) int argc; char *argv[]; {
        register i, l;
        register FILE *fd;
        register struct t *p;
        register struct t2 *q;
        int number;
        char input[21], bf[9], c, symbol[21];
        char *argv2;

        argc--;
        argv++;
        argv2 = argv[0];
        argv++;

        /*
         * Scan off the 'c', 'h', 'm', and 't' options.
         */
        while ((argc > 1) && (argv2[0] == '-')) {
                for (i=1; (c=argv2[i]) != NULL; i++) switch (c) {
                case 'h':
                        if (hfile) {
                                printf(opterror);
                                exit(1);
                        }
                        hfile = argv[0];
                        argv++;
                        argc--;
                        break;
                case 'c':
                        if (cfile) {
                                printf(opterror);
                                exit(1);
                        }
                        cfile = argv[0];
                        argv++;
                        argc--;
                        break;
                case 'l':
                        printf("l option not supported\n");
                        exit(1);
                case 'm':
                        if (mfile) {
                                printf(opterror);
                                exit(1);
                        }
                        mfile = argv[0];
                        argv++;
                        argc--;
                        break;
                case 't':
                        tflag++;
                        break;

                default:
                        printf("Unknown option\n");
                        exit(1);
                }
                argc--;
                argv2 = argv[0];
                argv++;
        }
        if (argc != 1) {
                printf("Usage: config [-t][-c file][-h file][-m file] file\n");
                exit(1);

        }
        /*
         * Set up defaults for unspecified files.
         */
        if (cfile == 0)
                cfile = "conf.c";
        if (hfile == 0)
                hfile = "config.h";
        if (mfile == 0)
                mfile = "/etc/master";
        infile = argv2;
        fd = fopen (infile,"r");
        if (fd == NULL) {
                printf("Open error for file -- %s\n",infile);
                exit(1);
        }

        /*
         * Open configuration file and set modes.
         */
        if ( (fdhdr = fopen(hfile,"w")) == NULL) {
                printf("Open error for file -- %s\n",hfile);
                exit(1);
        }
        chmod (hfile,0644);

        if ( (fdconf = fopen(cfile,"w")) == NULL) {
                printf("Open error for file -- %s\n",cfile);
                exit(1);
        }
        chmod (cfile,0644);

        /*
         * Print configuration file heading.
         */
        fprintf(fdhdr,"/*\n *  Configuration table header information\n */\n\n");
        fprintf(fdhdr,"#define _5000_60_80      1\n\n");

        /*
         * Read in the master device table and the alias table.
         */
        file();

        /*
         * Start scanning the system file.
         */
        while( fgets(line,100,fd) != NULL ) {
                if( sscanf(line,"%20s",input) != 1 || line[0] == '*')
                        continue;
                if( line[0] == '$')
                        break;

                /*
                 * system device specification
                 */
                if( equal( input, "root" ) ) {
                        /*
                         * Root device specification
                         */
                        if( sscanf(line,"%*8s%8s%o",bf,&number) != 2 ) {
                                error("Incorrect root specification");
                                continue;
                        }
                        if( (q=master(bf)) == NULL) {
                                error("No such device");
                                continue;
                        }
                        if( (q->type2 & BLOCK) == 0) {
                                error("Not a block device");
                                continue;
                        }
                        if (number > 255) {
                                error("Invalid minor device number");
                                continue;
                        }
                        if (rtmin >= 0) {
                                error("Root re-specification");
                                continue;
                        }
                        rtmin = number;
                        rtmaj = q->block;
                } else if (equal(input,"pipe")) {
                        /*
                         * Pipe device specification
                         */
                        if( sscanf(line,"%*8s%8s%o",bf,&number) != 2) {
                                error("Incorrect pipe specification");
                                continue;
                        }
                        if( (q=master(bf)) == 0) {
                                error("No such device");
                                continue;
                        }
                        if( (q->type2 & BLOCK) == 0) {
                                error("Not a block device");
                                continue;
                        }
                        if (number > 255) {
                                error("Invalid minor device number");
                                continue;
                        }
                        if (pipmin >= 0) {
                                error("Pipe re-specification");
                                continue;
                        }
                        pipmin = number;
                        pipmaj = q->block;
                } else if (equal(input,"dump")) {
                        /*
                         * Dump device specification
                         */
                        error("Dump device specification ignored");
                        continue;
                } else {
                        error("Not a system device");
                        continue;
                }
        }
        /*
         * Make sure that the root and pipe devices were specified.
         */
        if (rtmaj < 0) {
                printf("root device not specified\n");
                eflag++;
        }
        if (pipmaj < 0) {
                printf("pipe device not specified\n");
                eflag++;
        }
        while (fgets(line,100,fd) != NULL) {
                if( sscanf(line,"%20s",input) != 1 || line[0] == '*')
                        continue;
                if (line[0] == '$')
                        break;

                /*
                 * swap device specification
                 */
                if( !equal(input,"swap")) {
                        error("Incorrect swap specification");
                        continue;
                }

                /*
                 * Swap device specification
                 */
                if( sscanf(line,"%*8s%8s%o%ld%ld",bf,&number,&swplo,&nswap) != 4) {
                        error("Incorrect swap specification");
                        continue;
                }
                if( (q=master(bf)) == 0) {
                        error("No such device");
                        continue;
                }
                if( (q->type2 & BLOCK) == 0) {
                        error("Not a block device");
                        continue;
                }
                if (number > 255) {
                        error("Invalid minor device number");
                        continue;
                }
                if (swpmin >= 0) {
                        error("Swap re-specification");
                        continue;
                }
                if (nswap < 1) {
                        error("Invalid nswap");
                        continue;
                }
                if (swplo < 0) {
                        error("Invalid swplo");
                        continue;
                }
                swpmin = number;
                swpmaj = q->block;
        }
        /*
         * Make sure that the swap device was specified.
         * Set up default values for tunable things where applicable.
         */
        if (swpmaj < 0) {
                printf("swap device not specified\n");
                eflag++;
        }
        while (fgets(line,100,fd) != NULL) {
                if( sscanf(line,"%20s",input) != 1 || line[0] == '*')
                        continue;
                if (line[0] == '$')
                        break;

                /*
                 * Device specification
                 */
                if( sscanf(line,"%8s%hd", d,&mc) != 2 ) {
                        error("Incorrect device specification");
                        continue;
                }

                /*
                 * Does such a device exist, and if so, do we allow its specification?
                 */
                if ((q=master(d)) == NULL) {
                        error("No such device");
                        continue;
                }

                /*
                 * check to see if it is a re-specification
                 */
                if( config(d) && (q->type2 & ONCE) ) {
                        error("Device re-specified");
                        continue;
                }

                /*
                 * Get the device multiplier
                 */
                if( (mc > q->mult) || (mc <= 0) ) {
                        error("Invalid controller multiplier");
                        continue;
                }
                enterdev(q, mc);
        }
        while (fgets(line,100,fd) != NULL) {
                if( sscanf(line,"%20s",input) != 1 || line[0] == '*')
                        continue;
                if (line[0] == '$')
                        break;

                /*
                 * Physical Device specification
                 */
                if( sscanf(line,"%8s%hd%hd", d,&cn,&md) != 3 ) {
                        error("Incorrect device allocation");
                        continue;
                }

                /*
                 * Does such a device exist, and if so, do we allow its allocation?
                 */
                if ((q=master(d)) == NULL) {
                        error("No such device");
                        continue;
                }
                if ((p=config(d)) == NULL) {
                        error("Device not specified");
                        continue;
                }
                if( cn > p->mc ) {
                        error("Invalid controller");
                        continue;
                }
                if( (md > q->phys) || (md <= 0) ) {
                        error("Invalid number of physical devices");
                        continue;
                }
/*
                p->md = md;
 */
        }
        while (fgets(line,100,fd) != NULL) {
                if( sscanf(line,"%20s",input) != 1 || line[0] == '*')
                        continue;
                if (line[0] == '$')
                        break;

                /*
                 * Logical Unit specification
                 */
                if( sscanf(line,"%8s%hd%hd%hd", d,&cn,&dn,&ml) != 4 ) {
                        error("Incorrect unit specification");
                        continue;
                }

                /*
                 * Does such a device exist, and if so, do we allow its allocation?
                 */
                if ((q=master(d)) == NULL) {
                        error("No such device");
                        continue;
                }
                if ((p=config(d)) == NULL) {
                        error("Device not specified");
                        continue;
                }
                if( cn > p->mc ) {
                        error("Invalid controller");
                        continue;
                }
                if( dn > p->md ) {
                        error("Invalid device");
                        continue;
                }
                if( (ml > q->log) || (ml <= 0) ) {
                        error("Invalid number of logical units");
                        continue;
                }
/*
                p->ml[dn] = ml;
 */
        }

        while (fgets(line,100,fd) != NULL) {
                if( sscanf(line,"%20s",input) != 1 || line[0] == '*')
                        continue;
                if (line[0] == '$')
                        break;

                /*
                 * Tunable parameter specification
                 */
                kwdptr = lookup(input);
                if( !kwdptr ) {
                        error("Invalid parameter name");
                        continue;
                }
                if( sscanf(line,"%20s%20s",input,symbol) != 2) {
                        error("Incorrect parameter specification");
                        continue;
                }
                if (strlen(kwdptr->value)) {
                        error("Parameter re-specification");
                        continue;
                }
                if (equal(input,"power") && equal(symbol,"1"))
                        power++;
                strcpy(kwdptr->value,symbol);
        }

        /*
         * Set up default values for tunable things where applicable.
         */
        for (kwdptr=parms; kwdptr<= &parms[pbound]; kwdptr++) {
                if (strlen(kwdptr->value) == 0) {
                        if (strlen(kwdptr->defval) == 0) {
                                printf("%s not specified\n",kwdptr->indef);
                                eflag++;
                        }
                        strcpy(kwdptr->value,kwdptr->defval);
                }
        }

        /*
         * See if configuration is to be terminated.
         */
        if (eflag) {
                printf("\nConfiguration aborted.\n");
                exit (1);
        }

        /*
         * Configuration is okay, so write the conf file and quit.
         */
        for( q = devinfo; q != NULL; q = q->next ) {
                if (q->type2 & REQ) {
                        if (!(config(q->dev))) {
                                enterdev(q, q->mult);
                        }
                }
        }

        prtconf();
        fclose( fdconf );
        fclose( fdhdr );
        exit(0);
}


/*
 * This routine is used to read in the master device table and the
 * alias table.  In the master device file, these two tables are separated
 * by a line that begins with an asterisk.
 */
file() {
        register struct t2 *q;
        register l;
        register FILE *fd;

        fd = fopen(mfile,"r");
        if (fd == NULL) {
                printf("Open error for file -- %s\n",mfile);
                exit(1);
        }
        
        while (fgets(line,100,fd) != NULL) {
                if (line[0] == '*')
                        continue;
                if (line[0] == '$')
                        break;
                q = newq();
                q->linsw[0] = '\0';
                q->lmsk = q->line = 0;
                l = sscanf(line,"%8s%ho%ho%8s%hd%hd%hd%hd%hd%8s%ho%hd",
                        q->dev,&(q->mask),&(q->type2),
                        q->hndlr,&(q->block),&(q->charr),&(q->mult),&(q->phys),&(q->log),
                        q->linsw,&(q->lmsk),&(q->line));
                if (l < 7) {
                        printf("%s\nDevice parameter count\n",line);
                        exit(1);
                }

                /*
                 * Update the ends of the block and character device tables.
                 */
                if (q->type2 & BLOCK)
                        if ((blockex = max(blockex,q->block)) >= BSIZE) {
                                printf("%s\nBad major device number\n",line);
                                exit(1);
                        }
                if (q->type2 & CHAR)
                        if ((charex = max(charex,q->charr)) >= CSIZE) {
                                printf("%s\nBad major device number\n",line);
                                exit(1);
                        }
                if( q->lmsk != 0  ) {
                        /*
                         * if the line switch table has a new entry, validate
                         */
                        if( !(q->type2 & CHAR) || l < 10 || q->lmsk == 0 || q->line >= LSIZE ) {
                                printf("%s\nBad linesw entry\n",line);
                                exit(1);
                        }
                        if( q->line > lbound )
                                lbound = q->line;
                        if( ldevices[q->line] != NULL ) {
                                printf("%s\nLinesw entry multiply defined\n",line);
                                exit(1);
                        }
                        ldevices[q->line] = q;
                }
                definedev(q);
        }
        r = alias;
        while (fgets(line,100,fd) != NULL) {
                if (line[0] == '$')
                        break;
                if (line[0] == '*')
                        continue;
                abound++;
                if (abound == ASIZE) {
                        printf("Alias table overflow\n");
                        exit(1);
                }
                l = sscanf(line,"%8s%8s",r->new,r->old);
                if (l < 2) {
                        printf("%s\nAlias parameter count\n",line);
                        exit(1);
                }
                r++;
        }
        kwdptr = parms;
        while (fgets(line,100,fd) != NULL) {
                /*
                 * Check for comment.
                 */
                if (line[0] == '*')
                        continue;
                pbound++;
                if (pbound == PSIZE) {
                        printf("Keyword table overflow\n");
                        exit(1);
                }
                l = sscanf(line,"%20s%20s%20s",kwdptr->indef,
                        kwdptr->oudef,kwdptr->defval);
                if (l < 2) {
                        printf("%s\nTunable parameter count\n",line);
                        exit(1);
                }
                if (l == 2)
                        *(kwdptr->defval) = NULL;
                kwdptr++;
        }
}

equal(s1,s2)
register char *s1, *s2;
{
        while (*s1++ == *s2) {
                if (*s2++ == 0)
                        return(1);
        }
        return(0);
}

/*
 * This routine is used to print a configuration time error message
 * and then set a flag indicating a contaminated configuration.
 */
error(message) char *message; {
        printf("%s%s\n",line,message);
        eflag++;
}

/*
 * This routine is used to search through the master device table for
 * some specified device.  If the device is found, we return a pointer to
 * the device.  If the device is not found, we search the alias table for
 * this device.  If the device is not found in the alias table, we return a
 * zero.  If the device is found, we change its name to the reference name of
 * the device and re-initiate the search for this new name in the master
 * device table.
 */
struct t2 *
master(device)
char *device;
{
        register struct t2 *q;
        register struct t3 *r;
        for (;;) {
                for( q = devinfo; q != NULL; q = q->next) {
                        if (equal(device,q->dev))
                                return(q);
                }
                for (r=alias; r<= &alias[abound]; r++) {
                        if (equal(device,r->new)) {
                                device = r->old;
                                break;
                        }
                }
                if (r > &alias[abound])
                        return(0);
        }
}

/*
 * This routine is used to set the character and/or block table pointers
 * to point to an entry of the master device table.
 */
setq( q ) register struct t2 *q; {
        register struct t2 *ptr;

        switch (q->type2 & (BLOCK|CHAR)) {
        case 0:
                break;
        case CHAR:
                subtmp = q->charr;
                ptr = cdevices[subtmp];
                if (ptr) {
                        if (!equal(ptr->dev,q->dev)) {
                                charex++;
                                if (charex == CSIZE) {
                                        printf("Character table overflow\n");
                                        exit(1);
                                }
                                q->charr = subtmp = charex;
                        }
                }
                cdevices[subtmp] = q;
                cmax = max (cmax,subtmp);
                break;
        case BLOCK:
                subtmp = q->block;
                ptr = bdevices[subtmp];
                if (ptr) {
                        if (!equal(ptr->dev,q->dev)) {
                                blockex++;
                                if (blockex == BSIZE) {
                                        printf("Block table overflow\n");
                                        exit(1);
                                }
                                q->block = subtmp = blockex;
                        }
                }
                bdevices[subtmp] = q;
                bmax = max (bmax,subtmp);
                break;
        case BLOCK|CHAR:
                subtmp = q->charr;
                ptr = cdevices[subtmp];
                if (ptr) {
                        if (!equal(ptr->dev,q->dev)) {
                                charex++;
                                if (charex == CSIZE) {
                                        printf("Character table overflow\n");
                                        exit(1);
                                }
                                q->charr = subtmp = charex;
                        }
                }
                cdevices[subtmp] = q;
                cmax = max (cmax,subtmp);
                subtmp = q->block;
                ptr = bdevices[subtmp];
                if (ptr) {
                        if (!equal(ptr->dev,q->dev)) {
                                blockex++;
                                if (blockex == BSIZE) {
                                        printf("Block table overflow\n");
                                        exit(1);
                                }
                                q->block = subtmp = blockex;
                        }
                }
                bdevices[subtmp] = q;
                bmax = max (bmax,subtmp);
                break;
        }
}

/*
 * This routine writes out the configuration file (C program.)
 */
prtconf() {
        register i, j, counter;
        register struct t2 *q;
        register struct t *p;
        short k;
        char *sname;

        for (kwdptr=parms; kwdptr<= &parms[pbound]; kwdptr++)
                fprintf(fdhdr,"#define\t%s\t%s\n",kwdptr->oudef, kwdptr->value);

        fprintf(fdconf,"\n");
        fprintf(fdconf,"/*\n *  Configuration table declaration information\n */\n\n");
        fprintf(fdconf,"#include\t\"config.h\"\n");
        fprintf(fdconf,"#include\t\"sys/param.h\"\n");
        fprintf(fdconf,"#include\t\"sys/types.h\"\n");
        fprintf(fdconf,"#include\t\"sys/sysmacros.h\"\n");
        fprintf(fdconf,"#include\t\"sys/signal.h\"\n");
        fprintf(fdconf,"#include\t\"sys/fs/s5dir.h\"\n");
        fprintf(fdconf,"#include\t\"sys/user.h\"\n");
        fprintf(fdconf,"#include\t\"sys/phinf.h\"\n");
        fprintf(fdconf,"#include\t\"sys/icb.h\"\n");
        fprintf(fdconf,"#include\t\"sys/stream.h\"\n");
        fprintf(fdconf,"#include\t\"sys/conf.h\"\n");
        fprintf(fdconf,"#include\t\"sys/space.h\"\n");
        fprintf(fdconf,"#include\t\"sys/errno.h\"\n\n");

        fprintf(fdconf,"extern nodev(), nulldev();\n");

        /*
         * Process the configuration table
         */
        for( p = table; p ; p = p->next) {
                fprintf(fdhdr,"\n#define\t%s_%d %d\n", uppermap (p->devname,capitals), p->count, p->mc);
                fprintf(fdhdr,"#define\t%s_%d_PHYS %d\n", uppermap (p->devname,capitals), p->count, p->md);

                j = 0;
                for(i = 0; i < p->md; i++) {
                        fprintf(fdhdr,"#define\t%s_%d_%d_LOG %d\n", uppermap (p->devname,capitals), p->count, i, p->ml[i]);
                        j += p->ml[i];
                }
                fprintf(fdhdr,"#define\t%s_%d_DEV %d\n", uppermap (p->devname,capitals), p->count, p->mc * j);

                if (p->count)
                        continue;
                switch (p->type & (BLOCK|CHAR)) {
                case CHAR:
                        q = master(p->devname);
			if (q->mask == 0) break;
                       	sprintf(xbf,"extern ");
                        if (q->mask & OPEN) {
                                strcat (xbf,q->hndlr);
                                strcat (xbf,"open(), ");
                        }
                        if (q->mask & CLOSE) {
                                strcat (xbf,q->hndlr);
                                strcat (xbf,"close(), ");
                        }
                        if (q->mask & READ) {
                                strcat (xbf,q->hndlr);
                                strcat (xbf,"read(), ");
                        }
                        if (q->mask & WRITE) {
                                strcat (xbf,q->hndlr);
                                strcat (xbf,"write(), ");
                        }
                        if (q->mask & IOCTL) {
                                strcat (xbf,q->hndlr);
                                strcat (xbf,"ioctl(), ");
                        }
                        if (q->mask & PWR)
                                if (power) {
                                        strcat (xbf,q->hndlr);
                                        strcat (xbf,"clr(), ");
                                }
                        if (q->mask & INIT) {
                                strcat (xbf,q->hndlr);
                                strcat (xbf,"init(), ");
/*kd0*/
                        }
                        xbf[strlen(xbf)-2] = ';';
                        xbf[strlen(xbf)-1] = NULL;
                        fprintf(fdconf,"%s\n",xbf);
			if (q->mask & STR)
			{
				fprintf(fdconf,"extern struct streamtab %sinfo;\n",q->hndlr);
			}
                        break;
                case BLOCK:
                        fprintf(fdconf, "extern %sopen(), %sclose(), %sstrategy(), %sprint();\n",
                                p->handler,p->handler,p->handler,p->handler);
                        break;
                case BLOCK|CHAR:
                        q = master(p->devname);
                        sprintf(xbf,"extern %sopen(), %sclose(), ", q->hndlr,q->hndlr);
                        if (q->mask & READ) {
                                strcat (xbf,q->hndlr);
                                strcat (xbf,"read(), ");
                        }
                        if (q->mask & WRITE) {
                                strcat (xbf,q->hndlr);
                                strcat (xbf,"write(), ");
                        }
                        if (q->mask & IOCTL) {
                                strcat (xbf,q->hndlr);
                                strcat (xbf,"ioctl(), ");
                        }
                        if (q->mask & PWR)
                                if (power) {
                                        strcat (xbf,q->hndlr);
                                        strcat (xbf,"clr(), ");
                                }
                        if (q->mask & INIT) {
                                strcat (xbf,q->hndlr);
                                strcat (xbf,"init(), ");
                        }
                        strcat (xbf,q->hndlr);
                        strcat (xbf,"strategy(), ");
                        strcat (xbf,q->hndlr);
                        strcat (xbf,"print();");
                        fprintf(fdconf,"%s\n",xbf);
                        break;
                }
        }

        fprintf(fdconf,"\nstruct bdevsw bdevsw[] = {\n");
/*
 * Go through block device table and indicate addresses of required routines.
 * If a particular device is not present, fill in "nodev" entries.
 */
        for (i=0; i<=bmax; i++) {
                q = bdevices[i];
                fprintf(fdconf,"/*%2d*/\t",i);
                if (q) {
                        fprintf(fdconf,"%sopen, %sclose, %sstrategy, %sprint,\n",
                                q->hndlr, q->hndlr, q->hndlr, q->hndlr);
                }else   fprintf(fdconf,"nodev,  nodev,  nodev,  0, \n");
        }
        fprintf(fdconf,"};\n\n");
/* define STR and TTY */

        fprintf(fdconf,"#define\tSTR (struct streamtab *)0\n");
        fprintf(fdconf,"#define\tTTY (struct tty *)-1\n");
        fprintf(fdconf,"#define\tLGCTTY (struct tty *)L_GCTTY\n\n"); /*kd0*/

        fprintf(fdconf,"struct cdevsw cdevsw[] = {\n");
/*
 * Go through character device table and indicate addresses of required
 * routines, or indicate "nulldev" if routine is not present.  If a
 * particular device is not present, fill in "nodev" entries.
 */
        for (j=0; j<=cmax; j++) {
                q = cdevices[j];
                fprintf(fdconf,"/*%2d*/\t",j);
                if (q) {
                        if (q->mask & OPEN)
                                fprintf(fdconf,"%sopen, ",q->hndlr);
                        else    fprintf(fdconf,"nulldev, ");
                        if (q->mask & CLOSE)
                                fprintf(fdconf,"%sclose, ",q->hndlr);
                        else    fprintf(fdconf,"nulldev, ");
                        if (q->mask & READ)
                                fprintf(fdconf,"%sread, ",q->hndlr);
                        else    fprintf(fdconf,"nodev,  ");
                        if (q->mask & WRITE)
                                fprintf(fdconf,"%swrite, ",q->hndlr);
                        else    fprintf(fdconf,"nodev,  ");
                        if (q->mask & IOCTL)
                                fprintf(fdconf,"%sioctl, ",q->hndlr);
                        else    fprintf(fdconf,"nodev,  ");
                        if (q->mask & TTYS) /*kd0*/
				if (strcmp(q->hndlr,"gctty_") == 0)
                                	fprintf(fdconf,"L%s, ",
						uppermap( q->dev, capitals ) );
				else fprintf(fdconf,"L_%s, ", 
					uppermap( q->dev, capitals ) );
                        else    fprintf(fdconf,"TTY, ");
                        if (q->mask & STR)
                                fprintf(fdconf,"&%sinfo,\n",q->hndlr);
                        else    fprintf(fdconf,"STR,\n");
                }else   fprintf(fdconf,"nodev,  nodev,  nodev,  nodev,  nodev,  TTY,  STR,\n");
        }
        fprintf(fdconf,"};\n\n");

	/* begin ken#0 */

	fprintf( fdconf, "\/\* Non-mapped buffer usage table \*\/" );
	fprintf( fdconf, "\nint buftypes[] = \{" ); 
        for (i=0; i<=bmax; i++)
		{
                q = bdevices[i];
		if ( q->type2 & LKERN )
			fprintf( fdconf, "0xff," );
		else
			fprintf( fdconf, "0x00," );
		}
	fprintf( fdconf, "\};\n\n" );

	/* end ken#0 */
/*
 * Print out block and character device counts, root, swap, and dump device
 * information, and the swplo, and nswap values.
 */
        fprintf(fdconf,"int\tbdevcnt = %d;\nint\tcdevcnt = %d;\n\n",i,j);
        fprintf(fdconf,"dev_t\trootdev = makedev(%d, %d);\n",rtmaj,rtmin);
        fprintf(fdconf,"dev_t\tpipedev = makedev(%d, %d);\n",pipmaj,pipmin);
        fprintf(fdconf,"dev_t\tswapdev = makedev(%d, %d);\n",swpmaj,swpmin);
        fprintf(fdconf,"daddr_t\tswplo = %lu;\nint\tnswap = %d;\n\n",swplo,nswap);

/*
 * Initialize the power fail and init handler buffers
 */
        sprintf(pwrbf,"\nint\t(*pwr_clr[])() = {");
        sprintf(initbf,"\nint\t(*dev_init[])() = {");
/*
 * Write out NULL entry into power fail and init buffers.
 */
        sprintf(&pwrbf[strlen(pwrbf)],"\t(int (*)())0\n};\n");
        sprintf(&initbf[strlen(initbf)],"\t(int (*)())0\n};\n");
        fprintf(fdconf,"%s",pwrbf);
        fprintf(fdconf,"%s",initbf);

/*
 * create the lineswitch table
 */
        if( lbound < 0 ) {
                /*
                 * no line switch entries
                 * put out null value for table
                 */
                fprintf(fdconf,"\nstruct linesw linesw[] = {\n");
                fprintf(fdconf,"\tnulldev, nulldev, nulldev, nulldev, nulldev, nulldev, nulldev, nulldev,\n");
        }else   {
                for (j=0; j<=lbound; j++) {
                        q = ldevices[j];
                        if( q == (struct t2 *)0 || q->lmsk == 0 )
                                continue;
                        fprintf(fdconf,"#ifdef\t%s_0\n", uppermap( q->dev, capitals ) );
                        sprintf(xbf,"extern ");
                        if (q->lmsk & OPEN) {
                                strcat (xbf,q->linsw);
                                strcat (xbf,"open(), ");
                        }
                        if (q->lmsk & CLOSE) {
                                strcat (xbf,q->linsw);
                                strcat (xbf,"close(), ");
                        }
                        if (q->lmsk & READ) {
                                strcat (xbf,q->linsw);
                                strcat (xbf,"read(), ");
                        }
                        if (q->lmsk & WRITE) {
                                strcat (xbf,q->linsw);
                                strcat (xbf,"write(), ");
                        }
                        if (q->lmsk & IOCTL) {
                                strcat (xbf,q->linsw);
                                strcat (xbf,"ioctl(), ");
                        }
                        if (q->lmsk & RXINT) {
                                strcat (xbf,q->linsw);
                                strcat (xbf,"in(), ");
                        }
                        if (q->lmsk & TXINT) {
                                strcat (xbf,q->linsw);
                                strcat (xbf,"out(), ");
                        }
                        if (q->lmsk & MDMINT) {
                                strcat (xbf,q->linsw);
                                strcat (xbf,"mdm(), ");
                        }
                        xbf[strlen(xbf)-2] = ';';
                        xbf[strlen(xbf)-1] = NULL;
                        fprintf(fdconf,"%s\n",xbf);
                        fprintf(fdconf,"#endif\n");
                }
                fprintf(fdconf,"\nstruct linesw linesw[] = {\n");
                for (j=0; j<=lbound; j++) {
                        q = ldevices[j];
                        fprintf(fdconf,"/*%2d*/",j);
                        if( q == (struct t2 *)0 ) {
                                fprintf(fdconf,"\tnulldev, nulldev, nulldev, nulldev, nulldev, nulldev, nulldev, nulldev,\n");
                                continue;
                        }
                        fprintf(fdconf,"\n#ifdef\t%s_0\n\t", uppermap( q->dev, capitals ) );
                        if( q->lmsk & OPEN )
                                fprintf(fdconf,"%sopen, ",q->linsw);
                        else    fprintf(fdconf,"nulldev, ");
                        if( q->lmsk & CLOSE )
                                fprintf(fdconf,"%sclose, ",q->linsw);
                        else    fprintf(fdconf,"nulldev, ");
                        if( q->lmsk & READ )
                                fprintf(fdconf,"%sread, ",q->linsw);
                        else    fprintf(fdconf,"nulldev, ");
                        if( q->lmsk & WRITE )
                                fprintf(fdconf,"%swrite, ",q->linsw);
                        else    fprintf(fdconf,"nulldev, ");
                        if( q->lmsk & IOCTL )
                                fprintf(fdconf,"%sioctl, ",q->linsw);
                        else    fprintf(fdconf,"nulldev, ");
                        if( q->lmsk & RXINT )
                                fprintf(fdconf,"%sin, ",q->linsw);
                        else    fprintf(fdconf,"nulldev, ");
                        if( q->lmsk & TXINT )
                                fprintf(fdconf,"%sout, ",q->linsw);
                        else    fprintf(fdconf,"nulldev, ");
                        if( q->lmsk & MDMINT )
                                fprintf(fdconf,"%smdm, ",q->linsw);
                        else    fprintf(fdconf,"nulldev, ");
                        fprintf(fdconf,"\n#else\n");
                        fprintf(fdconf,"\tnulldev, nulldev, nulldev, nulldev, nulldev, nulldev, nulldev, nulldev,\n");
                        fprintf(fdconf,"#endif\n");
                }
        }

/* number on entries in linesw */
        fprintf(fdconf,"};\n");
        fprintf(fdconf,"int\tlinecnt = %d;\n",lbound+1);

/*
 * Virtual Terminal Switch Table
 */

        fprintf(fdconf,"\n#ifdef VT_VT100\n");
        fprintf(fdconf,"extern  vt100input(), vt100output(), vt100ioctl();\n");
        fprintf(fdconf,"#endif\n");
        fprintf(fdconf,"#ifdef VT_HP45\n");
        fprintf(fdconf,"extern  hp45input(), hp45output(), hp45ioctl();\n");
        fprintf(fdconf,"#endif\n");
        fprintf(fdconf,"struct termsw termsw[] = {\n");
        fprintf(fdconf,"\tnulldev, nulldev, nulldev, /* tty */\n");
        fprintf(fdconf,"#ifdef VT_VT100\n");
        fprintf(fdconf,"\tvt100input, vt100output, vt100ioctl, /* VT100 */\n");
        fprintf(fdconf,"#else\n");
        fprintf(fdconf,"\tnulldev, nulldev, nulldev,\n");
        fprintf(fdconf,"#endif\n");
        fprintf(fdconf,"#ifdef VT_HP45\n");
        fprintf(fdconf,"\thp45input, hp45output, hp45ioctl, /* HP45 */\n");
        fprintf(fdconf,"#else\n");
        fprintf(fdconf,"\tnulldev, nulldev, nulldev,\n");
        fprintf(fdconf,"#endif\n");
        fprintf(fdconf,"};\n");

/* number of entries in termsw */
        fprintf(fdconf,"int\ttermcnt = sizeof(termsw) / sizeof(struct termsw);\n");

}

max(a,b) int a, b; { return(a>b ? a:b); }

/*
 * This routine is used to search the configuration table for some
 * specified device.  If the device is found we return a pointer to
 * that device.  If the device is not found, we search the alias
 * table for this device.  If the device is not found in the alias table
 * we return a zero.  If the device is found, we change its name to
 * the reference name of the device and re-initiate the search for this
 * new name in the configuration table.
 */

struct t *
config(device) char *device; {
        register struct t *p;
        register struct t3 *r;

        for (;;) {
                for( p = table; p != NULL; p = p->next) {
                        if (equal(device,p->devname))
                                return(p);
                }
                for (r=alias; r<= &alias[abound]; r++) {
                        if (equal(device,r->new)) {
                                device = r->old;
                                break;
                        }
                }
                if (r > &alias[abound])
                        return(NULL);
        }
}

/*
 * This routine is used to search the parameter table
 * for the keyword that was specified in the configuration.  If the
 * keyword cannot be found in this table, a value of zero is returned.
 * If the keyword is found, a pointer to that entry is returned.
 */
struct t4 *
lookup(keyword) char *keyword; {
        register struct t4 *kwdptr;
        for (kwdptr=parms; kwdptr<= &parms[pbound]; kwdptr++) {
                if (equal(keyword,kwdptr->indef))
                        return (kwdptr);
        }
        return(0);
}

/*
 * This routine is used to map lower case alphabetics into upper case.
 */
char *
uppermap(device,caps) char *device, *caps; {
        register char *ptr;
        register char *ptr2;

        ptr2 = caps;
        for (ptr=device; *ptr!=NULL; ptr++) {
                if ('a' <= *ptr && *ptr <= 'z')
                        *ptr2++ = *ptr + 'A' - 'a';
                else
                        *ptr2++ = *ptr;
        }
        *ptr2 = NULL;
        return (caps);
}

/*
 * This routine enters the device in the configuration table.
 */
enterdev(q, mc) register struct t2 *q; register int mc; {
        register struct t *p;
        register int i;

        p = newp( q->phys );
        setq( q );
        p->devname = q->dev;
        p->type = q->type2;
        p->handler = q->hndlr;
        p->count = q->dcount;
        p->blk = q->block;
        p->chr = q->charr;
        p->mc = mc;
        p->md = q->phys;
        for( i = 0; i < q->phys; i++ )
                p->ml[i] = q->log;
        q->dcount++;
}

struct t2 *
newq() {
        register struct t2 *q;

        if( (q = (struct t2 *)malloc(sizeof(struct t2))) == NULL) {
                error("Can't malloc master entry");
                exit(1);
        }
        if( devinfo == NULL ) {
                q->next = NULL;
                devinfo = q;
        }else   {
                q->next = devinfo->next;
                devinfo->next = q;
        }
        return( q );
}

struct t *
newp( md ) register int md; {
        register struct t *p;

        if( (p = (struct t *)malloc(sizeof(struct t) + ((md-1)*sizeof(short)))) == NULL) {
                error("Can't malloc table entry");
                exit(1);
        }
        if( table == NULL ) {
                p->next = NULL;
                table = p;
        }else   {
                p->next = table->next;
                table->next = p;
        }
        return( p );
}

definedev(q) register struct t2 *q; {
        /*
         * Write upper case define statements and sequence number for device.
         */
        if (q->type2 & BLOCK) {
                /*
                 * output B_uppermap(q->dev,capitals) major_dev
                 */
                fprintf(fdhdr,"#define\tB_%s\t%d\t\t/* bdevsw entry for %s */\n", uppermap (q->dev,capitals), q->block, q->hndlr);
        }
        if (q->type2 & CHAR) {
                /*
                 * output C_uppermap(q->dev,capitals) major_dev
                 */
                fprintf(fdhdr,"#define\tC_%s\t%d\t\t/* cdevsw entry for %s */\n", uppermap (q->dev,capitals), q->charr, q->hndlr);
        }
        if( q->lmsk != 0  ) {
                /*
                 * output L_uppermap(q->dev,capitals) major_dev
                 */
                fprintf(fdhdr,"#define\tL_%s\t%d\t\t/* linesw entry for %s */\n", uppermap (q->dev,capitals), q->line, q->hndlr);
        }
}



