/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) in_data.h: version 25.1 created on 12/2/91 at 14:01:59	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)in_data.h	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/


/*
 *	in_data.h -- defines and structures for input structures
 */

#include <stdio.h>
#include <ctype.h>

#define DSIZE		128	/* max block/character device table	*/

#define CASE		break;case	/* for convenience in switches	*/
#define DEFAULT		break;default

#define EOS		(-2)		/* end of section		*/
#define MAJ_UNKNOWN	(-3)		/* major number unknown/request	*/

#define FILELEN		128		/* length of a filename		*/
#define MAXLEN		256		/* length of a line		*/

#define TO_MAJOR(x)	makedev(x, 0)	/* convert a major to a dev_t	*/
#define NEL(x)		(int)(sizeof(x) / sizeof(*x))
#define MAX(a, b)	((a) > (b) ? (a) : (b))
#define EQ(a, b)	(strcmp(a, b) == 0)

#define STRSIZE(a)	((int)sizeof(a) - 1) /* char array string size 	*/

#define CNULL		((char *)NULL)	/* a cast to make lint happy	*/
#define INULL		((int *)NULL)	/* a cast to make lint happy	*/

#define ERROR_LIMIT	2		/* die after this many errors	*/

#define ungetline(ip)	((ip)->in_ptr = (ip)->in_buf)	/* unget this line */

/*
 * These input data structures are used by the different parsers, and are
 * initialized by openfile.
 */
typedef struct in_data {
	FILE	*in_fp;			/* input file pointer		*/
	char	*in_ptr;		/* current input char pointer	*/
	int	in_lineno;		/* current line number in file	*/
	char	in_filename[FILELEN];	/* file's name			*/
	char	in_buf[MAXLEN];		/* input line buffer		*/
	char	in_dup[MAXLEN];		/* copy of input line buffer	*/
	int	in_nodup;		/* don't use in_dup		*/
} in_t;

extern char	*progname;

extern FILE	*doopen();
extern char	*alloc(), *getword(), *pathend(), *stradd();
