/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) clri.c: version 25.1 created on 12/2/91 at 13:59:23	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)clri.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*	AT&T: #ident	"clri:clri.c	1.10"		*/
#ident	"@(#)clri:clri.c	25.1"

/*
 * clri filsys inumber ...
 */
#include <sys/param.h>
#include <sys/types.h>
#include <sys/ino.h>
#include <sys/fs/s5filsys.h>
#include <stdio.h>

/* file system block size */
#if (vax || u3b || u3b15 || u3b2) && (FsTYPE == 3)
#if u3b15
#define FSBSIZE (BSIZE*4)
#else
#define FSBSIZE	(BSIZE*2)
#endif
#else
#define	FSBSIZE BSIZE
#endif

#define MAXBSIZE 4096

#define	MX_NBINODE_OLD  (MAXBSIZE/FsINODESIZE)
#define MX_NBINODE_NEW  (MAXBSIZE/SEC_INODESIZE)

/*struct filsys sblock; */
int	bsize, nbinode;
int	status;
struct	ino_old {
	char	junk [FsINODESIZE];
	} buf_old[MX_NBINODE_OLD];
struct  ino_new {
	char	junk [SEC_INODESIZE];
	} buf_new[MX_NBINODE_NEW];

main(argc, argv)
char *argv[];
{
	register i, f;
	unsigned n;
	int j, k, isize;
	long off;
	char	*buf;
	struct	filsys	*sblock;
	char *fbuf , *cp, malloc();




	if(argc < 3) {
		printf("usage: clri filsys inumber ...\n");
		exit(4);
	}

	isize = inode_size (argv[1]);
	/* Here we determine where buf points to, depending on the size
	   of the inode, mer */
	if (isize == FsINODESIZE)

		buf = (char *)buf_old;

	else if (isize == SEC_INODESIZE)

		buf = (char *)buf_new;

	else {

		fprintf (stderr, "%s: Illegal inode size\n", argv[0]);
		exit (1);
	}


	f = open(argv[1], 2);
	if(f < 0) {
		printf("cannot open %s\n", argv[1]);
		exit(4);
	}

	fbuf=malloc(BSIZE);
	
	if (lseek(f, (long)0, 0) < 0
		|| read(f, fbuf, BSIZE) != BSIZE) {
		printf("cannot read super-block of %s\n", argv[1]);
		close(f);
		exit(4);
	}
	
	cp= fbuf+512;
	sblock=(struct filsys *)cp;

	if(sblock->s_magic == FsMAGIC) {
		if(sblock->s_type == Fs2b || sblock->s_type == FsSEC1) {
			bsize = BSIZE;
		} else if(sblock->s_type == Fs4b) {
			bsize = 2 * BSIZE;
		} else if(sblock->s_type == Fs8b || sblock->s_type == FsSEC4) {
			bsize = 4 * BSIZE;
		} else {
			printf("bad block type in %s\n", argv[1]);
			exit(4);
		}
	} else {
		bsize = BSIZE;
	}
	nbinode = bsize / isize;
	for(i=2; i<argc; i++) {
		if(!isnumber(argv[i])) {
			printf("%s: is not a number\n", argv[i]);
			status = 1;
			continue;
		}
		n = atoi(argv[i]);
		if(n == 0) {
			printf("%s: is zero\n", argv[i]);
			status = 1;
			continue;
		}
		off = ((n-1)/nbinode + 2) * (long)bsize;
		lseek(f, off, 0);
		if(read(f, (char *)buf, bsize) != bsize) {
			printf("%s: read error\n", argv[i]);
			status = 1;
		}
	}
	if(status)
		exit(status);
	for(i=2; i<argc; i++) {
		n = atoi(argv[i]);
		printf("clearing %u\n", n);
		off = ((n-1)/nbinode + 2) * (long)bsize;
		lseek(f, off, 0);
		read(f, (char *)buf, bsize);
		j = (n-1)%nbinode;
		for(k=0; k<isize; k++){
			
			if (isize == FsINODESIZE)

				buf_old[j].junk[k] = 0;

			else
	
				buf_new[j].junk[k] = 0;
		}
		lseek(f, off, 0);
		write(f, (char *)buf, bsize);
	}
	exit(status);
}

isnumber(s)
char *s;
{
	register c;

	while(c = *s++)
		if(c < '0' || c > '9')
			return(0);
	return(1);
}
