/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) setsched.c: version 25.1 created on 12/2/91 at 13:58:50	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)setsched.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include	<sys/types.h>
#include	<sys/schedcpu.h>
#include	<errno.h>

/*
 *	chgsched(CMD, nval ptr, oval ptr)
 */

getschedtype(oval)
register int	*oval;
{
	errno = 0;
	return (chgsched(SCHED_GETSCHEDTYPE,0,oval));
}

setschedtype(nval,oval)
register int	*nval, *oval;
{
	errno = 0;
	return (chgsched(SCHED_SETSCHEDTYPE,nval,oval));
}

getschedmode(oval)
register int	*oval;
{
	errno = 0;
	return (chgsched(SCHED_GETMODE,0,oval));
}

setschedmode(nval,oval)
register int	*nval, *oval;
{
	errno = 0;
	return (chgsched(SCHED_SETMODE,nval,oval));
}

getschedloadavg(oval)
register int	*oval;
{
	errno = 0;
	return (chgsched(SCHED_GETLOADAVG,0,oval));
}

setschedloadavg(nval,oval)
register int	*nval, *oval;
{
	errno = 0;
	return (chgsched(SCHED_SETLOADAVG,nval,oval));
}

getschedarray(oval)
register int	*oval;
{
	errno = 0;
	return (chgsched(SCHED_GETARRAY,0,oval));
}

setschedarray(nval,oval)
register int	*nval, *oval;
{
	errno = 0;
	return (chgsched(SCHED_SETARRAY,nval,oval));
}

getschedcpulimit(oval)
register int	*oval;
{
	errno = 0;
	return (chgsched(SCHED_GETCPULIMIT,0,oval));
}

setschedcpulimit(nval,oval)
register int	*nval, *oval;
{
	errno = 0;
	return (chgsched(SCHED_SETCPULIMIT,nval,oval));
}

getschedcpudecay(oval)
register int	*oval;
{
	errno = 0;
	return (chgsched(SCHED_GETCPUDECAY,0,oval));
}

setschedcpudecay(nval,oval)
register int	*nval, *oval;
{
	errno = 0;
	return (chgsched(SCHED_SETCPUDECAY,nval,oval));
}

getschedcpuattack(oval)
register int	*oval;
{
	errno = 0;
	return (chgsched(SCHED_GETCPUATTACK,0,oval));
}

setschedcpuattack(nval,oval)
register int	*nval, *oval;
{
	errno = 0;
	return (chgsched(SCHED_SETCPUATTACK,nval,oval));
}

getschedone(cmd,oval)
register int	cmd, *oval[];
{
	errno = 0;
	switch (cmd) {
	case IDX_GETCLKCPU:		/* to get individual indexes	*/
	case IDX_GETCLKPRI:		/* to get individual indexes	*/
	case IDX_GETUKCLKCPU:		/* to get individual indexes	*/
	case IDX_GETUKCLKPRI:		/* to get individual indexes	*/
	case IDX_GETUKCLKSLP:		/* to get individual indexes	*/
	case IDX_GETWAKEUPPRI:		/* to get individual indexes	*/
	case IDX_GETSETRUNPRI:		/* to get individual indexes	*/
	case IDX_GETUSERPRI:		/* to get individual indexes	*/
	case IDX_GETEXITCPU:		/* to get individual indexes	*/
	case IDX_GETLOADAVG:		/* to get individual indexes	*/
		break;

	default:
		errno = EINVAL;
		return (-1);
	}
	return (chgsched(cmd,0,oval));
}

setschedone(cmd,nval,oval)
register int	cmd, *nval[], *oval[];
{
	errno = 0;
	switch (cmd) {
	case IDX_SETCLKCPU:		/* to set individual indexes	*/
	case IDX_SETCLKPRI:		/* to set individual indexes	*/
	case IDX_SETUKCLKCPU:		/* to set individual indexes	*/
	case IDX_SETUKCLKPRI:		/* to set individual indexes	*/
	case IDX_SETUKCLKSLP:		/* to set individual indexes	*/
	case IDX_SETWAKEUPPRI:		/* to set individual indexes	*/
	case IDX_SETSETRUNPRI:		/* to set individual indexes	*/
	case IDX_GETUSERPRI:		/* to get individual indexes	*/
	case IDX_SETEXITCPU:		/* to set individual indexes	*/
	case IDX_GETLOADAVG:		/* to get individual indexes	*/
		break;

	default:
		errno = EINVAL;
		return (-1);
	}
	return (chgsched(cmd,nval,oval));
}

getscheddebug(oval)
register int	*oval;
{
	errno = 0;
	return (chgsched(SCHED_GETDEBUG,0,oval));
}

setscheddebug(nval,oval)
register int	*nval, *oval;
{
	errno = 0;
	return (chgsched(SCHED_SETDEBUG,nval,oval));
}
