/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) chsched.c: version 25.1 created on 12/2/91 at 13:58:43	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)chsched.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include	<stdio.h>
#include	<errno.h>
#include	<sys/types.h>
#include	<sys/param.h>
#include	<sys/proc.h>
#include	<sys/schedcpu.h>

char	*pname, *cname;
char	*cmdprefix = "sched";
char	*cmd1	   = "schedtype";
char	*cmd2	   = "schedmode";
char	*cmd3	   = "schedloadavg";
char	*cmd4	   = "schedarray";
char	*cmd5	   = "schedcpulimit";
char	*cmd6	   = "schedcpudecay";
char	*cmd7	   = "schedcpuattack";

int	oldval, newval;

main(argc,argv)
register int	argc;
register char	*argv[];
{
	pname = "";
	if ((cname = (char *)strrchr(argv[0],'/')) == NULL)
		cname = argv[0];
	else
		cname++;
	if (strcmp(cname,cmd1) == 0)
		exit (dotype(argc,argv));
	if (strcmp(cname,cmd2) == 0)
		exit (domode(argc,argv));
	if (strcmp(cname,cmd3) == 0)
		exit (doloadavg(argc,argv));
	if (strcmp(cname,cmd4) == 0)
		exit (doarray(argc,argv));
	if (strcmp(cname,cmd5) == 0)
		exit (docpulimit(argc,argv));
	if (strcmp(cname,cmd6) == 0)
		exit (docpudecay(argc,argv));
	if (strcmp(cname,cmd7) == 0)
		exit (docpuattack(argc,argv));
	pname = cname;
	if (argc < 2)
		exit(usage(cname));
	argc--;
	argv++;
	if ((cname = (char *)strrchr(argv[0],'/')) == NULL)
		cname = argv[0];
	else
		cname++;
	if (strcmp(cname,cmd1+strlen(cmdprefix)) == 0)
		exit (dotype(argc,argv));
	if (strcmp(cname,cmd2+strlen(cmdprefix)) == 0)
		exit (domode(argc,argv));
	if (strcmp(cname,cmd3+strlen(cmdprefix)) == 0)
		exit (doloadavg(argc,argv));
	if (strcmp(cname,cmd4+strlen(cmdprefix)) == 0)
		exit (doarray(argc,argv));
	if (strcmp(cname,cmd5+strlen(cmdprefix)) == 0)
		exit (docpulimit(argc,argv));
	if (strcmp(cname,cmd6+strlen(cmdprefix)) == 0)
		exit (docpudecay(argc,argv));
	if (strcmp(cname,cmd7+strlen(cmdprefix)) == 0)
		exit (docpuattack(argc,argv));
	exit(usage(cname));
}

dotype(argc,argv)
register int	argc;
register char	*argv[];
{
	if ((argv[1][0] == '-') && (argv[1][1] == 'h'))
		return (usagetype(cname));
	if ((argv[1][0] == '-') && (argv[1][1] == '?'))
		return (usage(cname));
	if ((argv[1][0] == '-') && (argv[1][1] == 'd')) {
		argc--;
		argv++;
		return (doscheddebug(argc,argv));
	}
	if (getschedtype(&oldval) < 0) {
		fprintf(stderr,"%s: get old scheduler type: ",
			cname);
		perror("getschedtype");
		return (-errno);
	}
	if (argc < 2) {
		fprintf(stderr,"current scheduler type is %d\n",
			oldval);
		return (oldval);
	}
	newval = atoi(argv[1]);
	if (setschedtype(&newval,&oldval) < 0) {
		fprintf(stderr,"%s: set new scheduler type to %d: ",
			cname,newval);
		perror("setschedtype");
		return (-errno);
	}
	fprintf(stderr,"change scheduler type from %d to %d\n",
		oldval,newval);
	return (newval);
}

domode(argc,argv)
register int	argc;
register char	*argv[];
{
	if ((argv[1][0] == '-') && (argv[1][1] == 'h'))
		return (usagemode(cname));
	if ((argv[1][0] == '-') && (argv[1][1] == '?'))
		return (usage(cname));
	if ((argv[1][0] == '-') && (argv[1][1] == 'd')) {
		argc--;
		argv++;
		return (doscheddebug(argc,argv));
	}
	if (getschedmode(&oldval) < 0) {
		fprintf(stderr,"%s: get old scheduler mode: ",
			cname);
		perror("getschedmode");
		return (-errno);
	}
	if (argc < 2) {
		fprintf(stderr,"current scheduler mode is %d\n",
			oldval);
		return (oldval);
	}
	newval = atoi(argv[1]);
	if (setschedmode(&newval,&oldval) < 0) {
		fprintf(stderr,"%s: set new scheduler mode to %d: ",
			cname,newval);
		perror("setschedmode");
		return (-errno);
	}
	fprintf(stderr,"change scheduler mode from %d to %d\n",
		oldval,newval);
	return (newval);
}

doloadavg(argc,argv)
register int	argc;
register char	*argv[];
{
	if ((argv[1][0] == '-') && (argv[1][1] == 'h'))
		return (usageloadavg(cname));
	if ((argv[1][0] == '-') && (argv[1][1] == '?'))
		return (usage(cname));
	if ((argv[1][0] == '-') && (argv[1][1] == 'd')) {
		argc--;
		argv++;
		return (doscheddebug(argc,argv));
	}
	if (getschedloadavg(&oldval) < 0) {
		fprintf(stderr,"%s: get old scheduler loadavg index: ",
			cname);
		perror("getschedloadavg");
		return (-errno);
	}
	if (argc < 2) {
		fprintf(stderr,"current scheduler loadavg index is %d\n",
			oldval);
		return (oldval);
	}
	newval = atoi(argv[1]);
	if (setschedloadavg(&newval,&oldval) < 0) {
		fprintf(stderr,"%s: set new scheduler loadavg index to %d: ",
			cname,newval);
		perror("setschedloadavg");
		return (-errno);
	}
	fprintf(stderr,"change scheduler loadavg index from %d to %d\n",
		oldval,newval);
	return (newval);
}

doarray(argc,argv)
register int	argc;
register char	*argv[];
{
int	i;
int	oldarray[SCHED_NUMIDX+1];
int	newarray[SCHED_NUMIDX+1];

	if ((argv[1][0] == '-') && (argv[1][1] == 'h'))
		return (usagearray(cname));
	if ((argv[1][0] == '-') && (argv[1][1] == '?'))
		return (usage(cname));
	if ((argv[1][0] == '-') && (argv[1][1] == 'd')) {
		argc--;
		argv++;
		return (doscheddebug(argc,argv));
	}
	if (getschedarray(&oldarray[0]) < 0) {
		fprintf(stderr,"%s: get old scheduler array: ",cname);
		perror("getschedarray");
		return (-errno);
	}
	if (argc < 2) {
		fprintf(stderr,"current scheduler array is:\n\t");
		for (i = 0; i < SCHED_NUMIDX; i++) {
			fprintf(stderr,"%2d ",i);
		}
		fprintf(stderr,"\n\t");
		for (i = 0; i < SCHED_NUMIDX-1; i++) {
			fprintf(stderr,"---");
		}
		fprintf(stderr,"--\n\t");
		for (i = 0; i < SCHED_NUMIDX; i++) {
			fprintf(stderr,"%2d ",oldarray[i]);
		}
		fprintf(stderr,"\n");
		return (0);
	}
	return (usagearray(cname));
}

docpulimit(argc,argv)
register int	argc;
register char	*argv[];
{
	if ((argv[1][0] == '-') && (argv[1][1] == 'h'))
		return (usagecpulimit(cname));
	if ((argv[1][0] == '-') && (argv[1][1] == '?'))
		return (usage(cname));
	if ((argv[1][0] == '-') && (argv[1][1] == 'd')) {
		argc--;
		argv++;
		return (doscheddebug(argc,argv));
	}
	if (getschedcpulimit(&oldval) < 0) {
		fprintf(stderr,"%s: get old scheduler cpu limit: ",
			cname);
		perror("getschedcpulimit");
		return (-errno);
	}
	if (argc < 2) {
		fprintf(stderr,"current scheduler cpu limit is %d\n",
			oldval);
		return (oldval);
	}
	newval = atoi(argv[1]);
	if (setschedcpulimit(&newval,&oldval) < 0) {
		fprintf(stderr,"%s: set new scheduler cpu limit to %d: ",
			cname,newval);
		perror("setschedcpulimit");
		return (-errno);
	}
	fprintf(stderr,"change scheduler cpu limit from %d to %d\n",
		oldval,newval);
	return (newval);
}

docpudecay(argc,argv)
register int	argc;
register char	*argv[];
{
	if ((argv[1][0] == '-') && (argv[1][1] == 'h'))
		return (usagecpudecay(cname));
	if ((argv[1][0] == '-') && (argv[1][1] == '?'))
		return (usage(cname));
	if ((argv[1][0] == '-') && (argv[1][1] == 'd')) {
		argc--;
		argv++;
		return (doscheddebug(argc,argv));
	}
	if (getschedcpudecay(&oldval) < 0) {
		fprintf(stderr,"%s: get old scheduler cpu decay rate: ",
			cname);
		perror("getschedcpudecay");
		return (-errno);
	}
	if (argc < 2) {
		fprintf(stderr,"current scheduler cpu decay rate is 1/%d\n",
			oldval);
		return (oldval);
	}
	newval = atoi(argv[1]);
	if (setschedcpudecay(&newval,&oldval) < 0) {
		fprintf(stderr,"%s: set new scheduler cpu decay rate to 1/%d: ",
			cname,newval);
		perror("setschedcpudecay");
		return (-errno);
	}
	fprintf(stderr,"change scheduler cpu decay rate from 1/%d to 1/%d\n",
		oldval,newval);
	return (newval);
}

docpuattack(argc,argv)
register int	argc;
register char	*argv[];
{
	if ((argv[1][0] == '-') && (argv[1][1] == 'h'))
		return (usagecpuattack(cname));
	if ((argv[1][0] == '-') && (argv[1][1] == '?'))
		return (usage(cname));
	if ((argv[1][0] == '-') && (argv[1][1] == 'd')) {
		argc--;
		argv++;
		return (doscheddebug(argc,argv));
	}
	if (getschedcpuattack(&oldval) < 0) {
		fprintf(stderr,"%s: get old scheduler cpu attack rate: ",
			cname);
		perror("getschedcpuattack");
		return (-errno);
	}
	if (argc < 2) {
		fprintf(stderr,"current scheduler cpu attack rate is %d\n",
			oldval);
		return (oldval);
	}
	newval = atoi(argv[1]);
	if (setschedcpuattack(&newval,&oldval) < 0) {
		fprintf(stderr,"%s: set new scheduler cpu attack rate to %d: ",
			cname,newval);
		perror("setschedcpuattack");
		return (-errno);
	}
	fprintf(stderr,"change scheduler cpu attack rate from %d to %d\n",
		oldval,newval);
	return (newval);
}

usage(cname)
register char	*cname;
{
fprintf(stderr,"Invoke the following with -h arg to get more info:\n");
fprintf(stderr,"%s%s%s [ -h | -? ] [ type ]\n",
	pname,(*pname ? " " : ""),cmd1+(*pname ? strlen(cmdprefix) : 0));
fprintf(stderr,"%s%s%s [ -h | -? ] [ mode ]\n",
	pname,(*pname ? " " : ""),cmd2+(*pname ? strlen(cmdprefix) : 0));
fprintf(stderr,"%s%s%s [ -h | -? ] [ idx ]\n",
	pname,(*pname ? " " : ""),cmd3+(*pname ? strlen(cmdprefix) : 0));
fprintf(stderr,"%s%s%s [ -h | -? ] [ array ]\n",
	pname,(*pname ? " " : ""),cmd4+(*pname ? strlen(cmdprefix) : 0));
fprintf(stderr,"%s%s%s [ -h | -? ] [ limit ]\n",
	pname,(*pname ? " " : ""),cmd5+(*pname ? strlen(cmdprefix) : 0));
fprintf(stderr,"%s%s%s [ -h | -? ] [ rate ]\n",
	pname,(*pname ? " " : ""),cmd6+(*pname ? strlen(cmdprefix) : 0));
fprintf(stderr,"%s%s%s [ -h | -? ] [ rate ]\n",
	pname,(*pname ? " " : ""),cmd7+(*pname ? strlen(cmdprefix) : 0));
	return (-1);
}

usagetype(cname)
register char	*cname;
{
fprintf(stderr,"usage: %s%s%s [ -h | -? ] [ type ]\n",
	pname,(*pname ? " " : ""),cname);
fprintf(stderr,"       -h    -  show this help\n");
fprintf(stderr,"       -?    -  show all possible invocations\n");
fprintf(stderr,"       type  -  new scheduler type\n");
fprintf(stderr,"                %-2d - SVR32 std decay by 1/2\n",SCHED_SVR32);
fprintf(stderr,"                %-2d - SVR32 enh dynamic decay, attack, limit\n",
				SCHED_SVR32ENH);
fprintf(stderr,"                %-2d - SVR32 enh BSD decay\n",SCHED_SVR32BSD);
fprintf(stderr,"                %-2d - BSD43 standard\n",SCHED_BSD43);
fprintf(stderr,"                %-2d - MACH  standard\n",SCHED_MACH);
fprintf(stderr,"                if omitted, then show current setting\n");
	return (-1);
}

usagemode(cname)
register char	*cname;
{
fprintf(stderr,"usage: %s%s%s [ -h | -? ] [ mode ]\n",
	pname,(*pname ? " " : ""),cname);
fprintf(stderr,"       -h    -  show this help\n");
fprintf(stderr,"       -?    -  show all possible invocations\n");
fprintf(stderr,"       mode  -  new scheduler mode\n");
fprintf(stderr,"                if omitted, then show current setting\n");
	return (-1);
}

usageloadavg(cname)
register char	*cname;
{
fprintf(stderr,"usage: %s%s%s [ -h | -? ] [ idx ]\n",
	pname,(*pname ? " " : ""),cname);
fprintf(stderr,"       -h   -  show this help\n");
fprintf(stderr,"       -?   -  show all possible invocations\n");
fprintf(stderr,"       idx  -  new loadavg index\n");
fprintf(stderr,"               for SVR32 & BSD43 schedulers:\n");
fprintf(stderr,"               %-2d - use  1 min  load average\n",LOADAVG_1MIN);
fprintf(stderr,"               %-2d - use  5 min  load average\n",LOADAVG_5MIN);
fprintf(stderr,"               %-2d - use 15 min  load average\n",LOADAVG_15MIN);
fprintf(stderr,"               %-2d - use  5 sec  load average\n",LOADAVG_5SEC);
fprintf(stderr,"               %-2d - use instant load average\n",LOADAVG_INST);
fprintf(stderr,"               for MACH scheduler or alternate factor:\n");
fprintf(stderr,"               %-2d - use  1 min  load average\n",LOADAVG_M1MIN);
fprintf(stderr,"               %-2d - use  5 min  load average\n",LOADAVG_M5MIN);
fprintf(stderr,"               %-2d - use 30 sec  load average\n",LOADAVG_M30SEC);
fprintf(stderr,"               %-2d - use  5 sec  load average\n",LOADAVG_M5SEC);
fprintf(stderr,"               %-2d - use instant load average\n",LOADAVG_MINST);
fprintf(stderr,"               if omitted, then show current setting\n");
	return (-1);
}

usagearray(cname)
register char	*cname;
{
fprintf(stderr,"usage: %s%s%s [ -h | -? ] [ array ]\n",
	pname,(*pname ? " " : ""),cname);
fprintf(stderr,"       -h     -  show this help\n");
fprintf(stderr,"       -?     -  show all possible invocations\n");
fprintf(stderr,"       array  -  new scheduler array\n");
fprintf(stderr,"                 if omitted, then show current setting\n");
fprintf(stderr,"NOTE=> This function is currently not implemented! <=NOTE\n");
	return (-1);
}

usagecpulimit(cname)
register char	*cname;
{
fprintf(stderr,"usage: %s%s%s [ -h | -? ] [ limit ]\n",
	pname,(*pname ? " " : ""),cname);
fprintf(stderr,"       -h     -  show this help\n");
fprintf(stderr,"       -?     -  show all possible invocations\n");
fprintf(stderr,"       limit  -  new cpu limit\n");
fprintf(stderr,"                 valid range is %d to 255 inclusive\n",(PUSER - NZERO));
fprintf(stderr,"                 new cpu limit allowed only for these sched types:\n");
fprintf(stderr,"                 %-2d - SVR32 enh user defined decay & cpulimit\n",SCHED_SVR32ENH);
fprintf(stderr,"                 %-2d - SVR32 enh BSD decay & user defined cpulimit\n",SCHED_SVR32BSD);
fprintf(stderr,"                 if omitted, then show current setting\n");
	return (-1);
}

usagecpudecay(cname)
register char	*cname;
{
fprintf(stderr,"usage: %s%s%s [ -h | -? ] [ rate ]\n",
	pname,(*pname ? " " : ""),cname);
fprintf(stderr,"       -h    -  show this help\n");
fprintf(stderr,"       -?    -  show all possible invocations\n");
fprintf(stderr,"       rate  -  new cpu decay rate (used as 1/rate)\n");
fprintf(stderr,"                new rate must be greater than zero\n");
fprintf(stderr,"                new cpu decay rate allowed only for these sched types:\n");
fprintf(stderr,"                %-2d - SVR32 enh user defined decay & cpulimit\n",SCHED_SVR32ENH);
fprintf(stderr,"                if omitted, then show current setting\n");
	return (-1);
}

usagecpuattack(cname)
register char	*cname;
{
fprintf(stderr,"usage: %s%s%s [ -h | -? ] [ rate ]\n",
	pname,(*pname ? " " : ""),cname);
fprintf(stderr,"       -h    -  show this help\n");
fprintf(stderr,"       -?    -  show all possible invocations\n");
fprintf(stderr,"       rate  -  new cpu attack rate (use rate - 1)\n");
fprintf(stderr,"                new cpu decay rate allowed only for these sched types:\n");
fprintf(stderr,"                %-2d - SVR32 enh dynamic decay, attack, limit\n",
				SCHED_SVR32ENH);
fprintf(stderr,"                if omitted, then show current setting\n");
	return (-1);
}

doscheddebug(argc,argv)
register int	argc;
register char	*argv[];
{
	if (getscheddebug(&oldval) < 0) {
		fprintf(stderr,"%s: get scheduler's old debug level: ",cname);
		perror("getscheddebug");
		return (-errno);
	}
	if (argc < 2) {
		fprintf(stderr,"scheduler's current debug level is %d\n",
			oldval);
		return (oldval);
	}
	newval = atoi(argv[1]);
	if (setscheddebug(&newval,&oldval) < 0) {
		fprintf(stderr,"%s: set scheduler's new debug level to %d: ",
			cname,newval);
		perror("setscheddebug");
		return (-errno);
	}
	fprintf(stderr,"change scheduler's debug level from %d to %d\n",
		oldval,newval);
	return (newval);
}
