/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) usage.c: version 25.1 created on 12/2/91 at 13:58:09	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)usage.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include	"chperf.h"

usage(cname)
register char	*cname;
{
fprintf(stderr,"Invoke the following without args to get more info:\n");
fprintf(stderr,"%s%s%s [ -h | -s | -c | -m | -g | -l | -f file | pid ] [ ticks ]\n",
	pname,(*pname ? " " : ""),cmd1);
fprintf(stderr,"%s%s%s [ -h | -s | -c | -m | -g | -l | -f file | pid ] [ clamp ]\n",
	pname,(*pname ? " " : ""),cmd2);
fprintf(stderr,"%s%s%s [ -h | -s | -c | -m | -g | -l | -f file | pid ] [ clamp ]\n",
	pname,(*pname ? " " : ""),cmd3);
fprintf(stderr,"%s%s%s [ -h | -s | -c | -m | -g | -l | -f file | pid ] [ clamp ]\n",
	pname,(*pname ? " " : ""),cmd4);
fprintf(stderr,"%s%s%s [ -h | -s | -c | -m | -g | -l | -f file | pid ] [ clamp ]\n",
	pname,(*pname ? " " : ""),cmd5);
fprintf(stderr,"%s%s%s [ -h | -c | -f file | pid ] [ flags ]\n",
	pname,(*pname ? " " : ""),cmd6);
fprintf(stderr,"%s%s%s [ -h ] [ pri ]\n",
	pname,(*pname ? " " : ""),cmd7);
fprintf(stderr,"%s%s%s [ -h ] [ pri ]\n",
	pname,(*pname ? " " : ""),cmd8);
fprintf(stderr,"%s%s%s [ -h ] [ pri ]\n",
	pname,(*pname ? " " : ""),cmd9);
	return (-1);
}

usagequantum(cname)
register char	*cname;
{
int	maxquantum;

	if (getmaxquantum(&maxquantum) < 0)
		maxquantum = 500;
fprintf(stderr,"usage: %s%s%s -h\n",pname,(*pname ? " " : ""),cname);
fprintf(stderr,"       -h      -  show all possible invocations\n");
fprintf(stderr,"or:    %s%s%s -s [ pid ] [ cnt ] [ ovfl ]\n",
					pname,(*pname ? " " : ""),cname);
fprintf(stderr,"       -s      -  get/set quantum size stats\n");
fprintf(stderr,"       pid     -  get/set quantum size stats for this 'pid'\n");
fprintf(stderr,"                  if omitted then show global stats\n");
fprintf(stderr,"                  if -1 then get/set global stats\n");
fprintf(stderr,"                  if  0 then get/set stats for own pid\n");
fprintf(stderr,"                  else, get/set stats for this 'pid'\n");
fprintf(stderr,"       cnt     -  reset stat count to 'cnt'\n");
fprintf(stderr,"                  if omitted, then show current value\n");
fprintf(stderr,"       ovfl    -  reset stat overflow to 'ovfl'\n");
fprintf(stderr,"                  if omitted, then show current value\n");
fprintf(stderr,"or:    %s%s%s -c [ flag ]\n",pname,(*pname ? " " : ""),cname);
fprintf(stderr,"       -c      -  get/set system quantum size copy flag\n");
fprintf(stderr,"       flag    -  new value for system quantum size copy flag\n");
fprintf(stderr,"                  if omitted, then show current value\n");
fprintf(stderr,"or:    %s%s%s -m [ clamp ]\n",pname,(*pname?" ":""),cname);
fprintf(stderr,"       -m      -  get/set system max value of quantum size\n");
fprintf(stderr,"       clamp   -  new system max quantum size in ticks\n");
fprintf(stderr,"                  valid range is 1 - %d inclusive\n",maxquantum);
fprintf(stderr,"                  (@ 50HZ this is 0.02 to %.02f seconds)\n",
				  ((double)((double)maxquantum/50.0)));
fprintf(stderr,"                  if omitted, then show current value\n");
fprintf(stderr,"or:    %s%s%s -g [ clamp ]\n",pname,(*pname?" ":""),cname);
fprintf(stderr,"       -g      -  get/set system value of global quantum size\n");
fprintf(stderr,"       clamp   -  new system global quantum size in ticks\n");
fprintf(stderr,"                  valid range is 1 - %d inclusive\n",maxquantum);
fprintf(stderr,"                  (@ 50HZ this is 0.02 to %.02f seconds)\n",
				  ((double)((double)maxquantum/50.0)));
fprintf(stderr,"                  non-zero value overrides other clamps\n");
fprintf(stderr,"                  if omitted, then show current value\n");
fprintf(stderr,"or:    %s%s%s -l -f file [ flag ]\n",pname,(*pname ? " " : ""),
	cname);
fprintf(stderr,"       -l      -  get/set quantum size group leader flag\n");
fprintf(stderr,"       -f file -  get/set quantum size leader flag for this file\n");
fprintf(stderr,"                  if 0 then default is own pid\n");
fprintf(stderr,"       flag    -  0 is NOT-LEADER, 1 is YES-LEADER\n");
fprintf(stderr,"                  if omitted, then show current value\n");
fprintf(stderr,"or:    %s%s%s -f file [ clamp ]\n",
	pname,(*pname ? " " : ""),cname);
fprintf(stderr,"       -f file -  get/set quantum size for this file\n");
fprintf(stderr,"       clamp   -  new quantum size in ticks\n");
fprintf(stderr,"                  valid range is 1 - %d inclusive\n",maxquantum);
fprintf(stderr,"                  (@ 50HZ this is 0.02 to %.02f seconds)\n",
				  ((double)((double)maxquantum/50.0)));
fprintf(stderr,"                  if omitted, then show current value\n");
fprintf(stderr,"or:    %s%s%s -l pid [ flag ]\n",pname,(*pname ? " " : ""),
	cname);
fprintf(stderr,"       -l      -  get/set quantum size group leader flag\n");
fprintf(stderr,"       pid     -  get/set quantum size leader flag for this 'pid'\n");
fprintf(stderr,"                  if 0 then default is own pid\n");
fprintf(stderr,"       flag    -  0 is NOT-LEADER, 1 is YES-LEADER\n");
fprintf(stderr,"                  if omitted, then show current value\n");
fprintf(stderr,"or:    %s%s%s pid [ clamp ]\n",pname,(*pname ? " " : ""),cname);
fprintf(stderr,"       pid     -  get/set quantum size for this 'pid'\n");
fprintf(stderr,"                  if 0 then default is own pid\n");
fprintf(stderr,"       clamp   -  new quantum size in ticks\n");
fprintf(stderr,"                  valid range is 1 - %d inclusive\n",maxquantum);
fprintf(stderr,"                  (@ 50HZ this is 0.02 to %.02f seconds)\n",
				  ((double)((double)maxquantum/50.0)));
fprintf(stderr,"                  if omitted, then show current value\n");
	return (-1);
}

usagesliceclamp(cname)
register char	*cname;
{
int	maxsliceclamp;

	if (getmaxsliceclamp(&maxsliceclamp) < 0)
		maxsliceclamp = 500;
fprintf(stderr,"usage: %s%s%s -h\n",pname,(*pname ? " " : ""),cname);
fprintf(stderr,"       -h      -  show all possible invocations\n");
fprintf(stderr,"or:    %s%s%s -s [ pid ] [ cnt ] [ ovfl ]\n",
					pname,(*pname ? " " : ""),cname);
fprintf(stderr,"       -s      -  get/set time slice stats\n");
fprintf(stderr,"       pid     -  get/set time slice stats for this 'pid'\n");
fprintf(stderr,"                  if omitted then show global stats\n");
fprintf(stderr,"                  if -1 then get/set global stats\n");
fprintf(stderr,"                  if  0 then get/set stats for own pid\n");
fprintf(stderr,"                  else, get/set stats for this 'pid'\n");
fprintf(stderr,"       cnt     -  reset stat count to 'cnt'\n");
fprintf(stderr,"                  if omitted, then show current value\n");
fprintf(stderr,"       ovfl    -  reset stat overflow to 'ovfl'\n");
fprintf(stderr,"                  if omitted, then show current value\n");
fprintf(stderr,"or:    %s%s%s -c [ flag ]\n",pname,(*pname ? " " : ""),cname);
fprintf(stderr,"       -c      -  get/set system time slice copy flag\n");
fprintf(stderr,"       flag    -  new value for system time slice copy flag\n");
fprintf(stderr,"                  if omitted, then show current value\n");
fprintf(stderr,"or:    %s%s%s -m [ clamp ]\n",pname,(*pname?" ":""),cname);
fprintf(stderr,"       -m      -  get/set system max value of time slice\n");
fprintf(stderr,"       clamp   -  new system max time slice in ticks\n");
fprintf(stderr,"                  valid range is 1 - %d inclusive\n",maxsliceclamp);
fprintf(stderr,"                  (@ 50HZ this is 0.02 to %.02f seconds)\n",
				  ((double)((double)maxsliceclamp/50.0)));
fprintf(stderr,"                  if omitted, then show current value\n");
fprintf(stderr,"or:    %s%s%s -g [ clamp ]\n",pname,(*pname?" ":""),cname);
fprintf(stderr,"       -g      -  get/set system value of global time slice\n");
fprintf(stderr,"       clamp   -  new system global time slice in ticks\n");
fprintf(stderr,"                  valid range is 1 - %d inclusive\n",maxsliceclamp);
fprintf(stderr,"                  (@ 50HZ this is 0.02 to %.02f seconds)\n",
				  ((double)((double)maxsliceclamp/50.0)));
fprintf(stderr,"                  non-zero value overrides other clamps\n");
fprintf(stderr,"                  if omitted, then show current value\n");
fprintf(stderr,"or:    %s%s%s -l -f file [ flag ]\n",pname,(*pname ? " " : ""),
	cname);
fprintf(stderr,"       -l      -  get/set time slice group leader flag\n");
fprintf(stderr,"       -f file -  get/set time slice leader flag for this file\n");
fprintf(stderr,"                  if 0 then default is own pid\n");
fprintf(stderr,"       flag    -  0 is NOT-LEADER, 1 is YES-LEADER\n");
fprintf(stderr,"                  if omitted, then show current value\n");
fprintf(stderr,"or:    %s%s%s -f file [ clamp ]\n",
	pname,(*pname ? " " : ""),cname);
fprintf(stderr,"       -f file -  get/set time slice for this file\n");
fprintf(stderr,"       clamp   -  new time slice in ticks\n");
fprintf(stderr,"                  valid range is 1 - %d inclusive\n",maxsliceclamp);
fprintf(stderr,"                  (@ 50HZ this is 0.02 to %.02f seconds)\n",
				  ((double)((double)maxsliceclamp/50.0)));
fprintf(stderr,"                  if omitted, then show current value\n");
fprintf(stderr,"or:    %s%s%s -l pid [ flag ]\n",pname,(*pname ? " " : ""),
	cname);
fprintf(stderr,"       -l      -  get/set time slice group leader flag\n");
fprintf(stderr,"       pid     -  get/set time slice leader flag for this 'pid'\n");
fprintf(stderr,"                  if 0 then default is own pid\n");
fprintf(stderr,"       flag    -  0 is NOT-LEADER, 1 is YES-LEADER\n");
fprintf(stderr,"                  if omitted, then show current value\n");
fprintf(stderr,"or:    %s%s%s pid [ clamp ]\n",pname,(*pname ? " " : ""),cname);
fprintf(stderr,"       pid     -  get/set time slice for this 'pid'\n");
fprintf(stderr,"                  if 0 then default is own pid\n");
fprintf(stderr,"       clamp   -  new time slice in ticks\n");
fprintf(stderr,"                  valid range is 1 - %d inclusive\n",maxsliceclamp);
fprintf(stderr,"                  (@ 50HZ this is 0.02 to %.02f seconds)\n",
				  ((double)((double)maxsliceclamp/50.0)));
fprintf(stderr,"                  if omitted, then show current value\n");
	return (-1);
}

usagepriclamp(cname)
register char	*cname;
{
int	maxpriclamp;

	if (getmaxpriclamp(&maxpriclamp) < 0)
		maxpriclamp = NUM_PRIORITIES - 1;
fprintf(stderr,"usage: %s%s%s -h\n",pname,(*pname ? " " : ""),cname);
fprintf(stderr,"       -h      -  show all possible invocations\n");
fprintf(stderr,"or:    %s%s%s -s [ pid ] [ cnt ] [ ovfl ]\n",
					pname,(*pname ? " " : ""),cname);
fprintf(stderr,"       -s      -  get/set pri clamp stats\n");
fprintf(stderr,"       pid     -  get/set pri clamp stats for this 'pid'\n");
fprintf(stderr,"                  if omitted then show global stats\n");
fprintf(stderr,"                  if -1 then get/set global stats\n");
fprintf(stderr,"                  if  0 then get/set stats for own pid\n");
fprintf(stderr,"                  else, get/set stats for this 'pid'\n");
fprintf(stderr,"       cnt     -  reset stat count to 'cnt'\n");
fprintf(stderr,"                  if omitted, then show current value\n");
fprintf(stderr,"       ovfl    -  reset stat overflow to 'ovfl'\n");
fprintf(stderr,"                  if omitted, then show current value\n");
fprintf(stderr,"or:    %s%s%s -c [ flag ]\n",pname,(*pname ? " " : ""),cname);
fprintf(stderr,"       -c      -  get/set system pri clamp copy flag\n");
fprintf(stderr,"       flag    -  new value for system pri clamp copy flag\n");
fprintf(stderr,"                  if omitted, then show current value\n");
fprintf(stderr,"or:    %s%s%s -m [ clamp ]\n",pname,(*pname?" ":""),cname);
fprintf(stderr,"       -m      -  get/set system max value of pri clamp\n");
fprintf(stderr,"       clamp   -  new system max pri clamp\n");
fprintf(stderr,"                  valid range is %d - %d inclusive\n",
					(PZERO+1),maxpriclamp);
fprintf(stderr,"                  if omitted, then show current value\n");
fprintf(stderr,"or:    %s%s%s -g [ clamp ]\n",pname,(*pname?" ":""),cname);
fprintf(stderr,"       -g      -  get/set system value of global pri clamp\n");
fprintf(stderr,"       clamp   -  new system global pri clamp\n");
fprintf(stderr,"                  valid range is %d - %d inclusive\n",
					(PZERO+1),maxpriclamp);
fprintf(stderr,"                  non-zero value overrides other clamps\n");
fprintf(stderr,"                  if omitted, then show current value\n");
fprintf(stderr,"or:    %s%s%s -l -f file [ flag ]\n",pname,(*pname ? " " : ""),
	cname);
fprintf(stderr,"       -l      -  get/set pri clamp group leader flag\n");
fprintf(stderr,"       -f file -  get/set pri clamp leader flag for this file\n");
fprintf(stderr,"                  if 0 then default is own pid\n");
fprintf(stderr,"       flag    -  0 is NOT-LEADER, 1 is YES-LEADER\n");
fprintf(stderr,"                  if omitted, then show current value\n");
fprintf(stderr,"or:    %s%s%s -f file [ clamp ]\n",
	pname,(*pname ? " " : ""),cname);
fprintf(stderr,"       -f file -  get/set pri clamp for this file\n");
fprintf(stderr,"       clamp   -  new pri clamp\n");
fprintf(stderr,"                  valid range is %d - %d inclusive\n",
					(PZERO+1),maxpriclamp);
fprintf(stderr,"                  if omitted, then show current value\n");
fprintf(stderr,"or:    %s%s%s -l pid [ flag ]\n",pname,(*pname ? " " : ""),
	cname);
fprintf(stderr,"       -l      -  get/set pri clamp group leader flag\n");
fprintf(stderr,"       pid     -  get/set pri clamp leader flag for this 'pid'\n");
fprintf(stderr,"                  if 0 then default is own pid\n");
fprintf(stderr,"       flag    -  0 is NOT-LEADER, 1 is YES-LEADER\n");
fprintf(stderr,"                  if omitted, then show current value\n");
fprintf(stderr,"or:    %s%s%s pid [ clamp ]\n",pname,(*pname ? " " : ""),cname);
fprintf(stderr,"       pid     -  get/set pri clamp for this 'pid'\n");
fprintf(stderr,"                  if 0 then default is own pid\n");
fprintf(stderr,"       clamp   -  new pri clamp\n");
fprintf(stderr,"                  valid range is %d - %d inclusive\n",
					(PZERO+1),maxpriclamp);
fprintf(stderr,"                  if omitted, then show current value\n");
	return (-1);
}

usageusrpriclamp(cname)
register char	*cname;
{
int	maxusrpriclamp;

	if (getmaxusrpriclamp(&maxusrpriclamp) < 0)
		maxusrpriclamp = NUM_PRIORITIES - 1;
fprintf(stderr,"usage: %s%s%s -h\n",pname,(*pname ? " " : ""),cname);
fprintf(stderr,"       -h      -  show all possible invocations\n");
fprintf(stderr,"or:    %s%s%s -s [ pid ] [ cnt ] [ ovfl ]\n",
					pname,(*pname ? " " : ""),cname);
fprintf(stderr,"       -s      -  get/set usrpri clamp stats\n");
fprintf(stderr,"       pid     -  get/set usrpri clamp stats for this 'pid'\n");
fprintf(stderr,"                  if omitted then show global stats\n");
fprintf(stderr,"                  if -1 then get/set global stats\n");
fprintf(stderr,"                  if  0 then get/set stats for own pid\n");
fprintf(stderr,"                  else, get/set stats for this 'pid'\n");
fprintf(stderr,"       cnt     -  reset stat count to 'cnt'\n");
fprintf(stderr,"                  if omitted, then show current value\n");
fprintf(stderr,"       ovfl    -  reset stat overflow to 'ovfl'\n");
fprintf(stderr,"                  if omitted, then show current value\n");
fprintf(stderr,"or:    %s%s%s -c [ flag ]\n",pname,(*pname ? " " : ""),cname);
fprintf(stderr,"       -c      -  get/set system usrpri clamp copy flag\n");
fprintf(stderr,"       flag    -  new value for system usrpri clamp copy flag\n");
fprintf(stderr,"                  if omitted, then show current value\n");
fprintf(stderr,"or:    %s%s%s -m [ clamp ]\n",pname,(*pname?" ":""),cname);
fprintf(stderr,"       -m      -  get/set system max value of usrpri clamp\n");
fprintf(stderr,"       clamp   -  new system max usrpri clamp\n");
fprintf(stderr,"                  valid range is %d - %d inclusive\n",
					(PZERO+1),maxusrpriclamp);
fprintf(stderr,"                  if omitted, then show current value\n");
fprintf(stderr,"or:    %s%s%s -g [ clamp ]\n",pname,(*pname?" ":""),cname);
fprintf(stderr,"       -g      -  get/set system value of global usrpri clamp\n");
fprintf(stderr,"       clamp   -  new system global usrpri clamp\n");
fprintf(stderr,"                  valid range is %d - %d inclusive\n",
					(PZERO+1),maxusrpriclamp);
fprintf(stderr,"                  non-zero value overrides other clamps\n");
fprintf(stderr,"                  if omitted, then show current value\n");
fprintf(stderr,"or:    %s%s%s -l -f file [ flag ]\n",pname,(*pname ? " " : ""),
	cname);
fprintf(stderr,"       -l      -  get/set usrpri clamp group leader flag\n");
fprintf(stderr,"       -f file -  get/set usrpri clamp leader flag for this file\n");
fprintf(stderr,"                  if 0 then default is own pid\n");
fprintf(stderr,"       flag    -  0 is NOT-LEADER, 1 is YES-LEADER\n");
fprintf(stderr,"                  if omitted, then show current value\n");
fprintf(stderr,"or:    %s%s%s -f file [ clamp ]\n",
	pname,(*pname ? " " : ""),cname);
fprintf(stderr,"       -f file -  get/set usrpri clamp for this file\n");
fprintf(stderr,"       clamp   -  new usrpri clamp\n");
fprintf(stderr,"                  valid range is %d - %d inclusive\n",
					(PZERO+1),maxusrpriclamp);
fprintf(stderr,"                  if omitted, then show current value\n");
fprintf(stderr,"or:    %s%s%s -l pid [ flag ]\n",pname,(*pname ? " " : ""),
	cname);
fprintf(stderr,"       -l      -  get/set usrpri clamp group leader flag\n");
fprintf(stderr,"       pid     -  get/set usrpri clamp leader flag for this 'pid'\n");
fprintf(stderr,"                  if 0 then default is own pid\n");
fprintf(stderr,"       flag    -  0 is NOT-LEADER, 1 is YES-LEADER\n");
fprintf(stderr,"                  if omitted, then show current value\n");
fprintf(stderr,"or:    %s%s%s pid [ clamp ]\n",pname,(*pname ? " " : ""),cname);
fprintf(stderr,"       pid     -  get/set usrpri clamp for this 'pid'\n");
fprintf(stderr,"                  if 0 then default is own pid\n");
fprintf(stderr,"       clamp   -  new usrpri clamp\n");
fprintf(stderr,"                  valid range is %d - %d inclusive\n",
					(PZERO+1),maxusrpriclamp);
fprintf(stderr,"                  if omitted, then show current value\n");
	return (-1);
}

usagecpuclamp(cname)
register char	*cname;
{
int	maxcpuclamp;

	if (getmaxcpuclamp(&maxcpuclamp) < 0)
		maxcpuclamp = 255;
fprintf(stderr,"usage: %s%s%s -h\n",pname,(*pname ? " " : ""),cname);
fprintf(stderr,"       -h      -  show all possible invocations\n");
fprintf(stderr,"or:    %s%s%s -s [ pid ] [ cnt ] [ ovfl ]\n",
					pname,(*pname ? " " : ""),cname);
fprintf(stderr,"       -s      -  get/set cpu clamp stats\n");
fprintf(stderr,"       pid     -  get/set cpu clamp stats for this 'pid'\n");
fprintf(stderr,"                  if omitted then show global stats\n");
fprintf(stderr,"                  if -1 then get/set global stats\n");
fprintf(stderr,"                  if  0 then get/set stats for own pid\n");
fprintf(stderr,"                  else, get/set stats for this 'pid'\n");
fprintf(stderr,"       cnt     -  reset stat count to 'cnt'\n");
fprintf(stderr,"                  if omitted, then show current value\n");
fprintf(stderr,"       ovfl    -  reset stat overflow to 'ovfl'\n");
fprintf(stderr,"                  if omitted, then show current value\n");
fprintf(stderr,"or:    %s%s%s -c [ flag ]\n",pname,(*pname ? " " : ""),cname);
fprintf(stderr,"       -c      -  get/set system cpu clamp copy flag\n");
fprintf(stderr,"       flag    -  new value for system cpu clamp copy flag\n");
fprintf(stderr,"                  if omitted, then show current value\n");
fprintf(stderr,"or:    %s%s%s -m [ clamp ]\n",pname,(*pname?" ":""),cname);
fprintf(stderr,"       -m      -  get/set system max value of cpu clamp\n");
fprintf(stderr,"       clamp   -  new system max cpu clamp\n");
fprintf(stderr,"                  valid range is %d - %d inclusive\n",
					(PZERO+1),maxcpuclamp);
fprintf(stderr,"                  if omitted, then show current value\n");
fprintf(stderr,"or:    %s%s%s -g [ clamp ]\n",pname,(*pname?" ":""),cname);
fprintf(stderr,"       -g      -  get/set system value of global cpu clamp\n");
fprintf(stderr,"       clamp   -  new system global cpu clamp\n");
fprintf(stderr,"                  valid range is %d - %d inclusive\n",
					(PZERO+1),maxcpuclamp);
fprintf(stderr,"                  non-zero value overrides other clamps\n");
fprintf(stderr,"                  if omitted, then show current value\n");
fprintf(stderr,"or:    %s%s%s -l -f file [ flag ]\n",pname,(*pname ? " " : ""),
	cname);
fprintf(stderr,"       -l      -  get/set cpu clamp group leader flag\n");
fprintf(stderr,"       -f file -  get/set cpu clamp leader flag for this file\n");
fprintf(stderr,"                  if 0 then default is own pid\n");
fprintf(stderr,"       flag    -  0 is NOT-LEADER, 1 is YES-LEADER\n");
fprintf(stderr,"                  if omitted, then show current value\n");
fprintf(stderr,"or:    %s%s%s -f file [ clamp ]\n",
	pname,(*pname ? " " : ""),cname);
fprintf(stderr,"       -f file -  get/set cpu clamp for this file\n");
fprintf(stderr,"       clamp   -  new cpu clamp\n");
fprintf(stderr,"                  valid range is %d - %d inclusive\n",
					(PZERO+1),maxcpuclamp);
fprintf(stderr,"                  if omitted, then show current value\n");
fprintf(stderr,"or:    %s%s%s -l pid [ flag ]\n",pname,(*pname ? " " : ""),
	cname);
fprintf(stderr,"       -l      -  get/set cpu clamp group leader flag\n");
fprintf(stderr,"       pid     -  get/set cpu clamp leader flag for this 'pid'\n");
fprintf(stderr,"                  if 0 then default is own pid\n");
fprintf(stderr,"       flag    -  0 is NOT-LEADER, 1 is YES-LEADER\n");
fprintf(stderr,"                  if omitted, then show current value\n");
fprintf(stderr,"or:    %s%s%s pid [ clamp ]\n",pname,(*pname ? " " : ""),cname);
fprintf(stderr,"       pid     -  get/set cpu clamp for this 'pid'\n");
fprintf(stderr,"                  if 0 then default is own pid\n");
fprintf(stderr,"       clamp   -  new cpu clamp\n");
fprintf(stderr,"                  valid range is %d - %d inclusive\n",
					(PUSER - NZERO),maxcpuclamp);
fprintf(stderr,"                  if omitted, then show current value\n");
	return (-1);
}

usageperfflags(cname)
register char	*cname;
{
fprintf(stderr,"usage: %s%s%s -h\n",pname,(*pname ? " " : ""),cname);
fprintf(stderr,"       -h      -  show all possible invocations\n");
fprintf(stderr,"or:    %s%s%s -c [ flag ]\n",pname,(*pname ? " " : ""),cname);
fprintf(stderr,"       -c      -  get/set performance flags copy flag\n");
fprintf(stderr,"       flag    -  new value for performance flags copy flag\n");
fprintf(stderr,"                  if omitted, then show current value\n");
fprintf(stderr,"or:    %s%s%s -f file [ flags ]\n",
	pname,(*pname ? " " : ""),cname);
fprintf(stderr,"       -f file -  get/set performance flags for this file\n");
fprintf(stderr,"       flags   -  new performance flags in hex (0x...)\n");
fprintf(stderr,"                  if omitted, then show current value\n");
fprintf(stderr,"or:    %s%s%s pid [ flags ]\n",pname,(*pname ? " " : ""),cname);
fprintf(stderr,"       pid     -  get/set performance flags for this 'pid'\n");
fprintf(stderr,"                  if 0 then default is own pid\n");
fprintf(stderr,"       flags   -  new performance flags in hex (0x...)\n");
fprintf(stderr,"                  if omitted, then show current value\n");
	return (-1);
}

usageprippipe(cname)
register char	*cname;
{
fprintf(stderr,"usage: %s%s%s -h\n",pname,(*pname ? " " : ""),cname);
fprintf(stderr,"       -h   -  show all possible invocations\n");
fprintf(stderr,"or:    %s%s%s [ pri ]\n",pname,(*pname ? " " : ""),cname);
fprintf(stderr,"       pri  -  new priority value\n");
fprintf(stderr,"               if omitted, then show current value\n");
	return (-1);
}

usagepripsemz(cname)
register char	*cname;
{
fprintf(stderr,"usage: %s%s%s -h\n",pname,(*pname ? " " : ""),cname);
fprintf(stderr,"       -h   -  show all possible invocations\n");
fprintf(stderr,"or:    %s%s%s [ pri ]\n",pname,(*pname ? " " : ""),cname);
fprintf(stderr,"       pri  -  new priority value\n");
fprintf(stderr,"               if omitted, then show current value\n");
	return (-1);
}

usagepripsemn(cname)
register char	*cname;
{
fprintf(stderr,"usage: %s%s%s -h\n",pname,(*pname ? " " : ""),cname);
fprintf(stderr,"       -h   -  show all possible invocations\n");
fprintf(stderr,"or:    %s%s%s [ pri ]\n",pname,(*pname ? " " : ""),cname);
fprintf(stderr,"       pri  -  new priority value\n");
fprintf(stderr,"               if omitted, then show current value\n");
	return (-1);
}
