/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) setusrpri.c: version 25.1 created on 12/2/91 at 13:58:02	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)setusrpri.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include	<sys/types.h>
#include	<sys/perf.h>
#include	<errno.h>

/*
 *	chgperf(fname or fd, CMD, pid, nval ptr, oval ptr)
 */

getusrpristat(pid,nval,oval)
register int	pid, *nval, *oval;
{
	errno = 0;
	return (chgperf(0,PERF_GETUSRPRISTAT,pid,nval,oval));
}

setusrpristat(pid,nval,oval)
register int	pid, *nval, *oval;
{
	errno = 0;
	return (chgperf(0,PERF_SETUSRPRISTAT,pid,nval,oval));
}

getusrpricopy(oval)
register int	*oval;
{
	errno = 0;
	return (chgperf(0,PERF_GETUSRPRICOPY,0,0,oval));
}

setusrpricopy(nval,oval)
register int	*nval, *oval;
{
	errno = 0;
	return (chgperf(0,PERF_SETUSRPRICOPY,0,nval,oval));
}

getusrpriflags(pid,oval)
register int	pid, *oval;
{
register int	ret;

	errno = 0;
	if ((ret = chgperf(0,PERF_GETPERFFLAGS,pid,0,oval)) < 0)
		return (ret);
	if (*oval & PERF_USRPRI_LEADER)
		*oval = 1;
	else
		*oval = 0;
	return (ret);
}

setusrpriflags(pid,nval,oval)
register int	pid, *nval, *oval;
{
register int	ret;

	errno = 0;
	if ((ret = chgperf(0,PERF_GETPERFFLAGS,pid,0,oval)) < 0)
		return (ret);
	if (*nval)
		*nval = *oval | PERF_USRPRI_LEADER;
	else
		*nval = *oval & ~PERF_USRPRI_LEADER;
	if ((ret = chgperf(0,PERF_SETPERFFLAGS,pid,nval,oval)) < 0)
		return (ret);
	if (*oval & PERF_USRPRI_LEADER)
		*oval = 1;
	else
		*oval = 0;
	return (ret);
}

getfusrpriflags(fname,oval)
register char	*fname;
register int	*oval;
{
register int	ret;

	errno = 0;
	if ((ret = chgperf(fname,PERF_GETPERFFLAGS,0,0,oval)) < 0)
		return (ret);
	if (*oval & PERF_USRPRI_LEADER)
		*oval = 1;
	else
		*oval = 0;
	return (ret);
}

setfusrpriflags(fname,nval,oval)
register char	*fname;
register int	*nval, *oval;
{
register int	ret;

	errno = 0;
	if ((ret = chgperf(fname,PERF_GETPERFFLAGS,0,0,oval)) < 0)
		return (ret);
	if (*nval)
		*nval = *oval | PERF_USRPRI_LEADER;
	else
		*nval = *oval & ~PERF_USRPRI_LEADER;
	if ((ret = chgperf(fname,PERF_SETPERFFLAGS,0,nval,oval)) < 0)
		return (ret);
	if (*oval & PERF_USRPRI_LEADER)
		*oval = 1;
	else
		*oval = 0;
	return (ret);
}

fgetfusrpriflags(fd,oval)
register int	fd, *oval;
{
register int	ret;

	errno = 0;
	if ((ret = fchgperf(fd,PERF_GETPERFFLAGS,0,0,oval)) < 0)
		return (ret);
	if (*oval & PERF_USRPRI_LEADER)
		*oval = 1;
	else
		*oval = 0;
	return (ret);
}

fsetfusrpriflags(fd,nval,oval)
register int	fd, *nval, *oval;
{
register int	ret;

	errno = 0;
	if ((ret = fchgperf(fd,PERF_GETPERFFLAGS,0,0,oval)) < 0)
		return (ret);
	if (*nval)
		*nval = *oval | PERF_USRPRI_LEADER;
	else
		*nval = *oval & ~PERF_USRPRI_LEADER;
	if ((ret = fchgperf(fd,PERF_SETPERFFLAGS,0,nval,oval)) < 0)
		return (ret);
	if (*oval & PERF_USRPRI_LEADER)
		*oval = 1;
	else
		*oval = 0;
	return (ret);
}

getglobusrpriclamp(oval)
register int	*oval;
{
	errno = 0;
	return (chgperf(0,PERF_GETGLOBUSRPRI,0,0,oval));
}

setglobusrpriclamp(nval,oval)
register int	*nval, *oval;
{
	errno = 0;
	return (chgperf(0,PERF_SETGLOBUSRPRI,0,nval,oval));
}

getmaxusrpriclamp(oval)
register int	*oval;
{
	errno = 0;
	return (chgperf(0,PERF_GETMAXUSRPRI,0,0,oval));
}

setmaxusrpriclamp(nval,oval)
register int	*nval, *oval;
{
	errno = 0;
	return (chgperf(0,PERF_SETMAXUSRPRI,0,nval,oval));
}

getusrpriclamp(pid,oval)
register int	pid, *oval;
{
	errno = 0;
	return (chgperf(0,PERF_GETUSRPRI,pid,0,oval));
}

setusrpriclamp(pid,nval,oval)
register int	pid, *nval, *oval;
{
	errno = 0;
	return (chgperf(0,PERF_SETUSRPRI,pid,nval,oval));
}

getfusrpriclamp(fname,oval)
register char	*fname;
register int	*oval;
{
	errno = 0;
	return (chgperf(fname,PERF_GETUSRPRI,0,0,oval));
}

setfusrpriclamp(fname,nval,oval)
register char	*fname;
register int	*nval, *oval;
{
	errno = 0;
	return (chgperf(fname,PERF_SETUSRPRI,0,nval,oval));
}

fgetfusrpriclamp(fd,oval)
register int	fd, *oval;
{
	errno = 0;
	return (fchgperf(fd,PERF_GETUSRPRI,0,0,oval));
}

fsetfusrpriclamp(fd,nval,oval)
register int	fd, *nval, *oval;
{
	errno = 0;
	return (fchgperf(fd,PERF_SETUSRPRI,0,nval,oval));
}
