/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) setslice.c: version 25.1 created on 12/2/91 at 13:57:59	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)setslice.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include	<sys/types.h>
#include	<sys/perf.h>
#include	<errno.h>

/*
 *	chgperf(fname or fd, CMD, pid, nval ptr, oval ptr)
 */

getslicestat(pid,nval,oval)
register int	pid, *nval, *oval;
{
	errno = 0;
	return (chgperf(0,PERF_GETSLICESTAT,pid,nval,oval));
}

setslicestat(pid,nval,oval)
register int	pid, *nval, *oval;
{
	errno = 0;
	return (chgperf(0,PERF_SETSLICESTAT,pid,nval,oval));
}

getslicecopy(oval)
register int	*oval;
{
	errno = 0;
	return (chgperf(0,PERF_GETSLICECOPY,0,0,oval));
}

setslicecopy(nval,oval)
register int	*nval, *oval;
{
	errno = 0;
	return (chgperf(0,PERF_SETSLICECOPY,0,nval,oval));
}

getsliceflags(pid,oval)
register int	pid, *oval;
{
register int	ret;

	errno = 0;
	if ((ret = chgperf(0,PERF_GETPERFFLAGS,pid,0,oval)) < 0)
		return (ret);
	if (*oval & PERF_SLICE_LEADER)
		*oval = 1;
	else
		*oval = 0;
	return (ret);
}

setsliceflags(pid,nval,oval)
register int	pid, *nval, *oval;
{
register int	ret;

	errno = 0;
	if ((ret = chgperf(0,PERF_GETPERFFLAGS,pid,0,oval)) < 0)
		return (ret);
	if (*nval)
		*nval = *oval | PERF_SLICE_LEADER;
	else
		*nval = *oval & ~PERF_SLICE_LEADER;
	if ((ret = chgperf(0,PERF_SETPERFFLAGS,pid,nval,oval)) < 0)
		return (ret);
	if (*oval & PERF_SLICE_LEADER)
		*oval = 1;
	else
		*oval = 0;
	return (ret);
}

getfsliceflags(fname,oval)
register char	*fname;
register int	*oval;
{
register int	ret;

	errno = 0;
	if ((ret = chgperf(fname,PERF_GETPERFFLAGS,0,0,oval)) < 0)
		return (ret);
	if (*oval & PERF_SLICE_LEADER)
		*oval = 1;
	else
		*oval = 0;
	return (ret);
}

setfsliceflags(fname,nval,oval)
register char	*fname;
register int	*nval, *oval;
{
register int	ret;

	errno = 0;
	if ((ret = chgperf(fname,PERF_GETPERFFLAGS,0,0,oval)) < 0)
		return (ret);
	if (*nval)
		*nval = *oval | PERF_SLICE_LEADER;
	else
		*nval = *oval & ~PERF_SLICE_LEADER;
	if ((ret = chgperf(fname,PERF_SETPERFFLAGS,0,nval,oval)) < 0)
		return (ret);
	if (*oval & PERF_SLICE_LEADER)
		*oval = 1;
	else
		*oval = 0;
	return (ret);
}

fgetfsliceflags(fd,oval)
register int	fd, *oval;
{
register int	ret;

	errno = 0;
	if ((ret = fchgperf(fd,PERF_GETPERFFLAGS,0,0,oval)) < 0)
		return (ret);
	if (*oval & PERF_SLICE_LEADER)
		*oval = 1;
	else
		*oval = 0;
	return (ret);
}

fsetfsliceflags(fd,nval,oval)
register int	fd, *nval, *oval;
{
register int	ret;

	errno = 0;
	if ((ret = fchgperf(fd,PERF_GETPERFFLAGS,0,0,oval)) < 0)
		return (ret);
	if (*nval)
		*nval = *oval | PERF_SLICE_LEADER;
	else
		*nval = *oval & ~PERF_SLICE_LEADER;
	if ((ret = fchgperf(fd,PERF_SETPERFFLAGS,0,nval,oval)) < 0)
		return (ret);
	if (*oval & PERF_SLICE_LEADER)
		*oval = 1;
	else
		*oval = 0;
	return (ret);
}

getglobsliceclamp(oval)
register int	*oval;
{
	errno = 0;
	return (chgperf(0,PERF_GETGLOBSLICE,0,0,oval));
}

setglobsliceclamp(nval,oval)
register int	*nval, *oval;
{
	errno = 0;
	return (chgperf(0,PERF_SETGLOBSLICE,0,nval,oval));
}

getmaxsliceclamp(oval)
register int	*oval;
{
	errno = 0;
	return (chgperf(0,PERF_GETMAXSLICE,0,0,oval));
}

setmaxsliceclamp(nval,oval)
register int	*nval, *oval;
{
	errno = 0;
	return (chgperf(0,PERF_SETMAXSLICE,0,nval,oval));
}

getsliceclamp(pid,oval)
register int	pid, *oval;
{
	errno = 0;
	return (chgperf(0,PERF_GETSLICE,pid,0,oval));
}

setsliceclamp(pid,nval,oval)
register int	pid, *nval, *oval;
{
	errno = 0;
	return (chgperf(0,PERF_SETSLICE,pid,nval,oval));
}

getfsliceclamp(fname,oval)
register char	*fname;
register int	*oval;
{
	errno = 0;
	return (chgperf(fname,PERF_GETSLICE,0,0,oval));
}

setfsliceclamp(fname,nval,oval)
register char	*fname;
register int	*nval, *oval;
{
	errno = 0;
	return (chgperf(fname,PERF_SETSLICE,0,nval,oval));
}

fgetfsliceclamp(fd,oval)
register int	fd, *oval;
{
	errno = 0;
	return (fchgperf(fd,PERF_GETSLICE,0,0,oval));
}

fsetfsliceclamp(fd,nval,oval)
register int	fd, *nval, *oval;
{
	errno = 0;
	return (fchgperf(fd,PERF_SETSLICE,0,nval,oval));
}
