/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) setquantum.c: version 25.1 created on 12/2/91 at 13:57:55	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)setquantum.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include	<sys/types.h>
#include	<sys/perf.h>
#include	<errno.h>

/*
 *	chgperf(fname or fd, CMD, pid, nval ptr, oval ptr)
 */

getquantumstat(pid,nval,oval)
register int	pid, *nval, *oval;
{
	errno = 0;
	return (chgperf(0,PERF_GETQUANTUMSTAT,pid,nval,oval));
}

setquantumstat(pid,nval,oval)
register int	pid, *nval, *oval;
{
	errno = 0;
	return (chgperf(0,PERF_SETQUANTUMSTAT,pid,nval,oval));
}

getquantumcopy(oval)
register int	*oval;
{
	errno = 0;
	return (chgperf(0,PERF_GETQUANTUMCOPY,0,0,oval));
}

setquantumcopy(nval,oval)
register int	*nval, *oval;
{
	errno = 0;
	return (chgperf(0,PERF_SETQUANTUMCOPY,0,nval,oval));
}

getquantumflags(pid,oval)
register int	pid, *oval;
{
register int	ret;

	errno = 0;
	if ((ret = chgperf(0,PERF_GETPERFFLAGS,pid,0,oval)) < 0)
		return (ret);
	if (*oval & PERF_QUANTUM_LEADER)
		*oval = 1;
	else
		*oval = 0;
	return (ret);
}

setquantumflags(pid,nval,oval)
register int	pid, *nval, *oval;
{
register int	ret;

	errno = 0;
	if ((ret = chgperf(0,PERF_GETPERFFLAGS,pid,0,oval)) < 0)
		return (ret);
	if (*nval)
		*nval = *oval | PERF_QUANTUM_LEADER;
	else
		*nval = *oval & ~PERF_QUANTUM_LEADER;
	if ((ret = chgperf(0,PERF_SETPERFFLAGS,pid,nval,oval)) < 0)
		return (ret);
	if (*oval & PERF_QUANTUM_LEADER)
		*oval = 1;
	else
		*oval = 0;
	return (ret);
}

getfquantumflags(fname,oval)
register char	*fname;
register int	*oval;
{
register int	ret;

	errno = 0;
	if ((ret = chgperf(fname,PERF_GETPERFFLAGS,0,0,oval)) < 0)
		return (ret);
	if (*oval & PERF_QUANTUM_LEADER)
		*oval = 1;
	else
		*oval = 0;
	return (ret);
}

setfquantumflags(fname,nval,oval)
register char	*fname;
register int	*nval, *oval;
{
register int	ret;

	errno = 0;
	if ((ret = chgperf(fname,PERF_GETPERFFLAGS,0,0,oval)) < 0)
		return (ret);
	if (*nval)
		*nval = *oval | PERF_QUANTUM_LEADER;
	else
		*nval = *oval & ~PERF_QUANTUM_LEADER;
	if ((ret = chgperf(fname,PERF_SETPERFFLAGS,0,nval,oval)) < 0)
		return (ret);
	if (*oval & PERF_QUANTUM_LEADER)
		*oval = 1;
	else
		*oval = 0;
	return (ret);
}

fgetfquantumflags(fd,oval)
register int	fd, *oval;
{
register int	ret;

	errno = 0;
	if ((ret = fchgperf(fd,PERF_GETPERFFLAGS,0,0,oval)) < 0)
		return (ret);
	if (*oval & PERF_QUANTUM_LEADER)
		*oval = 1;
	else
		*oval = 0;
	return (ret);
}

fsetfquantumflags(fd,nval,oval)
register int	fd, *nval, *oval;
{
register int	ret;

	errno = 0;
	if ((ret = fchgperf(fd,PERF_GETPERFFLAGS,0,0,oval)) < 0)
		return (ret);
	if (*nval)
		*nval = *oval | PERF_QUANTUM_LEADER;
	else
		*nval = *oval & ~PERF_QUANTUM_LEADER;
	if ((ret = fchgperf(fd,PERF_SETPERFFLAGS,0,nval,oval)) < 0)
		return (ret);
	if (*oval & PERF_QUANTUM_LEADER)
		*oval = 1;
	else
		*oval = 0;
	return (ret);
}

getglobquantum(oval)
register int	*oval;
{
	errno = 0;
	return (chgperf(0,PERF_GETGLOBQUANTUM,0,0,oval));
}

setglobquantum(nval,oval)
register int	*nval, *oval;
{
	errno = 0;
	return (chgperf(0,PERF_SETGLOBQUANTUM,0,nval,oval));
}

getmaxquantum(oval)
register int	*oval;
{
	errno = 0;
	return (chgperf(0,PERF_GETMAXQUANTUM,0,0,oval));
}

setmaxquantum(nval,oval)
register int	*nval, *oval;
{
	errno = 0;
	return (chgperf(0,PERF_SETMAXQUANTUM,0,nval,oval));
}

getquantum(pid,oval)
register int	pid, *oval;
{
	errno = 0;
	return (chgperf(0,PERF_GETQUANTUM,pid,0,oval));
}

setquantum(pid,nval,oval)
register int	pid, *nval, *oval;
{
	errno = 0;
	return (chgperf(0,PERF_SETQUANTUM,pid,nval,oval));
}

getfquantum(fname,oval)
register char	*fname;
register int	*oval;
{
	errno = 0;
	return (chgperf(fname,PERF_GETQUANTUM,0,0,oval));
}

setfquantum(fname,nval,oval)
register char	*fname;
register int	*nval, *oval;
{
	errno = 0;
	return (chgperf(fname,PERF_SETQUANTUM,0,nval,oval));
}

fgetfquantum(fd,oval)
register int	fd, *oval;
{
	errno = 0;
	return (fchgperf(fd,PERF_GETQUANTUM,0,0,oval));
}

fsetfquantum(fd,nval,oval)
register int	fd, *nval, *oval;
{
	errno = 0;
	return (fchgperf(fd,PERF_SETQUANTUM,0,nval,oval));
}
