/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) setpri.c: version 25.1 created on 12/2/91 at 13:57:52	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)setpri.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include	<sys/types.h>
#include	<sys/perf.h>
#include	<errno.h>

/*
 *	chgperf(fname or fd, CMD, pid, nval ptr, oval ptr)
 */

getpristat(pid,nval,oval)
register int	pid, *nval, *oval;
{
	errno = 0;
	return (chgperf(0,PERF_GETPRISTAT,pid,nval,oval));
}

setpristat(pid,nval,oval)
register int	pid, *nval, *oval;
{
	errno = 0;
	return (chgperf(0,PERF_SETPRISTAT,pid,nval,oval));
}

getpricopy(oval)
register int	*oval;
{
	errno = 0;
	return (chgperf(0,PERF_GETPRICOPY,0,0,oval));
}

setpricopy(nval,oval)
register int	*nval, *oval;
{
	errno = 0;
	return (chgperf(0,PERF_SETPRICOPY,0,nval,oval));
}

getpriflags(pid,oval)
register int	pid, *oval;
{
register int	ret;

	errno = 0;
	if ((ret = chgperf(0,PERF_GETPERFFLAGS,pid,0,oval)) < 0)
		return (ret);
	if (*oval & PERF_PRI_LEADER)
		*oval = 1;
	else
		*oval = 0;
	return (ret);
}

setpriflags(pid,nval,oval)
register int	pid, *nval, *oval;
{
register int	ret;

	errno = 0;
	if ((ret = chgperf(0,PERF_GETPERFFLAGS,pid,0,oval)) < 0)
		return (ret);
	if (*nval)
		*nval = *oval | PERF_PRI_LEADER;
	else
		*nval = *oval & ~PERF_PRI_LEADER;
	if ((ret = chgperf(0,PERF_SETPERFFLAGS,pid,nval,oval)) < 0)
		return (ret);
	if (*oval & PERF_PRI_LEADER)
		*oval = 1;
	else
		*oval = 0;
	return (ret);
}

getfpriflags(fname,oval)
register char	*fname;
register int	*oval;
{
register int	ret;

	errno = 0;
	if ((ret = chgperf(fname,PERF_GETPERFFLAGS,0,0,oval)) < 0)
		return (ret);
	if (*oval & PERF_PRI_LEADER)
		*oval = 1;
	else
		*oval = 0;
	return (ret);
}

setfpriflags(fname,nval,oval)
register char	*fname;
register int	*nval, *oval;
{
register int	ret;

	errno = 0;
	if ((ret = chgperf(fname,PERF_GETPERFFLAGS,0,0,oval)) < 0)
		return (ret);
	if (*nval)
		*nval = *oval | PERF_PRI_LEADER;
	else
		*nval = *oval & ~PERF_PRI_LEADER;
	if ((ret = chgperf(fname,PERF_SETPERFFLAGS,0,nval,oval)) < 0)
		return (ret);
	if (*oval & PERF_PRI_LEADER)
		*oval = 1;
	else
		*oval = 0;
	return (ret);
}

fgetfpriflags(fd,oval)
register int	fd, *oval;
{
register int	ret;

	errno = 0;
	if ((ret = fchgperf(fd,PERF_GETPERFFLAGS,0,0,oval)) < 0)
		return (ret);
	if (*oval & PERF_PRI_LEADER)
		*oval = 1;
	else
		*oval = 0;
	return (ret);
}

fsetfpriflags(fd,nval,oval)
register int	fd, *nval, *oval;
{
register int	ret;

	errno = 0;
	if ((ret = fchgperf(fd,PERF_GETPERFFLAGS,0,0,oval)) < 0)
		return (ret);
	if (*nval)
		*nval = *oval | PERF_PRI_LEADER;
	else
		*nval = *oval & ~PERF_PRI_LEADER;
	if ((ret = fchgperf(fd,PERF_SETPERFFLAGS,0,nval,oval)) < 0)
		return (ret);
	if (*oval & PERF_PRI_LEADER)
		*oval = 1;
	else
		*oval = 0;
	return (ret);
}

getglobpriclamp(oval)
register int	*oval;
{
	errno = 0;
	return (chgperf(0,PERF_GETGLOBPRI,0,0,oval));
}

setglobpriclamp(nval,oval)
register int	*nval, *oval;
{
	errno = 0;
	return (chgperf(0,PERF_SETGLOBPRI,0,nval,oval));
}

getmaxpriclamp(oval)
register int	*oval;
{
	errno = 0;
	return (chgperf(0,PERF_GETMAXPRI,0,0,oval));
}

setmaxpriclamp(nval,oval)
register int	*nval, *oval;
{
	errno = 0;
	return (chgperf(0,PERF_SETMAXPRI,0,nval,oval));
}

getpriclamp(pid,oval)
register int	pid, *oval;
{
	errno = 0;
	return (chgperf(0,PERF_GETPRI,pid,0,oval));
}

setpriclamp(pid,nval,oval)
register int	pid, *nval, *oval;
{
	errno = 0;
	return (chgperf(0,PERF_SETPRI,pid,nval,oval));
}

getfpriclamp(fname,oval)
register char	*fname;
register int	*oval;
{
	errno = 0;
	return (chgperf(fname,PERF_GETPRI,0,0,oval));
}

setfpriclamp(fname,nval,oval)
register char	*fname;
register int	*nval, *oval;
{
	errno = 0;
	return (chgperf(fname,PERF_SETPRI,0,nval,oval));
}

fgetfpriclamp(fd,oval)
register int	fd, *oval;
{
	errno = 0;
	return (fchgperf(fd,PERF_GETPRI,0,0,oval));
}

fsetfpriclamp(fd,nval,oval)
register int	fd, *nval, *oval;
{
	errno = 0;
	return (fchgperf(fd,PERF_SETPRI,0,nval,oval));
}
