/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) setcpu.c: version 25.1 created on 12/2/91 at 13:57:42	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)setcpu.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include	<sys/types.h>
#include	<sys/perf.h>
#include	<errno.h>

/*
 *	chgperf(fname or fd, CMD, pid, nval ptr, oval ptr)
 */

getcpustat(pid,nval,oval)
register int	pid, *nval, *oval;
{
	errno = 0;
	return (chgperf(0,PERF_GETCPUSTAT,pid,nval,oval));
}

setcpustat(pid,nval,oval)
register int	pid, *nval, *oval;
{
	errno = 0;
	return (chgperf(0,PERF_SETCPUSTAT,pid,nval,oval));
}

getcpucopy(oval)
register int	*oval;
{
	errno = 0;
	return (chgperf(0,PERF_GETCPUCOPY,0,0,oval));
}

setcpucopy(nval,oval)
register int	*nval, *oval;
{
	errno = 0;
	return (chgperf(0,PERF_SETCPUCOPY,0,nval,oval));
}

getcpuflags(pid,oval)
register int	pid, *oval;
{
register int	ret;

	errno = 0;
	if ((ret = chgperf(0,PERF_GETPERFFLAGS,pid,0,oval)) < 0)
		return (ret);
	if (*oval & PERF_CPU_LEADER)
		*oval = 1;
	else
		*oval = 0;
	return (ret);
}

setcpuflags(pid,nval,oval)
register int	pid, *nval, *oval;
{
register int	ret;

	errno = 0;
	if ((ret = chgperf(0,PERF_GETPERFFLAGS,pid,0,oval)) < 0)
		return (ret);
	if (*nval)
		*nval = *oval | PERF_CPU_LEADER;
	else
		*nval = *oval & ~PERF_CPU_LEADER;
	if ((ret = chgperf(0,PERF_SETPERFFLAGS,pid,nval,oval)) < 0)
		return (ret);
	if (*oval & PERF_CPU_LEADER)
		*oval = 1;
	else
		*oval = 0;
	return (ret);
}

getfcpuflags(fname,oval)
register char	*fname;
register int	*oval;
{
register int	ret;

	errno = 0;
	if ((ret = chgperf(fname,PERF_GETPERFFLAGS,0,0,oval)) < 0)
		return (ret);
	if (*oval & PERF_CPU_LEADER)
		*oval = 1;
	else
		*oval = 0;
	return (ret);
}

setfcpuflags(fname,nval,oval)
register char	*fname;
register int	*nval, *oval;
{
register int	ret;

	errno = 0;
	if ((ret = chgperf(fname,PERF_GETPERFFLAGS,0,0,oval)) < 0)
		return (ret);
	if (*nval)
		*nval = *oval | PERF_CPU_LEADER;
	else
		*nval = *oval & ~PERF_CPU_LEADER;
	if ((ret = chgperf(fname,PERF_SETPERFFLAGS,0,nval,oval)) < 0)
		return (ret);
	if (*oval & PERF_CPU_LEADER)
		*oval = 1;
	else
		*oval = 0;
	return (ret);
}

fgetfcpuflags(fd,oval)
register int	fd, *oval;
{
register int	ret;

	errno = 0;
	if ((ret = fchgperf(fd,PERF_GETPERFFLAGS,0,0,oval)) < 0)
		return (ret);
	if (*oval & PERF_CPU_LEADER)
		*oval = 1;
	else
		*oval = 0;
	return (ret);
}

fsetfcpuflags(fd,nval,oval)
register int	fd, *nval, *oval;
{
register int	ret;

	errno = 0;
	if ((ret = fchgperf(fd,PERF_GETPERFFLAGS,0,0,oval)) < 0)
		return (ret);
	if (*nval)
		*nval = *oval | PERF_CPU_LEADER;
	else
		*nval = *oval & ~PERF_CPU_LEADER;
	if ((ret = fchgperf(fd,PERF_SETPERFFLAGS,0,nval,oval)) < 0)
		return (ret);
	if (*oval & PERF_CPU_LEADER)
		*oval = 1;
	else
		*oval = 0;
	return (ret);
}

getglobcpuclamp(oval)
register int	*oval;
{
	errno = 0;
	return (chgperf(0,PERF_GETGLOBCPU,0,0,oval));
}

setglobcpuclamp(nval,oval)
register int	*nval, *oval;
{
	errno = 0;
	return (chgperf(0,PERF_SETGLOBCPU,0,nval,oval));
}

getmaxcpuclamp(oval)
register int	*oval;
{
	errno = 0;
	return (chgperf(0,PERF_GETMAXCPU,0,0,oval));
}

setmaxcpuclamp(nval,oval)
register int	*nval, *oval;
{
	errno = 0;
	return (chgperf(0,PERF_SETMAXCPU,0,nval,oval));
}

getcpuclamp(pid,oval)
register int	pid, *oval;
{
	errno = 0;
	return (chgperf(0,PERF_GETCPU,pid,0,oval));
}

setcpuclamp(pid,nval,oval)
register int	pid, *nval, *oval;
{
	errno = 0;
	return (chgperf(0,PERF_SETCPU,pid,nval,oval));
}

getfcpuclamp(fname,oval)
register char	*fname;
register int	*oval;
{
	errno = 0;
	return (chgperf(fname,PERF_GETCPU,0,0,oval));
}

setfcpuclamp(fname,nval,oval)
register char	*fname;
register int	*nval, *oval;
{
	errno = 0;
	return (chgperf(fname,PERF_SETCPU,0,nval,oval));
}

fgetfcpuclamp(fd,oval)
register int	fd, *oval;
{
	errno = 0;
	return (fchgperf(fd,PERF_GETCPU,0,0,oval));
}

fsetfcpuclamp(fd,nval,oval)
register int	fd, *nval, *oval;
{
	errno = 0;
	return (fchgperf(fd,PERF_SETCPU,0,nval,oval));
}
