/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) chusrpri.c: version 25.1 created on 12/2/91 at 13:57:22	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)chusrpri.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include	"chperf.h"

dousrpriclamp(argc,argv)
register int	argc;
register char	*argv[];
{
	if (argc < 2)
		return (usageusrpriclamp(cname));
	if ((argv[1][0] == '-') && (argv[1][1] == 'h'))
		exit (usage(cname));
	if ((argv[1][0] == '-') && (argv[1][1] == '?'))
		exit (usage(cname));
	if ((argv[1][0] == '-') && (argv[1][1] == 'd')) {
		argc--;
		argv++;
		return (sysperfdebug(argc,argv));
	}
	if ((argv[1][0] == '-') && (argv[1][1] == 'c')) {
		argc--;
		argv++;
		return (sysusrpricopy(argc,argv));
	}
	if ((argv[1][0] == '-') && (argv[1][1] == 's')) {
		argc--;
		argv++;
		return (sysusrpristat(argc,argv));
	}
	if ((argv[1][0] == '-') && (argv[1][1] == 'm')) {
		argc--;
		argv++;
		return (sysmaxusrpriclamp(argc,argv));
	}
	if ((argv[1][0] == '-') && (argv[1][1] == 'g')) {
		argc--;
		argv++;
		return (sysglobusrpriclamp(argc,argv));
	}
	doleader = 0;
	if ((argv[1][0] == '-') && (argv[1][1] == 'l')) {
		argc--;
		argv++;
		doleader++;
	}
	if ((argv[1][0] == '-') && (argv[1][1] == 'f')) {
		if (argv[1][2] == '\0') {
			if (argc > 2) {
				fname = argv[2];
				argc--;
				argv++;
			} else
				return (usageusrpriclamp(cname));
		} else	{
			fname = &argv[1][2];
		}
		argc--;
		argv++;
		if (doleader)
			return (fnameusrpriflags(fname,argc,argv));
		else
			return (fnameusrpriclamp(fname,argc,argv));
	}
	if (doleader)
		return (pidusrpriflags(argc,argv));
	else
		return (pidusrpriclamp(argc,argv));
}

sysusrpristat(argc,argv)
register int	argc;
register char	*argv[];
{
register pid_t	pid;

	pid = -1;
	if (argc > 1) {
		pid = (pid_t) atoi(argv[1]);
		argc--;
		argv++;
	}
	if (getusrpristat(pid,&newval,&oldval) < 0) {
		if (pid < 0) {
			fprintf(stderr,
				"%s: get system global usrpri clamp stats: ",
				cname);
		} else	{
			fprintf(stderr,
				"%s: get usrpri clamp stats for pid %d: ",
				cname,((pid == 0) ? getpid() : pid));
		}
		perror("getusrpristat");
		return (-errno);
	}
	if (argc < 2) {
		if (pid < 0) {
			fprintf(stderr,
			"system global usrpri clamp stats: cnt=%d ovfl=%d\n",
				oldval,newval);
		} else	{
			fprintf(stderr,
			"usrpri clamp stats for pid %d: cnt=%d ovfl=%d\n",
				(pid == 0) ? getpid() : pid,oldval,newval);
		}
		return (0);
	}
	oval = atoi(argv[1]);
	argc--;
	argv++;
	if (setusrpristat(pid,0,&oval) < 0) {
		if (pid < 0) {
			fprintf(stderr,
			"%s: set system global usrpri clamp stat cnt to %d: ",
				cname,oval);
		} else	{
			fprintf(stderr,
			"%s: set usrpri clamp stat cnt for pid %d to %d: ",
				cname,((pid == 0) ? getpid() : pid),oval);
		}
		perror("setusrpristat cnt");
		return (-errno);
	}
	if (pid < 0) {
		fprintf(stderr,
		"change system global usrpri clamp stat cnt from %d to %d\n",
			oldval,oval);
	} else	{
		fprintf(stderr,
		"change usrpri clamp stat cnt for pid %d from %d to %d\n",
			(pid == 0) ? getpid() : pid,oldval,oval);
	}
	if (argc < 2)
		return (0);
	nval = atoi(argv[1]);
	if (setusrpristat(pid,&nval,0) < 0) {
		if (pid < 0) {
			fprintf(stderr,
			"%s: set system global usrpri clamp stat ovfl to %d: ",
				cname,nval);
		} else	{
			fprintf(stderr,
			"%s: set usrpri clamp stat ovfl for pid %d to %d: ",
				cname,((pid == 0) ? getpid() : pid),nval);
		}
		perror("setusrpristat ovfl");
		return (-errno);
	}
	if (pid < 0) {
		fprintf(stderr,
		"change system global usrpri clamp stat ovfl from %d to %d\n",
			newval,nval);
	} else	{
		fprintf(stderr,
		"change usrpri clamp stat ovfl for pid %d from %d to %d\n",
			(pid == 0) ? getpid() : pid,newval,nval);
	}
	return (0);
}

sysusrpricopy(argc,argv)
register int	argc;
register char	*argv[];
{
	if (getusrpricopy(&oldval) < 0) {
		fprintf(stderr,"%s: get old system usrpri clamp copy flag: ",
			cname);
		perror("getusrpricopy");
		return (-errno);
	}
	if (argc < 2) {
		fprintf(stderr,"current system usrpri clamp copy flag is %d\n",
			oldval);
		return (oldval);
	}
	newval = atoi(argv[1]);
	if (setusrpricopy(&newval,&oldval) < 0) {
		fprintf(stderr,
			"%s: set new system usrpri clamp copy flag to %d: ",
			cname,newval);
		perror("setusrpricopy");
		return (-errno);
	}
	fprintf(stderr,"change system usrpri clamp copy flag from %d to %d\n",
		oldval,newval);
	return (newval);
}

sysmaxusrpriclamp(argc,argv)
register int	argc;
register char	*argv[];
{
	if (getmaxusrpriclamp(&oldval) < 0) {
		fprintf(stderr,"%s: get old system maximum usrpri clamp: ",cname);
		perror("getmaxusrpriclamp");
		return (-errno);
	}
	if (argc < 2) {
		fprintf(stderr,"current system maximum usrpri clamp is %d\n",
			oldval);
		return (oldval);
	}
	newval = atoi(argv[1]);
	if (setmaxusrpriclamp(&newval,&oldval) < 0) {
		fprintf(stderr,"%s: set new system maximum usrpri clamp to %d: ",
			cname,newval);
		perror("setmaxusrpriclamp");
		return (-errno);
	}
	fprintf(stderr,"change system maximum usrpri clamp from %d to %d\n",
		oldval,newval);
	return (newval);
}

sysglobusrpriclamp(argc,argv)
register int	argc;
register char	*argv[];
{
	if (getglobusrpriclamp(&oldval) < 0) {
		fprintf(stderr,"%s: get old system global usrpri clamp: ",cname);
		perror("getglobusrpriclamp");
		return (-errno);
	}
	if (argc < 2) {
		fprintf(stderr,"current system global usrpri clamp is %d\n",
			oldval);
		return (oldval);
	}
	newval = atoi(argv[1]);
	if (setglobusrpriclamp(&newval,&oldval) < 0) {
		fprintf(stderr,"%s: set new system global usrpri clamp to %d: ",
			cname,newval);
		perror("setglobusrpriclamp");
		return (-errno);
	}
	fprintf(stderr,"change system global usrpri clamp from %d to %d\n",
		oldval,newval);
	return (newval);
}

pidusrpriclamp(argc,argv)
register int	argc;
register char	*argv[];
{
register pid_t	pid;

	pid = (pid_t) atoi(argv[1]);
	if (pid < 0)
		pid = 0;
	argc--;
	argv++;
	if (getusrpriclamp(pid,&oldval) < 0) {
		fprintf(stderr,"%s: get old usrpri clamp of pid=%d: ",cname,pid);
		perror("getusrpriclamp");
		return (-errno);
	}
	if (argc < 2) {
		fprintf(stderr,"current usrpri clamp of process %d is %d\n",
			((pid <= 0) ? getpid() : pid),oldval);
		return (oldval);
	}
	newval = atoi(argv[1]);
	if (setusrpriclamp(pid,&newval,&oldval) < 0) {
		fprintf(stderr,"%s: set new usrpri clamp of pid=%d to %d: ",
			cname,pid,newval);
		perror("setusrpriclamp");
		return (-errno);
	}
	fprintf(stderr,"change usrpri clamp of process %d from %d to %d\n",
		((pid <= 0) ? getpid() : pid),oldval,newval);
	return (newval);
}

fnameusrpriclamp(fname,argc,argv)
register char	*fname, *argv[];
register int	argc;
{
	if (getfusrpriclamp(fname,&oldval) < 0) {
		fprintf(stderr,"%s: get old usrpri clamp of file '%s': ",
			cname,fname);
		perror("getfusrpriclamp");
		return (-errno);
	}
	if (argc < 2) {
		fprintf(stderr,"current usrpri clamp of file '%s' is %d\n",
			fname,oldval);
		return (oldval);
	}
	newval = atoi(argv[1]);
	if (setfusrpriclamp(fname,&newval,&oldval) < 0) {
		fprintf(stderr,"%s: set new usrpri clamp of file '%s': ",
			cname,fname);
		perror("setfusrpriclamp");
		return (-errno);
	}
	fprintf(stderr,"change usrpri clamp of file '%s' from %d to %d\n",
		fname,oldval,newval);
	return (newval);
}

pidusrpriflags(argc,argv)
register int	argc;
register char	*argv[];
{
register pid_t	pid;

	pid = (pid_t) atoi(argv[1]);
	if (pid < 0)
		pid = 0;
	argc--;
	argv++;
	if (getusrpriflags(pid,&oldval) < 0) {
		fprintf(stderr,"%s: get old usrpri clamp leader flag of pid=%d: ",cname,pid);
		perror("getusrpriflags");
		return (-errno);
	}
	if (argc < 2) {
		fprintf(stderr,"current usrpri clamp leader flag of process %d is %d\n",
			((pid <= 0) ? getpid() : pid),oldval);
		return (oldval);
	}
	newval = atoi(argv[1]);
	if (setusrpriflags(pid,&newval,&oldval) < 0) {
		fprintf(stderr,"%s: set new usrpri clamp leader flag of pid=%d to %d: ",
			cname,pid,newval);
		perror("setusrpriflags");
		return (-errno);
	}
	fprintf(stderr,"change usrpri clamp leader flag of process %d from %d to %d\n",
		((pid <= 0) ? getpid() : pid),oldval,newval);
	return (newval);
}

fnameusrpriflags(fname,argc,argv)
register char	*fname, *argv[];
register int	argc;
{
	if (getfusrpriflags(fname,&oldval) < 0) {
		fprintf(stderr,"%s: get old usrpri clamp leader flag of file '%s': ",
			cname,fname);
		perror("getfusrpriflags");
		return (-errno);
	}
	if (argc < 2) {
		fprintf(stderr,"current usrpri clamp leader flag of file '%s' is %d\n",
			fname,oldval);
		return (oldval);
	}
	newval = atoi(argv[1]);
	if (setfusrpriflags(fname,&newval,&oldval) < 0) {
		fprintf(stderr,"%s: set new usrpri clamp leader flag of file '%s': ",
			cname,fname);
		perror("setfusrpriflags");
		return (-errno);
	}
	fprintf(stderr,"change usrpri clamp leader flag of file '%s' from %d to %d\n",
		fname,oldval,newval);
	return (newval);
}
