/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) chslice.c: version 25.1 created on 12/2/91 at 13:57:18	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)chslice.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include	"chperf.h"

dosliceclamp(argc,argv)
register int	argc;
register char	*argv[];
{
	if (argc < 2)
		return (usagesliceclamp(cname));
	if ((argv[1][0] == '-') && (argv[1][1] == 'h'))
		exit (usage(cname));
	if ((argv[1][0] == '-') && (argv[1][1] == '?'))
		exit (usage(cname));
	if ((argv[1][0] == '-') && (argv[1][1] == 'd')) {
		argc--;
		argv++;
		return (sysperfdebug(argc,argv));
	}
	if ((argv[1][0] == '-') && (argv[1][1] == 'c')) {
		argc--;
		argv++;
		return (sysslicecopy(argc,argv));
	}
	if ((argv[1][0] == '-') && (argv[1][1] == 's')) {
		argc--;
		argv++;
		return (sysslicestat(argc,argv));
	}
	if ((argv[1][0] == '-') && (argv[1][1] == 'm')) {
		argc--;
		argv++;
		return (sysmaxsliceclamp(argc,argv));
	}
	if ((argv[1][0] == '-') && (argv[1][1] == 'g')) {
		argc--;
		argv++;
		return (sysglobsliceclamp(argc,argv));
	}
	doleader = 0;
	if ((argv[1][0] == '-') && (argv[1][1] == 'l')) {
		argc--;
		argv++;
		doleader++;
	}
	if ((argv[1][0] == '-') && (argv[1][1] == 'f')) {
		if (argv[1][2] == '\0') {
			if (argc > 2) {
				fname = argv[2];
				argc--;
				argv++;
			} else
				return (usagesliceclamp(cname));
		} else	{
			fname = &argv[1][2];
		}
		argc--;
		argv++;
		if (doleader)
			return (fnamesliceflags(fname,argc,argv));
		else
			return (fnamesliceclamp(fname,argc,argv));
	}
	if (doleader)
		return (pidsliceflags(argc,argv));
	else
		return (pidsliceclamp(argc,argv));
}

sysslicestat(argc,argv)
register int	argc;
register char	*argv[];
{
register pid_t	pid;

	pid = -1;
	if (argc > 1) {
		pid = (pid_t) atoi(argv[1]);
		argc--;
		argv++;
	}
	if (getslicestat(pid,&newval,&oldval) < 0) {
		if (pid < 0) {
			fprintf(stderr,
				"%s: get system global time slice stats: ",
				cname);
		} else	{
			fprintf(stderr,
				"%s: get time slice stats for pid %d: ",
				cname,((pid == 0) ? getpid() : pid));
		}
		perror("getslicestat");
		return (-errno);
	}
	if (argc < 2) {
		if (pid < 0) {
			fprintf(stderr,
			"system global time slice stats: cnt=%d ovfl=%d\n",
				oldval,newval);
		} else	{
			fprintf(stderr,
			"time slice stats for pid %d: cnt=%d ovfl=%d\n",
				(pid == 0) ? getpid() : pid,oldval,newval);
		}
		return (0);
	}
	oval = atoi(argv[1]);
	argc--;
	argv++;
	if (setslicestat(pid,0,&oval) < 0) {
		if (pid < 0) {
			fprintf(stderr,
			"%s: set system global time slice stat cnt to %d: ",
				cname,oval);
		} else	{
			fprintf(stderr,
			"%s: set time slice stat cnt for pid %d to %d: ",
				cname,((pid == 0) ? getpid() : pid),oval);
		}
		perror("setslicestat cnt");
		return (-errno);
	}
	if (pid < 0) {
		fprintf(stderr,
		"change system global time slice stat cnt from %d to %d\n",
			oldval,oval);
	} else	{
		fprintf(stderr,
		"change time slice stat cnt for pid %d from %d to %d\n",
			(pid == 0) ? getpid() : pid,oldval,oval);
	}
	if (argc < 2)
		return (0);
	nval = atoi(argv[1]);
	if (setslicestat(pid,&nval,0) < 0) {
		if (pid < 0) {
			fprintf(stderr,
			"%s: set system global time slice stat ovfl to %d: ",
				cname,nval);
		} else	{
			fprintf(stderr,
			"%s: set time slice stat ovfl for pid %d to %d: ",
				cname,((pid == 0) ? getpid() : pid),nval);
		}
		perror("setslicestat ovfl");
		return (-errno);
	}
	if (pid < 0) {
		fprintf(stderr,
		"change system global time slice stat ovfl from %d to %d\n",
			newval,nval);
	} else	{
		fprintf(stderr,
		"change time slice stat ovfl for pid %d from %d to %d\n",
			(pid == 0) ? getpid() : pid,newval,nval);
	}
	return (0);
}

sysslicecopy(argc,argv)
register int	argc;
register char	*argv[];
{
	if (getslicecopy(&oldval) < 0) {
		fprintf(stderr,"%s: get old system time slice copy flag: ",
			cname);
		perror("getslicecopy");
		return (-errno);
	}
	if (argc < 2) {
		fprintf(stderr,"current system time slice copy flag is %d\n",
			oldval);
		return (oldval);
	}
	newval = atoi(argv[1]);
	if (setslicecopy(&newval,&oldval) < 0) {
		fprintf(stderr,
			"%s: set new system time slice copy flag to %d: ",
			cname,newval);
		perror("setslicecopy");
		return (-errno);
	}
	fprintf(stderr,"change system time slice copy flag from %d to %d\n",
		oldval,newval);
	return (newval);
}

sysmaxsliceclamp(argc,argv)
register int	argc;
register char	*argv[];
{
	if (getmaxsliceclamp(&oldval) < 0) {
		fprintf(stderr,"%s: get old system maximum time slice: ",cname);
		perror("getmaxsliceclamp");
		return (-errno);
	}
	if (argc < 2) {
		fprintf(stderr,"current system maximum time slice is %d\n",
			oldval);
		return (oldval);
	}
	newval = atoi(argv[1]);
	if (setmaxsliceclamp(&newval,&oldval) < 0) {
		fprintf(stderr,"%s: set new system maximum time slice to %d: ",
			cname,newval);
		perror("setmaxsliceclamp");
		return (-errno);
	}
	fprintf(stderr,"change system maximum time slice from %d to %d\n",
		oldval,newval);
	return (newval);
}

sysglobsliceclamp(argc,argv)
register int	argc;
register char	*argv[];
{
	if (getglobsliceclamp(&oldval) < 0) {
		fprintf(stderr,"%s: get old system global time slice: ",cname);
		perror("getglobsliceclamp");
		return (-errno);
	}
	if (argc < 2) {
		fprintf(stderr,"current system global time slice is %d\n",
			oldval);
		return (oldval);
	}
	newval = atoi(argv[1]);
	if (setglobsliceclamp(&newval,&oldval) < 0) {
		fprintf(stderr,"%s: set new system global time slice to %d: ",
			cname,newval);
		perror("setglobsliceclamp");
		return (-errno);
	}
	fprintf(stderr,"change system global time slice from %d to %d\n",
		oldval,newval);
	return (newval);
}

pidsliceclamp(argc,argv)
register int	argc;
register char	*argv[];
{
register pid_t	pid;

	pid = (pid_t) atoi(argv[1]);
	if (pid < 0)
		pid = 0;
	argc--;
	argv++;
	if (getsliceclamp(pid,&oldval) < 0) {
		fprintf(stderr,"%s: get old time slice of pid=%d: ",cname,pid);
		perror("getsliceclamp");
		return (-errno);
	}
	if (argc < 2) {
		fprintf(stderr,"current time slice of process %d is %d\n",
			((pid <= 0) ? getpid() : pid),oldval);
		return (oldval);
	}
	newval = atoi(argv[1]);
	if (setsliceclamp(pid,&newval,&oldval) < 0) {
		fprintf(stderr,"%s: set new time slice of pid=%d to %d: ",
			cname,pid,newval);
		perror("setsliceclamp");
		return (-errno);
	}
	fprintf(stderr,"change time slice of process %d from %d to %d\n",
		((pid <= 0) ? getpid() : pid),oldval,newval);
	return (newval);
}

fnamesliceclamp(fname,argc,argv)
register char	*fname, *argv[];
register int	argc;
{
	if (getfsliceclamp(fname,&oldval) < 0) {
		fprintf(stderr,"%s: get old time slice of file '%s': ",
			cname,fname);
		perror("getfsliceclamp");
		return (-errno);
	}
	if (argc < 2) {
		fprintf(stderr,"current time slice of file '%s' is %d\n",
			fname,oldval);
		return (oldval);
	}
	newval = atoi(argv[1]);
	if (setfsliceclamp(fname,&newval,&oldval) < 0) {
		fprintf(stderr,"%s: set new time slice of file '%s': ",
			cname,fname);
		perror("setfsliceclamp");
		return (-errno);
	}
	fprintf(stderr,"change time slice of file '%s' from %d to %d\n",
		fname,oldval,newval);
	return (newval);
}

pidsliceflags(argc,argv)
register int	argc;
register char	*argv[];
{
register pid_t	pid;

	pid = (pid_t) atoi(argv[1]);
	if (pid < 0)
		pid = 0;
	argc--;
	argv++;
	if (getsliceflags(pid,&oldval) < 0) {
		fprintf(stderr,"%s: get old time slice leader flag of pid=%d: ",cname,pid);
		perror("getsliceflags");
		return (-errno);
	}
	if (argc < 2) {
		fprintf(stderr,"current time slice leader flag of process %d is %d\n",
			((pid <= 0) ? getpid() : pid),oldval);
		return (oldval);
	}
	newval = atoi(argv[1]);
	if (setsliceflags(pid,&newval,&oldval) < 0) {
		fprintf(stderr,"%s: set new time slice leader flag of pid=%d to %d: ",
			cname,pid,newval);
		perror("setsliceflags");
		return (-errno);
	}
	fprintf(stderr,"change time slice leader flag of process %d from %d to %d\n",
		((pid <= 0) ? getpid() : pid),oldval,newval);
	return (newval);
}

fnamesliceflags(fname,argc,argv)
register char	*fname, *argv[];
register int	argc;
{
	if (getfsliceflags(fname,&oldval) < 0) {
		fprintf(stderr,"%s: get old time slice leader flag of file '%s': ",
			cname,fname);
		perror("getfsliceflags");
		return (-errno);
	}
	if (argc < 2) {
		fprintf(stderr,"current time slice leader flag of file '%s' is %d\n",
			fname,oldval);
		return (oldval);
	}
	newval = atoi(argv[1]);
	if (setfsliceflags(fname,&newval,&oldval) < 0) {
		fprintf(stderr,"%s: set new time slice leader flag of file '%s': ",
			cname,fname);
		perror("setfsliceflags");
		return (-errno);
	}
	fprintf(stderr,"change time slice leader flag of file '%s' from %d to %d\n",
		fname,oldval,newval);
	return (newval);
}
