/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) chquantum.c: version 25.1 created on 12/2/91 at 13:57:14	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)chquantum.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include	"chperf.h"

doquantum(argc,argv)
register int	argc;
register char	*argv[];
{
	if (argc < 2)
		return (usagequantum(cname));
	if ((argv[1][0] == '-') && (argv[1][1] == 'h'))
		exit (usage(cname));
	if ((argv[1][0] == '-') && (argv[1][1] == '?'))
		exit (usage(cname));
	if ((argv[1][0] == '-') && (argv[1][1] == 'd')) {
		argc--;
		argv++;
		return (sysperfdebug(argc,argv));
	}
	if ((argv[1][0] == '-') && (argv[1][1] == 'c')) {
		argc--;
		argv++;
		return (sysquantumcopy(argc,argv));
	}
	if ((argv[1][0] == '-') && (argv[1][1] == 's')) {
		argc--;
		argv++;
		return (sysquantumstat(argc,argv));
	}
	if ((argv[1][0] == '-') && (argv[1][1] == 'm')) {
		argc--;
		argv++;
		return (sysmaxquantum(argc,argv));
	}
	if ((argv[1][0] == '-') && (argv[1][1] == 'g')) {
		argc--;
		argv++;
		return (sysglobquantum(argc,argv));
	}
	doleader = 0;
	if ((argv[1][0] == '-') && (argv[1][1] == 'l')) {
		argc--;
		argv++;
		doleader++;
	}
	if ((argv[1][0] == '-') && (argv[1][1] == 'f')) {
		if (argv[1][2] == '\0') {
			if (argc > 2) {
				fname = argv[2];
				argc--;
				argv++;
			} else
				return (usagequantum(cname));
		} else	{
			fname = &argv[1][2];
		}
		argc--;
		argv++;
		if (doleader)
			return (fnamequantumflags(fname,argc,argv));
		else
			return (fnamequantum(fname,argc,argv));
	}
	if (doleader)
		return (pidquantumflags(argc,argv));
	else
		return (pidquantum(argc,argv));
}

sysquantumstat(argc,argv)
register int	argc;
register char	*argv[];
{
register pid_t	pid;

	pid = -1;
	if (argc > 1) {
		pid = (pid_t) atoi(argv[1]);
		argc--;
		argv++;
	}
	if (getquantumstat(pid,&newval,&oldval) < 0) {
		if (pid < 0) {
			fprintf(stderr,
				"%s: get system global quantum size stats: ",
				cname);
		} else	{
			fprintf(stderr,
				"%s: get quantum size stats for pid %d: ",
				cname,((pid == 0) ? getpid() : pid));
		}
		perror("getquantumstat");
		return (-errno);
	}
	if (argc < 2) {
		if (pid < 0) {
			fprintf(stderr,
			"system global quantum size stats: cnt=%d ovfl=%d\n",
				oldval,newval);
		} else	{
			fprintf(stderr,
			"quantum size stats for pid %d: cnt=%d ovfl=%d\n",
				(pid == 0) ? getpid() : pid,oldval,newval);
		}
		return (0);
	}
	oval = atoi(argv[1]);
	argc--;
	argv++;
	if (setquantumstat(pid,0,&oval) < 0) {
		if (pid < 0) {
			fprintf(stderr,
			"%s: set system global quantum size stat cnt to %d: ",
				cname,oval);
		} else	{
			fprintf(stderr,
			"%s: set quantum size stat cnt for pid %d to %d: ",
				cname,((pid == 0) ? getpid() : pid),oval);
		}
		perror("setquantumstat cnt");
		return (-errno);
	}
	if (pid < 0) {
		fprintf(stderr,
		"change system global quantum size stat cnt from %d to %d\n",
			oldval,oval);
	} else	{
		fprintf(stderr,
		"change quantum size stat cnt for pid %d from %d to %d\n",
			(pid == 0) ? getpid() : pid,oldval,oval);
	}
	if (argc < 2)
		return (0);
	nval = atoi(argv[1]);
	if (setquantumstat(pid,&nval,0) < 0) {
		if (pid < 0) {
			fprintf(stderr,
			"%s: set system global quantum size stat ovfl to %d: ",
				cname,nval);
		} else	{
			fprintf(stderr,
			"%s: set quantum size stat ovfl for pid %d to %d: ",
				cname,((pid == 0) ? getpid() : pid),nval);
		}
		perror("setquantumstat ovfl");
		return (-errno);
	}
	if (pid < 0) {
		fprintf(stderr,
		"change system global quantum size stat ovfl from %d to %d\n",
			newval,nval);
	} else	{
		fprintf(stderr,
		"change quantum size stat ovfl for pid %d from %d to %d\n",
			(pid == 0) ? getpid() : pid,newval,nval);
	}
	return (0);
}

sysquantumcopy(argc,argv)
register int	argc;
register char	*argv[];
{
	if (getquantumcopy(&oldval) < 0) {
		fprintf(stderr,"%s: get old system quantum size copy flag: ",
			cname);
		perror("getquantumcopy");
		return (-errno);
	}
	if (argc < 2) {
		fprintf(stderr,"current system quantum size copy flag is %d\n",
			oldval);
		return (oldval);
	}
	newval = atoi(argv[1]);
	if (setquantumcopy(&newval,&oldval) < 0) {
		fprintf(stderr,
			"%s: set new system quantum size copy flag to %d: ",
			cname,newval);
		perror("setquantumcopy");
		return (-errno);
	}
	fprintf(stderr,"change system quantum size copy flag from %d to %d\n",
		oldval,newval);
	return (newval);
}

sysmaxquantum(argc,argv)
register int	argc;
register char	*argv[];
{
	if (getmaxquantum(&oldval) < 0) {
		fprintf(stderr,"%s: get old system maximum quantum size: ",cname);
		perror("getmaxquantum");
		return (-errno);
	}
	if (argc < 2) {
		fprintf(stderr,"current system maximum quantum size is %d\n",
			oldval);
		return (oldval);
	}
	newval = atoi(argv[1]);
	if (setmaxquantum(&newval,&oldval) < 0) {
		fprintf(stderr,"%s: set new system maximum quantum size to %d: ",
			cname,newval);
		perror("setmaxquantum");
		return (-errno);
	}
	fprintf(stderr,"change system maximum quantum size from %d to %d\n",
		oldval,newval);
	return (newval);
}

sysglobquantum(argc,argv)
register int	argc;
register char	*argv[];
{
	if (getglobquantum(&oldval) < 0) {
		fprintf(stderr,"%s: get old system global quantum size: ",cname);
		perror("getglobquantum");
		return (-errno);
	}
	if (argc < 2) {
		fprintf(stderr,"current system global quantum size is %d\n",
			oldval);
		return (oldval);
	}
	newval = atoi(argv[1]);
	if (setglobquantum(&newval,&oldval) < 0) {
		fprintf(stderr,"%s: set new system global quantum size to %d: ",
			cname,newval);
		perror("setglobquantum");
		return (-errno);
	}
	fprintf(stderr,"change system global quantum size from %d to %d\n",
		oldval,newval);
	return (newval);
}

pidquantum(argc,argv)
register int	argc;
register char	*argv[];
{
register pid_t	pid;

	pid = (pid_t) atoi(argv[1]);
	if (pid < 0)
		pid = 0;
	argc--;
	argv++;
	if (getquantum(pid,&oldval) < 0) {
		fprintf(stderr,"%s: get old quantum size of pid=%d: ",cname,pid);
		perror("getquantum");
		return (-errno);
	}
	if (argc < 2) {
		fprintf(stderr,"current quantum size of process %d is %d\n",
			((pid <= 0) ? getpid() : pid),oldval);
		return (oldval);
	}
	newval = atoi(argv[1]);
	if (setquantum(pid,&newval,&oldval) < 0) {
		fprintf(stderr,"%s: set new quantum size of pid=%d to %d: ",
			cname,pid,newval);
		perror("setquantum");
		return (-errno);
	}
	fprintf(stderr,"change quantum size of process %d from %d to %d\n",
		((pid <= 0) ? getpid() : pid),oldval,newval);
	return (newval);
}

fnamequantum(fname,argc,argv)
register char	*fname, *argv[];
register int	argc;
{
	if (getfquantum(fname,&oldval) < 0) {
		fprintf(stderr,"%s: get old quantum size of file '%s': ",
			cname,fname);
		perror("getfquantum");
		return (-errno);
	}
	if (argc < 2) {
		fprintf(stderr,"current quantum size of file '%s' is %d\n",
			fname,oldval);
		return (oldval);
	}
	newval = atoi(argv[1]);
	if (setfquantum(fname,&newval,&oldval) < 0) {
		fprintf(stderr,"%s: set new quantum size of file '%s': ",
			cname,fname);
		perror("setfquantum");
		return (-errno);
	}
	fprintf(stderr,"change quantum size of file '%s' from %d to %d\n",
		fname,oldval,newval);
	return (newval);
}

pidquantumflags(argc,argv)
register int	argc;
register char	*argv[];
{
register pid_t	pid;

	pid = (pid_t) atoi(argv[1]);
	if (pid < 0)
		pid = 0;
	argc--;
	argv++;
	if (getquantumflags(pid,&oldval) < 0) {
		fprintf(stderr,"%s: get old quantum size leader flag of pid=%d: ",cname,pid);
		perror("getquantumflags");
		return (-errno);
	}
	if (argc < 2) {
		fprintf(stderr,"current quantum size leader flag of process %d is %d\n",
			((pid <= 0) ? getpid() : pid),oldval);
		return (oldval);
	}
	newval = atoi(argv[1]);
	if (setquantumflags(pid,&newval,&oldval) < 0) {
		fprintf(stderr,"%s: set new quantum size leader flag of pid=%d to %d: ",
			cname,pid,newval);
		perror("setquantumflags");
		return (-errno);
	}
	fprintf(stderr,"change quantum size leader flag of process %d from %d to %d\n",
		((pid <= 0) ? getpid() : pid),oldval,newval);
	return (newval);
}

fnamequantumflags(fname,argc,argv)
register char	*fname, *argv[];
register int	argc;
{
	if (getfquantumflags(fname,&oldval) < 0) {
		fprintf(stderr,"%s: get old quantum size leader flag of file '%s': ",
			cname,fname);
		perror("getfquantumflags");
		return (-errno);
	}
	if (argc < 2) {
		fprintf(stderr,"current quantum size leader flag of file '%s' is %d\n",
			fname,oldval);
		return (oldval);
	}
	newval = atoi(argv[1]);
	if (setfquantumflags(fname,&newval,&oldval) < 0) {
		fprintf(stderr,"%s: set new quantum size leader flag of file '%s': ",
			cname,fname);
		perror("setfquantumflags");
		return (-errno);
	}
	fprintf(stderr,"change quantum size leader flag of file '%s' from %d to %d\n",
		fname,oldval,newval);
	return (newval);
}
