/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) chpri.c: version 25.1 created on 12/2/91 at 13:57:10	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)chpri.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include	"chperf.h"

dopriclamp(argc,argv)
register int	argc;
register char	*argv[];
{
	if (argc < 2)
		return (usagepriclamp(cname));
	if ((argv[1][0] == '-') && (argv[1][1] == 'h'))
		exit (usage(cname));
	if ((argv[1][0] == '-') && (argv[1][1] == '?'))
		exit (usage(cname));
	if ((argv[1][0] == '-') && (argv[1][1] == 'd')) {
		argc--;
		argv++;
		return (sysperfdebug(argc,argv));
	}
	if ((argv[1][0] == '-') && (argv[1][1] == 'c')) {
		argc--;
		argv++;
		return (syspricopy(argc,argv));
	}
	if ((argv[1][0] == '-') && (argv[1][1] == 's')) {
		argc--;
		argv++;
		return (syspristat(argc,argv));
	}
	if ((argv[1][0] == '-') && (argv[1][1] == 'm')) {
		argc--;
		argv++;
		return (sysmaxpriclamp(argc,argv));
	}
	if ((argv[1][0] == '-') && (argv[1][1] == 'g')) {
		argc--;
		argv++;
		return (sysglobpriclamp(argc,argv));
	}
	doleader = 0;
	if ((argv[1][0] == '-') && (argv[1][1] == 'l')) {
		argc--;
		argv++;
		doleader++;
	}
	if ((argv[1][0] == '-') && (argv[1][1] == 'f')) {
		if (argv[1][2] == '\0') {
			if (argc > 2) {
				fname = argv[2];
				argc--;
				argv++;
			} else
				return (usagepriclamp(cname));
		} else	{
			fname = &argv[1][2];
		}
		argc--;
		argv++;
		if (doleader)
			return (fnamepriflags(fname,argc,argv));
		else
			return (fnamepriclamp(fname,argc,argv));
	}
	if (doleader)
		return (pidpriflags(argc,argv));
	else
		return (pidpriclamp(argc,argv));
}

syspristat(argc,argv)
register int	argc;
register char	*argv[];
{
register pid_t	pid;

	pid = -1;
	if (argc > 1) {
		pid = (pid_t) atoi(argv[1]);
		argc--;
		argv++;
	}
	if (getpristat(pid,&newval,&oldval) < 0) {
		if (pid < 0) {
			fprintf(stderr,
				"%s: get system global pri clamp stats: ",
				cname);
		} else	{
			fprintf(stderr,
				"%s: get pri clamp stats for pid %d: ",
				cname,((pid == 0) ? getpid() : pid));
		}
		perror("getpristat");
		return (-errno);
	}
	if (argc < 2) {
		if (pid < 0) {
			fprintf(stderr,
			"system global pri clamp stats: cnt=%d ovfl=%d\n",
				oldval,newval);
		} else	{
			fprintf(stderr,
			"pri clamp stats for pid %d: cnt=%d ovfl=%d\n",
				(pid == 0) ? getpid() : pid,oldval,newval);
		}
		return (0);
	}
	oval = atoi(argv[1]);
	argc--;
	argv++;
	if (setpristat(pid,0,&oval) < 0) {
		if (pid < 0) {
			fprintf(stderr,
			"%s: set system global pri clamp stat cnt to %d: ",
				cname,oval);
		} else	{
			fprintf(stderr,
			"%s: set pri clamp stat cnt for pid %d to %d: ",
				cname,((pid == 0) ? getpid() : pid),oval);
		}
		perror("setpristat cnt");
		return (-errno);
	}
	if (pid < 0) {
		fprintf(stderr,
		"change system global pri clamp stat cnt from %d to %d\n",
			oldval,oval);
	} else	{
		fprintf(stderr,
		"change pri clamp stat cnt for pid %d from %d to %d\n",
			(pid == 0) ? getpid() : pid,oldval,oval);
	}
	if (argc < 2)
		return (0);
	nval = atoi(argv[1]);
	if (setpristat(pid,&nval,0) < 0) {
		if (pid < 0) {
			fprintf(stderr,
			"%s: set system global pri clamp stat ovfl to %d: ",
				cname,nval);
		} else	{
			fprintf(stderr,
			"%s: set pri clamp stat ovfl for pid %d to %d: ",
				cname,((pid == 0) ? getpid() : pid),nval);
		}
		perror("setpristat ovfl");
		return (-errno);
	}
	if (pid < 0) {
		fprintf(stderr,
		"change system global pri clamp stat ovfl from %d to %d\n",
			newval,nval);
	} else	{
		fprintf(stderr,
		"change pri clamp stat ovfl for pid %d from %d to %d\n",
			(pid == 0) ? getpid() : pid,newval,nval);
	}
	return (0);
}

syspricopy(argc,argv)
register int	argc;
register char	*argv[];
{
	if (getpricopy(&oldval) < 0) {
		fprintf(stderr,"%s: get old system pri clamp copy flag: ",
			cname);
		perror("getpricopy");
		return (-errno);
	}
	if (argc < 2) {
		fprintf(stderr,"current system pri clamp copy flag is %d\n",
			oldval);
		return (oldval);
	}
	newval = atoi(argv[1]);
	if (setpricopy(&newval,&oldval) < 0) {
		fprintf(stderr,
			"%s: set new system pri clamp copy flag to %d: ",
			cname,newval);
		perror("setpricopy");
		return (-errno);
	}
	fprintf(stderr,"change system pri clamp copy flag from %d to %d\n",
		oldval,newval);
	return (newval);
}

sysmaxpriclamp(argc,argv)
register int	argc;
register char	*argv[];
{
	if (getmaxpriclamp(&oldval) < 0) {
		fprintf(stderr,"%s: get old system maximum pri clamp: ",cname);
		perror("getmaxpriclamp");
		return (-errno);
	}
	if (argc < 2) {
		fprintf(stderr,"current system maximum pri clamp is %d\n",
			oldval);
		return (oldval);
	}
	newval = atoi(argv[1]);
	if (setmaxpriclamp(&newval,&oldval) < 0) {
		fprintf(stderr,"%s: set new system maximum pri clamp to %d: ",
			cname,newval);
		perror("setmaxpriclamp");
		return (-errno);
	}
	fprintf(stderr,"change system maximum pri clamp from %d to %d\n",
		oldval,newval);
	return (newval);
}

sysglobpriclamp(argc,argv)
register int	argc;
register char	*argv[];
{
	if (getglobpriclamp(&oldval) < 0) {
		fprintf(stderr,"%s: get old system global pri clamp: ",cname);
		perror("getglobpriclamp");
		return (-errno);
	}
	if (argc < 2) {
		fprintf(stderr,"current system global pri clamp is %d\n",
			oldval);
		return (oldval);
	}
	newval = atoi(argv[1]);
	if (setglobpriclamp(&newval,&oldval) < 0) {
		fprintf(stderr,"%s: set new system global pri clamp to %d: ",
			cname,newval);
		perror("setglobpriclamp");
		return (-errno);
	}
	fprintf(stderr,"change system global pri clamp from %d to %d\n",
		oldval,newval);
	return (newval);
}

pidpriclamp(argc,argv)
register int	argc;
register char	*argv[];
{
register pid_t	pid;

	pid = (pid_t) atoi(argv[1]);
	if (pid < 0)
		pid = 0;
	argc--;
	argv++;
	if (getpriclamp(pid,&oldval) < 0) {
		fprintf(stderr,"%s: get old pri clamp of pid=%d: ",cname,pid);
		perror("getpriclamp");
		return (-errno);
	}
	if (argc < 2) {
		fprintf(stderr,"current pri clamp of process %d is %d\n",
			((pid <= 0) ? getpid() : pid),oldval);
		return (oldval);
	}
	newval = atoi(argv[1]);
	if (setpriclamp(pid,&newval,&oldval) < 0) {
		fprintf(stderr,"%s: set new pri clamp of pid=%d to %d: ",
			cname,pid,newval);
		perror("setpriclamp");
		return (-errno);
	}
	fprintf(stderr,"change pri clamp of process %d from %d to %d\n",
		((pid <= 0) ? getpid() : pid),oldval,newval);
	return (newval);
}

fnamepriclamp(fname,argc,argv)
register char	*fname, *argv[];
register int	argc;
{
	if (getfpriclamp(fname,&oldval) < 0) {
		fprintf(stderr,"%s: get old pri clamp of file '%s': ",
			cname,fname);
		perror("getfpriclamp");
		return (-errno);
	}
	if (argc < 2) {
		fprintf(stderr,"current pri clamp of file '%s' is %d\n",
			fname,oldval);
		return (oldval);
	}
	newval = atoi(argv[1]);
	if (setfpriclamp(fname,&newval,&oldval) < 0) {
		fprintf(stderr,"%s: set new pri clamp of file '%s': ",
			cname,fname);
		perror("setfpriclamp");
		return (-errno);
	}
	fprintf(stderr,"change pri clamp of file '%s' from %d to %d\n",
		fname,oldval,newval);
	return (newval);
}

pidpriflags(argc,argv)
register int	argc;
register char	*argv[];
{
register pid_t	pid;

	pid = (pid_t) atoi(argv[1]);
	if (pid < 0)
		pid = 0;
	argc--;
	argv++;
	if (getpriflags(pid,&oldval) < 0) {
		fprintf(stderr,"%s: get old pri clamp leader flag of pid=%d: ",cname,pid);
		perror("getpriflags");
		return (-errno);
	}
	if (argc < 2) {
		fprintf(stderr,"current pri clamp leader flag of process %d is %d\n",
			((pid <= 0) ? getpid() : pid),oldval);
		return (oldval);
	}
	newval = atoi(argv[1]);
	if (setpriflags(pid,&newval,&oldval) < 0) {
		fprintf(stderr,"%s: set new pri clamp leader flag of pid=%d to %d: ",
			cname,pid,newval);
		perror("setpriflags");
		return (-errno);
	}
	fprintf(stderr,"change pri clamp leader flag of process %d from %d to %d\n",
		((pid <= 0) ? getpid() : pid),oldval,newval);
	return (newval);
}

fnamepriflags(fname,argc,argv)
register char	*fname, *argv[];
register int	argc;
{
	if (getfpriflags(fname,&oldval) < 0) {
		fprintf(stderr,"%s: get old pri clamp leader flag of file '%s': ",
			cname,fname);
		perror("getfpriflags");
		return (-errno);
	}
	if (argc < 2) {
		fprintf(stderr,"current pri clamp leader flag of file '%s' is %d\n",
			fname,oldval);
		return (oldval);
	}
	newval = atoi(argv[1]);
	if (setfpriflags(fname,&newval,&oldval) < 0) {
		fprintf(stderr,"%s: set new pri clamp leader flag of file '%s': ",
			cname,fname);
		perror("setfpriflags");
		return (-errno);
	}
	fprintf(stderr,"change pri clamp leader flag of file '%s' from %d to %d\n",
		fname,oldval,newval);
	return (newval);
}
