#	START NEW ARIX SCCS HEADER
#
#	@(#) chperf.mk: version 25.1 created on 12/2/91 at 13:57:07
#
#	Copyright (c) 1990 by Arix Corporation
#	All Rights Reserved
#
#	@(#)chperf.mk	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation
#
#	END NEW ARIX SCCS HEADER
#
IROOT =
include $(IROOT)/macdefs

BININS	= $(ROOT)/bin
MANINS	= $(ROOT)/usr/catman/a_man/man1

PACK	= pack -f

.SUFFIXES: .z .1

MANOBJ	= \
	priclamp.z \
	prippipe.z \
	pripsemn.z \
	pripsemz.z \
	schedtype.z

SOURCES	= chperf.h \
	chperf.c setperf.c \
	chquantum.c setquantum.c \
	chslice.c setslice.c \
	chpri.c setpri.c \
	chusrpri.c setusrpri.c \
	chcpu.c setcpu.c \
	chflags.c setflags.c \
	usage.c chgperf.s

#
#	Note:  chgperf.o is now part of standard IO library.
#
OBJECTS	= \
	chperf.o setperf.o \
	chquantum.o setquantum.o \
	chslice.o setslice.o \
	chpri.o setpri.o \
	chusrpri.o setusrpri.o \
	chcpu.o setcpu.o \
	chflags.o setflags.o \
	usage.o

PROG0	= chperf
PROG1	= quantum
PROG2	= sliceclamp
PROG3	= priclamp
PROG4	= usrpriclamp
PROG5	= cpuclamp
PROG6	= perfflags
PROG7	= prippipe
PROG8	= pripsemz
PROG9	= pripsemn
PROGS	= $(PROG0) \
	$(PROG1) $(PROG2) $(PROG3) $(PROG4) $(PROG5) $(PROG6) \
	$(PROG7) $(PROG8) $(PROG9)

.1.z:
	@echo Processing $*
	@tbl $*.1 | neqn | nroff -man > $*
	@$(PACK) $*

all:	$(PROGS) $(MANOBJ)

$(PROG0): $(OBJECTS)
	$(CC) -o $(PROG0) $(OBJECTS)

$(PROG1): $(PROG0)
	-ln $(PROG0) $(PROG1)

$(PROG2): $(PROG0)
	-ln $(PROG0) $(PROG2)

$(PROG3): $(PROG0)
	-ln $(PROG0) $(PROG3)

$(PROG4): $(PROG0)
	-ln $(PROG0) $(PROG4)

$(PROG5): $(PROG0)
	-ln $(PROG0) $(PROG5)

$(PROG6): $(PROG0)
	-ln $(PROG0) $(PROG6)

$(PROG7): $(PROG0)
	-ln $(PROG0) $(PROG7)

$(PROG8): $(PROG0)
	-ln $(PROG0) $(PROG8)

$(PROG9): $(PROG0)
	-ln $(PROG0) $(PROG9)

install: $(PROG0) $(MANINS) $(MANOBJ)
	$(INS) $(PROG0) $(BININS)/$(PROG0)
	chown bin $(BININS)/$(PROG0)
	chgrp bin $(BININS)/$(PROG0)
	chmod 755 $(BININS)/$(PROG0)
	-ln $(BININS)/$(PROG0) $(BININS)/$(PROG1)
	-ln $(BININS)/$(PROG0) $(BININS)/$(PROG2)
	-ln $(BININS)/$(PROG0) $(BININS)/$(PROG3)
	-ln $(BININS)/$(PROG0) $(BININS)/$(PROG4)
	-ln $(BININS)/$(PROG0) $(BININS)/$(PROG5)
	-ln $(BININS)/$(PROG0) $(BININS)/$(PROG6)
	-ln $(BININS)/$(PROG0) $(BININS)/$(PROG7)
	-ln $(BININS)/$(PROG0) $(BININS)/$(PROG8)
	-ln $(BININS)/$(PROG0) $(BININS)/$(PROG9)
	@for i in $(MANOBJ) ; \
	do \
		echo "Installing $$i into $(MANINS)" ; \
		$(INS) $$i $(MANINS)/$$i ; \
		chmod 444 $(MANINS)/$$i ; \
		chgrp bin $(MANINS)/$$i ; \
		chown bin $(MANINS)/$$i ; \
	done

clean:
	-rm -f $(OBJECTS) core *.o nohup.out make.out

clobber: clean
	-rm -f $(PROGS) $(MANOBJ)

$(MANINS):
	@echo Making $@
	@mkdir -p -m 775 $@
	@chgrp bin $@
	@chown bin $@
