/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) chperf.c: version 25.1 created on 12/2/91 at 13:57:00	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)chperf.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include	"chperf.h"

char	*pname, *cname, *fname;
char	*cmd1 = "quantum";
char	*cmd2 = "sliceclamp";
char	*cmd3 = "priclamp";
char	*cmd4 = "usrpriclamp";
char	*cmd5 = "cpuclamp";
char	*cmd6 = "perfflags";
char	*cmd7 = "prippipe";
char	*cmd8 = "pripsemz";
char	*cmd9 = "pripsemn";

int	oldval, newval, oval, nval, doleader;

main(argc,argv)
register int	argc;
register char	*argv[];
{
	pname = "";
	if ((cname = (char *)strrchr(argv[0],'/')) == NULL)
		cname = argv[0];
	else
		cname++;
	if (strcmp(cname,cmd1) == 0)
		exit (doquantum(argc,argv));
	if (strcmp(cname,cmd2) == 0)
		exit (dosliceclamp(argc,argv));
	if (strcmp(cname,cmd3) == 0)
		exit (dopriclamp(argc,argv));
	if (strcmp(cname,cmd4) == 0)
		exit (dousrpriclamp(argc,argv));
	if (strcmp(cname,cmd5) == 0)
		exit (docpuclamp(argc,argv));
	if (strcmp(cname,cmd6) == 0)
		exit (doperfflags(argc,argv));
	if (strcmp(cname,cmd7) == 0)
		exit (doprippipe(argc,argv));
	if (strcmp(cname,cmd8) == 0)
		exit (dopripsemz(argc,argv));
	if (strcmp(cname,cmd9) == 0)
		exit (dopripsemn(argc,argv));
	pname = cname;
	if (argc < 2)
		exit(usage(cname));
	argc--;
	argv++;
	if ((cname = (char *)strrchr(argv[0],'/')) == NULL)
		cname = argv[0];
	else
		cname++;
	if (strcmp(cname,cmd1) == 0)
		exit (doquantum(argc,argv));
	if (strcmp(cname,cmd2) == 0)
		exit (dosliceclamp(argc,argv));
	if (strcmp(cname,cmd3) == 0)
		exit (dopriclamp(argc,argv));
	if (strcmp(cname,cmd4) == 0)
		exit (dousrpriclamp(argc,argv));
	if (strcmp(cname,cmd5) == 0)
		exit (docpuclamp(argc,argv));
	if (strcmp(cname,cmd6) == 0)
		exit (doperfflags(argc,argv));
	if (strcmp(cname,cmd7) == 0)
		exit (doprippipe(argc,argv));
	if (strcmp(cname,cmd8) == 0)
		exit (dopripsemz(argc,argv));
	if (strcmp(cname,cmd9) == 0)
		exit (dopripsemn(argc,argv));
	exit(usage(cname));
}

doprippipe(argc,argv)
register int	argc;
register char	*argv[];
{
	if ((argv[1][0] == '-') && (argv[1][1] == 'h'))
		exit (usage(cname));
	if ((argv[1][0] == '-') && (argv[1][1] == '?'))
		return (usageprippipe(cname));
	if ((argv[1][0] == '-') && (argv[1][1] == 'd')) {
		argc--;
		argv++;
		return (sysperfdebug(argc,argv));
	}
	return (sysprippipe(argc,argv));
}

sysprippipe(argc,argv)
register int	argc;
register char	*argv[];
{
	if (getprippipe(&oldval) < 0) {
		fprintf(stderr,"%s: get old system PPIPE priority value: ",
			cname);
		perror("getprippipe");
		return (-errno);
	}
	if (argc < 2) {
		fprintf(stderr,"current system PPIPE priority value is %d\n",
			oldval);
		return (oldval);
	}
	newval = atoi(argv[1]);
	if (setprippipe(&newval,&oldval) < 0) {
		fprintf(stderr,"%s: set new system PPIPE priority value to %d: ",
			cname,newval);
		perror("setprippipe");
		return (-errno);
	}
	fprintf(stderr,"change system PPIPE priority value from %d to %d\n",
		oldval,newval);
	return (newval);
}

dopripsemz(argc,argv)
register int	argc;
register char	*argv[];
{
	if ((argv[1][0] == '-') && (argv[1][1] == 'h'))
		exit (usage(cname));
	if ((argv[1][0] == '-') && (argv[1][1] == '?'))
		return (usagepripsemz(cname));
	if ((argv[1][0] == '-') && (argv[1][1] == 'd')) {
		argc--;
		argv++;
		return (sysperfdebug(argc,argv));
	}
	return (syspripsemz(argc,argv));
}

syspripsemz(argc,argv)
register int	argc;
register char	*argv[];
{
	if (getpripsemz(&oldval) < 0) {
		fprintf(stderr,"%s: get old system PSEMZ priority value: ",
			cname);
		perror("getpripsemz");
		return (-errno);
	}
	if (argc < 2) {
		fprintf(stderr,"current system PSEMZ priority value is %d\n",
			oldval);
		return (oldval);
	}
	newval = atoi(argv[1]);
	if (setpripsemz(&newval,&oldval) < 0) {
		fprintf(stderr,"%s: set new system PSEMZ priority value to %d: ",
			cname,newval);
		perror("setpripsemz");
		return (-errno);
	}
	fprintf(stderr,"change system PSEMZ priority value from %d to %d\n",
		oldval,newval);
	return (newval);
}

dopripsemn(argc,argv)
register int	argc;
register char	*argv[];
{
	if ((argv[1][0] == '-') && (argv[1][1] == 'h'))
		exit (usage(cname));
	if ((argv[1][0] == '-') && (argv[1][1] == '?'))
		return (usagepripsemn(cname));
	if ((argv[1][0] == '-') && (argv[1][1] == 'd')) {
		argc--;
		argv++;
		return (sysperfdebug(argc,argv));
	}
	return (syspripsemn(argc,argv));
}

syspripsemn(argc,argv)
register int	argc;
register char	*argv[];
{
	if (getpripsemn(&oldval) < 0) {
		fprintf(stderr,"%s: get old system PSEMN priority value: ",
			cname);
		perror("getpripsemn");
		return (-errno);
	}
	if (argc < 2) {
		fprintf(stderr,"current system PSEMN priority value is %d\n",
			oldval);
		return (oldval);
	}
	newval = atoi(argv[1]);
	if (setpripsemn(&newval,&oldval) < 0) {
		fprintf(stderr,"%s: set new system PSEMN priority value to %d: ",
			cname,newval);
		perror("setpripsemn");
		return (-errno);
	}
	fprintf(stderr,"change system PSEMN priority value from %d to %d\n",
		oldval,newval);
	return (newval);
}

sysperfdebug(argc,argv)
register int	argc;
register char	*argv[];
{
	if (getperfdebug(&oldval) < 0) {
		fprintf(stderr,"%s: get old system perf debug level: ",cname);
		perror("getperfdebug");
		return (-errno);
	}
	if (argc < 2) {
		fprintf(stderr,"current system perf debug level is %d\n",
			oldval);
		return (oldval);
	}
	newval = atoi(argv[1]);
	if (setperfdebug(&newval,&oldval) < 0) {
		fprintf(stderr,"%s: set new system perf debug level to %d: ",
			cname,newval);
		perror("setperfdebug");
		return (-errno);
	}
	fprintf(stderr,"change system perf debug level from %d to %d\n",
		oldval,newval);
	return (newval);
}
