/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) chflags.c: version 25.1 created on 12/2/91 at 13:56:57	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)chflags.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include	"chperf.h"

doperfflags(argc,argv)
register int	argc;
register char	*argv[];
{
	if (argc < 2)
		return (usageperfflags(cname));
	if ((argv[1][0] == '-') && (argv[1][1] == 'h'))
		exit (usage(cname));
	if ((argv[1][0] == '-') && (argv[1][1] == '?'))
		exit (usage(cname));
	if ((argv[1][0] == '-') && (argv[1][1] == 'd')) {
		argc--;
		argv++;
		return (sysperfdebug(argc,argv));
	}
	if ((argv[1][0] == '-') && (argv[1][1] == 'c')) {
		argc--;
		argv++;
		return (sysflagscopy(argc,argv));
	}
	if ((argv[1][0] == '-') && (argv[1][1] == 'f')) {
		if (argv[1][2] == '\0') {
			if (argc > 2) {
				fname = argv[2];
				argc--;
				argv++;
			} else
				return (usageperfflags(cname));
		} else	{
			fname = &argv[1][2];
		}
		argc--;
		argv++;
		return (fnameperfflags(fname,argc,argv));
	}
	return (pidperfflags(argc,argv));
}

sysflagscopy(argc,argv)
register int	argc;
register char	*argv[];
{
	if (getflagscopy(&oldval) < 0) {
		fprintf(stderr,"%s: get old performance flags copy flag: ",
			cname);
		perror("getflagscopy");
		return (-errno);
	}
	if (argc < 2) {
		fprintf(stderr,"current performance flags copy flag is %d\n",
			oldval);
		return (oldval);
	}
	newval = atoi(argv[1]);
	if (setflagscopy(&newval,&oldval) < 0) {
		fprintf(stderr,
			"%s: set new performance flags copy flag to %d: ",
			cname,newval);
		perror("setflagscopy");
		return (-errno);
	}
	fprintf(stderr,"change performance flags copy flag from %d to %d\n",
		oldval,newval);
	return (newval);
}

pidperfflags(argc,argv)
register int	argc;
register char	*argv[];
{
register pid_t	pid;

	pid = (pid_t) atoi(argv[1]);
	if (pid < 0)
		pid = 0;
	argc--;
	argv++;
	if (getperfflags(pid,&oldval) < 0) {
		fprintf(stderr,"%s: get old performance flags of pid=%d: ",cname,pid);
		perror("getperfflags");
		return (-errno);
	}
	if (argc < 2) {
		fprintf(stderr,"current performance flags of process %d are 0x%08x\n",
			((pid <= 0) ? getpid() : pid),oldval);
		return (oldval);
	}
	if ((argv[1][0] != '0') || ((argv[1][1] != 'x') && (argv[1][1] != 'X')))
	{
		fprintf(stderr,
		"performance flags must start with '0x' and be hexa-decimal\n");
		return (oldval);
	}
	if (argv[1][2] == '\0') {
		fprintf(stderr,
		"performance flags must start with '0x' and be hexa-decimal\n");
		return (oldval);
	}
	sscanf(&argv[1][2],"%x",&newval);
	if (setperfflags(pid,&newval,&oldval) < 0) {
		fprintf(stderr,"%s: set new performance flags of pid=%d to 0x%08x: ",
			cname,pid,newval);
		perror("setperfflags");
		return (-errno);
	}
	fprintf(stderr,"change performance flags of process %d from 0x%08x to 0x%08x\n",
		((pid <= 0) ? getpid() : pid),oldval,newval);
	return (newval);
}

fnameperfflags(fname,argc,argv)
register char	*fname, *argv[];
register int	argc;
{
	if (getfperfflags(fname,&oldval) < 0) {
		fprintf(stderr,"%s: get old performance flags of file '%s': ",
			cname,fname);
		perror("getfperfflags");
		return (-errno);
	}
	if (argc < 2) {
		fprintf(stderr,"current performance flags of file '%s' are 0x%08x\n",
			fname,oldval);
		return (oldval);
	}
	if ((argv[1][0] != '0') || ((argv[1][1] != 'x') && (argv[1][1] != 'X')))
	{
		fprintf(stderr,
		"performance flags must start with '0x' and be hexa-decimal\n");
		return (oldval);
	}
	if (argv[1][2] == '\0') {
		fprintf(stderr,
		"performance flags must start with '0x' and be hexa-decimal\n");
		return (oldval);
	}
	sscanf(&argv[1][2],"%x",&newval);
	if (setfperfflags(fname,&newval,&oldval) < 0) {
		fprintf(stderr,"%s: set new performance flags of file '%s': ",
			cname,fname);
		perror("setfperfflags");
		return (-errno);
	}
	fprintf(stderr,"change performance flags of file '%s' from 0x%08x to 0x%08x\n",
		fname,oldval,newval);
	return (newval);
}
