/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) chown.c: version 25.1 created on 12/2/91 at 13:56:46	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)chown.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/
/*	ATT: #ident	"chown:chown.c	1.3"			*/
#ident	"@(#)chown:chown.c	25.1"
/*
 * chown uid file ...
 */

#include <stdio.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <pwd.h>

#define	SYMLINK	1

struct	passwd	*pwd,*getpwnam();
struct	stat	stbuf;
ushort	uid;
int	status;
#ifdef	SYMLINK
int	h_flag;
#endif

main(argc, argv)
char *argv[];
{
	register c;
#ifdef	SYMLINK
 	register argv_index = 1;
#endif

	if(argc < 3) {
#ifdef	SYMLINK
 		fprintf(stderr, "usage: chown [-h] uid file ...\n");
#else
		fprintf(stderr, "usage: chown uid file ...\n");
#endif
		exit(4);
	}
#ifdef	SYMLINK
 	while ((c = getopt(argc, argv, "h")) != EOF)
 		switch(c) {
 		
 		case 'h':
 			h_flag++;
 			argv_index++;
 			break;
 		default:
 			fprintf(stderr,
 				"chgrp: usage: chgrp [-h] gid file ...\n");
 			exit(4);
 		}
 	if(isnumber(argv[argv_index])) {
 		uid = atoushort(argv[argv_index]); /* uid is unsigned short */
#else
	if(isnumber(argv[1])) {
		uid = atoushort(argv[1]); /* uid is unsigned short */
#endif
		goto cho;
	}
#ifdef	SYMLINK
 	if((pwd=getpwnam(argv[argv_index])) == NULL) {
#else
	if((pwd=getpwnam(argv[1])) == NULL) {
#endif
		fprintf(stderr, "chown: unknown user id %s\n",argv[1]);
		exit(4);
	}
	uid = pwd->pw_uid;

cho:
#ifdef	SYMLINK
 	argv_index++;
 	for(c = argv_index; c < argc; c++) {
 		if (lstat(argv[c], &stbuf) < 0) {
 			perror(argv[c]);
 			status = 1;
 		}
 		if (h_flag) {
 			if (lchown(argv[c], uid, stbuf.st_gid) < 0) {
 				perror(argv[c]);
 				status = 1;
 			}
 		}
 		else if (chown(argv[c], uid, stbuf.st_gid) < 0) {
#else
	for(c=2; c<argc; c++) {
		stat(argv[c], &stbuf);
		if(chown(argv[c], uid, stbuf.st_gid) < 0) {
#endif
			perror(argv[c]);
			status = 1;
		}
	}
	exit(status);
}

isnumber(s)
char *s;
{
	register c;

	while(c = *s++)
		if(!isdigit(c))
			return(0);
	return(1);
}

atoushort(s)
register char *s;
{
	register char c;
	ushort register i, previ;
	i = previ = 0;
	while(c = *s++) {
		i = c - '0' + 10 * i;
		if(i < previ) {
			fprintf(stderr,"chown: numeric user id too large\n");
			exit(4);
    		}
		previ = i;
	}
	return(i);
}
