/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) chmod.c: version 25.1 created on 12/2/91 at 13:56:32	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)chmod.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/
/*	ATT: #ident	"chmod:chmod.c	1.2"			*/
#ident	"@(#)chmod:chmod.c	23.2"
/*
 *  chmod [ugoa][+-=][rwxlstugo] files
 *  change mode of files
 */

/*
 *  Note that many convolutions are necessary
 *  due to the re-use of bits between locking
 *  and setgid
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>

#define	SYMLINK	1


char	*ms;
struct	stat st;

/* this routine is owned by libgen. */
void errormsg();

main(argc, argv)
int argc;
char **argv;
{
	register int i;
	register char *p;
	int status = 0;

	if (argc < 3) {
		(void) fprintf(stderr, "Usage: chmod [ugoa][+-=][rwxlstugo] file ...\n");
		exit(255);
	}
	for (i = 2; i < argc; i++) {
		p = argv[i];
#ifdef	SYMLINK
 		if (lstat(p, &st) == -1) {
#else
		if (stat(p, &st) == -1) {
#endif
			errormsg(2, 0, "can't access %s\n", p);
			status = 1;
			continue;
		}
#ifdef	SYMLINK
 		if ((st.st_mode & S_IFMT) == S_IFLNK) {
 			if (stat(p, &st) == -1) {
 				errormsg(2, 0, "can't access %s\n", p);
 				status = 1;
 				continue;
 			}
		}
#endif
		ms = argv[1];
		if (chmod(p, newmode(st.st_mode, p, ms)) == -1) {
			errormsg(2, 0, "can't change %s\n", p);
			status = 1;
			continue;
		}
	}
	exit(status);
/* NOTREACHED */
}
void
errormsg(severity, code, format, file)
int severity, code;
char *format;
char *file;
{
	static char *msg[] = {
	"",
	"ERROR",
	"WARNING",
	""
	};

	(void) fprintf(stderr, "chmod: %s: ", msg[severity]);
	(void) fprintf(stderr, format, file);
	if (code != 0)
		exit(code);
	return;
}
